// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Hosting;

namespace HostedInAspNet.Server
{
    public class Program
    {
        public static void Main(string[] args)
        {
            BuildWebHost(args).Run();
        }

        public static IHost BuildWebHost(string[] args) =>
            Host.CreateDefaultBuilder(args)
            .ConfigureWebHostDefaults(webHostBuilder =>
            {
                // We require this line because we run in Production environment
                // and static web assets are only on by default during development.
                webHostBuilder.UseStaticWebAssets();

                webHostBuilder.UseStartup<Startup>();
            })
            .Build();
    }
}
