# Microsoft.VisualBasic.CompilerServices

``` diff
+namespace Microsoft.VisualBasic.CompilerServices {
+    public sealed class BooleanType {
+        public static bool FromObject(object Value);
+        public static bool FromString(string Value);
+    }
+    public sealed class ByteType {
+        public static byte FromObject(object Value);
+        public static byte FromString(string Value);
+    }
+    public sealed class CharArrayType {
+        public static char[] FromObject(object Value);
+        public static char[] FromString(string Value);
+    }
+    public sealed class CharType {
+        public static char FromObject(object Value);
+        public static char FromString(string Value);
+    }
+    public sealed class Conversions {
+        public static object ChangeType(object Expression, Type TargetType);
+        public static object FallbackUserDefinedConversion(object Expression, Type TargetType);
+        public static string FromCharAndCount(char Value, int Count);
+        public static string FromCharArray(char[] Value);
+        public static string FromCharArraySubset(char[] Value, int StartIndex, int Length);
+        public static bool ToBoolean(object Value);
+        public static bool ToBoolean(string Value);
+        public static byte ToByte(object Value);
+        public static byte ToByte(string Value);
+        public static char ToChar(object Value);
+        public static char ToChar(string Value);
+        public static char[] ToCharArrayRankOne(object Value);
+        public static char[] ToCharArrayRankOne(string Value);
+        public static DateTime ToDate(object Value);
+        public static DateTime ToDate(string Value);
+        public static decimal ToDecimal(bool Value);
+        public static decimal ToDecimal(object Value);
+        public static decimal ToDecimal(string Value);
+        public static double ToDouble(object Value);
+        public static double ToDouble(string Value);
+        public static T ToGenericParameter<T>(object Value);
+        public static int ToInteger(object Value);
+        public static int ToInteger(string Value);
+        public static long ToLong(object Value);
+        public static long ToLong(string Value);
+        public static sbyte ToSByte(object Value);
+        public static sbyte ToSByte(string Value);
+        public static short ToShort(object Value);
+        public static short ToShort(string Value);
+        public static float ToSingle(object Value);
+        public static float ToSingle(string Value);
+        public static string ToString(bool Value);
+        public static string ToString(byte Value);
+        public static string ToString(char Value);
+        public static string ToString(DateTime Value);
+        public static string ToString(decimal Value);
+        public static string ToString(decimal Value, NumberFormatInfo NumberFormat);
+        public static string ToString(double Value);
+        public static string ToString(double Value, NumberFormatInfo NumberFormat);
+        public static string ToString(short Value);
+        public static string ToString(int Value);
+        public static string ToString(long Value);
+        public static string ToString(object Value);
+        public static string ToString(float Value);
+        public static string ToString(float Value, NumberFormatInfo NumberFormat);
+        public static string ToString(uint Value);
+        public static string ToString(ulong Value);
+        public static uint ToUInteger(object Value);
+        public static uint ToUInteger(string Value);
+        public static ulong ToULong(object Value);
+        public static ulong ToULong(string Value);
+        public static ushort ToUShort(object Value);
+        public static ushort ToUShort(string Value);
+    }
+    public sealed class DateType {
+        public static DateTime FromObject(object Value);
+        public static DateTime FromString(string Value);
+        public static DateTime FromString(string Value, CultureInfo culture);
+    }
+    public sealed class DecimalType {
+        public static decimal FromBoolean(bool Value);
+        public static decimal FromObject(object Value);
+        public static decimal FromObject(object Value, NumberFormatInfo NumberFormat);
+        public static decimal FromString(string Value);
+        public static decimal FromString(string Value, NumberFormatInfo NumberFormat);
+        public static decimal Parse(string Value, NumberFormatInfo NumberFormat);
+    }
+    public sealed class DesignerGeneratedAttribute : Attribute {
+        public DesignerGeneratedAttribute();
+    }
+    public sealed class DoubleType {
+        public static double FromObject(object Value);
+        public static double FromObject(object Value, NumberFormatInfo NumberFormat);
+        public static double FromString(string Value);
+        public static double FromString(string Value, NumberFormatInfo NumberFormat);
+        public static double Parse(string Value);
+        public static double Parse(string Value, NumberFormatInfo NumberFormat);
+    }
+    public sealed class ExceptionUtils
+    public sealed class FlowControl {
+        public static void CheckForSyncLockOnValueType(object obj);
+        public static IEnumerator ForEachInArr(Array ary);
+        public static IEnumerator ForEachInObj(object obj);
+        public static bool ForEachNextObj(ref object obj, IEnumerator enumerator);
+        public static bool ForLoopInitObj(object Counter, object Start, object Limit, object StepValue, ref object LoopForResult, ref object CounterResult);
+        public static bool ForNextCheckDec(decimal count, decimal limit, decimal StepValue);
+        public static bool ForNextCheckObj(object Counter, object LoopObj, ref object CounterResult);
+        public static bool ForNextCheckR4(float count, float limit, float StepValue);
+        public static bool ForNextCheckR8(double count, double limit, double StepValue);
+    }
+    public sealed class HostServices {
+        public HostServices();
+        public static IVbHost VBHost { get; set; }
+    }
+    public sealed class IncompleteInitialization : Exception {
+        public IncompleteInitialization();
+        public IncompleteInitialization(string message);
+        public IncompleteInitialization(string message, Exception innerException);
+    }
+    public sealed class IntegerType {
+        public static int FromObject(object Value);
+        public static int FromString(string Value);
+    }
+    public sealed class InternalErrorException : Exception {
+        public InternalErrorException();
+        public InternalErrorException(string message);
+        public InternalErrorException(string message, Exception innerException);
+    }
+    public interface IVbHost {
+        IWin32Window GetParentWindow();
+        string GetWindowTitle();
+    }
+    public sealed class LateBinding {
+        public static void LateCall(object o, Type objType, string name, object[] args, string[] paramnames, bool[] CopyBack);
+        public static object LateGet(object o, Type objType, string name, object[] args, string[] paramnames, bool[] CopyBack);
+        public static object LateIndexGet(object o, object[] args, string[] paramnames);
+        public static void LateIndexSet(object o, object[] args, string[] paramnames);
+        public static void LateIndexSetComplex(object o, object[] args, string[] paramnames, bool OptimisticSet, bool RValueBase);
+        public static void LateSet(object o, Type objType, string name, object[] args, string[] paramnames);
+        public static void LateSetComplex(object o, Type objType, string name, object[] args, string[] paramnames, bool OptimisticSet, bool RValueBase);
+    }
+    public sealed class LikeOperator {
+        public static object LikeObject(object Source, object Pattern, CompareMethod CompareOption);
+        public static bool LikeString(string Source, string Pattern, CompareMethod CompareOption);
+    }
+    public sealed class LongType {
+        public static long FromObject(object Value);
+        public static long FromString(string Value);
+    }
+    public sealed class NewLateBinding {
+        public static object FallbackCall(object Instance, string MemberName, object[] Arguments, string[] ArgumentNames, bool IgnoreReturn);
+        public static object FallbackGet(object Instance, string MemberName, object[] Arguments, string[] ArgumentNames);
+        public static void FallbackIndexSet(object Instance, object[] Arguments, string[] ArgumentNames);
+        public static void FallbackIndexSetComplex(object Instance, object[] Arguments, string[] ArgumentNames, bool OptimisticSet, bool RValueBase);
+        public static object FallbackInvokeDefault1(object Instance, object[] Arguments, string[] ArgumentNames, bool ReportErrors);
+        public static object FallbackInvokeDefault2(object Instance, object[] Arguments, string[] ArgumentNames, bool ReportErrors);
+        public static void FallbackSet(object Instance, string MemberName, object[] Arguments);
+        public static void FallbackSetComplex(object Instance, string MemberName, object[] Arguments, bool OptimisticSet, bool RValueBase);
+        public static object LateCall(object Instance, Type Type, string MemberName, object[] Arguments, string[] ArgumentNames, Type[] TypeArguments, bool[] CopyBack, bool IgnoreReturn);
+        public static object LateCallInvokeDefault(object Instance, object[] Arguments, string[] ArgumentNames, bool ReportErrors);
+        public static bool LateCanEvaluate(object instance, Type type, string memberName, object[] arguments, bool allowFunctionEvaluation, bool allowPropertyEvaluation);
+        public static object LateGet(object Instance, Type Type, string MemberName, object[] Arguments, string[] ArgumentNames, Type[] TypeArguments, bool[] CopyBack);
+        public static object LateGetInvokeDefault(object Instance, object[] Arguments, string[] ArgumentNames, bool ReportErrors);
+        public static object LateIndexGet(object Instance, object[] Arguments, string[] ArgumentNames);
+        public static void LateIndexSet(object Instance, object[] Arguments, string[] ArgumentNames);
+        public static void LateIndexSetComplex(object Instance, object[] Arguments, string[] ArgumentNames, bool OptimisticSet, bool RValueBase);
+        public static void LateSet(object Instance, Type Type, string MemberName, object[] Arguments, string[] ArgumentNames, Type[] TypeArguments);
+        public static void LateSet(object Instance, Type Type, string MemberName, object[] Arguments, string[] ArgumentNames, Type[] TypeArguments, bool OptimisticSet, bool RValueBase, CallType CallType);
+        public static void LateSetComplex(object Instance, Type Type, string MemberName, object[] Arguments, string[] ArgumentNames, Type[] TypeArguments, bool OptimisticSet, bool RValueBase);
+    }
+    public sealed class ObjectFlowControl {
+        public static void CheckForSyncLockOnValueType(object Expression);
+        public sealed class ForLoopControl {
+            public static bool ForLoopInitObj(object Counter, object Start, object Limit, object StepValue, ref object LoopForResult, ref object CounterResult);
+            public static bool ForNextCheckDec(decimal count, decimal limit, decimal StepValue);
+            public static bool ForNextCheckObj(object Counter, object LoopObj, ref object CounterResult);
+            public static bool ForNextCheckR4(float count, float limit, float StepValue);
+            public static bool ForNextCheckR8(double count, double limit, double StepValue);
+        }
+    }
+    public sealed class ObjectType {
+        public ObjectType();
+        public static object AddObj(object o1, object o2);
+        public static object BitAndObj(object obj1, object obj2);
+        public static object BitOrObj(object obj1, object obj2);
+        public static object BitXorObj(object obj1, object obj2);
+        public static object DivObj(object o1, object o2);
+        public static object GetObjectValuePrimitive(object o);
+        public static object IDivObj(object o1, object o2);
+        public static bool LikeObj(object vLeft, object vRight, CompareMethod CompareOption);
+        public static object ModObj(object o1, object o2);
+        public static object MulObj(object o1, object o2);
+        public static object NegObj(object obj);
+        public static object NotObj(object obj);
+        public static int ObjTst(object o1, object o2, bool TextCompare);
+        public static object PlusObj(object obj);
+        public static object PowObj(object obj1, object obj2);
+        public static object ShiftLeftObj(object o1, int amount);
+        public static object ShiftRightObj(object o1, int amount);
+        public static object StrCatObj(object vLeft, object vRight);
+        public static object SubObj(object o1, object o2);
+        public static object XorObj(object obj1, object obj2);
+    }
+    public sealed class Operators {
+        public static object AddObject(object Left, object Right);
+        public static object AndObject(object Left, object Right);
+        public static int CompareObject(object Left, object Right, bool TextCompare);
+        public static object CompareObjectEqual(object Left, object Right, bool TextCompare);
+        public static object CompareObjectGreater(object Left, object Right, bool TextCompare);
+        public static object CompareObjectGreaterEqual(object Left, object Right, bool TextCompare);
+        public static object CompareObjectLess(object Left, object Right, bool TextCompare);
+        public static object CompareObjectLessEqual(object Left, object Right, bool TextCompare);
+        public static object CompareObjectNotEqual(object Left, object Right, bool TextCompare);
+        public static int CompareString(string Left, string Right, bool TextCompare);
+        public static object ConcatenateObject(object Left, object Right);
+        public static bool ConditionalCompareObjectEqual(object Left, object Right, bool TextCompare);
+        public static bool ConditionalCompareObjectGreater(object Left, object Right, bool TextCompare);
+        public static bool ConditionalCompareObjectGreaterEqual(object Left, object Right, bool TextCompare);
+        public static bool ConditionalCompareObjectLess(object Left, object Right, bool TextCompare);
+        public static bool ConditionalCompareObjectLessEqual(object Left, object Right, bool TextCompare);
+        public static bool ConditionalCompareObjectNotEqual(object Left, object Right, bool TextCompare);
+        public static object DivideObject(object Left, object Right);
+        public static object ExponentObject(object Left, object Right);
+        public static object FallbackInvokeUserDefinedOperator(object vbOp, object[] Arguments);
+        public static object IntDivideObject(object Left, object Right);
+        public static object LeftShiftObject(object Operand, object Amount);
+        public static object LikeObject(object Source, object Pattern, CompareMethod CompareOption);
+        public static bool LikeString(string Source, string Pattern, CompareMethod CompareOption);
+        public static object ModObject(object Left, object Right);
+        public static object MultiplyObject(object Left, object Right);
+        public static object NegateObject(object Operand);
+        public static object NotObject(object Operand);
+        public static object OrObject(object Left, object Right);
+        public static object PlusObject(object Operand);
+        public static object RightShiftObject(object Operand, object Amount);
+        public static object SubtractObject(object Left, object Right);
+        public static object XorObject(object Left, object Right);
+    }
+    public sealed class OptionCompareAttribute : Attribute {
+        public OptionCompareAttribute();
+    }
+    public sealed class OptionTextAttribute : Attribute {
+        public OptionTextAttribute();
+    }
+    public sealed class ProjectData {
+        public static void ClearProjectError();
+        public static Exception CreateProjectError(int hr);
+        public static void EndApp();
+        public static void SetProjectError(Exception ex);
+        public static void SetProjectError(Exception ex, int lErl);
+    }
+    public sealed class ShortType {
+        public static short FromObject(object Value);
+        public static short FromString(string Value);
+    }
+    public sealed class SingleType {
+        public static float FromObject(object Value);
+        public static float FromObject(object Value, NumberFormatInfo NumberFormat);
+        public static float FromString(string Value);
+        public static float FromString(string Value, NumberFormatInfo NumberFormat);
+    }
+    public sealed class StandardModuleAttribute : Attribute {
+        public StandardModuleAttribute();
+    }
+    public sealed class StaticLocalInitFlag {
+        public short State;
+        public StaticLocalInitFlag();
+    }
+    public sealed class StringType {
+        public static string FromBoolean(bool Value);
+        public static string FromByte(byte Value);
+        public static string FromChar(char Value);
+        public static string FromDate(DateTime Value);
+        public static string FromDecimal(decimal Value);
+        public static string FromDecimal(decimal Value, NumberFormatInfo NumberFormat);
+        public static string FromDouble(double Value);
+        public static string FromDouble(double Value, NumberFormatInfo NumberFormat);
+        public static string FromInteger(int Value);
+        public static string FromLong(long Value);
+        public static string FromObject(object Value);
+        public static string FromShort(short Value);
+        public static string FromSingle(float Value);
+        public static string FromSingle(float Value, NumberFormatInfo NumberFormat);
+        public static void MidStmtStr(ref string sDest, int StartPosition, int MaxInsertLength, string sInsert);
+        public static int StrCmp(string sLeft, string sRight, bool TextCompare);
+        public static bool StrLike(string Source, string Pattern, CompareMethod CompareOption);
+        public static bool StrLikeBinary(string Source, string Pattern);
+        public static bool StrLikeText(string Source, string Pattern);
+    }
+    public sealed class Utils {
+        public static Array CopyArray(Array arySrc, Array aryDest);
+        public static string GetResourceString(string ResourceKey, params string[] Args);
+        public static string MethodToString(MethodBase Method);
+        public static object SetCultureInfo(CultureInfo Culture);
+        public static void ThrowException(int hr);
+    }
+    public sealed class Versioned {
+        public static object CallByName(object Instance, string MethodName, CallType UseCallType, params object[] Arguments);
+        public static bool IsNumeric(object Expression);
+        public static string SystemTypeName(string VbName);
+        public static string TypeName(object Expression);
+        public static string VbTypeName(string SystemName);
+    }
+}
```

