﻿// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

namespace Microsoft.AspNetCore.Razor.Language
{
    internal class DefaultRazorCodeGenerationOptions : RazorCodeGenerationOptions
    {
        public DefaultRazorCodeGenerationOptions(
            bool indentWithTabs, 
            int indentSize, 
            bool designTime,
            string rootNamespace,
            bool suppressChecksum,
            bool suppressMetadataAttributes,
            bool suppressPrimaryMethodBody,
            bool suppressNullabilityEnforcement)
        {
            IndentWithTabs = indentWithTabs;
            IndentSize = indentSize;
            DesignTime = designTime;
            RootNamespace = rootNamespace;
            SuppressChecksum = suppressChecksum;
            SuppressMetadataAttributes = suppressMetadataAttributes;
            SuppressPrimaryMethodBody = suppressPrimaryMethodBody;
            SuppressNullabilityEnforcement = suppressNullabilityEnforcement;
        }

        public override bool DesignTime { get; }

        public override bool IndentWithTabs { get; }

        public override int IndentSize { get; }

        public override string RootNamespace { get; }

        public override bool SuppressChecksum { get; }

        public override bool SuppressNullabilityEnforcement { get; }
    }
}
