# System.Web.Security.AntiXss

``` diff
+namespace System.Web.Security.AntiXss {
+    public class AntiXssEncoder : HttpEncoder {
+        public AntiXssEncoder();
+        public static string CssEncode(string input);
+        protected internal override void HtmlAttributeEncode(string value, TextWriter output);
+        public static string HtmlEncode(string input, bool useNamedEntities);
+        protected internal override void HtmlEncode(string value, TextWriter output);
+        public static string HtmlFormUrlEncode(string input);
+        public static string HtmlFormUrlEncode(string input, int codePage);
+        public static string HtmlFormUrlEncode(string input, Encoding inputEncoding);
+        public static void MarkAsSafe(LowerCodeCharts lowerCodeCharts, LowerMidCodeCharts lowerMidCodeCharts, MidCodeCharts midCodeCharts, UpperMidCodeCharts upperMidCodeCharts, UpperCodeCharts upperCodeCharts);
+        protected internal override byte[] UrlEncode(byte[] bytes, int offset, int count);
+        public static string UrlEncode(string input);
+        public static string UrlEncode(string input, int codePage);
+        public static string UrlEncode(string input, Encoding inputEncoding);
+        protected internal override string UrlPathEncode(string value);
+        public static string XmlAttributeEncode(string input);
+        public static string XmlEncode(string input);
+    }
+    public enum LowerCodeCharts : long {
+        Arabic = (long)4096,
+        ArabicSupplement = (long)16384,
+        Armenian = (long)1024,
+        BasicLatin = (long)1,
+        Bengali = (long)524288,
+        C1ControlsAndLatin1Supplement = (long)2,
+        CombiningDiacriticalMarks = (long)64,
+        Cyrillic = (long)256,
+        CyrillicSupplement = (long)512,
+        Default = (long)127,
+        Devanagari = (long)262144,
+        GreekAndCoptic = (long)128,
+        Gujarati = (long)2097152,
+        Gurmukhi = (long)1048576,
+        Hebrew = (long)2048,
+        IpaExtensions = (long)16,
+        Kannada = (long)33554432,
+        Lao = (long)536870912,
+        LatinExtendedA = (long)4,
+        LatinExtendedB = (long)8,
+        Malayalam = (long)67108864,
+        Nko = (long)65536,
+        None = (long)0,
+        Oriya = (long)4194304,
+        Samaritan = (long)131072,
+        Sinhala = (long)134217728,
+        SpacingModifierLetters = (long)32,
+        Syriac = (long)8192,
+        Tamil = (long)8388608,
+        Telugu = (long)16777216,
+        Thaana = (long)32768,
+        Thai = (long)268435456,
+        Tibetan = (long)1073741824,
+    }
+    public enum LowerMidCodeCharts : long {
+        Balinese = (long)4194304,
+        Buginese = (long)1048576,
+        Buhid = (long)2048,
+        Cherokee = (long)32,
+        CombiningDiacriticalMarksSupplement = (long)536870912,
+        Ethiopic = (long)8,
+        EthiopicSupplement = (long)16,
+        Georgian = (long)2,
+        HangulJamo = (long)4,
+        Hanunoo = (long)1024,
+        Khmer = (long)8192,
+        KhmerSymbols = (long)524288,
+        LatinExtendedAdditional = (long)1073741824,
+        Lepcha = (long)16777216,
+        Limbu = (long)65536,
+        Mongolian = (long)16384,
+        Myanmar = (long)1,
+        NewTaiLue = (long)262144,
+        None = (long)0,
+        Ogham = (long)128,
+        OlChiki = (long)33554432,
+        PhoneticExtensions = (long)134217728,
+        PhoneticExtensionsSupplement = (long)268435456,
+        Runic = (long)256,
+        Sudanese = (long)8388608,
+        Tagalog = (long)512,
+        Tagbanwa = (long)4096,
+        TaiLe = (long)131072,
+        TaiTham = (long)2097152,
+        UnifiedCanadianAboriginalSyllabics = (long)64,
+        UnifiedCanadianAboriginalSyllabicsExtended = (long)32768,
+        VedicExtensions = (long)67108864,
+    }
+    public enum MidCodeCharts : long {
+        Arrows = (long)128,
+        BlockElements = (long)16384,
+        BoxDrawing = (long)8192,
+        BraillePatterns = (long)1048576,
+        CombiningDiacriticalMarksForSymbols = (long)16,
+        ControlPictures = (long)1024,
+        Coptic = (long)134217728,
+        CurrencySymbols = (long)8,
+        Dingbats = (long)131072,
+        EnclosedAlphanumerics = (long)4096,
+        EthiopicExtended = (long)16384,
+        GeneralPunctuation = (long)2,
+        GeometricShapes = (long)32768,
+        GeorgianSupplement = (long)268435456,
+        Glagolitic = (long)33554432,
+        GreekExtended = (long)1,
+        LatinExtendedC = (long)67108864,
+        LetterlikeSymbols = (long)32,
+        MathematicalOperators = (long)256,
+        MiscellaneousMathematicalSymbolsA = (long)262144,
+        MiscellaneousMathematicalSymbolsB = (long)4194304,
+        MiscellaneousSymbols = (long)65536,
+        MiscellaneousSymbolsAndArrows = (long)16777216,
+        MiscellaneousTechnical = (long)512,
+        None = (long)0,
+        NumberForms = (long)64,
+        OpticalCharacterRecognition = (long)2048,
+        SuperscriptsAndSubscripts = (long)4,
+        SupplementalArrowsA = (long)524288,
+        SupplementalArrowsB = (long)2097152,
+        SupplementalMathematicalOperators = (long)8388608,
+        Tifinagh = (long)536870912,
+    }
+    public enum UpperCodeCharts {
+        AlphabeticPresentationForms = 4096,
+        ArabicPresentationFormsA = 8192,
+        ArabicPresentationFormsB = 524288,
+        Cham = 32,
+        CjkCompatibilityForms = 131072,
+        CjkCompatibilityIdeographs = 2048,
+        CombiningHalfMarks = 65536,
+        DevanagariExtended = 1,
+        HalfWidthAndFullWidthForms = 1048576,
+        HangulJamoExtendedA = 8,
+        HangulJamoExtendedB = 1024,
+        HangulSyllables = 512,
+        Javanese = 16,
+        KayahLi = 2,
+        MeeteiMayek = 256,
+        MyanmarExtendedA = 64,
+        None = 0,
+        Rejang = 4,
+        SmallFormVariants = 262144,
+        Specials = 2097152,
+        TaiViet = 128,
+        VariationSelectors = 16384,
+        VerticalForms = 32768,
+    }
+    public enum UpperMidCodeCharts : long {
+        Bamum = (long)16777216,
+        Bopomofo = (long)256,
+        BopomofoExtended = (long)2048,
+        CjkCompatibility = (long)32768,
+        CjkRadicalsSupplement = (long)4,
+        CjkStrokes = (long)4096,
+        CjkSymbolsAndPunctuation = (long)32,
+        CjkUnifiedIdeographs = (long)262144,
+        CjkUnifiedIdeographsExtensionA = (long)65536,
+        CommonIndicNumberForms = (long)268435456,
+        CyrillicExtendedA = (long)1,
+        CyrillicExtendedB = (long)8388608,
+        EnclosedCjkLettersAndMonths = (long)16384,
+        HangulCompatibilityJamo = (long)512,
+        Hiragana = (long)64,
+        IdeographicDescriptionCharacters = (long)16,
+        Kanbun = (long)1024,
+        KangxiRadicals = (long)8,
+        Katakana = (long)128,
+        KatakanaPhoneticExtensions = (long)8192,
+        LatinExtendedD = (long)67108864,
+        Lisu = (long)2097152,
+        ModifierToneLetters = (long)33554432,
+        None = (long)0,
+        Phagspa = (long)536870912,
+        Saurashtra = (long)1073741824,
+        SupplementalPunctuation = (long)2,
+        SylotiNagri = (long)134217728,
+        Vai = (long)4194304,
+        YijingHexagramSymbols = (long)131072,
+        YiRadicals = (long)1048576,
+        YiSyllables = (long)524288,
+    }
+}
```

