// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

namespace Microsoft.VisualStudio.TestPlatform.ObjectModel.Logging
{
    using System;
    using System.Runtime.Serialization;

    /// <summary>
    /// EventArg used for raising data collector message event.
    /// </summary>
    [DataContract]    
    public class DataCollectionMessageEventArgs : TestRunMessageEventArgs
    {
        #region constructor
        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="level">Level at which message should be logged.</param>
        /// <param name="message">Text message.</param>
        public DataCollectionMessageEventArgs(TestMessageLevel level, string message) : base(level, message)
        {
        }
        #endregion
        
        #region properties

        /// <summary>
        /// Friendly name of collector
        /// </summary>
        [DataMember]
        public string FriendlyName
        {
            get;
            set;
        }


        /// <summary>
        /// Uri of collector.
        /// </summary>
        [DataMember]
        public Uri Uri
        {
            get;
            set;
        }

        /// <summary>
        /// Test case id if the message is generated by test case collection.
        /// </summary>
        [DataMember]
        public Guid TestCaseId
        {
            get;
            set;
        }
        
        #endregion
    }
}
