// Copyright (c) .NET Foundation and contributors. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

using System.Linq;
using Microsoft.DotNet.Cli.CommandLine;

namespace Microsoft.DotNet.Tools.Test.Utilities
{

    public static class AppliedOptionExtensions
    {
        public static T ValueOrDefault<T>(this AppliedOption parseResult, string alias)
        {
            return parseResult
                .AppliedOptions
                .Where(o => o.HasAlias(alias))
                .Select(o => o.Value<T>())
                .SingleOrDefault();
        }
    }
}