﻿// <auto-generated />

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Immutable;
using System.Diagnostics;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Threading;
using System.Text;
using Microsoft.CodeAnalysis.Collections;
using Roslyn.Utilities;

using Microsoft.CodeAnalysis.Text;
using Microsoft.CodeAnalysis.CSharp.Symbols;
using Microsoft.CodeAnalysis.CSharp.Syntax;

namespace Microsoft.CodeAnalysis.CSharp
{
    internal enum BoundKind: byte
    {
        FieldInitializer,
        FieldEqualsValue,
        PropertyEqualsValue,
        ParameterEqualsValue,
        GlobalStatementInitializer,
        DeconstructValuePlaceholder,
        Dup,
        BadExpression,
        BadStatement,
        TypeExpression,
        TypeOrValueExpression,
        NamespaceExpression,
        UnaryOperator,
        IncrementOperator,
        AddressOfOperator,
        PointerIndirectionOperator,
        PointerElementAccess,
        RefTypeOperator,
        MakeRefOperator,
        RefValueOperator,
        BinaryOperator,
        UserDefinedConditionalLogicalOperator,
        CompoundAssignmentOperator,
        AssignmentOperator,
        DeconstructionAssignmentOperator,
        NullCoalescingOperator,
        ConditionalOperator,
        ArrayAccess,
        ArrayLength,
        AwaitExpression,
        TypeOfOperator,
        MethodDefIndex,
        MaximumMethodDefIndex,
        InstrumentationPayloadRoot,
        ModuleVersionId,
        ModuleVersionIdString,
        SourceDocumentIndex,
        MethodInfo,
        FieldInfo,
        DefaultExpression,
        IsOperator,
        AsOperator,
        SizeOfOperator,
        Conversion,
        ArgList,
        ArgListOperator,
        FixedLocalCollectionInitializer,
        SequencePoint,
        SequencePointExpression,
        SequencePointWithSpan,
        Block,
        Scope,
        StateMachineScope,
        LocalDeclaration,
        MultipleLocalDeclarations,
        LocalFunctionStatement,
        Sequence,
        NoOpStatement,
        ReturnStatement,
        YieldReturnStatement,
        YieldBreakStatement,
        ThrowStatement,
        ExpressionStatement,
        SwitchStatement,
        SwitchSection,
        SwitchLabel,
        BreakStatement,
        ContinueStatement,
        PatternSwitchStatement,
        PatternSwitchSection,
        PatternSwitchLabel,
        IfStatement,
        DoStatement,
        WhileStatement,
        ForStatement,
        ForEachStatement,
        ForEachDeconstructStep,
        UsingStatement,
        FixedStatement,
        LockStatement,
        TryStatement,
        CatchBlock,
        Literal,
        ThisReference,
        PreviousSubmissionReference,
        HostObjectMemberReference,
        BaseReference,
        Local,
        PseudoVariable,
        RangeVariable,
        Parameter,
        LabelStatement,
        GotoStatement,
        LabeledStatement,
        Label,
        StatementList,
        ConditionalGoto,
        DynamicMemberAccess,
        DynamicInvocation,
        ConditionalAccess,
        LoweredConditionalAccess,
        ConditionalReceiver,
        ComplexConditionalReceiver,
        MethodGroup,
        PropertyGroup,
        Call,
        EventAssignmentOperator,
        Attribute,
        ObjectCreationExpression,
        TupleLiteral,
        ConvertedTupleLiteral,
        DynamicObjectCreationExpression,
        NoPiaObjectCreationExpression,
        ObjectInitializerExpression,
        ObjectInitializerMember,
        DynamicObjectInitializerMember,
        CollectionInitializerExpression,
        CollectionElementInitializer,
        DynamicCollectionElementInitializer,
        ImplicitReceiver,
        AnonymousObjectCreationExpression,
        AnonymousPropertyDeclaration,
        NewT,
        DelegateCreationExpression,
        ArrayCreation,
        ArrayInitialization,
        StackAllocArrayCreation,
        ConvertedStackAllocExpression,
        FieldAccess,
        HoistedFieldAccess,
        PropertyAccess,
        EventAccess,
        IndexerAccess,
        DynamicIndexerAccess,
        Lambda,
        UnboundLambda,
        QueryClause,
        TypeOrInstanceInitializers,
        NameOfOperator,
        InterpolatedString,
        StringInsert,
        IsPatternExpression,
        DeclarationPattern,
        ConstantPattern,
        WildcardPattern,
        DiscardExpression,
        ThrowExpression,
        OutVariablePendingInference,
        DeconstructionVariablePendingInference,
        OutDeconstructVarPendingInference,
    }










    internal abstract partial class BoundInitializer : BoundNode
    {
        protected BoundInitializer(BoundKind kind, SyntaxNode syntax, bool hasErrors)
            : base(kind, syntax, hasErrors)
        {
        }

        protected BoundInitializer(BoundKind kind, SyntaxNode syntax)
            : base(kind, syntax)
        {
        }

    }

    internal sealed partial class BoundFieldInitializer : BoundInitializer
    {
        public BoundFieldInitializer(SyntaxNode syntax, FieldSymbol field, BoundExpression initialValue, bool hasErrors = false)
            : base(BoundKind.FieldInitializer, syntax, hasErrors || initialValue.HasErrors())
        {

            Debug.Assert(field != null, "Field 'field' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(initialValue != null, "Field 'initialValue' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Field = field;
            this.InitialValue = initialValue;
        }


        public FieldSymbol Field { get; }

        public BoundExpression InitialValue { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitFieldInitializer(this);
        }

        public BoundFieldInitializer Update(FieldSymbol field, BoundExpression initialValue)
        {
            if (field != this.Field || initialValue != this.InitialValue)
            {
                var result = new BoundFieldInitializer(this.Syntax, field, initialValue, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal abstract partial class BoundEqualsValue : BoundNode
    {
        protected BoundEqualsValue(BoundKind kind, SyntaxNode syntax, BoundExpression value, bool hasErrors = false)
            : base(kind, syntax, hasErrors)
        {

            Debug.Assert(value != null, "Field 'value' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Value = value;
        }


        public BoundExpression Value { get; }
    }

    internal sealed partial class BoundFieldEqualsValue : BoundEqualsValue
    {
        public BoundFieldEqualsValue(SyntaxNode syntax, FieldSymbol field, BoundExpression value, bool hasErrors = false)
            : base(BoundKind.FieldEqualsValue, syntax, value, hasErrors || value.HasErrors())
        {

            Debug.Assert(field != null, "Field 'field' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(value != null, "Field 'value' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Field = field;
        }


        public FieldSymbol Field { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitFieldEqualsValue(this);
        }

        public BoundFieldEqualsValue Update(FieldSymbol field, BoundExpression value)
        {
            if (field != this.Field || value != this.Value)
            {
                var result = new BoundFieldEqualsValue(this.Syntax, field, value, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPropertyEqualsValue : BoundEqualsValue
    {
        public BoundPropertyEqualsValue(SyntaxNode syntax, PropertySymbol property, BoundExpression value, bool hasErrors = false)
            : base(BoundKind.PropertyEqualsValue, syntax, value, hasErrors || value.HasErrors())
        {

            Debug.Assert(property != null, "Field 'property' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(value != null, "Field 'value' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Property = property;
        }


        public PropertySymbol Property { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPropertyEqualsValue(this);
        }

        public BoundPropertyEqualsValue Update(PropertySymbol property, BoundExpression value)
        {
            if (property != this.Property || value != this.Value)
            {
                var result = new BoundPropertyEqualsValue(this.Syntax, property, value, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundParameterEqualsValue : BoundEqualsValue
    {
        public BoundParameterEqualsValue(SyntaxNode syntax, ParameterSymbol parameter, BoundExpression value, bool hasErrors = false)
            : base(BoundKind.ParameterEqualsValue, syntax, value, hasErrors || value.HasErrors())
        {

            Debug.Assert(parameter != null, "Field 'parameter' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(value != null, "Field 'value' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Parameter = parameter;
        }


        public ParameterSymbol Parameter { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitParameterEqualsValue(this);
        }

        public BoundParameterEqualsValue Update(ParameterSymbol parameter, BoundExpression value)
        {
            if (parameter != this.Parameter || value != this.Value)
            {
                var result = new BoundParameterEqualsValue(this.Syntax, parameter, value, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundGlobalStatementInitializer : BoundInitializer
    {
        public BoundGlobalStatementInitializer(SyntaxNode syntax, BoundStatement statement, bool hasErrors = false)
            : base(BoundKind.GlobalStatementInitializer, syntax, hasErrors || statement.HasErrors())
        {

            Debug.Assert(statement != null, "Field 'statement' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Statement = statement;
        }


        public BoundStatement Statement { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitGlobalStatementInitializer(this);
        }

        public BoundGlobalStatementInitializer Update(BoundStatement statement)
        {
            if (statement != this.Statement)
            {
                var result = new BoundGlobalStatementInitializer(this.Syntax, statement, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal abstract partial class BoundExpression : BoundNode
    {
        protected BoundExpression(BoundKind kind, SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(kind, syntax, hasErrors)
        {
            this.Type = type;
        }

        protected BoundExpression(BoundKind kind, SyntaxNode syntax, TypeSymbol type)
            : base(kind, syntax)
        {
            this.Type = type;
        }


        public TypeSymbol Type { get; }
    }

    internal abstract partial class BoundValuePlaceholderBase : BoundExpression
    {
        protected BoundValuePlaceholderBase(BoundKind kind, SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(kind, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

        protected BoundValuePlaceholderBase(BoundKind kind, SyntaxNode syntax, TypeSymbol type)
            : base(kind, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

    }

    internal sealed partial class BoundDeconstructValuePlaceholder : BoundValuePlaceholderBase
    {
        public BoundDeconstructValuePlaceholder(SyntaxNode syntax, uint valEscape, TypeSymbol type, bool hasErrors)
            : base(BoundKind.DeconstructValuePlaceholder, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ValEscape = valEscape;
        }

        public BoundDeconstructValuePlaceholder(SyntaxNode syntax, uint valEscape, TypeSymbol type)
            : base(BoundKind.DeconstructValuePlaceholder, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ValEscape = valEscape;
        }


        public uint ValEscape { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDeconstructValuePlaceholder(this);
        }

        public BoundDeconstructValuePlaceholder Update(uint valEscape, TypeSymbol type)
        {
            if (valEscape != this.ValEscape || type != this.Type)
            {
                var result = new BoundDeconstructValuePlaceholder(this.Syntax, valEscape, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundDup : BoundExpression
    {
        public BoundDup(SyntaxNode syntax, RefKind refKind, TypeSymbol type, bool hasErrors)
            : base(BoundKind.Dup, syntax, type, hasErrors)
        {
            this.RefKind = refKind;
        }

        public BoundDup(SyntaxNode syntax, RefKind refKind, TypeSymbol type)
            : base(BoundKind.Dup, syntax, type)
        {
            this.RefKind = refKind;
        }


        public RefKind RefKind { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDup(this);
        }

        public BoundDup Update(RefKind refKind, TypeSymbol type)
        {
            if (refKind != this.RefKind || type != this.Type)
            {
                var result = new BoundDup(this.Syntax, refKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundBadExpression : BoundExpression
    {
        public BoundBadExpression(SyntaxNode syntax, LookupResultKind resultKind, ImmutableArray<Symbol> symbols, ImmutableArray<BoundExpression> childBoundNodes, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.BadExpression, syntax, type, hasErrors || childBoundNodes.HasErrors())
        {

            Debug.Assert(!symbols.IsDefault, "Field 'symbols' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!childBoundNodes.IsDefault, "Field 'childBoundNodes' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this._ResultKind = resultKind;
            this.Symbols = symbols;
            this.ChildBoundNodes = childBoundNodes;
        }


        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public ImmutableArray<Symbol> Symbols { get; }

        public ImmutableArray<BoundExpression> ChildBoundNodes { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitBadExpression(this);
        }

        public BoundBadExpression Update(LookupResultKind resultKind, ImmutableArray<Symbol> symbols, ImmutableArray<BoundExpression> childBoundNodes, TypeSymbol type)
        {
            if (resultKind != this.ResultKind || symbols != this.Symbols || childBoundNodes != this.ChildBoundNodes || type != this.Type)
            {
                var result = new BoundBadExpression(this.Syntax, resultKind, symbols, childBoundNodes, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundBadStatement : BoundStatement
    {
        public BoundBadStatement(SyntaxNode syntax, ImmutableArray<BoundNode> childBoundNodes, bool hasErrors = false)
            : base(BoundKind.BadStatement, syntax, hasErrors || childBoundNodes.HasErrors())
        {

            Debug.Assert(!childBoundNodes.IsDefault, "Field 'childBoundNodes' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ChildBoundNodes = childBoundNodes;
        }


        public ImmutableArray<BoundNode> ChildBoundNodes { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitBadStatement(this);
        }

        public BoundBadStatement Update(ImmutableArray<BoundNode> childBoundNodes)
        {
            if (childBoundNodes != this.ChildBoundNodes)
            {
                var result = new BoundBadStatement(this.Syntax, childBoundNodes, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundTypeExpression : BoundExpression
    {
        public BoundTypeExpression(SyntaxNode syntax, AliasSymbol aliasOpt, bool inferredType, BoundTypeExpression boundContainingTypeOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.TypeExpression, syntax, type, hasErrors || boundContainingTypeOpt.HasErrors())
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.AliasOpt = aliasOpt;
            this.InferredType = inferredType;
            this.BoundContainingTypeOpt = boundContainingTypeOpt;
        }


        public AliasSymbol AliasOpt { get; }

        public bool InferredType { get; }

        public BoundTypeExpression BoundContainingTypeOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitTypeExpression(this);
        }

        public BoundTypeExpression Update(AliasSymbol aliasOpt, bool inferredType, BoundTypeExpression boundContainingTypeOpt, TypeSymbol type)
        {
            if (aliasOpt != this.AliasOpt || inferredType != this.InferredType || boundContainingTypeOpt != this.BoundContainingTypeOpt || type != this.Type)
            {
                var result = new BoundTypeExpression(this.Syntax, aliasOpt, inferredType, boundContainingTypeOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundTypeOrValueExpression : BoundExpression
    {
        public BoundTypeOrValueExpression(SyntaxNode syntax, BoundTypeOrValueData data, TypeSymbol type, bool hasErrors)
            : base(BoundKind.TypeOrValueExpression, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Data = data;
        }

        public BoundTypeOrValueExpression(SyntaxNode syntax, BoundTypeOrValueData data, TypeSymbol type)
            : base(BoundKind.TypeOrValueExpression, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Data = data;
        }


        public BoundTypeOrValueData Data { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitTypeOrValueExpression(this);
        }

        public BoundTypeOrValueExpression Update(BoundTypeOrValueData data, TypeSymbol type)
        {
            if (data != this.Data || type != this.Type)
            {
                var result = new BoundTypeOrValueExpression(this.Syntax, data, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundNamespaceExpression : BoundExpression
    {
        public BoundNamespaceExpression(SyntaxNode syntax, NamespaceSymbol namespaceSymbol, AliasSymbol aliasOpt, bool hasErrors)
            : base(BoundKind.NamespaceExpression, syntax, null, hasErrors)
        {

            Debug.Assert(namespaceSymbol != null, "Field 'namespaceSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.NamespaceSymbol = namespaceSymbol;
            this.AliasOpt = aliasOpt;
        }

        public BoundNamespaceExpression(SyntaxNode syntax, NamespaceSymbol namespaceSymbol, AliasSymbol aliasOpt)
            : base(BoundKind.NamespaceExpression, syntax, null)
        {

            Debug.Assert(namespaceSymbol != null, "Field 'namespaceSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.NamespaceSymbol = namespaceSymbol;
            this.AliasOpt = aliasOpt;
        }


        public NamespaceSymbol NamespaceSymbol { get; }

        public AliasSymbol AliasOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitNamespaceExpression(this);
        }

        public BoundNamespaceExpression Update(NamespaceSymbol namespaceSymbol, AliasSymbol aliasOpt)
        {
            if (namespaceSymbol != this.NamespaceSymbol || aliasOpt != this.AliasOpt)
            {
                var result = new BoundNamespaceExpression(this.Syntax, namespaceSymbol, aliasOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundUnaryOperator : BoundExpression
    {
        public BoundUnaryOperator(SyntaxNode syntax, UnaryOperatorKind operatorKind, BoundExpression operand, ConstantValue constantValueOpt, MethodSymbol methodOpt, LookupResultKind resultKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.UnaryOperator, syntax, type, hasErrors || operand.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.OperatorKind = operatorKind;
            this.Operand = operand;
            this.ConstantValueOpt = constantValueOpt;
            this.MethodOpt = methodOpt;
            this._ResultKind = resultKind;
        }


        public UnaryOperatorKind OperatorKind { get; }

        public BoundExpression Operand { get; }

        public ConstantValue ConstantValueOpt { get; }

        public MethodSymbol MethodOpt { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitUnaryOperator(this);
        }

        public BoundUnaryOperator Update(UnaryOperatorKind operatorKind, BoundExpression operand, ConstantValue constantValueOpt, MethodSymbol methodOpt, LookupResultKind resultKind, TypeSymbol type)
        {
            if (operatorKind != this.OperatorKind || operand != this.Operand || constantValueOpt != this.ConstantValueOpt || methodOpt != this.MethodOpt || resultKind != this.ResultKind || type != this.Type)
            {
                var result = new BoundUnaryOperator(this.Syntax, operatorKind, operand, constantValueOpt, methodOpt, resultKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundIncrementOperator : BoundExpression
    {
        public BoundIncrementOperator(SyntaxNode syntax, UnaryOperatorKind operatorKind, BoundExpression operand, MethodSymbol methodOpt, Conversion operandConversion, Conversion resultConversion, LookupResultKind resultKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.IncrementOperator, syntax, type, hasErrors || operand.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.OperatorKind = operatorKind;
            this.Operand = operand;
            this.MethodOpt = methodOpt;
            this.OperandConversion = operandConversion;
            this.ResultConversion = resultConversion;
            this._ResultKind = resultKind;
        }


        public UnaryOperatorKind OperatorKind { get; }

        public BoundExpression Operand { get; }

        public MethodSymbol MethodOpt { get; }

        public Conversion OperandConversion { get; }

        public Conversion ResultConversion { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitIncrementOperator(this);
        }

        public BoundIncrementOperator Update(UnaryOperatorKind operatorKind, BoundExpression operand, MethodSymbol methodOpt, Conversion operandConversion, Conversion resultConversion, LookupResultKind resultKind, TypeSymbol type)
        {
            if (operatorKind != this.OperatorKind || operand != this.Operand || methodOpt != this.MethodOpt || operandConversion != this.OperandConversion || resultConversion != this.ResultConversion || resultKind != this.ResultKind || type != this.Type)
            {
                var result = new BoundIncrementOperator(this.Syntax, operatorKind, operand, methodOpt, operandConversion, resultConversion, resultKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundAddressOfOperator : BoundExpression
    {
        public BoundAddressOfOperator(SyntaxNode syntax, BoundExpression operand, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.AddressOfOperator, syntax, type, hasErrors || operand.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Operand = operand;
        }


        public BoundExpression Operand { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitAddressOfOperator(this);
        }

        public BoundAddressOfOperator Update(BoundExpression operand, TypeSymbol type)
        {
            if (operand != this.Operand || type != this.Type)
            {
                var result = new BoundAddressOfOperator(this.Syntax, operand, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPointerIndirectionOperator : BoundExpression
    {
        public BoundPointerIndirectionOperator(SyntaxNode syntax, BoundExpression operand, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.PointerIndirectionOperator, syntax, type, hasErrors || operand.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Operand = operand;
        }


        public BoundExpression Operand { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPointerIndirectionOperator(this);
        }

        public BoundPointerIndirectionOperator Update(BoundExpression operand, TypeSymbol type)
        {
            if (operand != this.Operand || type != this.Type)
            {
                var result = new BoundPointerIndirectionOperator(this.Syntax, operand, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPointerElementAccess : BoundExpression
    {
        public BoundPointerElementAccess(SyntaxNode syntax, BoundExpression expression, BoundExpression index, Boolean @checked, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.PointerElementAccess, syntax, type, hasErrors || expression.HasErrors() || index.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(index != null, "Field 'index' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
            this.Index = index;
            this.Checked = @checked;
        }


        public BoundExpression Expression { get; }

        public BoundExpression Index { get; }

        public Boolean Checked { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPointerElementAccess(this);
        }

        public BoundPointerElementAccess Update(BoundExpression expression, BoundExpression index, Boolean @checked, TypeSymbol type)
        {
            if (expression != this.Expression || index != this.Index || @checked != this.Checked || type != this.Type)
            {
                var result = new BoundPointerElementAccess(this.Syntax, expression, index, @checked, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundRefTypeOperator : BoundExpression
    {
        public BoundRefTypeOperator(SyntaxNode syntax, BoundExpression operand, MethodSymbol getTypeFromHandle, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.RefTypeOperator, syntax, type, hasErrors || operand.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Operand = operand;
            this.GetTypeFromHandle = getTypeFromHandle;
        }


        public BoundExpression Operand { get; }

        public MethodSymbol GetTypeFromHandle { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitRefTypeOperator(this);
        }

        public BoundRefTypeOperator Update(BoundExpression operand, MethodSymbol getTypeFromHandle, TypeSymbol type)
        {
            if (operand != this.Operand || getTypeFromHandle != this.GetTypeFromHandle || type != this.Type)
            {
                var result = new BoundRefTypeOperator(this.Syntax, operand, getTypeFromHandle, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundMakeRefOperator : BoundExpression
    {
        public BoundMakeRefOperator(SyntaxNode syntax, BoundExpression operand, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.MakeRefOperator, syntax, type, hasErrors || operand.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Operand = operand;
        }


        public BoundExpression Operand { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitMakeRefOperator(this);
        }

        public BoundMakeRefOperator Update(BoundExpression operand, TypeSymbol type)
        {
            if (operand != this.Operand || type != this.Type)
            {
                var result = new BoundMakeRefOperator(this.Syntax, operand, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundRefValueOperator : BoundExpression
    {
        public BoundRefValueOperator(SyntaxNode syntax, BoundExpression operand, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.RefValueOperator, syntax, type, hasErrors || operand.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Operand = operand;
        }


        public BoundExpression Operand { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitRefValueOperator(this);
        }

        public BoundRefValueOperator Update(BoundExpression operand, TypeSymbol type)
        {
            if (operand != this.Operand || type != this.Type)
            {
                var result = new BoundRefValueOperator(this.Syntax, operand, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundBinaryOperator : BoundExpression
    {
        public BoundBinaryOperator(SyntaxNode syntax, BinaryOperatorKind operatorKind, BoundExpression left, BoundExpression right, ConstantValue constantValueOpt, MethodSymbol methodOpt, LookupResultKind resultKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.BinaryOperator, syntax, type, hasErrors || left.HasErrors() || right.HasErrors())
        {

            Debug.Assert(left != null, "Field 'left' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(right != null, "Field 'right' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.OperatorKind = operatorKind;
            this.Left = left;
            this.Right = right;
            this.ConstantValueOpt = constantValueOpt;
            this.MethodOpt = methodOpt;
            this._ResultKind = resultKind;
        }


        public BinaryOperatorKind OperatorKind { get; }

        public BoundExpression Left { get; }

        public BoundExpression Right { get; }

        public ConstantValue ConstantValueOpt { get; }

        public MethodSymbol MethodOpt { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitBinaryOperator(this);
        }

        public BoundBinaryOperator Update(BinaryOperatorKind operatorKind, BoundExpression left, BoundExpression right, ConstantValue constantValueOpt, MethodSymbol methodOpt, LookupResultKind resultKind, TypeSymbol type)
        {
            if (operatorKind != this.OperatorKind || left != this.Left || right != this.Right || constantValueOpt != this.ConstantValueOpt || methodOpt != this.MethodOpt || resultKind != this.ResultKind || type != this.Type)
            {
                var result = new BoundBinaryOperator(this.Syntax, operatorKind, left, right, constantValueOpt, methodOpt, resultKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundUserDefinedConditionalLogicalOperator : BoundExpression
    {
        public BoundUserDefinedConditionalLogicalOperator(SyntaxNode syntax, BinaryOperatorKind operatorKind, BoundExpression left, BoundExpression right, MethodSymbol logicalOperator, MethodSymbol trueOperator, MethodSymbol falseOperator, LookupResultKind resultKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.UserDefinedConditionalLogicalOperator, syntax, type, hasErrors || left.HasErrors() || right.HasErrors())
        {

            Debug.Assert(left != null, "Field 'left' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(right != null, "Field 'right' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(logicalOperator != null, "Field 'logicalOperator' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(trueOperator != null, "Field 'trueOperator' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(falseOperator != null, "Field 'falseOperator' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.OperatorKind = operatorKind;
            this.Left = left;
            this.Right = right;
            this.LogicalOperator = logicalOperator;
            this.TrueOperator = trueOperator;
            this.FalseOperator = falseOperator;
            this._ResultKind = resultKind;
        }


        public BinaryOperatorKind OperatorKind { get; }

        public BoundExpression Left { get; }

        public BoundExpression Right { get; }

        public MethodSymbol LogicalOperator { get; }

        public MethodSymbol TrueOperator { get; }

        public MethodSymbol FalseOperator { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitUserDefinedConditionalLogicalOperator(this);
        }

        public BoundUserDefinedConditionalLogicalOperator Update(BinaryOperatorKind operatorKind, BoundExpression left, BoundExpression right, MethodSymbol logicalOperator, MethodSymbol trueOperator, MethodSymbol falseOperator, LookupResultKind resultKind, TypeSymbol type)
        {
            if (operatorKind != this.OperatorKind || left != this.Left || right != this.Right || logicalOperator != this.LogicalOperator || trueOperator != this.TrueOperator || falseOperator != this.FalseOperator || resultKind != this.ResultKind || type != this.Type)
            {
                var result = new BoundUserDefinedConditionalLogicalOperator(this.Syntax, operatorKind, left, right, logicalOperator, trueOperator, falseOperator, resultKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundCompoundAssignmentOperator : BoundExpression
    {
        public BoundCompoundAssignmentOperator(SyntaxNode syntax, BinaryOperatorSignature @operator, BoundExpression left, BoundExpression right, Conversion leftConversion, Conversion finalConversion, LookupResultKind resultKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.CompoundAssignmentOperator, syntax, type, hasErrors || left.HasErrors() || right.HasErrors())
        {

            Debug.Assert(left != null, "Field 'left' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(right != null, "Field 'right' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Operator = @operator;
            this.Left = left;
            this.Right = right;
            this.LeftConversion = leftConversion;
            this.FinalConversion = finalConversion;
            this._ResultKind = resultKind;
        }


        public BinaryOperatorSignature Operator { get; }

        public BoundExpression Left { get; }

        public BoundExpression Right { get; }

        public Conversion LeftConversion { get; }

        public Conversion FinalConversion { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitCompoundAssignmentOperator(this);
        }

        public BoundCompoundAssignmentOperator Update(BinaryOperatorSignature @operator, BoundExpression left, BoundExpression right, Conversion leftConversion, Conversion finalConversion, LookupResultKind resultKind, TypeSymbol type)
        {
            if (@operator != this.Operator || left != this.Left || right != this.Right || leftConversion != this.LeftConversion || finalConversion != this.FinalConversion || resultKind != this.ResultKind || type != this.Type)
            {
                var result = new BoundCompoundAssignmentOperator(this.Syntax, @operator, left, right, leftConversion, finalConversion, resultKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundAssignmentOperator : BoundExpression
    {
        public BoundAssignmentOperator(SyntaxNode syntax, BoundExpression left, BoundExpression right, RefKind refKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.AssignmentOperator, syntax, type, hasErrors || left.HasErrors() || right.HasErrors())
        {

            Debug.Assert(left != null, "Field 'left' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Left = left;
            this.Right = right;
            this.RefKind = refKind;
        }


        public BoundExpression Left { get; }

        public BoundExpression Right { get; }

        public RefKind RefKind { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitAssignmentOperator(this);
        }

        public BoundAssignmentOperator Update(BoundExpression left, BoundExpression right, RefKind refKind, TypeSymbol type)
        {
            if (left != this.Left || right != this.Right || refKind != this.RefKind || type != this.Type)
            {
                var result = new BoundAssignmentOperator(this.Syntax, left, right, refKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundDeconstructionAssignmentOperator : BoundExpression
    {
        public BoundDeconstructionAssignmentOperator(SyntaxNode syntax, BoundTupleExpression left, BoundConversion right, Boolean isUsed, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.DeconstructionAssignmentOperator, syntax, type, hasErrors || left.HasErrors() || right.HasErrors())
        {

            Debug.Assert(left != null, "Field 'left' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(right != null, "Field 'right' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Left = left;
            this.Right = right;
            this.IsUsed = isUsed;
        }


        public BoundTupleExpression Left { get; }

        public BoundConversion Right { get; }

        public Boolean IsUsed { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDeconstructionAssignmentOperator(this);
        }

        public BoundDeconstructionAssignmentOperator Update(BoundTupleExpression left, BoundConversion right, Boolean isUsed, TypeSymbol type)
        {
            if (left != this.Left || right != this.Right || isUsed != this.IsUsed || type != this.Type)
            {
                var result = new BoundDeconstructionAssignmentOperator(this.Syntax, left, right, isUsed, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundNullCoalescingOperator : BoundExpression
    {
        public BoundNullCoalescingOperator(SyntaxNode syntax, BoundExpression leftOperand, BoundExpression rightOperand, Conversion leftConversion, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.NullCoalescingOperator, syntax, type, hasErrors || leftOperand.HasErrors() || rightOperand.HasErrors())
        {

            Debug.Assert(leftOperand != null, "Field 'leftOperand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(rightOperand != null, "Field 'rightOperand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.LeftOperand = leftOperand;
            this.RightOperand = rightOperand;
            this.LeftConversion = leftConversion;
        }


        public BoundExpression LeftOperand { get; }

        public BoundExpression RightOperand { get; }

        public Conversion LeftConversion { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitNullCoalescingOperator(this);
        }

        public BoundNullCoalescingOperator Update(BoundExpression leftOperand, BoundExpression rightOperand, Conversion leftConversion, TypeSymbol type)
        {
            if (leftOperand != this.LeftOperand || rightOperand != this.RightOperand || leftConversion != this.LeftConversion || type != this.Type)
            {
                var result = new BoundNullCoalescingOperator(this.Syntax, leftOperand, rightOperand, leftConversion, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundConditionalOperator : BoundExpression
    {
        public BoundConditionalOperator(SyntaxNode syntax, bool isByRef, BoundExpression condition, BoundExpression consequence, BoundExpression alternative, ConstantValue constantValueOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ConditionalOperator, syntax, type, hasErrors || condition.HasErrors() || consequence.HasErrors() || alternative.HasErrors())
        {

            Debug.Assert(condition != null, "Field 'condition' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(consequence != null, "Field 'consequence' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(alternative != null, "Field 'alternative' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.IsByRef = isByRef;
            this.Condition = condition;
            this.Consequence = consequence;
            this.Alternative = alternative;
            this.ConstantValueOpt = constantValueOpt;
        }


        public bool IsByRef { get; }

        public BoundExpression Condition { get; }

        public BoundExpression Consequence { get; }

        public BoundExpression Alternative { get; }

        public ConstantValue ConstantValueOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitConditionalOperator(this);
        }

        public BoundConditionalOperator Update(bool isByRef, BoundExpression condition, BoundExpression consequence, BoundExpression alternative, ConstantValue constantValueOpt, TypeSymbol type)
        {
            if (isByRef != this.IsByRef || condition != this.Condition || consequence != this.Consequence || alternative != this.Alternative || constantValueOpt != this.ConstantValueOpt || type != this.Type)
            {
                var result = new BoundConditionalOperator(this.Syntax, isByRef, condition, consequence, alternative, constantValueOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundArrayAccess : BoundExpression
    {
        public BoundArrayAccess(SyntaxNode syntax, BoundExpression expression, ImmutableArray<BoundExpression> indices, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ArrayAccess, syntax, type, hasErrors || expression.HasErrors() || indices.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!indices.IsDefault, "Field 'indices' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
            this.Indices = indices;
        }


        public BoundExpression Expression { get; }

        public ImmutableArray<BoundExpression> Indices { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitArrayAccess(this);
        }

        public BoundArrayAccess Update(BoundExpression expression, ImmutableArray<BoundExpression> indices, TypeSymbol type)
        {
            if (expression != this.Expression || indices != this.Indices || type != this.Type)
            {
                var result = new BoundArrayAccess(this.Syntax, expression, indices, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundArrayLength : BoundExpression
    {
        public BoundArrayLength(SyntaxNode syntax, BoundExpression expression, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ArrayLength, syntax, type, hasErrors || expression.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
        }


        public BoundExpression Expression { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitArrayLength(this);
        }

        public BoundArrayLength Update(BoundExpression expression, TypeSymbol type)
        {
            if (expression != this.Expression || type != this.Type)
            {
                var result = new BoundArrayLength(this.Syntax, expression, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundAwaitExpression : BoundExpression
    {
        public BoundAwaitExpression(SyntaxNode syntax, BoundExpression expression, MethodSymbol getAwaiter, PropertySymbol isCompleted, MethodSymbol getResult, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.AwaitExpression, syntax, type, hasErrors || expression.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
            this.GetAwaiter = getAwaiter;
            this.IsCompleted = isCompleted;
            this.GetResult = getResult;
        }


        public BoundExpression Expression { get; }

        public MethodSymbol GetAwaiter { get; }

        public PropertySymbol IsCompleted { get; }

        public MethodSymbol GetResult { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitAwaitExpression(this);
        }

        public BoundAwaitExpression Update(BoundExpression expression, MethodSymbol getAwaiter, PropertySymbol isCompleted, MethodSymbol getResult, TypeSymbol type)
        {
            if (expression != this.Expression || getAwaiter != this.GetAwaiter || isCompleted != this.IsCompleted || getResult != this.GetResult || type != this.Type)
            {
                var result = new BoundAwaitExpression(this.Syntax, expression, getAwaiter, isCompleted, getResult, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal abstract partial class BoundTypeOf : BoundExpression
    {
        protected BoundTypeOf(BoundKind kind, SyntaxNode syntax, MethodSymbol getTypeFromHandle, TypeSymbol type, bool hasErrors)
            : base(kind, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.GetTypeFromHandle = getTypeFromHandle;
        }

        protected BoundTypeOf(BoundKind kind, SyntaxNode syntax, MethodSymbol getTypeFromHandle, TypeSymbol type)
            : base(kind, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.GetTypeFromHandle = getTypeFromHandle;
        }


        public MethodSymbol GetTypeFromHandle { get; }
    }

    internal sealed partial class BoundTypeOfOperator : BoundTypeOf
    {
        public BoundTypeOfOperator(SyntaxNode syntax, BoundTypeExpression sourceType, MethodSymbol getTypeFromHandle, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.TypeOfOperator, syntax, getTypeFromHandle, type, hasErrors || sourceType.HasErrors())
        {

            Debug.Assert(sourceType != null, "Field 'sourceType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.SourceType = sourceType;
        }


        public BoundTypeExpression SourceType { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitTypeOfOperator(this);
        }

        public BoundTypeOfOperator Update(BoundTypeExpression sourceType, MethodSymbol getTypeFromHandle, TypeSymbol type)
        {
            if (sourceType != this.SourceType || getTypeFromHandle != this.GetTypeFromHandle || type != this.Type)
            {
                var result = new BoundTypeOfOperator(this.Syntax, sourceType, getTypeFromHandle, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundMethodDefIndex : BoundExpression
    {
        public BoundMethodDefIndex(SyntaxNode syntax, MethodSymbol method, TypeSymbol type, bool hasErrors)
            : base(BoundKind.MethodDefIndex, syntax, type, hasErrors)
        {

            Debug.Assert(method != null, "Field 'method' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Method = method;
        }

        public BoundMethodDefIndex(SyntaxNode syntax, MethodSymbol method, TypeSymbol type)
            : base(BoundKind.MethodDefIndex, syntax, type)
        {

            Debug.Assert(method != null, "Field 'method' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Method = method;
        }


        public MethodSymbol Method { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitMethodDefIndex(this);
        }

        public BoundMethodDefIndex Update(MethodSymbol method, TypeSymbol type)
        {
            if (method != this.Method || type != this.Type)
            {
                var result = new BoundMethodDefIndex(this.Syntax, method, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundMaximumMethodDefIndex : BoundExpression
    {
        public BoundMaximumMethodDefIndex(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.MaximumMethodDefIndex, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

        public BoundMaximumMethodDefIndex(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.MaximumMethodDefIndex, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitMaximumMethodDefIndex(this);
        }

        public BoundMaximumMethodDefIndex Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundMaximumMethodDefIndex(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundInstrumentationPayloadRoot : BoundExpression
    {
        public BoundInstrumentationPayloadRoot(SyntaxNode syntax, int analysisKind, TypeSymbol type, bool hasErrors)
            : base(BoundKind.InstrumentationPayloadRoot, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.AnalysisKind = analysisKind;
        }

        public BoundInstrumentationPayloadRoot(SyntaxNode syntax, int analysisKind, TypeSymbol type)
            : base(BoundKind.InstrumentationPayloadRoot, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.AnalysisKind = analysisKind;
        }


        public int AnalysisKind { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitInstrumentationPayloadRoot(this);
        }

        public BoundInstrumentationPayloadRoot Update(int analysisKind, TypeSymbol type)
        {
            if (analysisKind != this.AnalysisKind || type != this.Type)
            {
                var result = new BoundInstrumentationPayloadRoot(this.Syntax, analysisKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundModuleVersionId : BoundExpression
    {
        public BoundModuleVersionId(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.ModuleVersionId, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

        public BoundModuleVersionId(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.ModuleVersionId, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitModuleVersionId(this);
        }

        public BoundModuleVersionId Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundModuleVersionId(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundModuleVersionIdString : BoundExpression
    {
        public BoundModuleVersionIdString(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.ModuleVersionIdString, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

        public BoundModuleVersionIdString(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.ModuleVersionIdString, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitModuleVersionIdString(this);
        }

        public BoundModuleVersionIdString Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundModuleVersionIdString(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundSourceDocumentIndex : BoundExpression
    {
        public BoundSourceDocumentIndex(SyntaxNode syntax, Cci.DebugSourceDocument document, TypeSymbol type, bool hasErrors)
            : base(BoundKind.SourceDocumentIndex, syntax, type, hasErrors)
        {

            Debug.Assert(document != null, "Field 'document' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Document = document;
        }

        public BoundSourceDocumentIndex(SyntaxNode syntax, Cci.DebugSourceDocument document, TypeSymbol type)
            : base(BoundKind.SourceDocumentIndex, syntax, type)
        {

            Debug.Assert(document != null, "Field 'document' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Document = document;
        }


        public Cci.DebugSourceDocument Document { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitSourceDocumentIndex(this);
        }

        public BoundSourceDocumentIndex Update(Cci.DebugSourceDocument document, TypeSymbol type)
        {
            if (document != this.Document || type != this.Type)
            {
                var result = new BoundSourceDocumentIndex(this.Syntax, document, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundMethodInfo : BoundExpression
    {
        public BoundMethodInfo(SyntaxNode syntax, MethodSymbol method, MethodSymbol getMethodFromHandle, TypeSymbol type, bool hasErrors)
            : base(BoundKind.MethodInfo, syntax, type, hasErrors)
        {

            Debug.Assert(method != null, "Field 'method' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Method = method;
            this.GetMethodFromHandle = getMethodFromHandle;
        }

        public BoundMethodInfo(SyntaxNode syntax, MethodSymbol method, MethodSymbol getMethodFromHandle, TypeSymbol type)
            : base(BoundKind.MethodInfo, syntax, type)
        {

            Debug.Assert(method != null, "Field 'method' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Method = method;
            this.GetMethodFromHandle = getMethodFromHandle;
        }


        public MethodSymbol Method { get; }

        public MethodSymbol GetMethodFromHandle { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitMethodInfo(this);
        }

        public BoundMethodInfo Update(MethodSymbol method, MethodSymbol getMethodFromHandle, TypeSymbol type)
        {
            if (method != this.Method || getMethodFromHandle != this.GetMethodFromHandle || type != this.Type)
            {
                var result = new BoundMethodInfo(this.Syntax, method, getMethodFromHandle, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundFieldInfo : BoundExpression
    {
        public BoundFieldInfo(SyntaxNode syntax, FieldSymbol field, MethodSymbol getFieldFromHandle, TypeSymbol type, bool hasErrors)
            : base(BoundKind.FieldInfo, syntax, type, hasErrors)
        {

            Debug.Assert(field != null, "Field 'field' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Field = field;
            this.GetFieldFromHandle = getFieldFromHandle;
        }

        public BoundFieldInfo(SyntaxNode syntax, FieldSymbol field, MethodSymbol getFieldFromHandle, TypeSymbol type)
            : base(BoundKind.FieldInfo, syntax, type)
        {

            Debug.Assert(field != null, "Field 'field' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Field = field;
            this.GetFieldFromHandle = getFieldFromHandle;
        }


        public FieldSymbol Field { get; }

        public MethodSymbol GetFieldFromHandle { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitFieldInfo(this);
        }

        public BoundFieldInfo Update(FieldSymbol field, MethodSymbol getFieldFromHandle, TypeSymbol type)
        {
            if (field != this.Field || getFieldFromHandle != this.GetFieldFromHandle || type != this.Type)
            {
                var result = new BoundFieldInfo(this.Syntax, field, getFieldFromHandle, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundDefaultExpression : BoundExpression
    {
        public BoundDefaultExpression(SyntaxNode syntax, ConstantValue constantValueOpt, TypeSymbol type, bool hasErrors)
            : base(BoundKind.DefaultExpression, syntax, type, hasErrors)
        {
            this.ConstantValueOpt = constantValueOpt;
        }

        public BoundDefaultExpression(SyntaxNode syntax, ConstantValue constantValueOpt, TypeSymbol type)
            : base(BoundKind.DefaultExpression, syntax, type)
        {
            this.ConstantValueOpt = constantValueOpt;
        }


        public ConstantValue ConstantValueOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDefaultExpression(this);
        }

        public BoundDefaultExpression Update(ConstantValue constantValueOpt, TypeSymbol type)
        {
            if (constantValueOpt != this.ConstantValueOpt || type != this.Type)
            {
                var result = new BoundDefaultExpression(this.Syntax, constantValueOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundIsOperator : BoundExpression
    {
        public BoundIsOperator(SyntaxNode syntax, BoundExpression operand, BoundTypeExpression targetType, Conversion conversion, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.IsOperator, syntax, type, hasErrors || operand.HasErrors() || targetType.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(targetType != null, "Field 'targetType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Operand = operand;
            this.TargetType = targetType;
            this.Conversion = conversion;
        }


        public BoundExpression Operand { get; }

        public BoundTypeExpression TargetType { get; }

        public Conversion Conversion { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitIsOperator(this);
        }

        public BoundIsOperator Update(BoundExpression operand, BoundTypeExpression targetType, Conversion conversion, TypeSymbol type)
        {
            if (operand != this.Operand || targetType != this.TargetType || conversion != this.Conversion || type != this.Type)
            {
                var result = new BoundIsOperator(this.Syntax, operand, targetType, conversion, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundAsOperator : BoundExpression
    {
        public BoundAsOperator(SyntaxNode syntax, BoundExpression operand, BoundTypeExpression targetType, Conversion conversion, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.AsOperator, syntax, type, hasErrors || operand.HasErrors() || targetType.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(targetType != null, "Field 'targetType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Operand = operand;
            this.TargetType = targetType;
            this.Conversion = conversion;
        }


        public BoundExpression Operand { get; }

        public BoundTypeExpression TargetType { get; }

        public Conversion Conversion { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitAsOperator(this);
        }

        public BoundAsOperator Update(BoundExpression operand, BoundTypeExpression targetType, Conversion conversion, TypeSymbol type)
        {
            if (operand != this.Operand || targetType != this.TargetType || conversion != this.Conversion || type != this.Type)
            {
                var result = new BoundAsOperator(this.Syntax, operand, targetType, conversion, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundSizeOfOperator : BoundExpression
    {
        public BoundSizeOfOperator(SyntaxNode syntax, BoundTypeExpression sourceType, ConstantValue constantValueOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.SizeOfOperator, syntax, type, hasErrors || sourceType.HasErrors())
        {

            Debug.Assert(sourceType != null, "Field 'sourceType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.SourceType = sourceType;
            this.ConstantValueOpt = constantValueOpt;
        }


        public BoundTypeExpression SourceType { get; }

        public ConstantValue ConstantValueOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitSizeOfOperator(this);
        }

        public BoundSizeOfOperator Update(BoundTypeExpression sourceType, ConstantValue constantValueOpt, TypeSymbol type)
        {
            if (sourceType != this.SourceType || constantValueOpt != this.ConstantValueOpt || type != this.Type)
            {
                var result = new BoundSizeOfOperator(this.Syntax, sourceType, constantValueOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundConversion : BoundExpression
    {
        public BoundConversion(SyntaxNode syntax, BoundExpression operand, Conversion conversion, Boolean isBaseConversion, Boolean @checked, Boolean explicitCastInCode, ConstantValue constantValueOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.Conversion, syntax, type, hasErrors || operand.HasErrors())
        {

            Debug.Assert(operand != null, "Field 'operand' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Operand = operand;
            this.Conversion = conversion;
            this.IsBaseConversion = isBaseConversion;
            this.Checked = @checked;
            this.ExplicitCastInCode = explicitCastInCode;
            this.ConstantValueOpt = constantValueOpt;
        }


        public BoundExpression Operand { get; }

        public Conversion Conversion { get; }

        public Boolean IsBaseConversion { get; }

        public Boolean Checked { get; }

        public Boolean ExplicitCastInCode { get; }

        public ConstantValue ConstantValueOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitConversion(this);
        }

        public BoundConversion Update(BoundExpression operand, Conversion conversion, Boolean isBaseConversion, Boolean @checked, Boolean explicitCastInCode, ConstantValue constantValueOpt, TypeSymbol type)
        {
            if (operand != this.Operand || conversion != this.Conversion || isBaseConversion != this.IsBaseConversion || @checked != this.Checked || explicitCastInCode != this.ExplicitCastInCode || constantValueOpt != this.ConstantValueOpt || type != this.Type)
            {
                var result = new BoundConversion(this.Syntax, operand, conversion, isBaseConversion, @checked, explicitCastInCode, constantValueOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundArgList : BoundExpression
    {
        public BoundArgList(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.ArgList, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

        public BoundArgList(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.ArgList, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitArgList(this);
        }

        public BoundArgList Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundArgList(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundArgListOperator : BoundExpression
    {
        public BoundArgListOperator(SyntaxNode syntax, ImmutableArray<BoundExpression> arguments, ImmutableArray<RefKind> argumentRefKindsOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ArgListOperator, syntax, type, hasErrors || arguments.HasErrors())
        {

            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Arguments = arguments;
            this.ArgumentRefKindsOpt = argumentRefKindsOpt;
        }


        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<RefKind> ArgumentRefKindsOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitArgListOperator(this);
        }

        public BoundArgListOperator Update(ImmutableArray<BoundExpression> arguments, ImmutableArray<RefKind> argumentRefKindsOpt, TypeSymbol type)
        {
            if (arguments != this.Arguments || argumentRefKindsOpt != this.ArgumentRefKindsOpt || type != this.Type)
            {
                var result = new BoundArgListOperator(this.Syntax, arguments, argumentRefKindsOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundFixedLocalCollectionInitializer : BoundExpression
    {
        public BoundFixedLocalCollectionInitializer(SyntaxNode syntax, TypeSymbol elementPointerType, Conversion elementPointerTypeConversion, BoundExpression expression, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.FixedLocalCollectionInitializer, syntax, type, hasErrors || expression.HasErrors())
        {

            Debug.Assert(elementPointerType != null, "Field 'elementPointerType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ElementPointerType = elementPointerType;
            this.ElementPointerTypeConversion = elementPointerTypeConversion;
            this.Expression = expression;
        }


        public TypeSymbol ElementPointerType { get; }

        public Conversion ElementPointerTypeConversion { get; }

        public BoundExpression Expression { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitFixedLocalCollectionInitializer(this);
        }

        public BoundFixedLocalCollectionInitializer Update(TypeSymbol elementPointerType, Conversion elementPointerTypeConversion, BoundExpression expression, TypeSymbol type)
        {
            if (elementPointerType != this.ElementPointerType || elementPointerTypeConversion != this.ElementPointerTypeConversion || expression != this.Expression || type != this.Type)
            {
                var result = new BoundFixedLocalCollectionInitializer(this.Syntax, elementPointerType, elementPointerTypeConversion, expression, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal abstract partial class BoundStatement : BoundNode
    {
        protected BoundStatement(BoundKind kind, SyntaxNode syntax, bool hasErrors)
            : base(kind, syntax, hasErrors)
        {
        }

        protected BoundStatement(BoundKind kind, SyntaxNode syntax)
            : base(kind, syntax)
        {
        }

    }

    internal sealed partial class BoundSequencePoint : BoundStatement
    {
        public BoundSequencePoint(SyntaxNode syntax, BoundStatement statementOpt, bool hasErrors = false)
            : base(BoundKind.SequencePoint, syntax, hasErrors || statementOpt.HasErrors())
        {
            this.StatementOpt = statementOpt;
        }


        public BoundStatement StatementOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitSequencePoint(this);
        }

        public BoundSequencePoint Update(BoundStatement statementOpt)
        {
            if (statementOpt != this.StatementOpt)
            {
                var result = new BoundSequencePoint(this.Syntax, statementOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundSequencePointExpression : BoundExpression
    {
        public BoundSequencePointExpression(SyntaxNode syntax, BoundExpression expression, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.SequencePointExpression, syntax, type, hasErrors || expression.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
        }


        public BoundExpression Expression { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitSequencePointExpression(this);
        }

        public BoundSequencePointExpression Update(BoundExpression expression, TypeSymbol type)
        {
            if (expression != this.Expression || type != this.Type)
            {
                var result = new BoundSequencePointExpression(this.Syntax, expression, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundSequencePointWithSpan : BoundStatement
    {
        public BoundSequencePointWithSpan(SyntaxNode syntax, BoundStatement statementOpt, TextSpan span, bool hasErrors = false)
            : base(BoundKind.SequencePointWithSpan, syntax, hasErrors || statementOpt.HasErrors())
        {
            this.StatementOpt = statementOpt;
            this.Span = span;
        }


        public BoundStatement StatementOpt { get; }

        public TextSpan Span { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitSequencePointWithSpan(this);
        }

        public BoundSequencePointWithSpan Update(BoundStatement statementOpt, TextSpan span)
        {
            if (statementOpt != this.StatementOpt || span != this.Span)
            {
                var result = new BoundSequencePointWithSpan(this.Syntax, statementOpt, span, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundBlock : BoundStatementList
    {
        public BoundBlock(SyntaxNode syntax, ImmutableArray<LocalSymbol> locals, ImmutableArray<LocalFunctionSymbol> localFunctions, ImmutableArray<BoundStatement> statements, bool hasErrors = false)
            : base(BoundKind.Block, syntax, statements, hasErrors || statements.HasErrors())
        {

            Debug.Assert(!locals.IsDefault, "Field 'locals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!localFunctions.IsDefault, "Field 'localFunctions' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!statements.IsDefault, "Field 'statements' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Locals = locals;
            this.LocalFunctions = localFunctions;
        }


        public ImmutableArray<LocalSymbol> Locals { get; }

        public ImmutableArray<LocalFunctionSymbol> LocalFunctions { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitBlock(this);
        }

        public BoundBlock Update(ImmutableArray<LocalSymbol> locals, ImmutableArray<LocalFunctionSymbol> localFunctions, ImmutableArray<BoundStatement> statements)
        {
            if (locals != this.Locals || localFunctions != this.LocalFunctions || statements != this.Statements)
            {
                var result = new BoundBlock(this.Syntax, locals, localFunctions, statements, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundScope : BoundStatementList
    {
        public BoundScope(SyntaxNode syntax, ImmutableArray<LocalSymbol> locals, ImmutableArray<BoundStatement> statements, bool hasErrors = false)
            : base(BoundKind.Scope, syntax, statements, hasErrors || statements.HasErrors())
        {

            Debug.Assert(!locals.IsDefault, "Field 'locals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!statements.IsDefault, "Field 'statements' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Locals = locals;
        }


        public ImmutableArray<LocalSymbol> Locals { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitScope(this);
        }

        public BoundScope Update(ImmutableArray<LocalSymbol> locals, ImmutableArray<BoundStatement> statements)
        {
            if (locals != this.Locals || statements != this.Statements)
            {
                var result = new BoundScope(this.Syntax, locals, statements, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundStateMachineScope : BoundStatement
    {
        public BoundStateMachineScope(SyntaxNode syntax, ImmutableArray<StateMachineFieldSymbol> fields, BoundStatement statement, bool hasErrors = false)
            : base(BoundKind.StateMachineScope, syntax, hasErrors || statement.HasErrors())
        {

            Debug.Assert(!fields.IsDefault, "Field 'fields' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(statement != null, "Field 'statement' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Fields = fields;
            this.Statement = statement;
        }


        public ImmutableArray<StateMachineFieldSymbol> Fields { get; }

        public BoundStatement Statement { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitStateMachineScope(this);
        }

        public BoundStateMachineScope Update(ImmutableArray<StateMachineFieldSymbol> fields, BoundStatement statement)
        {
            if (fields != this.Fields || statement != this.Statement)
            {
                var result = new BoundStateMachineScope(this.Syntax, fields, statement, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLocalDeclaration : BoundStatement
    {
        public BoundLocalDeclaration(SyntaxNode syntax, LocalSymbol localSymbol, BoundTypeExpression declaredType, BoundExpression initializerOpt, ImmutableArray<BoundExpression> argumentsOpt, bool hasErrors = false)
            : base(BoundKind.LocalDeclaration, syntax, hasErrors || declaredType.HasErrors() || initializerOpt.HasErrors() || argumentsOpt.HasErrors())
        {

            Debug.Assert(localSymbol != null, "Field 'localSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(declaredType != null, "Field 'declaredType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.LocalSymbol = localSymbol;
            this.DeclaredType = declaredType;
            this.InitializerOpt = initializerOpt;
            this.ArgumentsOpt = argumentsOpt;
        }


        public LocalSymbol LocalSymbol { get; }

        public BoundTypeExpression DeclaredType { get; }

        public BoundExpression InitializerOpt { get; }

        public ImmutableArray<BoundExpression> ArgumentsOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLocalDeclaration(this);
        }

        public BoundLocalDeclaration Update(LocalSymbol localSymbol, BoundTypeExpression declaredType, BoundExpression initializerOpt, ImmutableArray<BoundExpression> argumentsOpt)
        {
            if (localSymbol != this.LocalSymbol || declaredType != this.DeclaredType || initializerOpt != this.InitializerOpt || argumentsOpt != this.ArgumentsOpt)
            {
                var result = new BoundLocalDeclaration(this.Syntax, localSymbol, declaredType, initializerOpt, argumentsOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundMultipleLocalDeclarations : BoundStatement
    {
        public BoundMultipleLocalDeclarations(SyntaxNode syntax, ImmutableArray<BoundLocalDeclaration> localDeclarations, bool hasErrors = false)
            : base(BoundKind.MultipleLocalDeclarations, syntax, hasErrors || localDeclarations.HasErrors())
        {

            Debug.Assert(!localDeclarations.IsDefault, "Field 'localDeclarations' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.LocalDeclarations = localDeclarations;
        }


        public ImmutableArray<BoundLocalDeclaration> LocalDeclarations { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitMultipleLocalDeclarations(this);
        }

        public BoundMultipleLocalDeclarations Update(ImmutableArray<BoundLocalDeclaration> localDeclarations)
        {
            if (localDeclarations != this.LocalDeclarations)
            {
                var result = new BoundMultipleLocalDeclarations(this.Syntax, localDeclarations, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLocalFunctionStatement : BoundStatement
    {
        public BoundLocalFunctionStatement(SyntaxNode syntax, LocalFunctionSymbol symbol, BoundBlock body, bool hasErrors = false)
            : base(BoundKind.LocalFunctionStatement, syntax, hasErrors || body.HasErrors())
        {

            Debug.Assert(symbol != null, "Field 'symbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Symbol = symbol;
            this.Body = body;
        }


        public LocalFunctionSymbol Symbol { get; }

        public BoundBlock Body { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLocalFunctionStatement(this);
        }

        public BoundLocalFunctionStatement Update(LocalFunctionSymbol symbol, BoundBlock body)
        {
            if (symbol != this.Symbol || body != this.Body)
            {
                var result = new BoundLocalFunctionStatement(this.Syntax, symbol, body, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundSequence : BoundExpression
    {
        public BoundSequence(SyntaxNode syntax, ImmutableArray<LocalSymbol> locals, ImmutableArray<BoundExpression> sideEffects, BoundExpression value, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.Sequence, syntax, type, hasErrors || sideEffects.HasErrors() || value.HasErrors())
        {

            Debug.Assert(!locals.IsDefault, "Field 'locals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!sideEffects.IsDefault, "Field 'sideEffects' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(value != null, "Field 'value' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Locals = locals;
            this.SideEffects = sideEffects;
            this.Value = value;
        }


        public ImmutableArray<LocalSymbol> Locals { get; }

        public ImmutableArray<BoundExpression> SideEffects { get; }

        public BoundExpression Value { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitSequence(this);
        }

        public BoundSequence Update(ImmutableArray<LocalSymbol> locals, ImmutableArray<BoundExpression> sideEffects, BoundExpression value, TypeSymbol type)
        {
            if (locals != this.Locals || sideEffects != this.SideEffects || value != this.Value || type != this.Type)
            {
                var result = new BoundSequence(this.Syntax, locals, sideEffects, value, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundNoOpStatement : BoundStatement
    {
        public BoundNoOpStatement(SyntaxNode syntax, NoOpStatementFlavor flavor, bool hasErrors)
            : base(BoundKind.NoOpStatement, syntax, hasErrors)
        {
            this.Flavor = flavor;
        }

        public BoundNoOpStatement(SyntaxNode syntax, NoOpStatementFlavor flavor)
            : base(BoundKind.NoOpStatement, syntax)
        {
            this.Flavor = flavor;
        }


        public NoOpStatementFlavor Flavor { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitNoOpStatement(this);
        }

        public BoundNoOpStatement Update(NoOpStatementFlavor flavor)
        {
            if (flavor != this.Flavor)
            {
                var result = new BoundNoOpStatement(this.Syntax, flavor, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundReturnStatement : BoundStatement
    {
        public BoundReturnStatement(SyntaxNode syntax, RefKind refKind, BoundExpression expressionOpt, bool hasErrors = false)
            : base(BoundKind.ReturnStatement, syntax, hasErrors || expressionOpt.HasErrors())
        {
            this.RefKind = refKind;
            this.ExpressionOpt = expressionOpt;
        }


        public RefKind RefKind { get; }

        public BoundExpression ExpressionOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitReturnStatement(this);
        }

        public BoundReturnStatement Update(RefKind refKind, BoundExpression expressionOpt)
        {
            if (refKind != this.RefKind || expressionOpt != this.ExpressionOpt)
            {
                var result = new BoundReturnStatement(this.Syntax, refKind, expressionOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundYieldReturnStatement : BoundStatement
    {
        public BoundYieldReturnStatement(SyntaxNode syntax, BoundExpression expression, bool hasErrors = false)
            : base(BoundKind.YieldReturnStatement, syntax, hasErrors || expression.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
        }


        public BoundExpression Expression { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitYieldReturnStatement(this);
        }

        public BoundYieldReturnStatement Update(BoundExpression expression)
        {
            if (expression != this.Expression)
            {
                var result = new BoundYieldReturnStatement(this.Syntax, expression, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundYieldBreakStatement : BoundStatement
    {
        public BoundYieldBreakStatement(SyntaxNode syntax, bool hasErrors)
            : base(BoundKind.YieldBreakStatement, syntax, hasErrors)
        {
        }

        public BoundYieldBreakStatement(SyntaxNode syntax)
            : base(BoundKind.YieldBreakStatement, syntax)
        {
        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitYieldBreakStatement(this);
        }
    }

    internal sealed partial class BoundThrowStatement : BoundStatement
    {
        public BoundThrowStatement(SyntaxNode syntax, BoundExpression expressionOpt, bool hasErrors = false)
            : base(BoundKind.ThrowStatement, syntax, hasErrors || expressionOpt.HasErrors())
        {
            this.ExpressionOpt = expressionOpt;
        }


        public BoundExpression ExpressionOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitThrowStatement(this);
        }

        public BoundThrowStatement Update(BoundExpression expressionOpt)
        {
            if (expressionOpt != this.ExpressionOpt)
            {
                var result = new BoundThrowStatement(this.Syntax, expressionOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundExpressionStatement : BoundStatement
    {
        public BoundExpressionStatement(SyntaxNode syntax, BoundExpression expression, bool hasErrors = false)
            : base(BoundKind.ExpressionStatement, syntax, hasErrors || expression.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
        }


        public BoundExpression Expression { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitExpressionStatement(this);
        }

        public BoundExpressionStatement Update(BoundExpression expression)
        {
            if (expression != this.Expression)
            {
                var result = new BoundExpressionStatement(this.Syntax, expression, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundSwitchStatement : BoundStatement
    {
        public BoundSwitchStatement(SyntaxNode syntax, BoundStatement loweredPreambleOpt, BoundExpression expression, LabelSymbol constantTargetOpt, ImmutableArray<LocalSymbol> innerLocals, ImmutableArray<LocalFunctionSymbol> innerLocalFunctions, ImmutableArray<BoundSwitchSection> switchSections, GeneratedLabelSymbol breakLabel, MethodSymbol stringEquality, bool hasErrors = false)
            : base(BoundKind.SwitchStatement, syntax, hasErrors || loweredPreambleOpt.HasErrors() || expression.HasErrors() || switchSections.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!innerLocals.IsDefault, "Field 'innerLocals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!innerLocalFunctions.IsDefault, "Field 'innerLocalFunctions' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!switchSections.IsDefault, "Field 'switchSections' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(breakLabel != null, "Field 'breakLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.LoweredPreambleOpt = loweredPreambleOpt;
            this.Expression = expression;
            this.ConstantTargetOpt = constantTargetOpt;
            this.InnerLocals = innerLocals;
            this.InnerLocalFunctions = innerLocalFunctions;
            this.SwitchSections = switchSections;
            this.BreakLabel = breakLabel;
            this.StringEquality = stringEquality;
        }


        public BoundStatement LoweredPreambleOpt { get; }

        public BoundExpression Expression { get; }

        public LabelSymbol ConstantTargetOpt { get; }

        public ImmutableArray<LocalSymbol> InnerLocals { get; }

        public ImmutableArray<LocalFunctionSymbol> InnerLocalFunctions { get; }

        public ImmutableArray<BoundSwitchSection> SwitchSections { get; }

        public GeneratedLabelSymbol BreakLabel { get; }

        public MethodSymbol StringEquality { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitSwitchStatement(this);
        }

        public BoundSwitchStatement Update(BoundStatement loweredPreambleOpt, BoundExpression expression, LabelSymbol constantTargetOpt, ImmutableArray<LocalSymbol> innerLocals, ImmutableArray<LocalFunctionSymbol> innerLocalFunctions, ImmutableArray<BoundSwitchSection> switchSections, GeneratedLabelSymbol breakLabel, MethodSymbol stringEquality)
        {
            if (loweredPreambleOpt != this.LoweredPreambleOpt || expression != this.Expression || constantTargetOpt != this.ConstantTargetOpt || innerLocals != this.InnerLocals || innerLocalFunctions != this.InnerLocalFunctions || switchSections != this.SwitchSections || breakLabel != this.BreakLabel || stringEquality != this.StringEquality)
            {
                var result = new BoundSwitchStatement(this.Syntax, loweredPreambleOpt, expression, constantTargetOpt, innerLocals, innerLocalFunctions, switchSections, breakLabel, stringEquality, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundSwitchSection : BoundStatementList
    {
        public BoundSwitchSection(SyntaxNode syntax, ImmutableArray<BoundSwitchLabel> switchLabels, ImmutableArray<BoundStatement> statements, bool hasErrors = false)
            : base(BoundKind.SwitchSection, syntax, statements, hasErrors || switchLabels.HasErrors() || statements.HasErrors())
        {

            Debug.Assert(!switchLabels.IsDefault, "Field 'switchLabels' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!statements.IsDefault, "Field 'statements' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.SwitchLabels = switchLabels;
        }


        public ImmutableArray<BoundSwitchLabel> SwitchLabels { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitSwitchSection(this);
        }

        public BoundSwitchSection Update(ImmutableArray<BoundSwitchLabel> switchLabels, ImmutableArray<BoundStatement> statements)
        {
            if (switchLabels != this.SwitchLabels || statements != this.Statements)
            {
                var result = new BoundSwitchSection(this.Syntax, switchLabels, statements, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundSwitchLabel : BoundNode
    {
        public BoundSwitchLabel(SyntaxNode syntax, LabelSymbol label, BoundExpression expressionOpt, ConstantValue constantValueOpt, bool hasErrors = false)
            : base(BoundKind.SwitchLabel, syntax, hasErrors || expressionOpt.HasErrors())
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
            this.ExpressionOpt = expressionOpt;
            this.ConstantValueOpt = constantValueOpt;
        }


        public LabelSymbol Label { get; }

        public BoundExpression ExpressionOpt { get; }

        public ConstantValue ConstantValueOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitSwitchLabel(this);
        }

        public BoundSwitchLabel Update(LabelSymbol label, BoundExpression expressionOpt, ConstantValue constantValueOpt)
        {
            if (label != this.Label || expressionOpt != this.ExpressionOpt || constantValueOpt != this.ConstantValueOpt)
            {
                var result = new BoundSwitchLabel(this.Syntax, label, expressionOpt, constantValueOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundBreakStatement : BoundStatement
    {
        public BoundBreakStatement(SyntaxNode syntax, GeneratedLabelSymbol label, bool hasErrors)
            : base(BoundKind.BreakStatement, syntax, hasErrors)
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
        }

        public BoundBreakStatement(SyntaxNode syntax, GeneratedLabelSymbol label)
            : base(BoundKind.BreakStatement, syntax)
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
        }


        public GeneratedLabelSymbol Label { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitBreakStatement(this);
        }

        public BoundBreakStatement Update(GeneratedLabelSymbol label)
        {
            if (label != this.Label)
            {
                var result = new BoundBreakStatement(this.Syntax, label, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundContinueStatement : BoundStatement
    {
        public BoundContinueStatement(SyntaxNode syntax, GeneratedLabelSymbol label, bool hasErrors)
            : base(BoundKind.ContinueStatement, syntax, hasErrors)
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
        }

        public BoundContinueStatement(SyntaxNode syntax, GeneratedLabelSymbol label)
            : base(BoundKind.ContinueStatement, syntax)
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
        }


        public GeneratedLabelSymbol Label { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitContinueStatement(this);
        }

        public BoundContinueStatement Update(GeneratedLabelSymbol label)
        {
            if (label != this.Label)
            {
                var result = new BoundContinueStatement(this.Syntax, label, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPatternSwitchStatement : BoundStatement
    {
        public BoundPatternSwitchStatement(SyntaxNode syntax, BoundExpression expression, bool someLabelAlwaysMatches, ImmutableArray<LocalSymbol> innerLocals, ImmutableArray<LocalFunctionSymbol> innerLocalFunctions, ImmutableArray<BoundPatternSwitchSection> switchSections, BoundPatternSwitchLabel defaultLabel, GeneratedLabelSymbol breakLabel, PatternSwitchBinder binder, bool isComplete, bool hasErrors = false)
            : base(BoundKind.PatternSwitchStatement, syntax, hasErrors || expression.HasErrors() || switchSections.HasErrors() || defaultLabel.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!innerLocals.IsDefault, "Field 'innerLocals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!innerLocalFunctions.IsDefault, "Field 'innerLocalFunctions' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!switchSections.IsDefault, "Field 'switchSections' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(breakLabel != null, "Field 'breakLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(binder != null, "Field 'binder' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
            this.SomeLabelAlwaysMatches = someLabelAlwaysMatches;
            this.InnerLocals = innerLocals;
            this.InnerLocalFunctions = innerLocalFunctions;
            this.SwitchSections = switchSections;
            this.DefaultLabel = defaultLabel;
            this.BreakLabel = breakLabel;
            this.Binder = binder;
            this.IsComplete = isComplete;
        }


        public BoundExpression Expression { get; }

        public bool SomeLabelAlwaysMatches { get; }

        public ImmutableArray<LocalSymbol> InnerLocals { get; }

        public ImmutableArray<LocalFunctionSymbol> InnerLocalFunctions { get; }

        public ImmutableArray<BoundPatternSwitchSection> SwitchSections { get; }

        public BoundPatternSwitchLabel DefaultLabel { get; }

        public GeneratedLabelSymbol BreakLabel { get; }

        public PatternSwitchBinder Binder { get; }

        public bool IsComplete { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPatternSwitchStatement(this);
        }

        public BoundPatternSwitchStatement Update(BoundExpression expression, bool someLabelAlwaysMatches, ImmutableArray<LocalSymbol> innerLocals, ImmutableArray<LocalFunctionSymbol> innerLocalFunctions, ImmutableArray<BoundPatternSwitchSection> switchSections, BoundPatternSwitchLabel defaultLabel, GeneratedLabelSymbol breakLabel, PatternSwitchBinder binder, bool isComplete)
        {
            if (expression != this.Expression || someLabelAlwaysMatches != this.SomeLabelAlwaysMatches || innerLocals != this.InnerLocals || innerLocalFunctions != this.InnerLocalFunctions || switchSections != this.SwitchSections || defaultLabel != this.DefaultLabel || breakLabel != this.BreakLabel || binder != this.Binder || isComplete != this.IsComplete)
            {
                var result = new BoundPatternSwitchStatement(this.Syntax, expression, someLabelAlwaysMatches, innerLocals, innerLocalFunctions, switchSections, defaultLabel, breakLabel, binder, isComplete, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPatternSwitchSection : BoundStatementList
    {
        public BoundPatternSwitchSection(SyntaxNode syntax, ImmutableArray<LocalSymbol> locals, ImmutableArray<BoundPatternSwitchLabel> switchLabels, ImmutableArray<BoundStatement> statements, bool hasErrors = false)
            : base(BoundKind.PatternSwitchSection, syntax, statements, hasErrors || switchLabels.HasErrors() || statements.HasErrors())
        {

            Debug.Assert(!locals.IsDefault, "Field 'locals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!switchLabels.IsDefault, "Field 'switchLabels' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!statements.IsDefault, "Field 'statements' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Locals = locals;
            this.SwitchLabels = switchLabels;
        }


        public ImmutableArray<LocalSymbol> Locals { get; }

        public ImmutableArray<BoundPatternSwitchLabel> SwitchLabels { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPatternSwitchSection(this);
        }

        public BoundPatternSwitchSection Update(ImmutableArray<LocalSymbol> locals, ImmutableArray<BoundPatternSwitchLabel> switchLabels, ImmutableArray<BoundStatement> statements)
        {
            if (locals != this.Locals || switchLabels != this.SwitchLabels || statements != this.Statements)
            {
                var result = new BoundPatternSwitchSection(this.Syntax, locals, switchLabels, statements, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPatternSwitchLabel : BoundNode
    {
        public BoundPatternSwitchLabel(SyntaxNode syntax, LabelSymbol label, BoundPattern pattern, BoundExpression guard, bool isReachable, bool hasErrors = false)
            : base(BoundKind.PatternSwitchLabel, syntax, hasErrors || pattern.HasErrors() || guard.HasErrors())
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(pattern != null, "Field 'pattern' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
            this.Pattern = pattern;
            this.Guard = guard;
            this.IsReachable = isReachable;
        }


        public LabelSymbol Label { get; }

        public BoundPattern Pattern { get; }

        public BoundExpression Guard { get; }

        public bool IsReachable { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPatternSwitchLabel(this);
        }

        public BoundPatternSwitchLabel Update(LabelSymbol label, BoundPattern pattern, BoundExpression guard, bool isReachable)
        {
            if (label != this.Label || pattern != this.Pattern || guard != this.Guard || isReachable != this.IsReachable)
            {
                var result = new BoundPatternSwitchLabel(this.Syntax, label, pattern, guard, isReachable, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundIfStatement : BoundStatement
    {
        public BoundIfStatement(SyntaxNode syntax, BoundExpression condition, BoundStatement consequence, BoundStatement alternativeOpt, bool hasErrors = false)
            : base(BoundKind.IfStatement, syntax, hasErrors || condition.HasErrors() || consequence.HasErrors() || alternativeOpt.HasErrors())
        {

            Debug.Assert(condition != null, "Field 'condition' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(consequence != null, "Field 'consequence' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Condition = condition;
            this.Consequence = consequence;
            this.AlternativeOpt = alternativeOpt;
        }


        public BoundExpression Condition { get; }

        public BoundStatement Consequence { get; }

        public BoundStatement AlternativeOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitIfStatement(this);
        }

        public BoundIfStatement Update(BoundExpression condition, BoundStatement consequence, BoundStatement alternativeOpt)
        {
            if (condition != this.Condition || consequence != this.Consequence || alternativeOpt != this.AlternativeOpt)
            {
                var result = new BoundIfStatement(this.Syntax, condition, consequence, alternativeOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal abstract partial class BoundLoopStatement : BoundStatement
    {
        protected BoundLoopStatement(BoundKind kind, SyntaxNode syntax, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel, bool hasErrors)
            : base(kind, syntax, hasErrors)
        {

            Debug.Assert(breakLabel != null, "Field 'breakLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(continueLabel != null, "Field 'continueLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.BreakLabel = breakLabel;
            this.ContinueLabel = continueLabel;
        }

        protected BoundLoopStatement(BoundKind kind, SyntaxNode syntax, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel)
            : base(kind, syntax)
        {

            Debug.Assert(breakLabel != null, "Field 'breakLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(continueLabel != null, "Field 'continueLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.BreakLabel = breakLabel;
            this.ContinueLabel = continueLabel;
        }


        public GeneratedLabelSymbol BreakLabel { get; }

        public GeneratedLabelSymbol ContinueLabel { get; }
    }

    internal sealed partial class BoundDoStatement : BoundLoopStatement
    {
        public BoundDoStatement(SyntaxNode syntax, ImmutableArray<LocalSymbol> locals, BoundExpression condition, BoundStatement body, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel, bool hasErrors = false)
            : base(BoundKind.DoStatement, syntax, breakLabel, continueLabel, hasErrors || condition.HasErrors() || body.HasErrors())
        {

            Debug.Assert(!locals.IsDefault, "Field 'locals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(condition != null, "Field 'condition' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(breakLabel != null, "Field 'breakLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(continueLabel != null, "Field 'continueLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Locals = locals;
            this.Condition = condition;
            this.Body = body;
        }


        public ImmutableArray<LocalSymbol> Locals { get; }

        public BoundExpression Condition { get; }

        public BoundStatement Body { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDoStatement(this);
        }

        public BoundDoStatement Update(ImmutableArray<LocalSymbol> locals, BoundExpression condition, BoundStatement body, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel)
        {
            if (locals != this.Locals || condition != this.Condition || body != this.Body || breakLabel != this.BreakLabel || continueLabel != this.ContinueLabel)
            {
                var result = new BoundDoStatement(this.Syntax, locals, condition, body, breakLabel, continueLabel, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundWhileStatement : BoundLoopStatement
    {
        public BoundWhileStatement(SyntaxNode syntax, ImmutableArray<LocalSymbol> locals, BoundExpression condition, BoundStatement body, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel, bool hasErrors = false)
            : base(BoundKind.WhileStatement, syntax, breakLabel, continueLabel, hasErrors || condition.HasErrors() || body.HasErrors())
        {

            Debug.Assert(!locals.IsDefault, "Field 'locals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(condition != null, "Field 'condition' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(breakLabel != null, "Field 'breakLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(continueLabel != null, "Field 'continueLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Locals = locals;
            this.Condition = condition;
            this.Body = body;
        }


        public ImmutableArray<LocalSymbol> Locals { get; }

        public BoundExpression Condition { get; }

        public BoundStatement Body { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitWhileStatement(this);
        }

        public BoundWhileStatement Update(ImmutableArray<LocalSymbol> locals, BoundExpression condition, BoundStatement body, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel)
        {
            if (locals != this.Locals || condition != this.Condition || body != this.Body || breakLabel != this.BreakLabel || continueLabel != this.ContinueLabel)
            {
                var result = new BoundWhileStatement(this.Syntax, locals, condition, body, breakLabel, continueLabel, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundForStatement : BoundLoopStatement
    {
        public BoundForStatement(SyntaxNode syntax, ImmutableArray<LocalSymbol> outerLocals, BoundStatement initializer, ImmutableArray<LocalSymbol> innerLocals, BoundExpression condition, BoundStatement increment, BoundStatement body, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel, bool hasErrors = false)
            : base(BoundKind.ForStatement, syntax, breakLabel, continueLabel, hasErrors || initializer.HasErrors() || condition.HasErrors() || increment.HasErrors() || body.HasErrors())
        {

            Debug.Assert(!outerLocals.IsDefault, "Field 'outerLocals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!innerLocals.IsDefault, "Field 'innerLocals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(breakLabel != null, "Field 'breakLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(continueLabel != null, "Field 'continueLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.OuterLocals = outerLocals;
            this.Initializer = initializer;
            this.InnerLocals = innerLocals;
            this.Condition = condition;
            this.Increment = increment;
            this.Body = body;
        }


        public ImmutableArray<LocalSymbol> OuterLocals { get; }

        public BoundStatement Initializer { get; }

        public ImmutableArray<LocalSymbol> InnerLocals { get; }

        public BoundExpression Condition { get; }

        public BoundStatement Increment { get; }

        public BoundStatement Body { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitForStatement(this);
        }

        public BoundForStatement Update(ImmutableArray<LocalSymbol> outerLocals, BoundStatement initializer, ImmutableArray<LocalSymbol> innerLocals, BoundExpression condition, BoundStatement increment, BoundStatement body, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel)
        {
            if (outerLocals != this.OuterLocals || initializer != this.Initializer || innerLocals != this.InnerLocals || condition != this.Condition || increment != this.Increment || body != this.Body || breakLabel != this.BreakLabel || continueLabel != this.ContinueLabel)
            {
                var result = new BoundForStatement(this.Syntax, outerLocals, initializer, innerLocals, condition, increment, body, breakLabel, continueLabel, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundForEachStatement : BoundLoopStatement
    {
        public BoundForEachStatement(SyntaxNode syntax, ForEachEnumeratorInfo enumeratorInfoOpt, Conversion elementConversion, BoundTypeExpression iterationVariableType, ImmutableArray<LocalSymbol> iterationVariables, BoundExpression expression, BoundForEachDeconstructStep deconstructionOpt, BoundStatement body, Boolean @checked, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel, bool hasErrors = false)
            : base(BoundKind.ForEachStatement, syntax, breakLabel, continueLabel, hasErrors || iterationVariableType.HasErrors() || expression.HasErrors() || deconstructionOpt.HasErrors() || body.HasErrors())
        {

            Debug.Assert(iterationVariableType != null, "Field 'iterationVariableType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!iterationVariables.IsDefault, "Field 'iterationVariables' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(breakLabel != null, "Field 'breakLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(continueLabel != null, "Field 'continueLabel' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.EnumeratorInfoOpt = enumeratorInfoOpt;
            this.ElementConversion = elementConversion;
            this.IterationVariableType = iterationVariableType;
            this.IterationVariables = iterationVariables;
            this.Expression = expression;
            this.DeconstructionOpt = deconstructionOpt;
            this.Body = body;
            this.Checked = @checked;
        }


        public ForEachEnumeratorInfo EnumeratorInfoOpt { get; }

        public Conversion ElementConversion { get; }

        public BoundTypeExpression IterationVariableType { get; }

        public ImmutableArray<LocalSymbol> IterationVariables { get; }

        public BoundExpression Expression { get; }

        public BoundForEachDeconstructStep DeconstructionOpt { get; }

        public BoundStatement Body { get; }

        public Boolean Checked { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitForEachStatement(this);
        }

        public BoundForEachStatement Update(ForEachEnumeratorInfo enumeratorInfoOpt, Conversion elementConversion, BoundTypeExpression iterationVariableType, ImmutableArray<LocalSymbol> iterationVariables, BoundExpression expression, BoundForEachDeconstructStep deconstructionOpt, BoundStatement body, Boolean @checked, GeneratedLabelSymbol breakLabel, GeneratedLabelSymbol continueLabel)
        {
            if (enumeratorInfoOpt != this.EnumeratorInfoOpt || elementConversion != this.ElementConversion || iterationVariableType != this.IterationVariableType || iterationVariables != this.IterationVariables || expression != this.Expression || deconstructionOpt != this.DeconstructionOpt || body != this.Body || @checked != this.Checked || breakLabel != this.BreakLabel || continueLabel != this.ContinueLabel)
            {
                var result = new BoundForEachStatement(this.Syntax, enumeratorInfoOpt, elementConversion, iterationVariableType, iterationVariables, expression, deconstructionOpt, body, @checked, breakLabel, continueLabel, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundForEachDeconstructStep : BoundNode
    {
        public BoundForEachDeconstructStep(SyntaxNode syntax, BoundDeconstructionAssignmentOperator deconstructionAssignment, BoundDeconstructValuePlaceholder targetPlaceholder, bool hasErrors = false)
            : base(BoundKind.ForEachDeconstructStep, syntax, hasErrors || deconstructionAssignment.HasErrors() || targetPlaceholder.HasErrors())
        {

            Debug.Assert(deconstructionAssignment != null, "Field 'deconstructionAssignment' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(targetPlaceholder != null, "Field 'targetPlaceholder' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.DeconstructionAssignment = deconstructionAssignment;
            this.TargetPlaceholder = targetPlaceholder;
        }


        public BoundDeconstructionAssignmentOperator DeconstructionAssignment { get; }

        public BoundDeconstructValuePlaceholder TargetPlaceholder { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitForEachDeconstructStep(this);
        }

        public BoundForEachDeconstructStep Update(BoundDeconstructionAssignmentOperator deconstructionAssignment, BoundDeconstructValuePlaceholder targetPlaceholder)
        {
            if (deconstructionAssignment != this.DeconstructionAssignment || targetPlaceholder != this.TargetPlaceholder)
            {
                var result = new BoundForEachDeconstructStep(this.Syntax, deconstructionAssignment, targetPlaceholder, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundUsingStatement : BoundStatement
    {
        public BoundUsingStatement(SyntaxNode syntax, ImmutableArray<LocalSymbol> locals, BoundMultipleLocalDeclarations declarationsOpt, BoundExpression expressionOpt, Conversion iDisposableConversion, BoundStatement body, bool hasErrors = false)
            : base(BoundKind.UsingStatement, syntax, hasErrors || declarationsOpt.HasErrors() || expressionOpt.HasErrors() || body.HasErrors())
        {

            Debug.Assert(!locals.IsDefault, "Field 'locals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Locals = locals;
            this.DeclarationsOpt = declarationsOpt;
            this.ExpressionOpt = expressionOpt;
            this.IDisposableConversion = iDisposableConversion;
            this.Body = body;
        }


        public ImmutableArray<LocalSymbol> Locals { get; }

        public BoundMultipleLocalDeclarations DeclarationsOpt { get; }

        public BoundExpression ExpressionOpt { get; }

        public Conversion IDisposableConversion { get; }

        public BoundStatement Body { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitUsingStatement(this);
        }

        public BoundUsingStatement Update(ImmutableArray<LocalSymbol> locals, BoundMultipleLocalDeclarations declarationsOpt, BoundExpression expressionOpt, Conversion iDisposableConversion, BoundStatement body)
        {
            if (locals != this.Locals || declarationsOpt != this.DeclarationsOpt || expressionOpt != this.ExpressionOpt || iDisposableConversion != this.IDisposableConversion || body != this.Body)
            {
                var result = new BoundUsingStatement(this.Syntax, locals, declarationsOpt, expressionOpt, iDisposableConversion, body, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundFixedStatement : BoundStatement
    {
        public BoundFixedStatement(SyntaxNode syntax, ImmutableArray<LocalSymbol> locals, BoundMultipleLocalDeclarations declarations, BoundStatement body, bool hasErrors = false)
            : base(BoundKind.FixedStatement, syntax, hasErrors || declarations.HasErrors() || body.HasErrors())
        {

            Debug.Assert(!locals.IsDefault, "Field 'locals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(declarations != null, "Field 'declarations' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Locals = locals;
            this.Declarations = declarations;
            this.Body = body;
        }


        public ImmutableArray<LocalSymbol> Locals { get; }

        public BoundMultipleLocalDeclarations Declarations { get; }

        public BoundStatement Body { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitFixedStatement(this);
        }

        public BoundFixedStatement Update(ImmutableArray<LocalSymbol> locals, BoundMultipleLocalDeclarations declarations, BoundStatement body)
        {
            if (locals != this.Locals || declarations != this.Declarations || body != this.Body)
            {
                var result = new BoundFixedStatement(this.Syntax, locals, declarations, body, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLockStatement : BoundStatement
    {
        public BoundLockStatement(SyntaxNode syntax, BoundExpression argument, BoundStatement body, bool hasErrors = false)
            : base(BoundKind.LockStatement, syntax, hasErrors || argument.HasErrors() || body.HasErrors())
        {

            Debug.Assert(argument != null, "Field 'argument' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Argument = argument;
            this.Body = body;
        }


        public BoundExpression Argument { get; }

        public BoundStatement Body { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLockStatement(this);
        }

        public BoundLockStatement Update(BoundExpression argument, BoundStatement body)
        {
            if (argument != this.Argument || body != this.Body)
            {
                var result = new BoundLockStatement(this.Syntax, argument, body, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundTryStatement : BoundStatement
    {
        public BoundTryStatement(SyntaxNode syntax, BoundBlock tryBlock, ImmutableArray<BoundCatchBlock> catchBlocks, BoundBlock finallyBlockOpt, Boolean preferFaultHandler, bool hasErrors = false)
            : base(BoundKind.TryStatement, syntax, hasErrors || tryBlock.HasErrors() || catchBlocks.HasErrors() || finallyBlockOpt.HasErrors())
        {

            Debug.Assert(tryBlock != null, "Field 'tryBlock' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!catchBlocks.IsDefault, "Field 'catchBlocks' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.TryBlock = tryBlock;
            this.CatchBlocks = catchBlocks;
            this.FinallyBlockOpt = finallyBlockOpt;
            this.PreferFaultHandler = preferFaultHandler;
        }


        public BoundBlock TryBlock { get; }

        public ImmutableArray<BoundCatchBlock> CatchBlocks { get; }

        public BoundBlock FinallyBlockOpt { get; }

        public Boolean PreferFaultHandler { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitTryStatement(this);
        }

        public BoundTryStatement Update(BoundBlock tryBlock, ImmutableArray<BoundCatchBlock> catchBlocks, BoundBlock finallyBlockOpt, Boolean preferFaultHandler)
        {
            if (tryBlock != this.TryBlock || catchBlocks != this.CatchBlocks || finallyBlockOpt != this.FinallyBlockOpt || preferFaultHandler != this.PreferFaultHandler)
            {
                var result = new BoundTryStatement(this.Syntax, tryBlock, catchBlocks, finallyBlockOpt, preferFaultHandler, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundCatchBlock : BoundNode
    {
        public BoundCatchBlock(SyntaxNode syntax, ImmutableArray<LocalSymbol> locals, BoundExpression exceptionSourceOpt, TypeSymbol exceptionTypeOpt, BoundExpression exceptionFilterOpt, BoundBlock body, bool isSynthesizedAsyncCatchAll, bool hasErrors = false)
            : base(BoundKind.CatchBlock, syntax, hasErrors || exceptionSourceOpt.HasErrors() || exceptionFilterOpt.HasErrors() || body.HasErrors())
        {

            Debug.Assert(!locals.IsDefault, "Field 'locals' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Locals = locals;
            this.ExceptionSourceOpt = exceptionSourceOpt;
            this.ExceptionTypeOpt = exceptionTypeOpt;
            this.ExceptionFilterOpt = exceptionFilterOpt;
            this.Body = body;
            this.IsSynthesizedAsyncCatchAll = isSynthesizedAsyncCatchAll;
        }


        public ImmutableArray<LocalSymbol> Locals { get; }

        public BoundExpression ExceptionSourceOpt { get; }

        public TypeSymbol ExceptionTypeOpt { get; }

        public BoundExpression ExceptionFilterOpt { get; }

        public BoundBlock Body { get; }

        public bool IsSynthesizedAsyncCatchAll { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitCatchBlock(this);
        }

        public BoundCatchBlock Update(ImmutableArray<LocalSymbol> locals, BoundExpression exceptionSourceOpt, TypeSymbol exceptionTypeOpt, BoundExpression exceptionFilterOpt, BoundBlock body, bool isSynthesizedAsyncCatchAll)
        {
            if (locals != this.Locals || exceptionSourceOpt != this.ExceptionSourceOpt || exceptionTypeOpt != this.ExceptionTypeOpt || exceptionFilterOpt != this.ExceptionFilterOpt || body != this.Body || isSynthesizedAsyncCatchAll != this.IsSynthesizedAsyncCatchAll)
            {
                var result = new BoundCatchBlock(this.Syntax, locals, exceptionSourceOpt, exceptionTypeOpt, exceptionFilterOpt, body, isSynthesizedAsyncCatchAll, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLiteral : BoundExpression
    {
        public BoundLiteral(SyntaxNode syntax, ConstantValue constantValueOpt, TypeSymbol type, bool hasErrors)
            : base(BoundKind.Literal, syntax, type, hasErrors)
        {
            this.ConstantValueOpt = constantValueOpt;
        }

        public BoundLiteral(SyntaxNode syntax, ConstantValue constantValueOpt, TypeSymbol type)
            : base(BoundKind.Literal, syntax, type)
        {
            this.ConstantValueOpt = constantValueOpt;
        }


        public ConstantValue ConstantValueOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLiteral(this);
        }

        public BoundLiteral Update(ConstantValue constantValueOpt, TypeSymbol type)
        {
            if (constantValueOpt != this.ConstantValueOpt || type != this.Type)
            {
                var result = new BoundLiteral(this.Syntax, constantValueOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundThisReference : BoundExpression
    {
        public BoundThisReference(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.ThisReference, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

        public BoundThisReference(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.ThisReference, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitThisReference(this);
        }

        public BoundThisReference Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundThisReference(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPreviousSubmissionReference : BoundExpression
    {
        public BoundPreviousSubmissionReference(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.PreviousSubmissionReference, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

        public BoundPreviousSubmissionReference(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.PreviousSubmissionReference, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPreviousSubmissionReference(this);
        }

        public BoundPreviousSubmissionReference Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundPreviousSubmissionReference(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundHostObjectMemberReference : BoundExpression
    {
        public BoundHostObjectMemberReference(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.HostObjectMemberReference, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

        public BoundHostObjectMemberReference(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.HostObjectMemberReference, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitHostObjectMemberReference(this);
        }

        public BoundHostObjectMemberReference Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundHostObjectMemberReference(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundBaseReference : BoundExpression
    {
        public BoundBaseReference(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.BaseReference, syntax, type, hasErrors)
        {
        }

        public BoundBaseReference(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.BaseReference, syntax, type)
        {
        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitBaseReference(this);
        }

        public BoundBaseReference Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundBaseReference(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLocal : BoundExpression
    {
        public BoundLocal(SyntaxNode syntax, LocalSymbol localSymbol, bool isDeclaration, ConstantValue constantValueOpt, TypeSymbol type, bool hasErrors)
            : base(BoundKind.Local, syntax, type, hasErrors)
        {

            Debug.Assert(localSymbol != null, "Field 'localSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.LocalSymbol = localSymbol;
            this.IsDeclaration = isDeclaration;
            this.ConstantValueOpt = constantValueOpt;
        }

        public BoundLocal(SyntaxNode syntax, LocalSymbol localSymbol, bool isDeclaration, ConstantValue constantValueOpt, TypeSymbol type)
            : base(BoundKind.Local, syntax, type)
        {

            Debug.Assert(localSymbol != null, "Field 'localSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.LocalSymbol = localSymbol;
            this.IsDeclaration = isDeclaration;
            this.ConstantValueOpt = constantValueOpt;
        }


        public LocalSymbol LocalSymbol { get; }

        public bool IsDeclaration { get; }

        public ConstantValue ConstantValueOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLocal(this);
        }

        public BoundLocal Update(LocalSymbol localSymbol, bool isDeclaration, ConstantValue constantValueOpt, TypeSymbol type)
        {
            if (localSymbol != this.LocalSymbol || isDeclaration != this.IsDeclaration || constantValueOpt != this.ConstantValueOpt || type != this.Type)
            {
                var result = new BoundLocal(this.Syntax, localSymbol, isDeclaration, constantValueOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPseudoVariable : BoundExpression
    {
        public BoundPseudoVariable(SyntaxNode syntax, LocalSymbol localSymbol, PseudoVariableExpressions emitExpressions, TypeSymbol type, bool hasErrors)
            : base(BoundKind.PseudoVariable, syntax, type, hasErrors)
        {

            Debug.Assert(localSymbol != null, "Field 'localSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(emitExpressions != null, "Field 'emitExpressions' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.LocalSymbol = localSymbol;
            this.EmitExpressions = emitExpressions;
        }

        public BoundPseudoVariable(SyntaxNode syntax, LocalSymbol localSymbol, PseudoVariableExpressions emitExpressions, TypeSymbol type)
            : base(BoundKind.PseudoVariable, syntax, type)
        {

            Debug.Assert(localSymbol != null, "Field 'localSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(emitExpressions != null, "Field 'emitExpressions' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.LocalSymbol = localSymbol;
            this.EmitExpressions = emitExpressions;
        }


        public LocalSymbol LocalSymbol { get; }

        public PseudoVariableExpressions EmitExpressions { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPseudoVariable(this);
        }

        public BoundPseudoVariable Update(LocalSymbol localSymbol, PseudoVariableExpressions emitExpressions, TypeSymbol type)
        {
            if (localSymbol != this.LocalSymbol || emitExpressions != this.EmitExpressions || type != this.Type)
            {
                var result = new BoundPseudoVariable(this.Syntax, localSymbol, emitExpressions, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundRangeVariable : BoundExpression
    {
        public BoundRangeVariable(SyntaxNode syntax, RangeVariableSymbol rangeVariableSymbol, BoundExpression value, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.RangeVariable, syntax, type, hasErrors || value.HasErrors())
        {

            Debug.Assert(rangeVariableSymbol != null, "Field 'rangeVariableSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(value != null, "Field 'value' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.RangeVariableSymbol = rangeVariableSymbol;
            this.Value = value;
        }


        public RangeVariableSymbol RangeVariableSymbol { get; }

        public BoundExpression Value { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitRangeVariable(this);
        }

        public BoundRangeVariable Update(RangeVariableSymbol rangeVariableSymbol, BoundExpression value, TypeSymbol type)
        {
            if (rangeVariableSymbol != this.RangeVariableSymbol || value != this.Value || type != this.Type)
            {
                var result = new BoundRangeVariable(this.Syntax, rangeVariableSymbol, value, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundParameter : BoundExpression
    {
        public BoundParameter(SyntaxNode syntax, ParameterSymbol parameterSymbol, TypeSymbol type, bool hasErrors)
            : base(BoundKind.Parameter, syntax, type, hasErrors)
        {

            Debug.Assert(parameterSymbol != null, "Field 'parameterSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ParameterSymbol = parameterSymbol;
        }

        public BoundParameter(SyntaxNode syntax, ParameterSymbol parameterSymbol, TypeSymbol type)
            : base(BoundKind.Parameter, syntax, type)
        {

            Debug.Assert(parameterSymbol != null, "Field 'parameterSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ParameterSymbol = parameterSymbol;
        }


        public ParameterSymbol ParameterSymbol { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitParameter(this);
        }

        public BoundParameter Update(ParameterSymbol parameterSymbol, TypeSymbol type)
        {
            if (parameterSymbol != this.ParameterSymbol || type != this.Type)
            {
                var result = new BoundParameter(this.Syntax, parameterSymbol, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLabelStatement : BoundStatement
    {
        public BoundLabelStatement(SyntaxNode syntax, LabelSymbol label, bool hasErrors)
            : base(BoundKind.LabelStatement, syntax, hasErrors)
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
        }

        public BoundLabelStatement(SyntaxNode syntax, LabelSymbol label)
            : base(BoundKind.LabelStatement, syntax)
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
        }


        public LabelSymbol Label { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLabelStatement(this);
        }

        public BoundLabelStatement Update(LabelSymbol label)
        {
            if (label != this.Label)
            {
                var result = new BoundLabelStatement(this.Syntax, label, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundGotoStatement : BoundStatement
    {
        public BoundGotoStatement(SyntaxNode syntax, LabelSymbol label, BoundExpression caseExpressionOpt, BoundLabel labelExpressionOpt, bool hasErrors = false)
            : base(BoundKind.GotoStatement, syntax, hasErrors || caseExpressionOpt.HasErrors() || labelExpressionOpt.HasErrors())
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
            this.CaseExpressionOpt = caseExpressionOpt;
            this.LabelExpressionOpt = labelExpressionOpt;
        }


        public LabelSymbol Label { get; }

        public BoundExpression CaseExpressionOpt { get; }

        public BoundLabel LabelExpressionOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitGotoStatement(this);
        }

        public BoundGotoStatement Update(LabelSymbol label, BoundExpression caseExpressionOpt, BoundLabel labelExpressionOpt)
        {
            if (label != this.Label || caseExpressionOpt != this.CaseExpressionOpt || labelExpressionOpt != this.LabelExpressionOpt)
            {
                var result = new BoundGotoStatement(this.Syntax, label, caseExpressionOpt, labelExpressionOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLabeledStatement : BoundStatement
    {
        public BoundLabeledStatement(SyntaxNode syntax, LabelSymbol label, BoundStatement body, bool hasErrors = false)
            : base(BoundKind.LabeledStatement, syntax, hasErrors || body.HasErrors())
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
            this.Body = body;
        }


        public LabelSymbol Label { get; }

        public BoundStatement Body { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLabeledStatement(this);
        }

        public BoundLabeledStatement Update(LabelSymbol label, BoundStatement body)
        {
            if (label != this.Label || body != this.Body)
            {
                var result = new BoundLabeledStatement(this.Syntax, label, body, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLabel : BoundExpression
    {
        public BoundLabel(SyntaxNode syntax, LabelSymbol label, TypeSymbol type, bool hasErrors)
            : base(BoundKind.Label, syntax, type, hasErrors)
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
        }

        public BoundLabel(SyntaxNode syntax, LabelSymbol label, TypeSymbol type)
            : base(BoundKind.Label, syntax, type)
        {

            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Label = label;
        }


        public LabelSymbol Label { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLabel(this);
        }

        public BoundLabel Update(LabelSymbol label, TypeSymbol type)
        {
            if (label != this.Label || type != this.Type)
            {
                var result = new BoundLabel(this.Syntax, label, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal partial class BoundStatementList : BoundStatement
    {
        protected BoundStatementList(BoundKind kind, SyntaxNode syntax, ImmutableArray<BoundStatement> statements, bool hasErrors = false)
            : base(kind, syntax, hasErrors)
        {

            Debug.Assert(!statements.IsDefault, "Field 'statements' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Statements = statements;
        }

        public BoundStatementList(SyntaxNode syntax, ImmutableArray<BoundStatement> statements, bool hasErrors = false)
            : base(BoundKind.StatementList, syntax, hasErrors || statements.HasErrors())
        {

            Debug.Assert(!statements.IsDefault, "Field 'statements' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Statements = statements;
        }


        public ImmutableArray<BoundStatement> Statements { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitStatementList(this);
        }

        public BoundStatementList Update(ImmutableArray<BoundStatement> statements)
        {
            if (statements != this.Statements)
            {
                var result = new BoundStatementList(this.Syntax, statements, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundConditionalGoto : BoundStatement
    {
        public BoundConditionalGoto(SyntaxNode syntax, BoundExpression condition, bool jumpIfTrue, LabelSymbol label, bool hasErrors = false)
            : base(BoundKind.ConditionalGoto, syntax, hasErrors || condition.HasErrors())
        {

            Debug.Assert(condition != null, "Field 'condition' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(label != null, "Field 'label' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Condition = condition;
            this.JumpIfTrue = jumpIfTrue;
            this.Label = label;
        }


        public BoundExpression Condition { get; }

        public bool JumpIfTrue { get; }

        public LabelSymbol Label { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitConditionalGoto(this);
        }

        public BoundConditionalGoto Update(BoundExpression condition, bool jumpIfTrue, LabelSymbol label)
        {
            if (condition != this.Condition || jumpIfTrue != this.JumpIfTrue || label != this.Label)
            {
                var result = new BoundConditionalGoto(this.Syntax, condition, jumpIfTrue, label, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal abstract partial class BoundMethodOrPropertyGroup : BoundExpression
    {
        protected BoundMethodOrPropertyGroup(BoundKind kind, SyntaxNode syntax, BoundExpression receiverOpt, LookupResultKind resultKind, bool hasErrors = false)
            : base(kind, syntax, null, hasErrors)
        {
            this.ReceiverOpt = receiverOpt;
            this._ResultKind = resultKind;
        }


        public BoundExpression ReceiverOpt { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }
    }

    internal sealed partial class BoundDynamicMemberAccess : BoundExpression
    {
        public BoundDynamicMemberAccess(SyntaxNode syntax, BoundExpression receiver, ImmutableArray<TypeSymbol> typeArgumentsOpt, string name, bool invoked, bool indexed, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.DynamicMemberAccess, syntax, type, hasErrors || receiver.HasErrors())
        {

            Debug.Assert(receiver != null, "Field 'receiver' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(name != null, "Field 'name' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Receiver = receiver;
            this.TypeArgumentsOpt = typeArgumentsOpt;
            this.Name = name;
            this.Invoked = invoked;
            this.Indexed = indexed;
        }


        public BoundExpression Receiver { get; }

        public ImmutableArray<TypeSymbol> TypeArgumentsOpt { get; }

        public string Name { get; }

        public bool Invoked { get; }

        public bool Indexed { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDynamicMemberAccess(this);
        }

        public BoundDynamicMemberAccess Update(BoundExpression receiver, ImmutableArray<TypeSymbol> typeArgumentsOpt, string name, bool invoked, bool indexed, TypeSymbol type)
        {
            if (receiver != this.Receiver || typeArgumentsOpt != this.TypeArgumentsOpt || name != this.Name || invoked != this.Invoked || indexed != this.Indexed || type != this.Type)
            {
                var result = new BoundDynamicMemberAccess(this.Syntax, receiver, typeArgumentsOpt, name, invoked, indexed, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundDynamicInvocation : BoundExpression
    {
        public BoundDynamicInvocation(SyntaxNode syntax, BoundExpression expression, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, ImmutableArray<MethodSymbol> applicableMethods, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.DynamicInvocation, syntax, type, hasErrors || expression.HasErrors() || arguments.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!applicableMethods.IsDefault, "Field 'applicableMethods' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
            this.Arguments = arguments;
            this.ArgumentNamesOpt = argumentNamesOpt;
            this.ArgumentRefKindsOpt = argumentRefKindsOpt;
            this.ApplicableMethods = applicableMethods;
        }


        public BoundExpression Expression { get; }

        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<string> ArgumentNamesOpt { get; }

        public ImmutableArray<RefKind> ArgumentRefKindsOpt { get; }

        public ImmutableArray<MethodSymbol> ApplicableMethods { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDynamicInvocation(this);
        }

        public BoundDynamicInvocation Update(BoundExpression expression, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, ImmutableArray<MethodSymbol> applicableMethods, TypeSymbol type)
        {
            if (expression != this.Expression || arguments != this.Arguments || argumentNamesOpt != this.ArgumentNamesOpt || argumentRefKindsOpt != this.ArgumentRefKindsOpt || applicableMethods != this.ApplicableMethods || type != this.Type)
            {
                var result = new BoundDynamicInvocation(this.Syntax, expression, arguments, argumentNamesOpt, argumentRefKindsOpt, applicableMethods, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundConditionalAccess : BoundExpression
    {
        public BoundConditionalAccess(SyntaxNode syntax, BoundExpression receiver, BoundExpression accessExpression, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ConditionalAccess, syntax, type, hasErrors || receiver.HasErrors() || accessExpression.HasErrors())
        {

            Debug.Assert(receiver != null, "Field 'receiver' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(accessExpression != null, "Field 'accessExpression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Receiver = receiver;
            this.AccessExpression = accessExpression;
        }


        public BoundExpression Receiver { get; }

        public BoundExpression AccessExpression { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitConditionalAccess(this);
        }

        public BoundConditionalAccess Update(BoundExpression receiver, BoundExpression accessExpression, TypeSymbol type)
        {
            if (receiver != this.Receiver || accessExpression != this.AccessExpression || type != this.Type)
            {
                var result = new BoundConditionalAccess(this.Syntax, receiver, accessExpression, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLoweredConditionalAccess : BoundExpression
    {
        public BoundLoweredConditionalAccess(SyntaxNode syntax, BoundExpression receiver, MethodSymbol hasValueMethodOpt, BoundExpression whenNotNull, BoundExpression whenNullOpt, int id, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.LoweredConditionalAccess, syntax, type, hasErrors || receiver.HasErrors() || whenNotNull.HasErrors() || whenNullOpt.HasErrors())
        {

            Debug.Assert(receiver != null, "Field 'receiver' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(whenNotNull != null, "Field 'whenNotNull' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Receiver = receiver;
            this.HasValueMethodOpt = hasValueMethodOpt;
            this.WhenNotNull = whenNotNull;
            this.WhenNullOpt = whenNullOpt;
            this.Id = id;
        }


        public BoundExpression Receiver { get; }

        public MethodSymbol HasValueMethodOpt { get; }

        public BoundExpression WhenNotNull { get; }

        public BoundExpression WhenNullOpt { get; }

        public int Id { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLoweredConditionalAccess(this);
        }

        public BoundLoweredConditionalAccess Update(BoundExpression receiver, MethodSymbol hasValueMethodOpt, BoundExpression whenNotNull, BoundExpression whenNullOpt, int id, TypeSymbol type)
        {
            if (receiver != this.Receiver || hasValueMethodOpt != this.HasValueMethodOpt || whenNotNull != this.WhenNotNull || whenNullOpt != this.WhenNullOpt || id != this.Id || type != this.Type)
            {
                var result = new BoundLoweredConditionalAccess(this.Syntax, receiver, hasValueMethodOpt, whenNotNull, whenNullOpt, id, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundConditionalReceiver : BoundExpression
    {
        public BoundConditionalReceiver(SyntaxNode syntax, int id, TypeSymbol type, bool hasErrors)
            : base(BoundKind.ConditionalReceiver, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Id = id;
        }

        public BoundConditionalReceiver(SyntaxNode syntax, int id, TypeSymbol type)
            : base(BoundKind.ConditionalReceiver, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Id = id;
        }


        public int Id { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitConditionalReceiver(this);
        }

        public BoundConditionalReceiver Update(int id, TypeSymbol type)
        {
            if (id != this.Id || type != this.Type)
            {
                var result = new BoundConditionalReceiver(this.Syntax, id, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundComplexConditionalReceiver : BoundExpression
    {
        public BoundComplexConditionalReceiver(SyntaxNode syntax, BoundExpression valueTypeReceiver, BoundExpression referenceTypeReceiver, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ComplexConditionalReceiver, syntax, type, hasErrors || valueTypeReceiver.HasErrors() || referenceTypeReceiver.HasErrors())
        {

            Debug.Assert(valueTypeReceiver != null, "Field 'valueTypeReceiver' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(referenceTypeReceiver != null, "Field 'referenceTypeReceiver' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ValueTypeReceiver = valueTypeReceiver;
            this.ReferenceTypeReceiver = referenceTypeReceiver;
        }


        public BoundExpression ValueTypeReceiver { get; }

        public BoundExpression ReferenceTypeReceiver { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitComplexConditionalReceiver(this);
        }

        public BoundComplexConditionalReceiver Update(BoundExpression valueTypeReceiver, BoundExpression referenceTypeReceiver, TypeSymbol type)
        {
            if (valueTypeReceiver != this.ValueTypeReceiver || referenceTypeReceiver != this.ReferenceTypeReceiver || type != this.Type)
            {
                var result = new BoundComplexConditionalReceiver(this.Syntax, valueTypeReceiver, referenceTypeReceiver, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundMethodGroup : BoundMethodOrPropertyGroup
    {
        public BoundMethodGroup(SyntaxNode syntax, ImmutableArray<TypeSymbol> typeArgumentsOpt, string name, ImmutableArray<MethodSymbol> methods, Symbol lookupSymbolOpt, DiagnosticInfo lookupError, BoundMethodGroupFlags flags, BoundExpression receiverOpt, LookupResultKind resultKind, bool hasErrors = false)
            : base(BoundKind.MethodGroup, syntax, receiverOpt, resultKind, hasErrors || receiverOpt.HasErrors())
        {

            Debug.Assert(name != null, "Field 'name' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!methods.IsDefault, "Field 'methods' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.TypeArgumentsOpt = typeArgumentsOpt;
            this.Name = name;
            this.Methods = methods;
            this.LookupSymbolOpt = lookupSymbolOpt;
            this.LookupError = lookupError;
            this.Flags = flags;
        }


        public ImmutableArray<TypeSymbol> TypeArgumentsOpt { get; }

        public string Name { get; }

        public ImmutableArray<MethodSymbol> Methods { get; }

        public Symbol LookupSymbolOpt { get; }

        public DiagnosticInfo LookupError { get; }

        public BoundMethodGroupFlags Flags { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitMethodGroup(this);
        }

        public BoundMethodGroup Update(ImmutableArray<TypeSymbol> typeArgumentsOpt, string name, ImmutableArray<MethodSymbol> methods, Symbol lookupSymbolOpt, DiagnosticInfo lookupError, BoundMethodGroupFlags flags, BoundExpression receiverOpt, LookupResultKind resultKind)
        {
            if (typeArgumentsOpt != this.TypeArgumentsOpt || name != this.Name || methods != this.Methods || lookupSymbolOpt != this.LookupSymbolOpt || lookupError != this.LookupError || flags != this.Flags || receiverOpt != this.ReceiverOpt || resultKind != this.ResultKind)
            {
                var result = new BoundMethodGroup(this.Syntax, typeArgumentsOpt, name, methods, lookupSymbolOpt, lookupError, flags, receiverOpt, resultKind, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPropertyGroup : BoundMethodOrPropertyGroup
    {
        public BoundPropertyGroup(SyntaxNode syntax, ImmutableArray<PropertySymbol> properties, BoundExpression receiverOpt, LookupResultKind resultKind, bool hasErrors = false)
            : base(BoundKind.PropertyGroup, syntax, receiverOpt, resultKind, hasErrors || receiverOpt.HasErrors())
        {

            Debug.Assert(!properties.IsDefault, "Field 'properties' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Properties = properties;
        }


        public ImmutableArray<PropertySymbol> Properties { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPropertyGroup(this);
        }

        public BoundPropertyGroup Update(ImmutableArray<PropertySymbol> properties, BoundExpression receiverOpt, LookupResultKind resultKind)
        {
            if (properties != this.Properties || receiverOpt != this.ReceiverOpt || resultKind != this.ResultKind)
            {
                var result = new BoundPropertyGroup(this.Syntax, properties, receiverOpt, resultKind, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundCall : BoundExpression
    {
        public BoundCall(SyntaxNode syntax, BoundExpression receiverOpt, MethodSymbol method, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, bool isDelegateCall, bool expanded, bool invokedAsExtensionMethod, ImmutableArray<int> argsToParamsOpt, LookupResultKind resultKind, Binder binderOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.Call, syntax, type, hasErrors || receiverOpt.HasErrors() || arguments.HasErrors())
        {

            Debug.Assert(method != null, "Field 'method' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ReceiverOpt = receiverOpt;
            this.Method = method;
            this.Arguments = arguments;
            this.ArgumentNamesOpt = argumentNamesOpt;
            this.ArgumentRefKindsOpt = argumentRefKindsOpt;
            this.IsDelegateCall = isDelegateCall;
            this.Expanded = expanded;
            this.InvokedAsExtensionMethod = invokedAsExtensionMethod;
            this.ArgsToParamsOpt = argsToParamsOpt;
            this._ResultKind = resultKind;
            this.BinderOpt = binderOpt;
        }


        public BoundExpression ReceiverOpt { get; }

        public MethodSymbol Method { get; }

        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<string> ArgumentNamesOpt { get; }

        public ImmutableArray<RefKind> ArgumentRefKindsOpt { get; }

        public bool IsDelegateCall { get; }

        public bool Expanded { get; }

        public bool InvokedAsExtensionMethod { get; }

        public ImmutableArray<int> ArgsToParamsOpt { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public Binder BinderOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitCall(this);
        }

        public BoundCall Update(BoundExpression receiverOpt, MethodSymbol method, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, bool isDelegateCall, bool expanded, bool invokedAsExtensionMethod, ImmutableArray<int> argsToParamsOpt, LookupResultKind resultKind, Binder binderOpt, TypeSymbol type)
        {
            if (receiverOpt != this.ReceiverOpt || method != this.Method || arguments != this.Arguments || argumentNamesOpt != this.ArgumentNamesOpt || argumentRefKindsOpt != this.ArgumentRefKindsOpt || isDelegateCall != this.IsDelegateCall || expanded != this.Expanded || invokedAsExtensionMethod != this.InvokedAsExtensionMethod || argsToParamsOpt != this.ArgsToParamsOpt || resultKind != this.ResultKind || binderOpt != this.BinderOpt || type != this.Type)
            {
                var result = new BoundCall(this.Syntax, receiverOpt, method, arguments, argumentNamesOpt, argumentRefKindsOpt, isDelegateCall, expanded, invokedAsExtensionMethod, argsToParamsOpt, resultKind, binderOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundEventAssignmentOperator : BoundExpression
    {
        public BoundEventAssignmentOperator(SyntaxNode syntax, EventSymbol @event, bool isAddition, bool isDynamic, BoundExpression receiverOpt, BoundExpression argument, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.EventAssignmentOperator, syntax, type, hasErrors || receiverOpt.HasErrors() || argument.HasErrors())
        {

            Debug.Assert(@event != null, "Field '@event' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(argument != null, "Field 'argument' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Event = @event;
            this.IsAddition = isAddition;
            this.IsDynamic = isDynamic;
            this.ReceiverOpt = receiverOpt;
            this.Argument = argument;
        }


        public EventSymbol Event { get; }

        public bool IsAddition { get; }

        public bool IsDynamic { get; }

        public BoundExpression ReceiverOpt { get; }

        public BoundExpression Argument { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitEventAssignmentOperator(this);
        }

        public BoundEventAssignmentOperator Update(EventSymbol @event, bool isAddition, bool isDynamic, BoundExpression receiverOpt, BoundExpression argument, TypeSymbol type)
        {
            if (@event != this.Event || isAddition != this.IsAddition || isDynamic != this.IsDynamic || receiverOpt != this.ReceiverOpt || argument != this.Argument || type != this.Type)
            {
                var result = new BoundEventAssignmentOperator(this.Syntax, @event, isAddition, isDynamic, receiverOpt, argument, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundAttribute : BoundExpression
    {
        public BoundAttribute(SyntaxNode syntax, MethodSymbol constructor, ImmutableArray<BoundExpression> constructorArguments, ImmutableArray<string> constructorArgumentNamesOpt, ImmutableArray<BoundExpression> namedArguments, LookupResultKind resultKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.Attribute, syntax, type, hasErrors || constructorArguments.HasErrors() || namedArguments.HasErrors())
        {

            Debug.Assert(!constructorArguments.IsDefault, "Field 'constructorArguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!namedArguments.IsDefault, "Field 'namedArguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Constructor = constructor;
            this.ConstructorArguments = constructorArguments;
            this.ConstructorArgumentNamesOpt = constructorArgumentNamesOpt;
            this.NamedArguments = namedArguments;
            this._ResultKind = resultKind;
        }


        public MethodSymbol Constructor { get; }

        public ImmutableArray<BoundExpression> ConstructorArguments { get; }

        public ImmutableArray<string> ConstructorArgumentNamesOpt { get; }

        public ImmutableArray<BoundExpression> NamedArguments { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitAttribute(this);
        }

        public BoundAttribute Update(MethodSymbol constructor, ImmutableArray<BoundExpression> constructorArguments, ImmutableArray<string> constructorArgumentNamesOpt, ImmutableArray<BoundExpression> namedArguments, LookupResultKind resultKind, TypeSymbol type)
        {
            if (constructor != this.Constructor || constructorArguments != this.ConstructorArguments || constructorArgumentNamesOpt != this.ConstructorArgumentNamesOpt || namedArguments != this.NamedArguments || resultKind != this.ResultKind || type != this.Type)
            {
                var result = new BoundAttribute(this.Syntax, constructor, constructorArguments, constructorArgumentNamesOpt, namedArguments, resultKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundObjectCreationExpression : BoundExpression
    {
        public BoundObjectCreationExpression(SyntaxNode syntax, MethodSymbol constructor, ImmutableArray<MethodSymbol> constructorsGroup, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, bool expanded, ImmutableArray<int> argsToParamsOpt, ConstantValue constantValueOpt, BoundExpression initializerExpressionOpt, Binder binderOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ObjectCreationExpression, syntax, type, hasErrors || arguments.HasErrors() || initializerExpressionOpt.HasErrors())
        {

            Debug.Assert(constructor != null, "Field 'constructor' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!constructorsGroup.IsDefault, "Field 'constructorsGroup' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Constructor = constructor;
            this.ConstructorsGroup = constructorsGroup;
            this.Arguments = arguments;
            this.ArgumentNamesOpt = argumentNamesOpt;
            this.ArgumentRefKindsOpt = argumentRefKindsOpt;
            this.Expanded = expanded;
            this.ArgsToParamsOpt = argsToParamsOpt;
            this.ConstantValueOpt = constantValueOpt;
            this.InitializerExpressionOpt = initializerExpressionOpt;
            this.BinderOpt = binderOpt;
        }


        public MethodSymbol Constructor { get; }

        public ImmutableArray<MethodSymbol> ConstructorsGroup { get; }

        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<string> ArgumentNamesOpt { get; }

        public ImmutableArray<RefKind> ArgumentRefKindsOpt { get; }

        public bool Expanded { get; }

        public ImmutableArray<int> ArgsToParamsOpt { get; }

        public ConstantValue ConstantValueOpt { get; }

        public BoundExpression InitializerExpressionOpt { get; }

        public Binder BinderOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitObjectCreationExpression(this);
        }

        public BoundObjectCreationExpression Update(MethodSymbol constructor, ImmutableArray<MethodSymbol> constructorsGroup, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, bool expanded, ImmutableArray<int> argsToParamsOpt, ConstantValue constantValueOpt, BoundExpression initializerExpressionOpt, Binder binderOpt, TypeSymbol type)
        {
            if (constructor != this.Constructor || constructorsGroup != this.ConstructorsGroup || arguments != this.Arguments || argumentNamesOpt != this.ArgumentNamesOpt || argumentRefKindsOpt != this.ArgumentRefKindsOpt || expanded != this.Expanded || argsToParamsOpt != this.ArgsToParamsOpt || constantValueOpt != this.ConstantValueOpt || initializerExpressionOpt != this.InitializerExpressionOpt || binderOpt != this.BinderOpt || type != this.Type)
            {
                var result = new BoundObjectCreationExpression(this.Syntax, constructor, constructorsGroup, arguments, argumentNamesOpt, argumentRefKindsOpt, expanded, argsToParamsOpt, constantValueOpt, initializerExpressionOpt, binderOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal abstract partial class BoundTupleExpression : BoundExpression
    {
        protected BoundTupleExpression(BoundKind kind, SyntaxNode syntax, ImmutableArray<BoundExpression> arguments, TypeSymbol type, bool hasErrors = false)
            : base(kind, syntax, type, hasErrors)
        {

            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Arguments = arguments;
        }


        public ImmutableArray<BoundExpression> Arguments { get; }
    }

    internal sealed partial class BoundTupleLiteral : BoundTupleExpression
    {
        public BoundTupleLiteral(SyntaxNode syntax, ImmutableArray<string> argumentNamesOpt, ImmutableArray<bool> inferredNamesOpt, ImmutableArray<BoundExpression> arguments, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.TupleLiteral, syntax, arguments, type, hasErrors || arguments.HasErrors())
        {

            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ArgumentNamesOpt = argumentNamesOpt;
            this.InferredNamesOpt = inferredNamesOpt;
        }


        public ImmutableArray<string> ArgumentNamesOpt { get; }

        public ImmutableArray<bool> InferredNamesOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitTupleLiteral(this);
        }

        public BoundTupleLiteral Update(ImmutableArray<string> argumentNamesOpt, ImmutableArray<bool> inferredNamesOpt, ImmutableArray<BoundExpression> arguments, TypeSymbol type)
        {
            if (argumentNamesOpt != this.ArgumentNamesOpt || inferredNamesOpt != this.InferredNamesOpt || arguments != this.Arguments || type != this.Type)
            {
                var result = new BoundTupleLiteral(this.Syntax, argumentNamesOpt, inferredNamesOpt, arguments, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundConvertedTupleLiteral : BoundTupleExpression
    {
        public BoundConvertedTupleLiteral(SyntaxNode syntax, TypeSymbol naturalTypeOpt, ImmutableArray<BoundExpression> arguments, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ConvertedTupleLiteral, syntax, arguments, type, hasErrors || arguments.HasErrors())
        {

            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.NaturalTypeOpt = naturalTypeOpt;
        }


        public TypeSymbol NaturalTypeOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitConvertedTupleLiteral(this);
        }

        public BoundConvertedTupleLiteral Update(TypeSymbol naturalTypeOpt, ImmutableArray<BoundExpression> arguments, TypeSymbol type)
        {
            if (naturalTypeOpt != this.NaturalTypeOpt || arguments != this.Arguments || type != this.Type)
            {
                var result = new BoundConvertedTupleLiteral(this.Syntax, naturalTypeOpt, arguments, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundDynamicObjectCreationExpression : BoundExpression
    {
        public BoundDynamicObjectCreationExpression(SyntaxNode syntax, string name, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, BoundExpression initializerExpressionOpt, ImmutableArray<MethodSymbol> applicableMethods, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.DynamicObjectCreationExpression, syntax, type, hasErrors || arguments.HasErrors() || initializerExpressionOpt.HasErrors())
        {

            Debug.Assert(name != null, "Field 'name' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!applicableMethods.IsDefault, "Field 'applicableMethods' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Name = name;
            this.Arguments = arguments;
            this.ArgumentNamesOpt = argumentNamesOpt;
            this.ArgumentRefKindsOpt = argumentRefKindsOpt;
            this.InitializerExpressionOpt = initializerExpressionOpt;
            this.ApplicableMethods = applicableMethods;
        }


        public string Name { get; }

        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<string> ArgumentNamesOpt { get; }

        public ImmutableArray<RefKind> ArgumentRefKindsOpt { get; }

        public BoundExpression InitializerExpressionOpt { get; }

        public ImmutableArray<MethodSymbol> ApplicableMethods { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDynamicObjectCreationExpression(this);
        }

        public BoundDynamicObjectCreationExpression Update(string name, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, BoundExpression initializerExpressionOpt, ImmutableArray<MethodSymbol> applicableMethods, TypeSymbol type)
        {
            if (name != this.Name || arguments != this.Arguments || argumentNamesOpt != this.ArgumentNamesOpt || argumentRefKindsOpt != this.ArgumentRefKindsOpt || initializerExpressionOpt != this.InitializerExpressionOpt || applicableMethods != this.ApplicableMethods || type != this.Type)
            {
                var result = new BoundDynamicObjectCreationExpression(this.Syntax, name, arguments, argumentNamesOpt, argumentRefKindsOpt, initializerExpressionOpt, applicableMethods, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundNoPiaObjectCreationExpression : BoundExpression
    {
        public BoundNoPiaObjectCreationExpression(SyntaxNode syntax, string guidString, BoundExpression initializerExpressionOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.NoPiaObjectCreationExpression, syntax, type, hasErrors || initializerExpressionOpt.HasErrors())
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.GuidString = guidString;
            this.InitializerExpressionOpt = initializerExpressionOpt;
        }


        public string GuidString { get; }

        public BoundExpression InitializerExpressionOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitNoPiaObjectCreationExpression(this);
        }

        public BoundNoPiaObjectCreationExpression Update(string guidString, BoundExpression initializerExpressionOpt, TypeSymbol type)
        {
            if (guidString != this.GuidString || initializerExpressionOpt != this.InitializerExpressionOpt || type != this.Type)
            {
                var result = new BoundNoPiaObjectCreationExpression(this.Syntax, guidString, initializerExpressionOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundObjectInitializerExpression : BoundExpression
    {
        public BoundObjectInitializerExpression(SyntaxNode syntax, ImmutableArray<BoundExpression> initializers, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ObjectInitializerExpression, syntax, type, hasErrors || initializers.HasErrors())
        {

            Debug.Assert(!initializers.IsDefault, "Field 'initializers' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Initializers = initializers;
        }


        public ImmutableArray<BoundExpression> Initializers { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitObjectInitializerExpression(this);
        }

        public BoundObjectInitializerExpression Update(ImmutableArray<BoundExpression> initializers, TypeSymbol type)
        {
            if (initializers != this.Initializers || type != this.Type)
            {
                var result = new BoundObjectInitializerExpression(this.Syntax, initializers, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundObjectInitializerMember : BoundExpression
    {
        public BoundObjectInitializerMember(SyntaxNode syntax, Symbol memberSymbol, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, bool expanded, ImmutableArray<int> argsToParamsOpt, LookupResultKind resultKind, TypeSymbol receiverType, Binder binderOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ObjectInitializerMember, syntax, type, hasErrors || arguments.HasErrors())
        {

            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(receiverType != null, "Field 'receiverType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.MemberSymbol = memberSymbol;
            this.Arguments = arguments;
            this.ArgumentNamesOpt = argumentNamesOpt;
            this.ArgumentRefKindsOpt = argumentRefKindsOpt;
            this.Expanded = expanded;
            this.ArgsToParamsOpt = argsToParamsOpt;
            this._ResultKind = resultKind;
            this.ReceiverType = receiverType;
            this.BinderOpt = binderOpt;
        }


        public Symbol MemberSymbol { get; }

        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<string> ArgumentNamesOpt { get; }

        public ImmutableArray<RefKind> ArgumentRefKindsOpt { get; }

        public bool Expanded { get; }

        public ImmutableArray<int> ArgsToParamsOpt { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public TypeSymbol ReceiverType { get; }

        public Binder BinderOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitObjectInitializerMember(this);
        }

        public BoundObjectInitializerMember Update(Symbol memberSymbol, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, bool expanded, ImmutableArray<int> argsToParamsOpt, LookupResultKind resultKind, TypeSymbol receiverType, Binder binderOpt, TypeSymbol type)
        {
            if (memberSymbol != this.MemberSymbol || arguments != this.Arguments || argumentNamesOpt != this.ArgumentNamesOpt || argumentRefKindsOpt != this.ArgumentRefKindsOpt || expanded != this.Expanded || argsToParamsOpt != this.ArgsToParamsOpt || resultKind != this.ResultKind || receiverType != this.ReceiverType || binderOpt != this.BinderOpt || type != this.Type)
            {
                var result = new BoundObjectInitializerMember(this.Syntax, memberSymbol, arguments, argumentNamesOpt, argumentRefKindsOpt, expanded, argsToParamsOpt, resultKind, receiverType, binderOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundDynamicObjectInitializerMember : BoundExpression
    {
        public BoundDynamicObjectInitializerMember(SyntaxNode syntax, string memberName, TypeSymbol type, bool hasErrors)
            : base(BoundKind.DynamicObjectInitializerMember, syntax, type, hasErrors)
        {

            Debug.Assert(memberName != null, "Field 'memberName' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.MemberName = memberName;
        }

        public BoundDynamicObjectInitializerMember(SyntaxNode syntax, string memberName, TypeSymbol type)
            : base(BoundKind.DynamicObjectInitializerMember, syntax, type)
        {

            Debug.Assert(memberName != null, "Field 'memberName' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.MemberName = memberName;
        }


        public string MemberName { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDynamicObjectInitializerMember(this);
        }

        public BoundDynamicObjectInitializerMember Update(string memberName, TypeSymbol type)
        {
            if (memberName != this.MemberName || type != this.Type)
            {
                var result = new BoundDynamicObjectInitializerMember(this.Syntax, memberName, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundCollectionInitializerExpression : BoundExpression
    {
        public BoundCollectionInitializerExpression(SyntaxNode syntax, ImmutableArray<BoundExpression> initializers, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.CollectionInitializerExpression, syntax, type, hasErrors || initializers.HasErrors())
        {

            Debug.Assert(!initializers.IsDefault, "Field 'initializers' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Initializers = initializers;
        }


        public ImmutableArray<BoundExpression> Initializers { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitCollectionInitializerExpression(this);
        }

        public BoundCollectionInitializerExpression Update(ImmutableArray<BoundExpression> initializers, TypeSymbol type)
        {
            if (initializers != this.Initializers || type != this.Type)
            {
                var result = new BoundCollectionInitializerExpression(this.Syntax, initializers, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundCollectionElementInitializer : BoundExpression
    {
        public BoundCollectionElementInitializer(SyntaxNode syntax, MethodSymbol addMethod, ImmutableArray<BoundExpression> arguments, bool expanded, ImmutableArray<int> argsToParamsOpt, bool invokedAsExtensionMethod, LookupResultKind resultKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.CollectionElementInitializer, syntax, type, hasErrors || arguments.HasErrors())
        {

            Debug.Assert(addMethod != null, "Field 'addMethod' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.AddMethod = addMethod;
            this.Arguments = arguments;
            this.Expanded = expanded;
            this.ArgsToParamsOpt = argsToParamsOpt;
            this.InvokedAsExtensionMethod = invokedAsExtensionMethod;
            this._ResultKind = resultKind;
        }


        public MethodSymbol AddMethod { get; }

        public ImmutableArray<BoundExpression> Arguments { get; }

        public bool Expanded { get; }

        public ImmutableArray<int> ArgsToParamsOpt { get; }

        public bool InvokedAsExtensionMethod { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitCollectionElementInitializer(this);
        }

        public BoundCollectionElementInitializer Update(MethodSymbol addMethod, ImmutableArray<BoundExpression> arguments, bool expanded, ImmutableArray<int> argsToParamsOpt, bool invokedAsExtensionMethod, LookupResultKind resultKind, TypeSymbol type)
        {
            if (addMethod != this.AddMethod || arguments != this.Arguments || expanded != this.Expanded || argsToParamsOpt != this.ArgsToParamsOpt || invokedAsExtensionMethod != this.InvokedAsExtensionMethod || resultKind != this.ResultKind || type != this.Type)
            {
                var result = new BoundCollectionElementInitializer(this.Syntax, addMethod, arguments, expanded, argsToParamsOpt, invokedAsExtensionMethod, resultKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundDynamicCollectionElementInitializer : BoundExpression
    {
        public BoundDynamicCollectionElementInitializer(SyntaxNode syntax, ImmutableArray<BoundExpression> arguments, ImmutableArray<MethodSymbol> applicableMethods, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.DynamicCollectionElementInitializer, syntax, type, hasErrors || arguments.HasErrors())
        {

            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!applicableMethods.IsDefault, "Field 'applicableMethods' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Arguments = arguments;
            this.ApplicableMethods = applicableMethods;
        }


        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<MethodSymbol> ApplicableMethods { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDynamicCollectionElementInitializer(this);
        }

        public BoundDynamicCollectionElementInitializer Update(ImmutableArray<BoundExpression> arguments, ImmutableArray<MethodSymbol> applicableMethods, TypeSymbol type)
        {
            if (arguments != this.Arguments || applicableMethods != this.ApplicableMethods || type != this.Type)
            {
                var result = new BoundDynamicCollectionElementInitializer(this.Syntax, arguments, applicableMethods, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundImplicitReceiver : BoundExpression
    {
        public BoundImplicitReceiver(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.ImplicitReceiver, syntax, type, hasErrors)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }

        public BoundImplicitReceiver(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.ImplicitReceiver, syntax, type)
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitImplicitReceiver(this);
        }

        public BoundImplicitReceiver Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundImplicitReceiver(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundAnonymousObjectCreationExpression : BoundExpression
    {
        public BoundAnonymousObjectCreationExpression(SyntaxNode syntax, MethodSymbol constructor, ImmutableArray<BoundExpression> arguments, ImmutableArray<BoundAnonymousPropertyDeclaration> declarations, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.AnonymousObjectCreationExpression, syntax, type, hasErrors || arguments.HasErrors() || declarations.HasErrors())
        {

            Debug.Assert(constructor != null, "Field 'constructor' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!declarations.IsDefault, "Field 'declarations' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Constructor = constructor;
            this.Arguments = arguments;
            this.Declarations = declarations;
        }


        public MethodSymbol Constructor { get; }

        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<BoundAnonymousPropertyDeclaration> Declarations { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitAnonymousObjectCreationExpression(this);
        }

        public BoundAnonymousObjectCreationExpression Update(MethodSymbol constructor, ImmutableArray<BoundExpression> arguments, ImmutableArray<BoundAnonymousPropertyDeclaration> declarations, TypeSymbol type)
        {
            if (constructor != this.Constructor || arguments != this.Arguments || declarations != this.Declarations || type != this.Type)
            {
                var result = new BoundAnonymousObjectCreationExpression(this.Syntax, constructor, arguments, declarations, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundAnonymousPropertyDeclaration : BoundExpression
    {
        public BoundAnonymousPropertyDeclaration(SyntaxNode syntax, PropertySymbol property, TypeSymbol type, bool hasErrors)
            : base(BoundKind.AnonymousPropertyDeclaration, syntax, type, hasErrors)
        {

            Debug.Assert(property != null, "Field 'property' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Property = property;
        }

        public BoundAnonymousPropertyDeclaration(SyntaxNode syntax, PropertySymbol property, TypeSymbol type)
            : base(BoundKind.AnonymousPropertyDeclaration, syntax, type)
        {

            Debug.Assert(property != null, "Field 'property' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Property = property;
        }


        public PropertySymbol Property { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitAnonymousPropertyDeclaration(this);
        }

        public BoundAnonymousPropertyDeclaration Update(PropertySymbol property, TypeSymbol type)
        {
            if (property != this.Property || type != this.Type)
            {
                var result = new BoundAnonymousPropertyDeclaration(this.Syntax, property, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundNewT : BoundExpression
    {
        public BoundNewT(SyntaxNode syntax, BoundExpression initializerExpressionOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.NewT, syntax, type, hasErrors || initializerExpressionOpt.HasErrors())
        {

            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.InitializerExpressionOpt = initializerExpressionOpt;
        }


        public BoundExpression InitializerExpressionOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitNewT(this);
        }

        public BoundNewT Update(BoundExpression initializerExpressionOpt, TypeSymbol type)
        {
            if (initializerExpressionOpt != this.InitializerExpressionOpt || type != this.Type)
            {
                var result = new BoundNewT(this.Syntax, initializerExpressionOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundDelegateCreationExpression : BoundExpression
    {
        public BoundDelegateCreationExpression(SyntaxNode syntax, BoundExpression argument, MethodSymbol methodOpt, bool isExtensionMethod, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.DelegateCreationExpression, syntax, type, hasErrors || argument.HasErrors())
        {

            Debug.Assert(argument != null, "Field 'argument' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Argument = argument;
            this.MethodOpt = methodOpt;
            this.IsExtensionMethod = isExtensionMethod;
        }


        public BoundExpression Argument { get; }

        public MethodSymbol MethodOpt { get; }

        public bool IsExtensionMethod { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDelegateCreationExpression(this);
        }

        public BoundDelegateCreationExpression Update(BoundExpression argument, MethodSymbol methodOpt, bool isExtensionMethod, TypeSymbol type)
        {
            if (argument != this.Argument || methodOpt != this.MethodOpt || isExtensionMethod != this.IsExtensionMethod || type != this.Type)
            {
                var result = new BoundDelegateCreationExpression(this.Syntax, argument, methodOpt, isExtensionMethod, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundArrayCreation : BoundExpression
    {
        public BoundArrayCreation(SyntaxNode syntax, ImmutableArray<BoundExpression> bounds, BoundArrayInitialization initializerOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ArrayCreation, syntax, type, hasErrors || bounds.HasErrors() || initializerOpt.HasErrors())
        {

            Debug.Assert(!bounds.IsDefault, "Field 'bounds' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Bounds = bounds;
            this.InitializerOpt = initializerOpt;
        }


        public ImmutableArray<BoundExpression> Bounds { get; }

        public BoundArrayInitialization InitializerOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitArrayCreation(this);
        }

        public BoundArrayCreation Update(ImmutableArray<BoundExpression> bounds, BoundArrayInitialization initializerOpt, TypeSymbol type)
        {
            if (bounds != this.Bounds || initializerOpt != this.InitializerOpt || type != this.Type)
            {
                var result = new BoundArrayCreation(this.Syntax, bounds, initializerOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundArrayInitialization : BoundExpression
    {
        public BoundArrayInitialization(SyntaxNode syntax, ImmutableArray<BoundExpression> initializers, bool hasErrors = false)
            : base(BoundKind.ArrayInitialization, syntax, null, hasErrors || initializers.HasErrors())
        {

            Debug.Assert(!initializers.IsDefault, "Field 'initializers' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Initializers = initializers;
        }


        public ImmutableArray<BoundExpression> Initializers { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitArrayInitialization(this);
        }

        public BoundArrayInitialization Update(ImmutableArray<BoundExpression> initializers)
        {
            if (initializers != this.Initializers)
            {
                var result = new BoundArrayInitialization(this.Syntax, initializers, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal partial class BoundStackAllocArrayCreation : BoundExpression
    {
        protected BoundStackAllocArrayCreation(BoundKind kind, SyntaxNode syntax, TypeSymbol elementType, BoundExpression count, TypeSymbol type, bool hasErrors = false)
            : base(kind, syntax, type, hasErrors)
        {

            Debug.Assert(elementType != null, "Field 'elementType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(count != null, "Field 'count' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ElementType = elementType;
            this.Count = count;
        }

        public BoundStackAllocArrayCreation(SyntaxNode syntax, TypeSymbol elementType, BoundExpression count, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.StackAllocArrayCreation, syntax, type, hasErrors || count.HasErrors())
        {

            Debug.Assert(elementType != null, "Field 'elementType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(count != null, "Field 'count' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ElementType = elementType;
            this.Count = count;
        }


        public TypeSymbol ElementType { get; }

        public BoundExpression Count { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitStackAllocArrayCreation(this);
        }

        public BoundStackAllocArrayCreation Update(TypeSymbol elementType, BoundExpression count, TypeSymbol type)
        {
            if (elementType != this.ElementType || count != this.Count || type != this.Type)
            {
                var result = new BoundStackAllocArrayCreation(this.Syntax, elementType, count, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundConvertedStackAllocExpression : BoundStackAllocArrayCreation
    {
        public BoundConvertedStackAllocExpression(SyntaxNode syntax, TypeSymbol elementType, BoundExpression count, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ConvertedStackAllocExpression, syntax, elementType, count, type, hasErrors || count.HasErrors())
        {

            Debug.Assert(elementType != null, "Field 'elementType' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(count != null, "Field 'count' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitConvertedStackAllocExpression(this);
        }

        public new BoundConvertedStackAllocExpression Update(TypeSymbol elementType, BoundExpression count, TypeSymbol type)
        {
            if (elementType != this.ElementType || count != this.Count || type != this.Type)
            {
                var result = new BoundConvertedStackAllocExpression(this.Syntax, elementType, count, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundFieldAccess : BoundExpression
    {
        public BoundFieldAccess(SyntaxNode syntax, BoundExpression receiverOpt, FieldSymbol fieldSymbol, ConstantValue constantValueOpt, LookupResultKind resultKind, bool isByValue, bool isDeclaration, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.FieldAccess, syntax, type, hasErrors || receiverOpt.HasErrors())
        {

            Debug.Assert(fieldSymbol != null, "Field 'fieldSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ReceiverOpt = receiverOpt;
            this.FieldSymbol = fieldSymbol;
            this.ConstantValueOpt = constantValueOpt;
            this._ResultKind = resultKind;
            this.IsByValue = isByValue;
            this.IsDeclaration = isDeclaration;
        }


        public BoundExpression ReceiverOpt { get; }

        public FieldSymbol FieldSymbol { get; }

        public ConstantValue ConstantValueOpt { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public bool IsByValue { get; }

        public bool IsDeclaration { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitFieldAccess(this);
        }

        public BoundFieldAccess Update(BoundExpression receiverOpt, FieldSymbol fieldSymbol, ConstantValue constantValueOpt, LookupResultKind resultKind, bool isByValue, bool isDeclaration, TypeSymbol type)
        {
            if (receiverOpt != this.ReceiverOpt || fieldSymbol != this.FieldSymbol || constantValueOpt != this.ConstantValueOpt || resultKind != this.ResultKind || isByValue != this.IsByValue || isDeclaration != this.IsDeclaration || type != this.Type)
            {
                var result = new BoundFieldAccess(this.Syntax, receiverOpt, fieldSymbol, constantValueOpt, resultKind, isByValue, isDeclaration, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundHoistedFieldAccess : BoundExpression
    {
        public BoundHoistedFieldAccess(SyntaxNode syntax, FieldSymbol fieldSymbol, TypeSymbol type, bool hasErrors)
            : base(BoundKind.HoistedFieldAccess, syntax, type, hasErrors)
        {

            Debug.Assert(fieldSymbol != null, "Field 'fieldSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.FieldSymbol = fieldSymbol;
        }

        public BoundHoistedFieldAccess(SyntaxNode syntax, FieldSymbol fieldSymbol, TypeSymbol type)
            : base(BoundKind.HoistedFieldAccess, syntax, type)
        {

            Debug.Assert(fieldSymbol != null, "Field 'fieldSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.FieldSymbol = fieldSymbol;
        }


        public FieldSymbol FieldSymbol { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitHoistedFieldAccess(this);
        }

        public BoundHoistedFieldAccess Update(FieldSymbol fieldSymbol, TypeSymbol type)
        {
            if (fieldSymbol != this.FieldSymbol || type != this.Type)
            {
                var result = new BoundHoistedFieldAccess(this.Syntax, fieldSymbol, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundPropertyAccess : BoundExpression
    {
        public BoundPropertyAccess(SyntaxNode syntax, BoundExpression receiverOpt, PropertySymbol propertySymbol, LookupResultKind resultKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.PropertyAccess, syntax, type, hasErrors || receiverOpt.HasErrors())
        {

            Debug.Assert(propertySymbol != null, "Field 'propertySymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ReceiverOpt = receiverOpt;
            this.PropertySymbol = propertySymbol;
            this._ResultKind = resultKind;
        }


        public BoundExpression ReceiverOpt { get; }

        public PropertySymbol PropertySymbol { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitPropertyAccess(this);
        }

        public BoundPropertyAccess Update(BoundExpression receiverOpt, PropertySymbol propertySymbol, LookupResultKind resultKind, TypeSymbol type)
        {
            if (receiverOpt != this.ReceiverOpt || propertySymbol != this.PropertySymbol || resultKind != this.ResultKind || type != this.Type)
            {
                var result = new BoundPropertyAccess(this.Syntax, receiverOpt, propertySymbol, resultKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundEventAccess : BoundExpression
    {
        public BoundEventAccess(SyntaxNode syntax, BoundExpression receiverOpt, EventSymbol eventSymbol, bool isUsableAsField, LookupResultKind resultKind, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.EventAccess, syntax, type, hasErrors || receiverOpt.HasErrors())
        {

            Debug.Assert(eventSymbol != null, "Field 'eventSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ReceiverOpt = receiverOpt;
            this.EventSymbol = eventSymbol;
            this.IsUsableAsField = isUsableAsField;
            this._ResultKind = resultKind;
        }


        public BoundExpression ReceiverOpt { get; }

        public EventSymbol EventSymbol { get; }

        public bool IsUsableAsField { get; }

        private readonly LookupResultKind _ResultKind;
        public override LookupResultKind ResultKind { get { return _ResultKind;} }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitEventAccess(this);
        }

        public BoundEventAccess Update(BoundExpression receiverOpt, EventSymbol eventSymbol, bool isUsableAsField, LookupResultKind resultKind, TypeSymbol type)
        {
            if (receiverOpt != this.ReceiverOpt || eventSymbol != this.EventSymbol || isUsableAsField != this.IsUsableAsField || resultKind != this.ResultKind || type != this.Type)
            {
                var result = new BoundEventAccess(this.Syntax, receiverOpt, eventSymbol, isUsableAsField, resultKind, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundIndexerAccess : BoundExpression
    {
        public BoundIndexerAccess(SyntaxNode syntax, BoundExpression receiverOpt, PropertySymbol indexer, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, bool expanded, ImmutableArray<int> argsToParamsOpt, Binder binderOpt, bool useSetterForDefaultArgumentGeneration, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.IndexerAccess, syntax, type, hasErrors || receiverOpt.HasErrors() || arguments.HasErrors())
        {

            Debug.Assert(indexer != null, "Field 'indexer' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ReceiverOpt = receiverOpt;
            this.Indexer = indexer;
            this.Arguments = arguments;
            this.ArgumentNamesOpt = argumentNamesOpt;
            this.ArgumentRefKindsOpt = argumentRefKindsOpt;
            this.Expanded = expanded;
            this.ArgsToParamsOpt = argsToParamsOpt;
            this.BinderOpt = binderOpt;
            this.UseSetterForDefaultArgumentGeneration = useSetterForDefaultArgumentGeneration;
        }


        public BoundExpression ReceiverOpt { get; }

        public PropertySymbol Indexer { get; }

        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<string> ArgumentNamesOpt { get; }

        public ImmutableArray<RefKind> ArgumentRefKindsOpt { get; }

        public bool Expanded { get; }

        public ImmutableArray<int> ArgsToParamsOpt { get; }

        public Binder BinderOpt { get; }

        public bool UseSetterForDefaultArgumentGeneration { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitIndexerAccess(this);
        }

        public BoundIndexerAccess Update(BoundExpression receiverOpt, PropertySymbol indexer, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, bool expanded, ImmutableArray<int> argsToParamsOpt, Binder binderOpt, bool useSetterForDefaultArgumentGeneration, TypeSymbol type)
        {
            if (receiverOpt != this.ReceiverOpt || indexer != this.Indexer || arguments != this.Arguments || argumentNamesOpt != this.ArgumentNamesOpt || argumentRefKindsOpt != this.ArgumentRefKindsOpt || expanded != this.Expanded || argsToParamsOpt != this.ArgsToParamsOpt || binderOpt != this.BinderOpt || useSetterForDefaultArgumentGeneration != this.UseSetterForDefaultArgumentGeneration || type != this.Type)
            {
                var result = new BoundIndexerAccess(this.Syntax, receiverOpt, indexer, arguments, argumentNamesOpt, argumentRefKindsOpt, expanded, argsToParamsOpt, binderOpt, useSetterForDefaultArgumentGeneration, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundDynamicIndexerAccess : BoundExpression
    {
        public BoundDynamicIndexerAccess(SyntaxNode syntax, BoundExpression receiverOpt, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, ImmutableArray<PropertySymbol> applicableIndexers, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.DynamicIndexerAccess, syntax, type, hasErrors || receiverOpt.HasErrors() || arguments.HasErrors())
        {

            Debug.Assert(!arguments.IsDefault, "Field 'arguments' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!applicableIndexers.IsDefault, "Field 'applicableIndexers' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.ReceiverOpt = receiverOpt;
            this.Arguments = arguments;
            this.ArgumentNamesOpt = argumentNamesOpt;
            this.ArgumentRefKindsOpt = argumentRefKindsOpt;
            this.ApplicableIndexers = applicableIndexers;
        }


        public BoundExpression ReceiverOpt { get; }

        public ImmutableArray<BoundExpression> Arguments { get; }

        public ImmutableArray<string> ArgumentNamesOpt { get; }

        public ImmutableArray<RefKind> ArgumentRefKindsOpt { get; }

        public ImmutableArray<PropertySymbol> ApplicableIndexers { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDynamicIndexerAccess(this);
        }

        public BoundDynamicIndexerAccess Update(BoundExpression receiverOpt, ImmutableArray<BoundExpression> arguments, ImmutableArray<string> argumentNamesOpt, ImmutableArray<RefKind> argumentRefKindsOpt, ImmutableArray<PropertySymbol> applicableIndexers, TypeSymbol type)
        {
            if (receiverOpt != this.ReceiverOpt || arguments != this.Arguments || argumentNamesOpt != this.ArgumentNamesOpt || argumentRefKindsOpt != this.ArgumentRefKindsOpt || applicableIndexers != this.ApplicableIndexers || type != this.Type)
            {
                var result = new BoundDynamicIndexerAccess(this.Syntax, receiverOpt, arguments, argumentNamesOpt, argumentRefKindsOpt, applicableIndexers, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundLambda : BoundExpression
    {
        public BoundLambda(SyntaxNode syntax, LambdaSymbol symbol, BoundBlock body, ImmutableArray<Microsoft.CodeAnalysis.Diagnostic> diagnostics, Binder binder, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.Lambda, syntax, type, hasErrors || body.HasErrors())
        {

            Debug.Assert(symbol != null, "Field 'symbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(body != null, "Field 'body' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(!diagnostics.IsDefault, "Field 'diagnostics' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(binder != null, "Field 'binder' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Symbol = symbol;
            this.Body = body;
            this.Diagnostics = diagnostics;
            this.Binder = binder;
        }


        public LambdaSymbol Symbol { get; }

        public BoundBlock Body { get; }

        public ImmutableArray<Microsoft.CodeAnalysis.Diagnostic> Diagnostics { get; }

        public Binder Binder { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitLambda(this);
        }

        public BoundLambda Update(LambdaSymbol symbol, BoundBlock body, ImmutableArray<Microsoft.CodeAnalysis.Diagnostic> diagnostics, Binder binder, TypeSymbol type)
        {
            if (symbol != this.Symbol || body != this.Body || diagnostics != this.Diagnostics || binder != this.Binder || type != this.Type)
            {
                var result = new BoundLambda(this.Syntax, symbol, body, diagnostics, binder, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class UnboundLambda : BoundExpression
    {
        public UnboundLambda(SyntaxNode syntax, UnboundLambdaState data, bool hasErrors)
            : base(BoundKind.UnboundLambda, syntax, null, hasErrors)
        {

            Debug.Assert(data != null, "Field 'data' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Data = data;
        }

        public UnboundLambda(SyntaxNode syntax, UnboundLambdaState data)
            : base(BoundKind.UnboundLambda, syntax, null)
        {

            Debug.Assert(data != null, "Field 'data' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Data = data;
        }


        public UnboundLambdaState Data { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitUnboundLambda(this);
        }

        public UnboundLambda Update(UnboundLambdaState data)
        {
            if (data != this.Data)
            {
                var result = new UnboundLambda(this.Syntax, data, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundQueryClause : BoundExpression
    {
        public BoundQueryClause(SyntaxNode syntax, BoundExpression value, RangeVariableSymbol definedSymbol, Binder binder, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.QueryClause, syntax, type, hasErrors || value.HasErrors())
        {

            Debug.Assert(value != null, "Field 'value' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(binder != null, "Field 'binder' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Value = value;
            this.DefinedSymbol = definedSymbol;
            this.Binder = binder;
        }


        public BoundExpression Value { get; }

        public RangeVariableSymbol DefinedSymbol { get; }

        public Binder Binder { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitQueryClause(this);
        }

        public BoundQueryClause Update(BoundExpression value, RangeVariableSymbol definedSymbol, Binder binder, TypeSymbol type)
        {
            if (value != this.Value || definedSymbol != this.DefinedSymbol || binder != this.Binder || type != this.Type)
            {
                var result = new BoundQueryClause(this.Syntax, value, definedSymbol, binder, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundTypeOrInstanceInitializers : BoundStatementList
    {
        public BoundTypeOrInstanceInitializers(SyntaxNode syntax, ImmutableArray<BoundStatement> statements, bool hasErrors = false)
            : base(BoundKind.TypeOrInstanceInitializers, syntax, statements, hasErrors || statements.HasErrors())
        {

            Debug.Assert(!statements.IsDefault, "Field 'statements' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitTypeOrInstanceInitializers(this);
        }

        public new BoundTypeOrInstanceInitializers Update(ImmutableArray<BoundStatement> statements)
        {
            if (statements != this.Statements)
            {
                var result = new BoundTypeOrInstanceInitializers(this.Syntax, statements, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundNameOfOperator : BoundExpression
    {
        public BoundNameOfOperator(SyntaxNode syntax, BoundExpression argument, ConstantValue constantValueOpt, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.NameOfOperator, syntax, type, hasErrors || argument.HasErrors())
        {

            Debug.Assert(argument != null, "Field 'argument' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(constantValueOpt != null, "Field 'constantValueOpt' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(type != null, "Field 'type' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Argument = argument;
            this.ConstantValueOpt = constantValueOpt;
        }


        public BoundExpression Argument { get; }

        public ConstantValue ConstantValueOpt { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitNameOfOperator(this);
        }

        public BoundNameOfOperator Update(BoundExpression argument, ConstantValue constantValueOpt, TypeSymbol type)
        {
            if (argument != this.Argument || constantValueOpt != this.ConstantValueOpt || type != this.Type)
            {
                var result = new BoundNameOfOperator(this.Syntax, argument, constantValueOpt, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundInterpolatedString : BoundExpression
    {
        public BoundInterpolatedString(SyntaxNode syntax, ImmutableArray<BoundExpression> parts, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.InterpolatedString, syntax, type, hasErrors || parts.HasErrors())
        {

            Debug.Assert(!parts.IsDefault, "Field 'parts' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Parts = parts;
        }


        public ImmutableArray<BoundExpression> Parts { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitInterpolatedString(this);
        }

        public BoundInterpolatedString Update(ImmutableArray<BoundExpression> parts, TypeSymbol type)
        {
            if (parts != this.Parts || type != this.Type)
            {
                var result = new BoundInterpolatedString(this.Syntax, parts, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundStringInsert : BoundExpression
    {
        public BoundStringInsert(SyntaxNode syntax, BoundExpression value, BoundExpression alignment, BoundExpression format, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.StringInsert, syntax, type, hasErrors || value.HasErrors() || alignment.HasErrors() || format.HasErrors())
        {

            Debug.Assert(value != null, "Field 'value' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Value = value;
            this.Alignment = alignment;
            this.Format = format;
        }


        public BoundExpression Value { get; }

        public BoundExpression Alignment { get; }

        public BoundExpression Format { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitStringInsert(this);
        }

        public BoundStringInsert Update(BoundExpression value, BoundExpression alignment, BoundExpression format, TypeSymbol type)
        {
            if (value != this.Value || alignment != this.Alignment || format != this.Format || type != this.Type)
            {
                var result = new BoundStringInsert(this.Syntax, value, alignment, format, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundIsPatternExpression : BoundExpression
    {
        public BoundIsPatternExpression(SyntaxNode syntax, BoundExpression expression, BoundPattern pattern, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.IsPatternExpression, syntax, type, hasErrors || expression.HasErrors() || pattern.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");
            Debug.Assert(pattern != null, "Field 'pattern' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
            this.Pattern = pattern;
        }


        public BoundExpression Expression { get; }

        public BoundPattern Pattern { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitIsPatternExpression(this);
        }

        public BoundIsPatternExpression Update(BoundExpression expression, BoundPattern pattern, TypeSymbol type)
        {
            if (expression != this.Expression || pattern != this.Pattern || type != this.Type)
            {
                var result = new BoundIsPatternExpression(this.Syntax, expression, pattern, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal abstract partial class BoundPattern : BoundNode
    {
        protected BoundPattern(BoundKind kind, SyntaxNode syntax, bool hasErrors)
            : base(kind, syntax, hasErrors)
        {
        }

        protected BoundPattern(BoundKind kind, SyntaxNode syntax)
            : base(kind, syntax)
        {
        }

    }

    internal sealed partial class BoundDeclarationPattern : BoundPattern
    {
        public BoundDeclarationPattern(SyntaxNode syntax, Symbol variable, BoundExpression variableAccess, BoundTypeExpression declaredType, bool isVar, bool hasErrors = false)
            : base(BoundKind.DeclarationPattern, syntax, hasErrors || variableAccess.HasErrors() || declaredType.HasErrors())
        {

            Debug.Assert(variableAccess != null, "Field 'variableAccess' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Variable = variable;
            this.VariableAccess = variableAccess;
            this.DeclaredType = declaredType;
            this.IsVar = isVar;
        }


        public Symbol Variable { get; }

        public BoundExpression VariableAccess { get; }

        public BoundTypeExpression DeclaredType { get; }

        public bool IsVar { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDeclarationPattern(this);
        }

        public BoundDeclarationPattern Update(Symbol variable, BoundExpression variableAccess, BoundTypeExpression declaredType, bool isVar)
        {
            if (variable != this.Variable || variableAccess != this.VariableAccess || declaredType != this.DeclaredType || isVar != this.IsVar)
            {
                var result = new BoundDeclarationPattern(this.Syntax, variable, variableAccess, declaredType, isVar, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundConstantPattern : BoundPattern
    {
        public BoundConstantPattern(SyntaxNode syntax, BoundExpression value, ConstantValue constantValue, bool hasErrors = false)
            : base(BoundKind.ConstantPattern, syntax, hasErrors || value.HasErrors())
        {

            Debug.Assert(value != null, "Field 'value' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Value = value;
            this.ConstantValue = constantValue;
        }


        public BoundExpression Value { get; }

        public ConstantValue ConstantValue { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitConstantPattern(this);
        }

        public BoundConstantPattern Update(BoundExpression value, ConstantValue constantValue)
        {
            if (value != this.Value || constantValue != this.ConstantValue)
            {
                var result = new BoundConstantPattern(this.Syntax, value, constantValue, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundWildcardPattern : BoundPattern
    {
        public BoundWildcardPattern(SyntaxNode syntax, bool hasErrors)
            : base(BoundKind.WildcardPattern, syntax, hasErrors)
        {
        }

        public BoundWildcardPattern(SyntaxNode syntax)
            : base(BoundKind.WildcardPattern, syntax)
        {
        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitWildcardPattern(this);
        }
    }

    internal sealed partial class BoundDiscardExpression : BoundExpression
    {
        public BoundDiscardExpression(SyntaxNode syntax, TypeSymbol type, bool hasErrors)
            : base(BoundKind.DiscardExpression, syntax, type, hasErrors)
        {
        }

        public BoundDiscardExpression(SyntaxNode syntax, TypeSymbol type)
            : base(BoundKind.DiscardExpression, syntax, type)
        {
        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDiscardExpression(this);
        }

        public BoundDiscardExpression Update(TypeSymbol type)
        {
            if (type != this.Type)
            {
                var result = new BoundDiscardExpression(this.Syntax, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class BoundThrowExpression : BoundExpression
    {
        public BoundThrowExpression(SyntaxNode syntax, BoundExpression expression, TypeSymbol type, bool hasErrors = false)
            : base(BoundKind.ThrowExpression, syntax, type, hasErrors || expression.HasErrors())
        {

            Debug.Assert(expression != null, "Field 'expression' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.Expression = expression;
        }


        public BoundExpression Expression { get; }

        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitThrowExpression(this);
        }

        public BoundThrowExpression Update(BoundExpression expression, TypeSymbol type)
        {
            if (expression != this.Expression || type != this.Type)
            {
                var result = new BoundThrowExpression(this.Syntax, expression, type, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal abstract partial class VariablePendingInference : BoundExpression
    {
        protected VariablePendingInference(BoundKind kind, SyntaxNode syntax, Symbol variableSymbol, BoundExpression receiverOpt, bool hasErrors = false)
            : base(kind, syntax, null, hasErrors)
        {

            Debug.Assert(variableSymbol != null, "Field 'variableSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

            this.VariableSymbol = variableSymbol;
            this.ReceiverOpt = receiverOpt;
        }


        public Symbol VariableSymbol { get; }

        public BoundExpression ReceiverOpt { get; }
    }

    internal sealed partial class OutVariablePendingInference : VariablePendingInference
    {
        public OutVariablePendingInference(SyntaxNode syntax, Symbol variableSymbol, BoundExpression receiverOpt, bool hasErrors = false)
            : base(BoundKind.OutVariablePendingInference, syntax, variableSymbol, receiverOpt, hasErrors || receiverOpt.HasErrors())
        {

            Debug.Assert(variableSymbol != null, "Field 'variableSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitOutVariablePendingInference(this);
        }

        public OutVariablePendingInference Update(Symbol variableSymbol, BoundExpression receiverOpt)
        {
            if (variableSymbol != this.VariableSymbol || receiverOpt != this.ReceiverOpt)
            {
                var result = new OutVariablePendingInference(this.Syntax, variableSymbol, receiverOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class DeconstructionVariablePendingInference : VariablePendingInference
    {
        public DeconstructionVariablePendingInference(SyntaxNode syntax, Symbol variableSymbol, BoundExpression receiverOpt, bool hasErrors = false)
            : base(BoundKind.DeconstructionVariablePendingInference, syntax, variableSymbol, receiverOpt, hasErrors || receiverOpt.HasErrors())
        {

            Debug.Assert(variableSymbol != null, "Field 'variableSymbol' cannot be null (use Null=\"allow\" in BoundNodes.xml to remove this check)");

        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitDeconstructionVariablePendingInference(this);
        }

        public DeconstructionVariablePendingInference Update(Symbol variableSymbol, BoundExpression receiverOpt)
        {
            if (variableSymbol != this.VariableSymbol || receiverOpt != this.ReceiverOpt)
            {
                var result = new DeconstructionVariablePendingInference(this.Syntax, variableSymbol, receiverOpt, this.HasErrors);
                result.WasCompilerGenerated = this.WasCompilerGenerated;
                return result;
            }
            return this;
        }
    }

    internal sealed partial class OutDeconstructVarPendingInference : BoundExpression
    {
        public OutDeconstructVarPendingInference(SyntaxNode syntax, bool hasErrors)
            : base(BoundKind.OutDeconstructVarPendingInference, syntax, null, hasErrors)
        {
        }

        public OutDeconstructVarPendingInference(SyntaxNode syntax)
            : base(BoundKind.OutDeconstructVarPendingInference, syntax, null)
        {
        }


        public override BoundNode Accept(BoundTreeVisitor visitor)
        {
            return visitor.VisitOutDeconstructVarPendingInference(this);
        }

        public OutDeconstructVarPendingInference Update()
        {
            return this;
        }
    }

    internal abstract partial class BoundTreeVisitor<A,R>
    {

        [MethodImpl(MethodImplOptions.NoInlining)]
        internal R VisitInternal(BoundNode node, A arg)
        {
            switch (node.Kind)
            {
                case BoundKind.FieldInitializer: 
                    return VisitFieldInitializer(node as BoundFieldInitializer, arg);
                case BoundKind.FieldEqualsValue: 
                    return VisitFieldEqualsValue(node as BoundFieldEqualsValue, arg);
                case BoundKind.PropertyEqualsValue: 
                    return VisitPropertyEqualsValue(node as BoundPropertyEqualsValue, arg);
                case BoundKind.ParameterEqualsValue: 
                    return VisitParameterEqualsValue(node as BoundParameterEqualsValue, arg);
                case BoundKind.GlobalStatementInitializer: 
                    return VisitGlobalStatementInitializer(node as BoundGlobalStatementInitializer, arg);
                case BoundKind.DeconstructValuePlaceholder: 
                    return VisitDeconstructValuePlaceholder(node as BoundDeconstructValuePlaceholder, arg);
                case BoundKind.Dup: 
                    return VisitDup(node as BoundDup, arg);
                case BoundKind.BadExpression: 
                    return VisitBadExpression(node as BoundBadExpression, arg);
                case BoundKind.BadStatement: 
                    return VisitBadStatement(node as BoundBadStatement, arg);
                case BoundKind.TypeExpression: 
                    return VisitTypeExpression(node as BoundTypeExpression, arg);
                case BoundKind.TypeOrValueExpression: 
                    return VisitTypeOrValueExpression(node as BoundTypeOrValueExpression, arg);
                case BoundKind.NamespaceExpression: 
                    return VisitNamespaceExpression(node as BoundNamespaceExpression, arg);
                case BoundKind.UnaryOperator: 
                    return VisitUnaryOperator(node as BoundUnaryOperator, arg);
                case BoundKind.IncrementOperator: 
                    return VisitIncrementOperator(node as BoundIncrementOperator, arg);
                case BoundKind.AddressOfOperator: 
                    return VisitAddressOfOperator(node as BoundAddressOfOperator, arg);
                case BoundKind.PointerIndirectionOperator: 
                    return VisitPointerIndirectionOperator(node as BoundPointerIndirectionOperator, arg);
                case BoundKind.PointerElementAccess: 
                    return VisitPointerElementAccess(node as BoundPointerElementAccess, arg);
                case BoundKind.RefTypeOperator: 
                    return VisitRefTypeOperator(node as BoundRefTypeOperator, arg);
                case BoundKind.MakeRefOperator: 
                    return VisitMakeRefOperator(node as BoundMakeRefOperator, arg);
                case BoundKind.RefValueOperator: 
                    return VisitRefValueOperator(node as BoundRefValueOperator, arg);
                case BoundKind.BinaryOperator: 
                    return VisitBinaryOperator(node as BoundBinaryOperator, arg);
                case BoundKind.UserDefinedConditionalLogicalOperator: 
                    return VisitUserDefinedConditionalLogicalOperator(node as BoundUserDefinedConditionalLogicalOperator, arg);
                case BoundKind.CompoundAssignmentOperator: 
                    return VisitCompoundAssignmentOperator(node as BoundCompoundAssignmentOperator, arg);
                case BoundKind.AssignmentOperator: 
                    return VisitAssignmentOperator(node as BoundAssignmentOperator, arg);
                case BoundKind.DeconstructionAssignmentOperator: 
                    return VisitDeconstructionAssignmentOperator(node as BoundDeconstructionAssignmentOperator, arg);
                case BoundKind.NullCoalescingOperator: 
                    return VisitNullCoalescingOperator(node as BoundNullCoalescingOperator, arg);
                case BoundKind.ConditionalOperator: 
                    return VisitConditionalOperator(node as BoundConditionalOperator, arg);
                case BoundKind.ArrayAccess: 
                    return VisitArrayAccess(node as BoundArrayAccess, arg);
                case BoundKind.ArrayLength: 
                    return VisitArrayLength(node as BoundArrayLength, arg);
                case BoundKind.AwaitExpression: 
                    return VisitAwaitExpression(node as BoundAwaitExpression, arg);
                case BoundKind.TypeOfOperator: 
                    return VisitTypeOfOperator(node as BoundTypeOfOperator, arg);
                case BoundKind.MethodDefIndex: 
                    return VisitMethodDefIndex(node as BoundMethodDefIndex, arg);
                case BoundKind.MaximumMethodDefIndex: 
                    return VisitMaximumMethodDefIndex(node as BoundMaximumMethodDefIndex, arg);
                case BoundKind.InstrumentationPayloadRoot: 
                    return VisitInstrumentationPayloadRoot(node as BoundInstrumentationPayloadRoot, arg);
                case BoundKind.ModuleVersionId: 
                    return VisitModuleVersionId(node as BoundModuleVersionId, arg);
                case BoundKind.ModuleVersionIdString: 
                    return VisitModuleVersionIdString(node as BoundModuleVersionIdString, arg);
                case BoundKind.SourceDocumentIndex: 
                    return VisitSourceDocumentIndex(node as BoundSourceDocumentIndex, arg);
                case BoundKind.MethodInfo: 
                    return VisitMethodInfo(node as BoundMethodInfo, arg);
                case BoundKind.FieldInfo: 
                    return VisitFieldInfo(node as BoundFieldInfo, arg);
                case BoundKind.DefaultExpression: 
                    return VisitDefaultExpression(node as BoundDefaultExpression, arg);
                case BoundKind.IsOperator: 
                    return VisitIsOperator(node as BoundIsOperator, arg);
                case BoundKind.AsOperator: 
                    return VisitAsOperator(node as BoundAsOperator, arg);
                case BoundKind.SizeOfOperator: 
                    return VisitSizeOfOperator(node as BoundSizeOfOperator, arg);
                case BoundKind.Conversion: 
                    return VisitConversion(node as BoundConversion, arg);
                case BoundKind.ArgList: 
                    return VisitArgList(node as BoundArgList, arg);
                case BoundKind.ArgListOperator: 
                    return VisitArgListOperator(node as BoundArgListOperator, arg);
                case BoundKind.FixedLocalCollectionInitializer: 
                    return VisitFixedLocalCollectionInitializer(node as BoundFixedLocalCollectionInitializer, arg);
                case BoundKind.SequencePoint: 
                    return VisitSequencePoint(node as BoundSequencePoint, arg);
                case BoundKind.SequencePointExpression: 
                    return VisitSequencePointExpression(node as BoundSequencePointExpression, arg);
                case BoundKind.SequencePointWithSpan: 
                    return VisitSequencePointWithSpan(node as BoundSequencePointWithSpan, arg);
                case BoundKind.Block: 
                    return VisitBlock(node as BoundBlock, arg);
                case BoundKind.Scope: 
                    return VisitScope(node as BoundScope, arg);
                case BoundKind.StateMachineScope: 
                    return VisitStateMachineScope(node as BoundStateMachineScope, arg);
                case BoundKind.LocalDeclaration: 
                    return VisitLocalDeclaration(node as BoundLocalDeclaration, arg);
                case BoundKind.MultipleLocalDeclarations: 
                    return VisitMultipleLocalDeclarations(node as BoundMultipleLocalDeclarations, arg);
                case BoundKind.LocalFunctionStatement: 
                    return VisitLocalFunctionStatement(node as BoundLocalFunctionStatement, arg);
                case BoundKind.Sequence: 
                    return VisitSequence(node as BoundSequence, arg);
                case BoundKind.NoOpStatement: 
                    return VisitNoOpStatement(node as BoundNoOpStatement, arg);
                case BoundKind.ReturnStatement: 
                    return VisitReturnStatement(node as BoundReturnStatement, arg);
                case BoundKind.YieldReturnStatement: 
                    return VisitYieldReturnStatement(node as BoundYieldReturnStatement, arg);
                case BoundKind.YieldBreakStatement: 
                    return VisitYieldBreakStatement(node as BoundYieldBreakStatement, arg);
                case BoundKind.ThrowStatement: 
                    return VisitThrowStatement(node as BoundThrowStatement, arg);
                case BoundKind.ExpressionStatement: 
                    return VisitExpressionStatement(node as BoundExpressionStatement, arg);
                case BoundKind.SwitchStatement: 
                    return VisitSwitchStatement(node as BoundSwitchStatement, arg);
                case BoundKind.SwitchSection: 
                    return VisitSwitchSection(node as BoundSwitchSection, arg);
                case BoundKind.SwitchLabel: 
                    return VisitSwitchLabel(node as BoundSwitchLabel, arg);
                case BoundKind.BreakStatement: 
                    return VisitBreakStatement(node as BoundBreakStatement, arg);
                case BoundKind.ContinueStatement: 
                    return VisitContinueStatement(node as BoundContinueStatement, arg);
                case BoundKind.PatternSwitchStatement: 
                    return VisitPatternSwitchStatement(node as BoundPatternSwitchStatement, arg);
                case BoundKind.PatternSwitchSection: 
                    return VisitPatternSwitchSection(node as BoundPatternSwitchSection, arg);
                case BoundKind.PatternSwitchLabel: 
                    return VisitPatternSwitchLabel(node as BoundPatternSwitchLabel, arg);
                case BoundKind.IfStatement: 
                    return VisitIfStatement(node as BoundIfStatement, arg);
                case BoundKind.DoStatement: 
                    return VisitDoStatement(node as BoundDoStatement, arg);
                case BoundKind.WhileStatement: 
                    return VisitWhileStatement(node as BoundWhileStatement, arg);
                case BoundKind.ForStatement: 
                    return VisitForStatement(node as BoundForStatement, arg);
                case BoundKind.ForEachStatement: 
                    return VisitForEachStatement(node as BoundForEachStatement, arg);
                case BoundKind.ForEachDeconstructStep: 
                    return VisitForEachDeconstructStep(node as BoundForEachDeconstructStep, arg);
                case BoundKind.UsingStatement: 
                    return VisitUsingStatement(node as BoundUsingStatement, arg);
                case BoundKind.FixedStatement: 
                    return VisitFixedStatement(node as BoundFixedStatement, arg);
                case BoundKind.LockStatement: 
                    return VisitLockStatement(node as BoundLockStatement, arg);
                case BoundKind.TryStatement: 
                    return VisitTryStatement(node as BoundTryStatement, arg);
                case BoundKind.CatchBlock: 
                    return VisitCatchBlock(node as BoundCatchBlock, arg);
                case BoundKind.Literal: 
                    return VisitLiteral(node as BoundLiteral, arg);
                case BoundKind.ThisReference: 
                    return VisitThisReference(node as BoundThisReference, arg);
                case BoundKind.PreviousSubmissionReference: 
                    return VisitPreviousSubmissionReference(node as BoundPreviousSubmissionReference, arg);
                case BoundKind.HostObjectMemberReference: 
                    return VisitHostObjectMemberReference(node as BoundHostObjectMemberReference, arg);
                case BoundKind.BaseReference: 
                    return VisitBaseReference(node as BoundBaseReference, arg);
                case BoundKind.Local: 
                    return VisitLocal(node as BoundLocal, arg);
                case BoundKind.PseudoVariable: 
                    return VisitPseudoVariable(node as BoundPseudoVariable, arg);
                case BoundKind.RangeVariable: 
                    return VisitRangeVariable(node as BoundRangeVariable, arg);
                case BoundKind.Parameter: 
                    return VisitParameter(node as BoundParameter, arg);
                case BoundKind.LabelStatement: 
                    return VisitLabelStatement(node as BoundLabelStatement, arg);
                case BoundKind.GotoStatement: 
                    return VisitGotoStatement(node as BoundGotoStatement, arg);
                case BoundKind.LabeledStatement: 
                    return VisitLabeledStatement(node as BoundLabeledStatement, arg);
                case BoundKind.Label: 
                    return VisitLabel(node as BoundLabel, arg);
                case BoundKind.StatementList: 
                    return VisitStatementList(node as BoundStatementList, arg);
                case BoundKind.ConditionalGoto: 
                    return VisitConditionalGoto(node as BoundConditionalGoto, arg);
                case BoundKind.DynamicMemberAccess: 
                    return VisitDynamicMemberAccess(node as BoundDynamicMemberAccess, arg);
                case BoundKind.DynamicInvocation: 
                    return VisitDynamicInvocation(node as BoundDynamicInvocation, arg);
                case BoundKind.ConditionalAccess: 
                    return VisitConditionalAccess(node as BoundConditionalAccess, arg);
                case BoundKind.LoweredConditionalAccess: 
                    return VisitLoweredConditionalAccess(node as BoundLoweredConditionalAccess, arg);
                case BoundKind.ConditionalReceiver: 
                    return VisitConditionalReceiver(node as BoundConditionalReceiver, arg);
                case BoundKind.ComplexConditionalReceiver: 
                    return VisitComplexConditionalReceiver(node as BoundComplexConditionalReceiver, arg);
                case BoundKind.MethodGroup: 
                    return VisitMethodGroup(node as BoundMethodGroup, arg);
                case BoundKind.PropertyGroup: 
                    return VisitPropertyGroup(node as BoundPropertyGroup, arg);
                case BoundKind.Call: 
                    return VisitCall(node as BoundCall, arg);
                case BoundKind.EventAssignmentOperator: 
                    return VisitEventAssignmentOperator(node as BoundEventAssignmentOperator, arg);
                case BoundKind.Attribute: 
                    return VisitAttribute(node as BoundAttribute, arg);
                case BoundKind.ObjectCreationExpression: 
                    return VisitObjectCreationExpression(node as BoundObjectCreationExpression, arg);
                case BoundKind.TupleLiteral: 
                    return VisitTupleLiteral(node as BoundTupleLiteral, arg);
                case BoundKind.ConvertedTupleLiteral: 
                    return VisitConvertedTupleLiteral(node as BoundConvertedTupleLiteral, arg);
                case BoundKind.DynamicObjectCreationExpression: 
                    return VisitDynamicObjectCreationExpression(node as BoundDynamicObjectCreationExpression, arg);
                case BoundKind.NoPiaObjectCreationExpression: 
                    return VisitNoPiaObjectCreationExpression(node as BoundNoPiaObjectCreationExpression, arg);
                case BoundKind.ObjectInitializerExpression: 
                    return VisitObjectInitializerExpression(node as BoundObjectInitializerExpression, arg);
                case BoundKind.ObjectInitializerMember: 
                    return VisitObjectInitializerMember(node as BoundObjectInitializerMember, arg);
                case BoundKind.DynamicObjectInitializerMember: 
                    return VisitDynamicObjectInitializerMember(node as BoundDynamicObjectInitializerMember, arg);
                case BoundKind.CollectionInitializerExpression: 
                    return VisitCollectionInitializerExpression(node as BoundCollectionInitializerExpression, arg);
                case BoundKind.CollectionElementInitializer: 
                    return VisitCollectionElementInitializer(node as BoundCollectionElementInitializer, arg);
                case BoundKind.DynamicCollectionElementInitializer: 
                    return VisitDynamicCollectionElementInitializer(node as BoundDynamicCollectionElementInitializer, arg);
                case BoundKind.ImplicitReceiver: 
                    return VisitImplicitReceiver(node as BoundImplicitReceiver, arg);
                case BoundKind.AnonymousObjectCreationExpression: 
                    return VisitAnonymousObjectCreationExpression(node as BoundAnonymousObjectCreationExpression, arg);
                case BoundKind.AnonymousPropertyDeclaration: 
                    return VisitAnonymousPropertyDeclaration(node as BoundAnonymousPropertyDeclaration, arg);
                case BoundKind.NewT: 
                    return VisitNewT(node as BoundNewT, arg);
                case BoundKind.DelegateCreationExpression: 
                    return VisitDelegateCreationExpression(node as BoundDelegateCreationExpression, arg);
                case BoundKind.ArrayCreation: 
                    return VisitArrayCreation(node as BoundArrayCreation, arg);
                case BoundKind.ArrayInitialization: 
                    return VisitArrayInitialization(node as BoundArrayInitialization, arg);
                case BoundKind.StackAllocArrayCreation: 
                    return VisitStackAllocArrayCreation(node as BoundStackAllocArrayCreation, arg);
                case BoundKind.ConvertedStackAllocExpression: 
                    return VisitConvertedStackAllocExpression(node as BoundConvertedStackAllocExpression, arg);
                case BoundKind.FieldAccess: 
                    return VisitFieldAccess(node as BoundFieldAccess, arg);
                case BoundKind.HoistedFieldAccess: 
                    return VisitHoistedFieldAccess(node as BoundHoistedFieldAccess, arg);
                case BoundKind.PropertyAccess: 
                    return VisitPropertyAccess(node as BoundPropertyAccess, arg);
                case BoundKind.EventAccess: 
                    return VisitEventAccess(node as BoundEventAccess, arg);
                case BoundKind.IndexerAccess: 
                    return VisitIndexerAccess(node as BoundIndexerAccess, arg);
                case BoundKind.DynamicIndexerAccess: 
                    return VisitDynamicIndexerAccess(node as BoundDynamicIndexerAccess, arg);
                case BoundKind.Lambda: 
                    return VisitLambda(node as BoundLambda, arg);
                case BoundKind.UnboundLambda: 
                    return VisitUnboundLambda(node as UnboundLambda, arg);
                case BoundKind.QueryClause: 
                    return VisitQueryClause(node as BoundQueryClause, arg);
                case BoundKind.TypeOrInstanceInitializers: 
                    return VisitTypeOrInstanceInitializers(node as BoundTypeOrInstanceInitializers, arg);
                case BoundKind.NameOfOperator: 
                    return VisitNameOfOperator(node as BoundNameOfOperator, arg);
                case BoundKind.InterpolatedString: 
                    return VisitInterpolatedString(node as BoundInterpolatedString, arg);
                case BoundKind.StringInsert: 
                    return VisitStringInsert(node as BoundStringInsert, arg);
                case BoundKind.IsPatternExpression: 
                    return VisitIsPatternExpression(node as BoundIsPatternExpression, arg);
                case BoundKind.DeclarationPattern: 
                    return VisitDeclarationPattern(node as BoundDeclarationPattern, arg);
                case BoundKind.ConstantPattern: 
                    return VisitConstantPattern(node as BoundConstantPattern, arg);
                case BoundKind.WildcardPattern: 
                    return VisitWildcardPattern(node as BoundWildcardPattern, arg);
                case BoundKind.DiscardExpression: 
                    return VisitDiscardExpression(node as BoundDiscardExpression, arg);
                case BoundKind.ThrowExpression: 
                    return VisitThrowExpression(node as BoundThrowExpression, arg);
                case BoundKind.OutVariablePendingInference: 
                    return VisitOutVariablePendingInference(node as OutVariablePendingInference, arg);
                case BoundKind.DeconstructionVariablePendingInference: 
                    return VisitDeconstructionVariablePendingInference(node as DeconstructionVariablePendingInference, arg);
                case BoundKind.OutDeconstructVarPendingInference: 
                    return VisitOutDeconstructVarPendingInference(node as OutDeconstructVarPendingInference, arg);
            }

            return default(R);
        }
    }

    internal abstract partial class BoundTreeVisitor<A,R>
    {
        public virtual R VisitFieldInitializer(BoundFieldInitializer node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitFieldEqualsValue(BoundFieldEqualsValue node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPropertyEqualsValue(BoundPropertyEqualsValue node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitParameterEqualsValue(BoundParameterEqualsValue node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitGlobalStatementInitializer(BoundGlobalStatementInitializer node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDeconstructValuePlaceholder(BoundDeconstructValuePlaceholder node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDup(BoundDup node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitBadExpression(BoundBadExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitBadStatement(BoundBadStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitTypeExpression(BoundTypeExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitTypeOrValueExpression(BoundTypeOrValueExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitNamespaceExpression(BoundNamespaceExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitUnaryOperator(BoundUnaryOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitIncrementOperator(BoundIncrementOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitAddressOfOperator(BoundAddressOfOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPointerIndirectionOperator(BoundPointerIndirectionOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPointerElementAccess(BoundPointerElementAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitRefTypeOperator(BoundRefTypeOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitMakeRefOperator(BoundMakeRefOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitRefValueOperator(BoundRefValueOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitBinaryOperator(BoundBinaryOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitUserDefinedConditionalLogicalOperator(BoundUserDefinedConditionalLogicalOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitCompoundAssignmentOperator(BoundCompoundAssignmentOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitAssignmentOperator(BoundAssignmentOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDeconstructionAssignmentOperator(BoundDeconstructionAssignmentOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitNullCoalescingOperator(BoundNullCoalescingOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitConditionalOperator(BoundConditionalOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitArrayAccess(BoundArrayAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitArrayLength(BoundArrayLength node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitAwaitExpression(BoundAwaitExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitTypeOfOperator(BoundTypeOfOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitMethodDefIndex(BoundMethodDefIndex node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitMaximumMethodDefIndex(BoundMaximumMethodDefIndex node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitInstrumentationPayloadRoot(BoundInstrumentationPayloadRoot node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitModuleVersionId(BoundModuleVersionId node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitModuleVersionIdString(BoundModuleVersionIdString node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitSourceDocumentIndex(BoundSourceDocumentIndex node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitMethodInfo(BoundMethodInfo node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitFieldInfo(BoundFieldInfo node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDefaultExpression(BoundDefaultExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitIsOperator(BoundIsOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitAsOperator(BoundAsOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitSizeOfOperator(BoundSizeOfOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitConversion(BoundConversion node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitArgList(BoundArgList node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitArgListOperator(BoundArgListOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitFixedLocalCollectionInitializer(BoundFixedLocalCollectionInitializer node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitSequencePoint(BoundSequencePoint node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitSequencePointExpression(BoundSequencePointExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitSequencePointWithSpan(BoundSequencePointWithSpan node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitBlock(BoundBlock node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitScope(BoundScope node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitStateMachineScope(BoundStateMachineScope node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLocalDeclaration(BoundLocalDeclaration node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitMultipleLocalDeclarations(BoundMultipleLocalDeclarations node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLocalFunctionStatement(BoundLocalFunctionStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitSequence(BoundSequence node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitNoOpStatement(BoundNoOpStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitReturnStatement(BoundReturnStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitYieldReturnStatement(BoundYieldReturnStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitYieldBreakStatement(BoundYieldBreakStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitThrowStatement(BoundThrowStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitExpressionStatement(BoundExpressionStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitSwitchStatement(BoundSwitchStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitSwitchSection(BoundSwitchSection node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitSwitchLabel(BoundSwitchLabel node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitBreakStatement(BoundBreakStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitContinueStatement(BoundContinueStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPatternSwitchStatement(BoundPatternSwitchStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPatternSwitchSection(BoundPatternSwitchSection node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPatternSwitchLabel(BoundPatternSwitchLabel node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitIfStatement(BoundIfStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDoStatement(BoundDoStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitWhileStatement(BoundWhileStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitForStatement(BoundForStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitForEachStatement(BoundForEachStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitForEachDeconstructStep(BoundForEachDeconstructStep node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitUsingStatement(BoundUsingStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitFixedStatement(BoundFixedStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLockStatement(BoundLockStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitTryStatement(BoundTryStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitCatchBlock(BoundCatchBlock node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLiteral(BoundLiteral node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitThisReference(BoundThisReference node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPreviousSubmissionReference(BoundPreviousSubmissionReference node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitHostObjectMemberReference(BoundHostObjectMemberReference node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitBaseReference(BoundBaseReference node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLocal(BoundLocal node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPseudoVariable(BoundPseudoVariable node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitRangeVariable(BoundRangeVariable node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitParameter(BoundParameter node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLabelStatement(BoundLabelStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitGotoStatement(BoundGotoStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLabeledStatement(BoundLabeledStatement node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLabel(BoundLabel node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitStatementList(BoundStatementList node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitConditionalGoto(BoundConditionalGoto node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDynamicMemberAccess(BoundDynamicMemberAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDynamicInvocation(BoundDynamicInvocation node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitConditionalAccess(BoundConditionalAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLoweredConditionalAccess(BoundLoweredConditionalAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitConditionalReceiver(BoundConditionalReceiver node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitComplexConditionalReceiver(BoundComplexConditionalReceiver node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitMethodGroup(BoundMethodGroup node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPropertyGroup(BoundPropertyGroup node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitCall(BoundCall node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitEventAssignmentOperator(BoundEventAssignmentOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitAttribute(BoundAttribute node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitObjectCreationExpression(BoundObjectCreationExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitTupleLiteral(BoundTupleLiteral node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitConvertedTupleLiteral(BoundConvertedTupleLiteral node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDynamicObjectCreationExpression(BoundDynamicObjectCreationExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitNoPiaObjectCreationExpression(BoundNoPiaObjectCreationExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitObjectInitializerExpression(BoundObjectInitializerExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitObjectInitializerMember(BoundObjectInitializerMember node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDynamicObjectInitializerMember(BoundDynamicObjectInitializerMember node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitCollectionInitializerExpression(BoundCollectionInitializerExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitCollectionElementInitializer(BoundCollectionElementInitializer node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDynamicCollectionElementInitializer(BoundDynamicCollectionElementInitializer node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitImplicitReceiver(BoundImplicitReceiver node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitAnonymousObjectCreationExpression(BoundAnonymousObjectCreationExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitAnonymousPropertyDeclaration(BoundAnonymousPropertyDeclaration node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitNewT(BoundNewT node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDelegateCreationExpression(BoundDelegateCreationExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitArrayCreation(BoundArrayCreation node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitArrayInitialization(BoundArrayInitialization node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitStackAllocArrayCreation(BoundStackAllocArrayCreation node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitConvertedStackAllocExpression(BoundConvertedStackAllocExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitFieldAccess(BoundFieldAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitHoistedFieldAccess(BoundHoistedFieldAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitPropertyAccess(BoundPropertyAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitEventAccess(BoundEventAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitIndexerAccess(BoundIndexerAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDynamicIndexerAccess(BoundDynamicIndexerAccess node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitLambda(BoundLambda node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitUnboundLambda(UnboundLambda node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitQueryClause(BoundQueryClause node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitTypeOrInstanceInitializers(BoundTypeOrInstanceInitializers node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitNameOfOperator(BoundNameOfOperator node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitInterpolatedString(BoundInterpolatedString node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitStringInsert(BoundStringInsert node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitIsPatternExpression(BoundIsPatternExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDeclarationPattern(BoundDeclarationPattern node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitConstantPattern(BoundConstantPattern node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitWildcardPattern(BoundWildcardPattern node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDiscardExpression(BoundDiscardExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitThrowExpression(BoundThrowExpression node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitOutVariablePendingInference(OutVariablePendingInference node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitDeconstructionVariablePendingInference(DeconstructionVariablePendingInference node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
        public virtual R VisitOutDeconstructVarPendingInference(OutDeconstructVarPendingInference node, A arg)
        {
            return this.DefaultVisit(node, arg);
        }
    }

    internal abstract partial class BoundTreeVisitor
    {
        public virtual BoundNode VisitFieldInitializer(BoundFieldInitializer node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitFieldEqualsValue(BoundFieldEqualsValue node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPropertyEqualsValue(BoundPropertyEqualsValue node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitParameterEqualsValue(BoundParameterEqualsValue node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitGlobalStatementInitializer(BoundGlobalStatementInitializer node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDeconstructValuePlaceholder(BoundDeconstructValuePlaceholder node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDup(BoundDup node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitBadExpression(BoundBadExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitBadStatement(BoundBadStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitTypeExpression(BoundTypeExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitTypeOrValueExpression(BoundTypeOrValueExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitNamespaceExpression(BoundNamespaceExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitUnaryOperator(BoundUnaryOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitIncrementOperator(BoundIncrementOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitAddressOfOperator(BoundAddressOfOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPointerIndirectionOperator(BoundPointerIndirectionOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPointerElementAccess(BoundPointerElementAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitRefTypeOperator(BoundRefTypeOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitMakeRefOperator(BoundMakeRefOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitRefValueOperator(BoundRefValueOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitBinaryOperator(BoundBinaryOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitUserDefinedConditionalLogicalOperator(BoundUserDefinedConditionalLogicalOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitCompoundAssignmentOperator(BoundCompoundAssignmentOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitAssignmentOperator(BoundAssignmentOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDeconstructionAssignmentOperator(BoundDeconstructionAssignmentOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitNullCoalescingOperator(BoundNullCoalescingOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitConditionalOperator(BoundConditionalOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitArrayAccess(BoundArrayAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitArrayLength(BoundArrayLength node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitAwaitExpression(BoundAwaitExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitTypeOfOperator(BoundTypeOfOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitMethodDefIndex(BoundMethodDefIndex node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitMaximumMethodDefIndex(BoundMaximumMethodDefIndex node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitInstrumentationPayloadRoot(BoundInstrumentationPayloadRoot node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitModuleVersionId(BoundModuleVersionId node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitModuleVersionIdString(BoundModuleVersionIdString node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitSourceDocumentIndex(BoundSourceDocumentIndex node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitMethodInfo(BoundMethodInfo node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitFieldInfo(BoundFieldInfo node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDefaultExpression(BoundDefaultExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitIsOperator(BoundIsOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitAsOperator(BoundAsOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitSizeOfOperator(BoundSizeOfOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitConversion(BoundConversion node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitArgList(BoundArgList node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitArgListOperator(BoundArgListOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitFixedLocalCollectionInitializer(BoundFixedLocalCollectionInitializer node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitSequencePoint(BoundSequencePoint node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitSequencePointExpression(BoundSequencePointExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitSequencePointWithSpan(BoundSequencePointWithSpan node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitBlock(BoundBlock node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitScope(BoundScope node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitStateMachineScope(BoundStateMachineScope node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLocalDeclaration(BoundLocalDeclaration node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitMultipleLocalDeclarations(BoundMultipleLocalDeclarations node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLocalFunctionStatement(BoundLocalFunctionStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitSequence(BoundSequence node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitNoOpStatement(BoundNoOpStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitReturnStatement(BoundReturnStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitYieldReturnStatement(BoundYieldReturnStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitYieldBreakStatement(BoundYieldBreakStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitThrowStatement(BoundThrowStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitExpressionStatement(BoundExpressionStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitSwitchStatement(BoundSwitchStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitSwitchSection(BoundSwitchSection node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitSwitchLabel(BoundSwitchLabel node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitBreakStatement(BoundBreakStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitContinueStatement(BoundContinueStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPatternSwitchStatement(BoundPatternSwitchStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPatternSwitchSection(BoundPatternSwitchSection node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPatternSwitchLabel(BoundPatternSwitchLabel node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitIfStatement(BoundIfStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDoStatement(BoundDoStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitWhileStatement(BoundWhileStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitForStatement(BoundForStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitForEachStatement(BoundForEachStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitForEachDeconstructStep(BoundForEachDeconstructStep node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitUsingStatement(BoundUsingStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitFixedStatement(BoundFixedStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLockStatement(BoundLockStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitTryStatement(BoundTryStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitCatchBlock(BoundCatchBlock node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLiteral(BoundLiteral node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitThisReference(BoundThisReference node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPreviousSubmissionReference(BoundPreviousSubmissionReference node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitHostObjectMemberReference(BoundHostObjectMemberReference node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitBaseReference(BoundBaseReference node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLocal(BoundLocal node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPseudoVariable(BoundPseudoVariable node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitRangeVariable(BoundRangeVariable node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitParameter(BoundParameter node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLabelStatement(BoundLabelStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitGotoStatement(BoundGotoStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLabeledStatement(BoundLabeledStatement node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLabel(BoundLabel node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitStatementList(BoundStatementList node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitConditionalGoto(BoundConditionalGoto node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDynamicMemberAccess(BoundDynamicMemberAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDynamicInvocation(BoundDynamicInvocation node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitConditionalAccess(BoundConditionalAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLoweredConditionalAccess(BoundLoweredConditionalAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitConditionalReceiver(BoundConditionalReceiver node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitComplexConditionalReceiver(BoundComplexConditionalReceiver node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitMethodGroup(BoundMethodGroup node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPropertyGroup(BoundPropertyGroup node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitCall(BoundCall node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitEventAssignmentOperator(BoundEventAssignmentOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitAttribute(BoundAttribute node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitObjectCreationExpression(BoundObjectCreationExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitTupleLiteral(BoundTupleLiteral node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitConvertedTupleLiteral(BoundConvertedTupleLiteral node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDynamicObjectCreationExpression(BoundDynamicObjectCreationExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitNoPiaObjectCreationExpression(BoundNoPiaObjectCreationExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitObjectInitializerExpression(BoundObjectInitializerExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitObjectInitializerMember(BoundObjectInitializerMember node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDynamicObjectInitializerMember(BoundDynamicObjectInitializerMember node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitCollectionInitializerExpression(BoundCollectionInitializerExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitCollectionElementInitializer(BoundCollectionElementInitializer node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDynamicCollectionElementInitializer(BoundDynamicCollectionElementInitializer node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitImplicitReceiver(BoundImplicitReceiver node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitAnonymousObjectCreationExpression(BoundAnonymousObjectCreationExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitAnonymousPropertyDeclaration(BoundAnonymousPropertyDeclaration node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitNewT(BoundNewT node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDelegateCreationExpression(BoundDelegateCreationExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitArrayCreation(BoundArrayCreation node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitArrayInitialization(BoundArrayInitialization node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitStackAllocArrayCreation(BoundStackAllocArrayCreation node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitConvertedStackAllocExpression(BoundConvertedStackAllocExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitFieldAccess(BoundFieldAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitHoistedFieldAccess(BoundHoistedFieldAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitPropertyAccess(BoundPropertyAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitEventAccess(BoundEventAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitIndexerAccess(BoundIndexerAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDynamicIndexerAccess(BoundDynamicIndexerAccess node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitLambda(BoundLambda node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitUnboundLambda(UnboundLambda node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitQueryClause(BoundQueryClause node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitTypeOrInstanceInitializers(BoundTypeOrInstanceInitializers node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitNameOfOperator(BoundNameOfOperator node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitInterpolatedString(BoundInterpolatedString node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitStringInsert(BoundStringInsert node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitIsPatternExpression(BoundIsPatternExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDeclarationPattern(BoundDeclarationPattern node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitConstantPattern(BoundConstantPattern node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitWildcardPattern(BoundWildcardPattern node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDiscardExpression(BoundDiscardExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitThrowExpression(BoundThrowExpression node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitOutVariablePendingInference(OutVariablePendingInference node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitDeconstructionVariablePendingInference(DeconstructionVariablePendingInference node)
        {
            return this.DefaultVisit(node);
        }
        public virtual BoundNode VisitOutDeconstructVarPendingInference(OutDeconstructVarPendingInference node)
        {
            return this.DefaultVisit(node);
        }
    }

    internal abstract partial class BoundTreeWalker: BoundTreeVisitor
    {
        public override BoundNode VisitFieldInitializer(BoundFieldInitializer node)
        {
            this.Visit(node.InitialValue);
            return null;
        }
        public override BoundNode VisitFieldEqualsValue(BoundFieldEqualsValue node)
        {
            this.Visit(node.Value);
            return null;
        }
        public override BoundNode VisitPropertyEqualsValue(BoundPropertyEqualsValue node)
        {
            this.Visit(node.Value);
            return null;
        }
        public override BoundNode VisitParameterEqualsValue(BoundParameterEqualsValue node)
        {
            this.Visit(node.Value);
            return null;
        }
        public override BoundNode VisitGlobalStatementInitializer(BoundGlobalStatementInitializer node)
        {
            this.Visit(node.Statement);
            return null;
        }
        public override BoundNode VisitDeconstructValuePlaceholder(BoundDeconstructValuePlaceholder node)
        {
            return null;
        }
        public override BoundNode VisitDup(BoundDup node)
        {
            return null;
        }
        public override BoundNode VisitBadExpression(BoundBadExpression node)
        {
            this.VisitList(node.ChildBoundNodes);
            return null;
        }
        public override BoundNode VisitBadStatement(BoundBadStatement node)
        {
            this.VisitList(node.ChildBoundNodes);
            return null;
        }
        public override BoundNode VisitTypeExpression(BoundTypeExpression node)
        {
            this.Visit(node.BoundContainingTypeOpt);
            return null;
        }
        public override BoundNode VisitTypeOrValueExpression(BoundTypeOrValueExpression node)
        {
            return null;
        }
        public override BoundNode VisitNamespaceExpression(BoundNamespaceExpression node)
        {
            return null;
        }
        public override BoundNode VisitUnaryOperator(BoundUnaryOperator node)
        {
            this.Visit(node.Operand);
            return null;
        }
        public override BoundNode VisitIncrementOperator(BoundIncrementOperator node)
        {
            this.Visit(node.Operand);
            return null;
        }
        public override BoundNode VisitAddressOfOperator(BoundAddressOfOperator node)
        {
            this.Visit(node.Operand);
            return null;
        }
        public override BoundNode VisitPointerIndirectionOperator(BoundPointerIndirectionOperator node)
        {
            this.Visit(node.Operand);
            return null;
        }
        public override BoundNode VisitPointerElementAccess(BoundPointerElementAccess node)
        {
            this.Visit(node.Expression);
            this.Visit(node.Index);
            return null;
        }
        public override BoundNode VisitRefTypeOperator(BoundRefTypeOperator node)
        {
            this.Visit(node.Operand);
            return null;
        }
        public override BoundNode VisitMakeRefOperator(BoundMakeRefOperator node)
        {
            this.Visit(node.Operand);
            return null;
        }
        public override BoundNode VisitRefValueOperator(BoundRefValueOperator node)
        {
            this.Visit(node.Operand);
            return null;
        }
        public override BoundNode VisitBinaryOperator(BoundBinaryOperator node)
        {
            this.Visit(node.Left);
            this.Visit(node.Right);
            return null;
        }
        public override BoundNode VisitUserDefinedConditionalLogicalOperator(BoundUserDefinedConditionalLogicalOperator node)
        {
            this.Visit(node.Left);
            this.Visit(node.Right);
            return null;
        }
        public override BoundNode VisitCompoundAssignmentOperator(BoundCompoundAssignmentOperator node)
        {
            this.Visit(node.Left);
            this.Visit(node.Right);
            return null;
        }
        public override BoundNode VisitAssignmentOperator(BoundAssignmentOperator node)
        {
            this.Visit(node.Left);
            this.Visit(node.Right);
            return null;
        }
        public override BoundNode VisitDeconstructionAssignmentOperator(BoundDeconstructionAssignmentOperator node)
        {
            this.Visit(node.Left);
            this.Visit(node.Right);
            return null;
        }
        public override BoundNode VisitNullCoalescingOperator(BoundNullCoalescingOperator node)
        {
            this.Visit(node.LeftOperand);
            this.Visit(node.RightOperand);
            return null;
        }
        public override BoundNode VisitConditionalOperator(BoundConditionalOperator node)
        {
            this.Visit(node.Condition);
            this.Visit(node.Consequence);
            this.Visit(node.Alternative);
            return null;
        }
        public override BoundNode VisitArrayAccess(BoundArrayAccess node)
        {
            this.Visit(node.Expression);
            this.VisitList(node.Indices);
            return null;
        }
        public override BoundNode VisitArrayLength(BoundArrayLength node)
        {
            this.Visit(node.Expression);
            return null;
        }
        public override BoundNode VisitAwaitExpression(BoundAwaitExpression node)
        {
            this.Visit(node.Expression);
            return null;
        }
        public override BoundNode VisitTypeOfOperator(BoundTypeOfOperator node)
        {
            this.Visit(node.SourceType);
            return null;
        }
        public override BoundNode VisitMethodDefIndex(BoundMethodDefIndex node)
        {
            return null;
        }
        public override BoundNode VisitMaximumMethodDefIndex(BoundMaximumMethodDefIndex node)
        {
            return null;
        }
        public override BoundNode VisitInstrumentationPayloadRoot(BoundInstrumentationPayloadRoot node)
        {
            return null;
        }
        public override BoundNode VisitModuleVersionId(BoundModuleVersionId node)
        {
            return null;
        }
        public override BoundNode VisitModuleVersionIdString(BoundModuleVersionIdString node)
        {
            return null;
        }
        public override BoundNode VisitSourceDocumentIndex(BoundSourceDocumentIndex node)
        {
            return null;
        }
        public override BoundNode VisitMethodInfo(BoundMethodInfo node)
        {
            return null;
        }
        public override BoundNode VisitFieldInfo(BoundFieldInfo node)
        {
            return null;
        }
        public override BoundNode VisitDefaultExpression(BoundDefaultExpression node)
        {
            return null;
        }
        public override BoundNode VisitIsOperator(BoundIsOperator node)
        {
            this.Visit(node.Operand);
            this.Visit(node.TargetType);
            return null;
        }
        public override BoundNode VisitAsOperator(BoundAsOperator node)
        {
            this.Visit(node.Operand);
            this.Visit(node.TargetType);
            return null;
        }
        public override BoundNode VisitSizeOfOperator(BoundSizeOfOperator node)
        {
            this.Visit(node.SourceType);
            return null;
        }
        public override BoundNode VisitConversion(BoundConversion node)
        {
            this.Visit(node.Operand);
            return null;
        }
        public override BoundNode VisitArgList(BoundArgList node)
        {
            return null;
        }
        public override BoundNode VisitArgListOperator(BoundArgListOperator node)
        {
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitFixedLocalCollectionInitializer(BoundFixedLocalCollectionInitializer node)
        {
            this.Visit(node.Expression);
            return null;
        }
        public override BoundNode VisitSequencePoint(BoundSequencePoint node)
        {
            this.Visit(node.StatementOpt);
            return null;
        }
        public override BoundNode VisitSequencePointExpression(BoundSequencePointExpression node)
        {
            this.Visit(node.Expression);
            return null;
        }
        public override BoundNode VisitSequencePointWithSpan(BoundSequencePointWithSpan node)
        {
            this.Visit(node.StatementOpt);
            return null;
        }
        public override BoundNode VisitBlock(BoundBlock node)
        {
            this.VisitList(node.Statements);
            return null;
        }
        public override BoundNode VisitScope(BoundScope node)
        {
            this.VisitList(node.Statements);
            return null;
        }
        public override BoundNode VisitStateMachineScope(BoundStateMachineScope node)
        {
            this.Visit(node.Statement);
            return null;
        }
        public override BoundNode VisitLocalDeclaration(BoundLocalDeclaration node)
        {
            this.Visit(node.DeclaredType);
            this.Visit(node.InitializerOpt);
            this.VisitList(node.ArgumentsOpt);
            return null;
        }
        public override BoundNode VisitMultipleLocalDeclarations(BoundMultipleLocalDeclarations node)
        {
            this.VisitList(node.LocalDeclarations);
            return null;
        }
        public override BoundNode VisitLocalFunctionStatement(BoundLocalFunctionStatement node)
        {
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitSequence(BoundSequence node)
        {
            this.VisitList(node.SideEffects);
            this.Visit(node.Value);
            return null;
        }
        public override BoundNode VisitNoOpStatement(BoundNoOpStatement node)
        {
            return null;
        }
        public override BoundNode VisitReturnStatement(BoundReturnStatement node)
        {
            this.Visit(node.ExpressionOpt);
            return null;
        }
        public override BoundNode VisitYieldReturnStatement(BoundYieldReturnStatement node)
        {
            this.Visit(node.Expression);
            return null;
        }
        public override BoundNode VisitYieldBreakStatement(BoundYieldBreakStatement node)
        {
            return null;
        }
        public override BoundNode VisitThrowStatement(BoundThrowStatement node)
        {
            this.Visit(node.ExpressionOpt);
            return null;
        }
        public override BoundNode VisitExpressionStatement(BoundExpressionStatement node)
        {
            this.Visit(node.Expression);
            return null;
        }
        public override BoundNode VisitSwitchStatement(BoundSwitchStatement node)
        {
            this.Visit(node.LoweredPreambleOpt);
            this.Visit(node.Expression);
            this.VisitList(node.SwitchSections);
            return null;
        }
        public override BoundNode VisitSwitchSection(BoundSwitchSection node)
        {
            this.VisitList(node.SwitchLabels);
            this.VisitList(node.Statements);
            return null;
        }
        public override BoundNode VisitSwitchLabel(BoundSwitchLabel node)
        {
            this.Visit(node.ExpressionOpt);
            return null;
        }
        public override BoundNode VisitBreakStatement(BoundBreakStatement node)
        {
            return null;
        }
        public override BoundNode VisitContinueStatement(BoundContinueStatement node)
        {
            return null;
        }
        public override BoundNode VisitPatternSwitchStatement(BoundPatternSwitchStatement node)
        {
            this.Visit(node.Expression);
            this.VisitList(node.SwitchSections);
            this.Visit(node.DefaultLabel);
            return null;
        }
        public override BoundNode VisitPatternSwitchSection(BoundPatternSwitchSection node)
        {
            this.VisitList(node.SwitchLabels);
            this.VisitList(node.Statements);
            return null;
        }
        public override BoundNode VisitPatternSwitchLabel(BoundPatternSwitchLabel node)
        {
            this.Visit(node.Pattern);
            this.Visit(node.Guard);
            return null;
        }
        public override BoundNode VisitIfStatement(BoundIfStatement node)
        {
            this.Visit(node.Condition);
            this.Visit(node.Consequence);
            this.Visit(node.AlternativeOpt);
            return null;
        }
        public override BoundNode VisitDoStatement(BoundDoStatement node)
        {
            this.Visit(node.Condition);
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitWhileStatement(BoundWhileStatement node)
        {
            this.Visit(node.Condition);
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitForStatement(BoundForStatement node)
        {
            this.Visit(node.Initializer);
            this.Visit(node.Condition);
            this.Visit(node.Increment);
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitForEachStatement(BoundForEachStatement node)
        {
            this.Visit(node.IterationVariableType);
            this.Visit(node.Expression);
            this.Visit(node.DeconstructionOpt);
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitForEachDeconstructStep(BoundForEachDeconstructStep node)
        {
            this.Visit(node.DeconstructionAssignment);
            this.Visit(node.TargetPlaceholder);
            return null;
        }
        public override BoundNode VisitUsingStatement(BoundUsingStatement node)
        {
            this.Visit(node.DeclarationsOpt);
            this.Visit(node.ExpressionOpt);
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitFixedStatement(BoundFixedStatement node)
        {
            this.Visit(node.Declarations);
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitLockStatement(BoundLockStatement node)
        {
            this.Visit(node.Argument);
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitTryStatement(BoundTryStatement node)
        {
            this.Visit(node.TryBlock);
            this.VisitList(node.CatchBlocks);
            this.Visit(node.FinallyBlockOpt);
            return null;
        }
        public override BoundNode VisitCatchBlock(BoundCatchBlock node)
        {
            this.Visit(node.ExceptionSourceOpt);
            this.Visit(node.ExceptionFilterOpt);
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitLiteral(BoundLiteral node)
        {
            return null;
        }
        public override BoundNode VisitThisReference(BoundThisReference node)
        {
            return null;
        }
        public override BoundNode VisitPreviousSubmissionReference(BoundPreviousSubmissionReference node)
        {
            return null;
        }
        public override BoundNode VisitHostObjectMemberReference(BoundHostObjectMemberReference node)
        {
            return null;
        }
        public override BoundNode VisitBaseReference(BoundBaseReference node)
        {
            return null;
        }
        public override BoundNode VisitLocal(BoundLocal node)
        {
            return null;
        }
        public override BoundNode VisitPseudoVariable(BoundPseudoVariable node)
        {
            return null;
        }
        public override BoundNode VisitRangeVariable(BoundRangeVariable node)
        {
            this.Visit(node.Value);
            return null;
        }
        public override BoundNode VisitParameter(BoundParameter node)
        {
            return null;
        }
        public override BoundNode VisitLabelStatement(BoundLabelStatement node)
        {
            return null;
        }
        public override BoundNode VisitGotoStatement(BoundGotoStatement node)
        {
            this.Visit(node.CaseExpressionOpt);
            this.Visit(node.LabelExpressionOpt);
            return null;
        }
        public override BoundNode VisitLabeledStatement(BoundLabeledStatement node)
        {
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitLabel(BoundLabel node)
        {
            return null;
        }
        public override BoundNode VisitStatementList(BoundStatementList node)
        {
            this.VisitList(node.Statements);
            return null;
        }
        public override BoundNode VisitConditionalGoto(BoundConditionalGoto node)
        {
            this.Visit(node.Condition);
            return null;
        }
        public override BoundNode VisitDynamicMemberAccess(BoundDynamicMemberAccess node)
        {
            this.Visit(node.Receiver);
            return null;
        }
        public override BoundNode VisitDynamicInvocation(BoundDynamicInvocation node)
        {
            this.Visit(node.Expression);
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitConditionalAccess(BoundConditionalAccess node)
        {
            this.Visit(node.Receiver);
            this.Visit(node.AccessExpression);
            return null;
        }
        public override BoundNode VisitLoweredConditionalAccess(BoundLoweredConditionalAccess node)
        {
            this.Visit(node.Receiver);
            this.Visit(node.WhenNotNull);
            this.Visit(node.WhenNullOpt);
            return null;
        }
        public override BoundNode VisitConditionalReceiver(BoundConditionalReceiver node)
        {
            return null;
        }
        public override BoundNode VisitComplexConditionalReceiver(BoundComplexConditionalReceiver node)
        {
            this.Visit(node.ValueTypeReceiver);
            this.Visit(node.ReferenceTypeReceiver);
            return null;
        }
        public override BoundNode VisitMethodGroup(BoundMethodGroup node)
        {
            this.Visit(node.ReceiverOpt);
            return null;
        }
        public override BoundNode VisitPropertyGroup(BoundPropertyGroup node)
        {
            this.Visit(node.ReceiverOpt);
            return null;
        }
        public override BoundNode VisitCall(BoundCall node)
        {
            this.Visit(node.ReceiverOpt);
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitEventAssignmentOperator(BoundEventAssignmentOperator node)
        {
            this.Visit(node.ReceiverOpt);
            this.Visit(node.Argument);
            return null;
        }
        public override BoundNode VisitAttribute(BoundAttribute node)
        {
            this.VisitList(node.ConstructorArguments);
            this.VisitList(node.NamedArguments);
            return null;
        }
        public override BoundNode VisitObjectCreationExpression(BoundObjectCreationExpression node)
        {
            this.VisitList(node.Arguments);
            this.Visit(node.InitializerExpressionOpt);
            return null;
        }
        public override BoundNode VisitTupleLiteral(BoundTupleLiteral node)
        {
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitConvertedTupleLiteral(BoundConvertedTupleLiteral node)
        {
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitDynamicObjectCreationExpression(BoundDynamicObjectCreationExpression node)
        {
            this.VisitList(node.Arguments);
            this.Visit(node.InitializerExpressionOpt);
            return null;
        }
        public override BoundNode VisitNoPiaObjectCreationExpression(BoundNoPiaObjectCreationExpression node)
        {
            this.Visit(node.InitializerExpressionOpt);
            return null;
        }
        public override BoundNode VisitObjectInitializerExpression(BoundObjectInitializerExpression node)
        {
            this.VisitList(node.Initializers);
            return null;
        }
        public override BoundNode VisitObjectInitializerMember(BoundObjectInitializerMember node)
        {
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitDynamicObjectInitializerMember(BoundDynamicObjectInitializerMember node)
        {
            return null;
        }
        public override BoundNode VisitCollectionInitializerExpression(BoundCollectionInitializerExpression node)
        {
            this.VisitList(node.Initializers);
            return null;
        }
        public override BoundNode VisitCollectionElementInitializer(BoundCollectionElementInitializer node)
        {
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitDynamicCollectionElementInitializer(BoundDynamicCollectionElementInitializer node)
        {
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitImplicitReceiver(BoundImplicitReceiver node)
        {
            return null;
        }
        public override BoundNode VisitAnonymousObjectCreationExpression(BoundAnonymousObjectCreationExpression node)
        {
            this.VisitList(node.Arguments);
            this.VisitList(node.Declarations);
            return null;
        }
        public override BoundNode VisitAnonymousPropertyDeclaration(BoundAnonymousPropertyDeclaration node)
        {
            return null;
        }
        public override BoundNode VisitNewT(BoundNewT node)
        {
            this.Visit(node.InitializerExpressionOpt);
            return null;
        }
        public override BoundNode VisitDelegateCreationExpression(BoundDelegateCreationExpression node)
        {
            this.Visit(node.Argument);
            return null;
        }
        public override BoundNode VisitArrayCreation(BoundArrayCreation node)
        {
            this.VisitList(node.Bounds);
            this.Visit(node.InitializerOpt);
            return null;
        }
        public override BoundNode VisitArrayInitialization(BoundArrayInitialization node)
        {
            this.VisitList(node.Initializers);
            return null;
        }
        public override BoundNode VisitStackAllocArrayCreation(BoundStackAllocArrayCreation node)
        {
            this.Visit(node.Count);
            return null;
        }
        public override BoundNode VisitConvertedStackAllocExpression(BoundConvertedStackAllocExpression node)
        {
            this.Visit(node.Count);
            return null;
        }
        public override BoundNode VisitFieldAccess(BoundFieldAccess node)
        {
            this.Visit(node.ReceiverOpt);
            return null;
        }
        public override BoundNode VisitHoistedFieldAccess(BoundHoistedFieldAccess node)
        {
            return null;
        }
        public override BoundNode VisitPropertyAccess(BoundPropertyAccess node)
        {
            this.Visit(node.ReceiverOpt);
            return null;
        }
        public override BoundNode VisitEventAccess(BoundEventAccess node)
        {
            this.Visit(node.ReceiverOpt);
            return null;
        }
        public override BoundNode VisitIndexerAccess(BoundIndexerAccess node)
        {
            this.Visit(node.ReceiverOpt);
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitDynamicIndexerAccess(BoundDynamicIndexerAccess node)
        {
            this.Visit(node.ReceiverOpt);
            this.VisitList(node.Arguments);
            return null;
        }
        public override BoundNode VisitLambda(BoundLambda node)
        {
            this.Visit(node.Body);
            return null;
        }
        public override BoundNode VisitUnboundLambda(UnboundLambda node)
        {
            return null;
        }
        public override BoundNode VisitQueryClause(BoundQueryClause node)
        {
            this.Visit(node.Value);
            return null;
        }
        public override BoundNode VisitTypeOrInstanceInitializers(BoundTypeOrInstanceInitializers node)
        {
            this.VisitList(node.Statements);
            return null;
        }
        public override BoundNode VisitNameOfOperator(BoundNameOfOperator node)
        {
            this.Visit(node.Argument);
            return null;
        }
        public override BoundNode VisitInterpolatedString(BoundInterpolatedString node)
        {
            this.VisitList(node.Parts);
            return null;
        }
        public override BoundNode VisitStringInsert(BoundStringInsert node)
        {
            this.Visit(node.Value);
            this.Visit(node.Alignment);
            this.Visit(node.Format);
            return null;
        }
        public override BoundNode VisitIsPatternExpression(BoundIsPatternExpression node)
        {
            this.Visit(node.Expression);
            this.Visit(node.Pattern);
            return null;
        }
        public override BoundNode VisitDeclarationPattern(BoundDeclarationPattern node)
        {
            this.Visit(node.VariableAccess);
            this.Visit(node.DeclaredType);
            return null;
        }
        public override BoundNode VisitConstantPattern(BoundConstantPattern node)
        {
            this.Visit(node.Value);
            return null;
        }
        public override BoundNode VisitWildcardPattern(BoundWildcardPattern node)
        {
            return null;
        }
        public override BoundNode VisitDiscardExpression(BoundDiscardExpression node)
        {
            return null;
        }
        public override BoundNode VisitThrowExpression(BoundThrowExpression node)
        {
            this.Visit(node.Expression);
            return null;
        }
        public override BoundNode VisitOutVariablePendingInference(OutVariablePendingInference node)
        {
            this.Visit(node.ReceiverOpt);
            return null;
        }
        public override BoundNode VisitDeconstructionVariablePendingInference(DeconstructionVariablePendingInference node)
        {
            this.Visit(node.ReceiverOpt);
            return null;
        }
        public override BoundNode VisitOutDeconstructVarPendingInference(OutDeconstructVarPendingInference node)
        {
            return null;
        }
    }

    internal abstract partial class BoundTreeRewriter : BoundTreeVisitor
    {
        public override BoundNode VisitFieldInitializer(BoundFieldInitializer node)
        {
            BoundExpression initialValue = (BoundExpression)this.Visit(node.InitialValue);
            return node.Update(node.Field, initialValue);
        }
        public override BoundNode VisitFieldEqualsValue(BoundFieldEqualsValue node)
        {
            BoundExpression value = (BoundExpression)this.Visit(node.Value);
            return node.Update(node.Field, value);
        }
        public override BoundNode VisitPropertyEqualsValue(BoundPropertyEqualsValue node)
        {
            BoundExpression value = (BoundExpression)this.Visit(node.Value);
            return node.Update(node.Property, value);
        }
        public override BoundNode VisitParameterEqualsValue(BoundParameterEqualsValue node)
        {
            BoundExpression value = (BoundExpression)this.Visit(node.Value);
            return node.Update(node.Parameter, value);
        }
        public override BoundNode VisitGlobalStatementInitializer(BoundGlobalStatementInitializer node)
        {
            BoundStatement statement = (BoundStatement)this.Visit(node.Statement);
            return node.Update(statement);
        }
        public override BoundNode VisitDeconstructValuePlaceholder(BoundDeconstructValuePlaceholder node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.ValEscape, type);
        }
        public override BoundNode VisitDup(BoundDup node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.RefKind, type);
        }
        public override BoundNode VisitBadExpression(BoundBadExpression node)
        {
            ImmutableArray<BoundExpression> childBoundNodes = (ImmutableArray<BoundExpression>)this.VisitList(node.ChildBoundNodes);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.ResultKind, node.Symbols, childBoundNodes, type);
        }
        public override BoundNode VisitBadStatement(BoundBadStatement node)
        {
            ImmutableArray<BoundNode> childBoundNodes = (ImmutableArray<BoundNode>)this.VisitList(node.ChildBoundNodes);
            return node.Update(childBoundNodes);
        }
        public override BoundNode VisitTypeExpression(BoundTypeExpression node)
        {
            BoundTypeExpression boundContainingTypeOpt = (BoundTypeExpression)this.Visit(node.BoundContainingTypeOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.AliasOpt, node.InferredType, boundContainingTypeOpt, type);
        }
        public override BoundNode VisitTypeOrValueExpression(BoundTypeOrValueExpression node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Data, type);
        }
        public override BoundNode VisitNamespaceExpression(BoundNamespaceExpression node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.NamespaceSymbol, node.AliasOpt);
        }
        public override BoundNode VisitUnaryOperator(BoundUnaryOperator node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.OperatorKind, operand, node.ConstantValueOpt, node.MethodOpt, node.ResultKind, type);
        }
        public override BoundNode VisitIncrementOperator(BoundIncrementOperator node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.OperatorKind, operand, node.MethodOpt, node.OperandConversion, node.ResultConversion, node.ResultKind, type);
        }
        public override BoundNode VisitAddressOfOperator(BoundAddressOfOperator node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(operand, type);
        }
        public override BoundNode VisitPointerIndirectionOperator(BoundPointerIndirectionOperator node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(operand, type);
        }
        public override BoundNode VisitPointerElementAccess(BoundPointerElementAccess node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            BoundExpression index = (BoundExpression)this.Visit(node.Index);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(expression, index, node.Checked, type);
        }
        public override BoundNode VisitRefTypeOperator(BoundRefTypeOperator node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(operand, node.GetTypeFromHandle, type);
        }
        public override BoundNode VisitMakeRefOperator(BoundMakeRefOperator node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(operand, type);
        }
        public override BoundNode VisitRefValueOperator(BoundRefValueOperator node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(operand, type);
        }
        public override BoundNode VisitBinaryOperator(BoundBinaryOperator node)
        {
            BoundExpression left = (BoundExpression)this.Visit(node.Left);
            BoundExpression right = (BoundExpression)this.Visit(node.Right);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.OperatorKind, left, right, node.ConstantValueOpt, node.MethodOpt, node.ResultKind, type);
        }
        public override BoundNode VisitUserDefinedConditionalLogicalOperator(BoundUserDefinedConditionalLogicalOperator node)
        {
            BoundExpression left = (BoundExpression)this.Visit(node.Left);
            BoundExpression right = (BoundExpression)this.Visit(node.Right);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.OperatorKind, left, right, node.LogicalOperator, node.TrueOperator, node.FalseOperator, node.ResultKind, type);
        }
        public override BoundNode VisitCompoundAssignmentOperator(BoundCompoundAssignmentOperator node)
        {
            BoundExpression left = (BoundExpression)this.Visit(node.Left);
            BoundExpression right = (BoundExpression)this.Visit(node.Right);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Operator, left, right, node.LeftConversion, node.FinalConversion, node.ResultKind, type);
        }
        public override BoundNode VisitAssignmentOperator(BoundAssignmentOperator node)
        {
            BoundExpression left = (BoundExpression)this.Visit(node.Left);
            BoundExpression right = (BoundExpression)this.Visit(node.Right);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(left, right, node.RefKind, type);
        }
        public override BoundNode VisitDeconstructionAssignmentOperator(BoundDeconstructionAssignmentOperator node)
        {
            BoundTupleExpression left = (BoundTupleExpression)this.Visit(node.Left);
            BoundConversion right = (BoundConversion)this.Visit(node.Right);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(left, right, node.IsUsed, type);
        }
        public override BoundNode VisitNullCoalescingOperator(BoundNullCoalescingOperator node)
        {
            BoundExpression leftOperand = (BoundExpression)this.Visit(node.LeftOperand);
            BoundExpression rightOperand = (BoundExpression)this.Visit(node.RightOperand);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(leftOperand, rightOperand, node.LeftConversion, type);
        }
        public override BoundNode VisitConditionalOperator(BoundConditionalOperator node)
        {
            BoundExpression condition = (BoundExpression)this.Visit(node.Condition);
            BoundExpression consequence = (BoundExpression)this.Visit(node.Consequence);
            BoundExpression alternative = (BoundExpression)this.Visit(node.Alternative);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.IsByRef, condition, consequence, alternative, node.ConstantValueOpt, type);
        }
        public override BoundNode VisitArrayAccess(BoundArrayAccess node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            ImmutableArray<BoundExpression> indices = (ImmutableArray<BoundExpression>)this.VisitList(node.Indices);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(expression, indices, type);
        }
        public override BoundNode VisitArrayLength(BoundArrayLength node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(expression, type);
        }
        public override BoundNode VisitAwaitExpression(BoundAwaitExpression node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(expression, node.GetAwaiter, node.IsCompleted, node.GetResult, type);
        }
        public override BoundNode VisitTypeOfOperator(BoundTypeOfOperator node)
        {
            BoundTypeExpression sourceType = (BoundTypeExpression)this.Visit(node.SourceType);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(sourceType, node.GetTypeFromHandle, type);
        }
        public override BoundNode VisitMethodDefIndex(BoundMethodDefIndex node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Method, type);
        }
        public override BoundNode VisitMaximumMethodDefIndex(BoundMaximumMethodDefIndex node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitInstrumentationPayloadRoot(BoundInstrumentationPayloadRoot node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.AnalysisKind, type);
        }
        public override BoundNode VisitModuleVersionId(BoundModuleVersionId node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitModuleVersionIdString(BoundModuleVersionIdString node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitSourceDocumentIndex(BoundSourceDocumentIndex node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Document, type);
        }
        public override BoundNode VisitMethodInfo(BoundMethodInfo node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Method, node.GetMethodFromHandle, type);
        }
        public override BoundNode VisitFieldInfo(BoundFieldInfo node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Field, node.GetFieldFromHandle, type);
        }
        public override BoundNode VisitDefaultExpression(BoundDefaultExpression node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.ConstantValueOpt, type);
        }
        public override BoundNode VisitIsOperator(BoundIsOperator node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            BoundTypeExpression targetType = (BoundTypeExpression)this.Visit(node.TargetType);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(operand, targetType, node.Conversion, type);
        }
        public override BoundNode VisitAsOperator(BoundAsOperator node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            BoundTypeExpression targetType = (BoundTypeExpression)this.Visit(node.TargetType);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(operand, targetType, node.Conversion, type);
        }
        public override BoundNode VisitSizeOfOperator(BoundSizeOfOperator node)
        {
            BoundTypeExpression sourceType = (BoundTypeExpression)this.Visit(node.SourceType);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(sourceType, node.ConstantValueOpt, type);
        }
        public override BoundNode VisitConversion(BoundConversion node)
        {
            BoundExpression operand = (BoundExpression)this.Visit(node.Operand);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(operand, node.Conversion, node.IsBaseConversion, node.Checked, node.ExplicitCastInCode, node.ConstantValueOpt, type);
        }
        public override BoundNode VisitArgList(BoundArgList node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitArgListOperator(BoundArgListOperator node)
        {
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(arguments, node.ArgumentRefKindsOpt, type);
        }
        public override BoundNode VisitFixedLocalCollectionInitializer(BoundFixedLocalCollectionInitializer node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            TypeSymbol elementPointerType = this.VisitType(node.ElementPointerType);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(elementPointerType, node.ElementPointerTypeConversion, expression, type);
        }
        public override BoundNode VisitSequencePoint(BoundSequencePoint node)
        {
            BoundStatement statementOpt = (BoundStatement)this.Visit(node.StatementOpt);
            return node.Update(statementOpt);
        }
        public override BoundNode VisitSequencePointExpression(BoundSequencePointExpression node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(expression, type);
        }
        public override BoundNode VisitSequencePointWithSpan(BoundSequencePointWithSpan node)
        {
            BoundStatement statementOpt = (BoundStatement)this.Visit(node.StatementOpt);
            return node.Update(statementOpt, node.Span);
        }
        public override BoundNode VisitBlock(BoundBlock node)
        {
            ImmutableArray<BoundStatement> statements = (ImmutableArray<BoundStatement>)this.VisitList(node.Statements);
            return node.Update(node.Locals, node.LocalFunctions, statements);
        }
        public override BoundNode VisitScope(BoundScope node)
        {
            ImmutableArray<BoundStatement> statements = (ImmutableArray<BoundStatement>)this.VisitList(node.Statements);
            return node.Update(node.Locals, statements);
        }
        public override BoundNode VisitStateMachineScope(BoundStateMachineScope node)
        {
            BoundStatement statement = (BoundStatement)this.Visit(node.Statement);
            return node.Update(node.Fields, statement);
        }
        public override BoundNode VisitLocalDeclaration(BoundLocalDeclaration node)
        {
            BoundTypeExpression declaredType = (BoundTypeExpression)this.Visit(node.DeclaredType);
            BoundExpression initializerOpt = (BoundExpression)this.Visit(node.InitializerOpt);
            ImmutableArray<BoundExpression> argumentsOpt = (ImmutableArray<BoundExpression>)this.VisitList(node.ArgumentsOpt);
            return node.Update(node.LocalSymbol, declaredType, initializerOpt, argumentsOpt);
        }
        public override BoundNode VisitMultipleLocalDeclarations(BoundMultipleLocalDeclarations node)
        {
            ImmutableArray<BoundLocalDeclaration> localDeclarations = (ImmutableArray<BoundLocalDeclaration>)this.VisitList(node.LocalDeclarations);
            return node.Update(localDeclarations);
        }
        public override BoundNode VisitLocalFunctionStatement(BoundLocalFunctionStatement node)
        {
            BoundBlock body = (BoundBlock)this.Visit(node.Body);
            return node.Update(node.Symbol, body);
        }
        public override BoundNode VisitSequence(BoundSequence node)
        {
            ImmutableArray<BoundExpression> sideEffects = (ImmutableArray<BoundExpression>)this.VisitList(node.SideEffects);
            BoundExpression value = (BoundExpression)this.Visit(node.Value);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Locals, sideEffects, value, type);
        }
        public override BoundNode VisitNoOpStatement(BoundNoOpStatement node)
        {
            return node;
        }
        public override BoundNode VisitReturnStatement(BoundReturnStatement node)
        {
            BoundExpression expressionOpt = (BoundExpression)this.Visit(node.ExpressionOpt);
            return node.Update(node.RefKind, expressionOpt);
        }
        public override BoundNode VisitYieldReturnStatement(BoundYieldReturnStatement node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            return node.Update(expression);
        }
        public override BoundNode VisitYieldBreakStatement(BoundYieldBreakStatement node)
        {
            return node;
        }
        public override BoundNode VisitThrowStatement(BoundThrowStatement node)
        {
            BoundExpression expressionOpt = (BoundExpression)this.Visit(node.ExpressionOpt);
            return node.Update(expressionOpt);
        }
        public override BoundNode VisitExpressionStatement(BoundExpressionStatement node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            return node.Update(expression);
        }
        public override BoundNode VisitSwitchStatement(BoundSwitchStatement node)
        {
            BoundStatement loweredPreambleOpt = (BoundStatement)this.Visit(node.LoweredPreambleOpt);
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            ImmutableArray<BoundSwitchSection> switchSections = (ImmutableArray<BoundSwitchSection>)this.VisitList(node.SwitchSections);
            return node.Update(loweredPreambleOpt, expression, node.ConstantTargetOpt, node.InnerLocals, node.InnerLocalFunctions, switchSections, node.BreakLabel, node.StringEquality);
        }
        public override BoundNode VisitSwitchSection(BoundSwitchSection node)
        {
            ImmutableArray<BoundSwitchLabel> switchLabels = (ImmutableArray<BoundSwitchLabel>)this.VisitList(node.SwitchLabels);
            ImmutableArray<BoundStatement> statements = (ImmutableArray<BoundStatement>)this.VisitList(node.Statements);
            return node.Update(switchLabels, statements);
        }
        public override BoundNode VisitSwitchLabel(BoundSwitchLabel node)
        {
            BoundExpression expressionOpt = (BoundExpression)this.Visit(node.ExpressionOpt);
            return node.Update(node.Label, expressionOpt, node.ConstantValueOpt);
        }
        public override BoundNode VisitBreakStatement(BoundBreakStatement node)
        {
            return node;
        }
        public override BoundNode VisitContinueStatement(BoundContinueStatement node)
        {
            return node;
        }
        public override BoundNode VisitPatternSwitchStatement(BoundPatternSwitchStatement node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            ImmutableArray<BoundPatternSwitchSection> switchSections = (ImmutableArray<BoundPatternSwitchSection>)this.VisitList(node.SwitchSections);
            BoundPatternSwitchLabel defaultLabel = (BoundPatternSwitchLabel)this.Visit(node.DefaultLabel);
            return node.Update(expression, node.SomeLabelAlwaysMatches, node.InnerLocals, node.InnerLocalFunctions, switchSections, defaultLabel, node.BreakLabel, node.Binder, node.IsComplete);
        }
        public override BoundNode VisitPatternSwitchSection(BoundPatternSwitchSection node)
        {
            ImmutableArray<BoundPatternSwitchLabel> switchLabels = (ImmutableArray<BoundPatternSwitchLabel>)this.VisitList(node.SwitchLabels);
            ImmutableArray<BoundStatement> statements = (ImmutableArray<BoundStatement>)this.VisitList(node.Statements);
            return node.Update(node.Locals, switchLabels, statements);
        }
        public override BoundNode VisitPatternSwitchLabel(BoundPatternSwitchLabel node)
        {
            BoundPattern pattern = (BoundPattern)this.Visit(node.Pattern);
            BoundExpression guard = (BoundExpression)this.Visit(node.Guard);
            return node.Update(node.Label, pattern, guard, node.IsReachable);
        }
        public override BoundNode VisitIfStatement(BoundIfStatement node)
        {
            BoundExpression condition = (BoundExpression)this.Visit(node.Condition);
            BoundStatement consequence = (BoundStatement)this.Visit(node.Consequence);
            BoundStatement alternativeOpt = (BoundStatement)this.Visit(node.AlternativeOpt);
            return node.Update(condition, consequence, alternativeOpt);
        }
        public override BoundNode VisitDoStatement(BoundDoStatement node)
        {
            BoundExpression condition = (BoundExpression)this.Visit(node.Condition);
            BoundStatement body = (BoundStatement)this.Visit(node.Body);
            return node.Update(node.Locals, condition, body, node.BreakLabel, node.ContinueLabel);
        }
        public override BoundNode VisitWhileStatement(BoundWhileStatement node)
        {
            BoundExpression condition = (BoundExpression)this.Visit(node.Condition);
            BoundStatement body = (BoundStatement)this.Visit(node.Body);
            return node.Update(node.Locals, condition, body, node.BreakLabel, node.ContinueLabel);
        }
        public override BoundNode VisitForStatement(BoundForStatement node)
        {
            BoundStatement initializer = (BoundStatement)this.Visit(node.Initializer);
            BoundExpression condition = (BoundExpression)this.Visit(node.Condition);
            BoundStatement increment = (BoundStatement)this.Visit(node.Increment);
            BoundStatement body = (BoundStatement)this.Visit(node.Body);
            return node.Update(node.OuterLocals, initializer, node.InnerLocals, condition, increment, body, node.BreakLabel, node.ContinueLabel);
        }
        public override BoundNode VisitForEachStatement(BoundForEachStatement node)
        {
            BoundTypeExpression iterationVariableType = (BoundTypeExpression)this.Visit(node.IterationVariableType);
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            BoundForEachDeconstructStep deconstructionOpt = (BoundForEachDeconstructStep)this.Visit(node.DeconstructionOpt);
            BoundStatement body = (BoundStatement)this.Visit(node.Body);
            return node.Update(node.EnumeratorInfoOpt, node.ElementConversion, iterationVariableType, node.IterationVariables, expression, deconstructionOpt, body, node.Checked, node.BreakLabel, node.ContinueLabel);
        }
        public override BoundNode VisitForEachDeconstructStep(BoundForEachDeconstructStep node)
        {
            BoundDeconstructionAssignmentOperator deconstructionAssignment = (BoundDeconstructionAssignmentOperator)this.Visit(node.DeconstructionAssignment);
            BoundDeconstructValuePlaceholder targetPlaceholder = (BoundDeconstructValuePlaceholder)this.Visit(node.TargetPlaceholder);
            return node.Update(deconstructionAssignment, targetPlaceholder);
        }
        public override BoundNode VisitUsingStatement(BoundUsingStatement node)
        {
            BoundMultipleLocalDeclarations declarationsOpt = (BoundMultipleLocalDeclarations)this.Visit(node.DeclarationsOpt);
            BoundExpression expressionOpt = (BoundExpression)this.Visit(node.ExpressionOpt);
            BoundStatement body = (BoundStatement)this.Visit(node.Body);
            return node.Update(node.Locals, declarationsOpt, expressionOpt, node.IDisposableConversion, body);
        }
        public override BoundNode VisitFixedStatement(BoundFixedStatement node)
        {
            BoundMultipleLocalDeclarations declarations = (BoundMultipleLocalDeclarations)this.Visit(node.Declarations);
            BoundStatement body = (BoundStatement)this.Visit(node.Body);
            return node.Update(node.Locals, declarations, body);
        }
        public override BoundNode VisitLockStatement(BoundLockStatement node)
        {
            BoundExpression argument = (BoundExpression)this.Visit(node.Argument);
            BoundStatement body = (BoundStatement)this.Visit(node.Body);
            return node.Update(argument, body);
        }
        public override BoundNode VisitTryStatement(BoundTryStatement node)
        {
            BoundBlock tryBlock = (BoundBlock)this.Visit(node.TryBlock);
            ImmutableArray<BoundCatchBlock> catchBlocks = (ImmutableArray<BoundCatchBlock>)this.VisitList(node.CatchBlocks);
            BoundBlock finallyBlockOpt = (BoundBlock)this.Visit(node.FinallyBlockOpt);
            return node.Update(tryBlock, catchBlocks, finallyBlockOpt, node.PreferFaultHandler);
        }
        public override BoundNode VisitCatchBlock(BoundCatchBlock node)
        {
            BoundExpression exceptionSourceOpt = (BoundExpression)this.Visit(node.ExceptionSourceOpt);
            BoundExpression exceptionFilterOpt = (BoundExpression)this.Visit(node.ExceptionFilterOpt);
            BoundBlock body = (BoundBlock)this.Visit(node.Body);
            TypeSymbol exceptionTypeOpt = this.VisitType(node.ExceptionTypeOpt);
            return node.Update(node.Locals, exceptionSourceOpt, exceptionTypeOpt, exceptionFilterOpt, body, node.IsSynthesizedAsyncCatchAll);
        }
        public override BoundNode VisitLiteral(BoundLiteral node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.ConstantValueOpt, type);
        }
        public override BoundNode VisitThisReference(BoundThisReference node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitPreviousSubmissionReference(BoundPreviousSubmissionReference node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitHostObjectMemberReference(BoundHostObjectMemberReference node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitBaseReference(BoundBaseReference node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitLocal(BoundLocal node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.LocalSymbol, node.IsDeclaration, node.ConstantValueOpt, type);
        }
        public override BoundNode VisitPseudoVariable(BoundPseudoVariable node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.LocalSymbol, node.EmitExpressions, type);
        }
        public override BoundNode VisitRangeVariable(BoundRangeVariable node)
        {
            BoundExpression value = (BoundExpression)this.Visit(node.Value);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.RangeVariableSymbol, value, type);
        }
        public override BoundNode VisitParameter(BoundParameter node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.ParameterSymbol, type);
        }
        public override BoundNode VisitLabelStatement(BoundLabelStatement node)
        {
            return node;
        }
        public override BoundNode VisitGotoStatement(BoundGotoStatement node)
        {
            BoundExpression caseExpressionOpt = (BoundExpression)this.Visit(node.CaseExpressionOpt);
            BoundLabel labelExpressionOpt = (BoundLabel)this.Visit(node.LabelExpressionOpt);
            return node.Update(node.Label, caseExpressionOpt, labelExpressionOpt);
        }
        public override BoundNode VisitLabeledStatement(BoundLabeledStatement node)
        {
            BoundStatement body = (BoundStatement)this.Visit(node.Body);
            return node.Update(node.Label, body);
        }
        public override BoundNode VisitLabel(BoundLabel node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Label, type);
        }
        public override BoundNode VisitStatementList(BoundStatementList node)
        {
            ImmutableArray<BoundStatement> statements = (ImmutableArray<BoundStatement>)this.VisitList(node.Statements);
            return node.Update(statements);
        }
        public override BoundNode VisitConditionalGoto(BoundConditionalGoto node)
        {
            BoundExpression condition = (BoundExpression)this.Visit(node.Condition);
            return node.Update(condition, node.JumpIfTrue, node.Label);
        }
        public override BoundNode VisitDynamicMemberAccess(BoundDynamicMemberAccess node)
        {
            BoundExpression receiver = (BoundExpression)this.Visit(node.Receiver);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(receiver, node.TypeArgumentsOpt, node.Name, node.Invoked, node.Indexed, type);
        }
        public override BoundNode VisitDynamicInvocation(BoundDynamicInvocation node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(expression, arguments, node.ArgumentNamesOpt, node.ArgumentRefKindsOpt, node.ApplicableMethods, type);
        }
        public override BoundNode VisitConditionalAccess(BoundConditionalAccess node)
        {
            BoundExpression receiver = (BoundExpression)this.Visit(node.Receiver);
            BoundExpression accessExpression = (BoundExpression)this.Visit(node.AccessExpression);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(receiver, accessExpression, type);
        }
        public override BoundNode VisitLoweredConditionalAccess(BoundLoweredConditionalAccess node)
        {
            BoundExpression receiver = (BoundExpression)this.Visit(node.Receiver);
            BoundExpression whenNotNull = (BoundExpression)this.Visit(node.WhenNotNull);
            BoundExpression whenNullOpt = (BoundExpression)this.Visit(node.WhenNullOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(receiver, node.HasValueMethodOpt, whenNotNull, whenNullOpt, node.Id, type);
        }
        public override BoundNode VisitConditionalReceiver(BoundConditionalReceiver node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Id, type);
        }
        public override BoundNode VisitComplexConditionalReceiver(BoundComplexConditionalReceiver node)
        {
            BoundExpression valueTypeReceiver = (BoundExpression)this.Visit(node.ValueTypeReceiver);
            BoundExpression referenceTypeReceiver = (BoundExpression)this.Visit(node.ReferenceTypeReceiver);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(valueTypeReceiver, referenceTypeReceiver, type);
        }
        public override BoundNode VisitMethodGroup(BoundMethodGroup node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.TypeArgumentsOpt, node.Name, node.Methods, node.LookupSymbolOpt, node.LookupError, node.Flags, receiverOpt, node.ResultKind);
        }
        public override BoundNode VisitPropertyGroup(BoundPropertyGroup node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Properties, receiverOpt, node.ResultKind);
        }
        public override BoundNode VisitCall(BoundCall node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(receiverOpt, node.Method, arguments, node.ArgumentNamesOpt, node.ArgumentRefKindsOpt, node.IsDelegateCall, node.Expanded, node.InvokedAsExtensionMethod, node.ArgsToParamsOpt, node.ResultKind, node.BinderOpt, type);
        }
        public override BoundNode VisitEventAssignmentOperator(BoundEventAssignmentOperator node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            BoundExpression argument = (BoundExpression)this.Visit(node.Argument);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Event, node.IsAddition, node.IsDynamic, receiverOpt, argument, type);
        }
        public override BoundNode VisitAttribute(BoundAttribute node)
        {
            ImmutableArray<BoundExpression> constructorArguments = (ImmutableArray<BoundExpression>)this.VisitList(node.ConstructorArguments);
            ImmutableArray<BoundExpression> namedArguments = (ImmutableArray<BoundExpression>)this.VisitList(node.NamedArguments);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Constructor, constructorArguments, node.ConstructorArgumentNamesOpt, namedArguments, node.ResultKind, type);
        }
        public override BoundNode VisitObjectCreationExpression(BoundObjectCreationExpression node)
        {
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            BoundExpression initializerExpressionOpt = (BoundExpression)this.Visit(node.InitializerExpressionOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Constructor, node.ConstructorsGroup, arguments, node.ArgumentNamesOpt, node.ArgumentRefKindsOpt, node.Expanded, node.ArgsToParamsOpt, node.ConstantValueOpt, initializerExpressionOpt, node.BinderOpt, type);
        }
        public override BoundNode VisitTupleLiteral(BoundTupleLiteral node)
        {
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.ArgumentNamesOpt, node.InferredNamesOpt, arguments, type);
        }
        public override BoundNode VisitConvertedTupleLiteral(BoundConvertedTupleLiteral node)
        {
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol naturalTypeOpt = this.VisitType(node.NaturalTypeOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(naturalTypeOpt, arguments, type);
        }
        public override BoundNode VisitDynamicObjectCreationExpression(BoundDynamicObjectCreationExpression node)
        {
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            BoundExpression initializerExpressionOpt = (BoundExpression)this.Visit(node.InitializerExpressionOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Name, arguments, node.ArgumentNamesOpt, node.ArgumentRefKindsOpt, initializerExpressionOpt, node.ApplicableMethods, type);
        }
        public override BoundNode VisitNoPiaObjectCreationExpression(BoundNoPiaObjectCreationExpression node)
        {
            BoundExpression initializerExpressionOpt = (BoundExpression)this.Visit(node.InitializerExpressionOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.GuidString, initializerExpressionOpt, type);
        }
        public override BoundNode VisitObjectInitializerExpression(BoundObjectInitializerExpression node)
        {
            ImmutableArray<BoundExpression> initializers = (ImmutableArray<BoundExpression>)this.VisitList(node.Initializers);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(initializers, type);
        }
        public override BoundNode VisitObjectInitializerMember(BoundObjectInitializerMember node)
        {
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol receiverType = this.VisitType(node.ReceiverType);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.MemberSymbol, arguments, node.ArgumentNamesOpt, node.ArgumentRefKindsOpt, node.Expanded, node.ArgsToParamsOpt, node.ResultKind, receiverType, node.BinderOpt, type);
        }
        public override BoundNode VisitDynamicObjectInitializerMember(BoundDynamicObjectInitializerMember node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.MemberName, type);
        }
        public override BoundNode VisitCollectionInitializerExpression(BoundCollectionInitializerExpression node)
        {
            ImmutableArray<BoundExpression> initializers = (ImmutableArray<BoundExpression>)this.VisitList(node.Initializers);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(initializers, type);
        }
        public override BoundNode VisitCollectionElementInitializer(BoundCollectionElementInitializer node)
        {
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.AddMethod, arguments, node.Expanded, node.ArgsToParamsOpt, node.InvokedAsExtensionMethod, node.ResultKind, type);
        }
        public override BoundNode VisitDynamicCollectionElementInitializer(BoundDynamicCollectionElementInitializer node)
        {
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(arguments, node.ApplicableMethods, type);
        }
        public override BoundNode VisitImplicitReceiver(BoundImplicitReceiver node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitAnonymousObjectCreationExpression(BoundAnonymousObjectCreationExpression node)
        {
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            ImmutableArray<BoundAnonymousPropertyDeclaration> declarations = (ImmutableArray<BoundAnonymousPropertyDeclaration>)this.VisitList(node.Declarations);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Constructor, arguments, declarations, type);
        }
        public override BoundNode VisitAnonymousPropertyDeclaration(BoundAnonymousPropertyDeclaration node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Property, type);
        }
        public override BoundNode VisitNewT(BoundNewT node)
        {
            BoundExpression initializerExpressionOpt = (BoundExpression)this.Visit(node.InitializerExpressionOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(initializerExpressionOpt, type);
        }
        public override BoundNode VisitDelegateCreationExpression(BoundDelegateCreationExpression node)
        {
            BoundExpression argument = (BoundExpression)this.Visit(node.Argument);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(argument, node.MethodOpt, node.IsExtensionMethod, type);
        }
        public override BoundNode VisitArrayCreation(BoundArrayCreation node)
        {
            ImmutableArray<BoundExpression> bounds = (ImmutableArray<BoundExpression>)this.VisitList(node.Bounds);
            BoundArrayInitialization initializerOpt = (BoundArrayInitialization)this.Visit(node.InitializerOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(bounds, initializerOpt, type);
        }
        public override BoundNode VisitArrayInitialization(BoundArrayInitialization node)
        {
            ImmutableArray<BoundExpression> initializers = (ImmutableArray<BoundExpression>)this.VisitList(node.Initializers);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(initializers);
        }
        public override BoundNode VisitStackAllocArrayCreation(BoundStackAllocArrayCreation node)
        {
            BoundExpression count = (BoundExpression)this.Visit(node.Count);
            TypeSymbol elementType = this.VisitType(node.ElementType);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(elementType, count, type);
        }
        public override BoundNode VisitConvertedStackAllocExpression(BoundConvertedStackAllocExpression node)
        {
            BoundExpression count = (BoundExpression)this.Visit(node.Count);
            TypeSymbol elementType = this.VisitType(node.ElementType);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(elementType, count, type);
        }
        public override BoundNode VisitFieldAccess(BoundFieldAccess node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(receiverOpt, node.FieldSymbol, node.ConstantValueOpt, node.ResultKind, node.IsByValue, node.IsDeclaration, type);
        }
        public override BoundNode VisitHoistedFieldAccess(BoundHoistedFieldAccess node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.FieldSymbol, type);
        }
        public override BoundNode VisitPropertyAccess(BoundPropertyAccess node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(receiverOpt, node.PropertySymbol, node.ResultKind, type);
        }
        public override BoundNode VisitEventAccess(BoundEventAccess node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(receiverOpt, node.EventSymbol, node.IsUsableAsField, node.ResultKind, type);
        }
        public override BoundNode VisitIndexerAccess(BoundIndexerAccess node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(receiverOpt, node.Indexer, arguments, node.ArgumentNamesOpt, node.ArgumentRefKindsOpt, node.Expanded, node.ArgsToParamsOpt, node.BinderOpt, node.UseSetterForDefaultArgumentGeneration, type);
        }
        public override BoundNode VisitDynamicIndexerAccess(BoundDynamicIndexerAccess node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            ImmutableArray<BoundExpression> arguments = (ImmutableArray<BoundExpression>)this.VisitList(node.Arguments);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(receiverOpt, arguments, node.ArgumentNamesOpt, node.ArgumentRefKindsOpt, node.ApplicableIndexers, type);
        }
        public override BoundNode VisitLambda(BoundLambda node)
        {
            BoundBlock body = (BoundBlock)this.Visit(node.Body);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Symbol, body, node.Diagnostics, node.Binder, type);
        }
        public override BoundNode VisitUnboundLambda(UnboundLambda node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.Data);
        }
        public override BoundNode VisitQueryClause(BoundQueryClause node)
        {
            BoundExpression value = (BoundExpression)this.Visit(node.Value);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(value, node.DefinedSymbol, node.Binder, type);
        }
        public override BoundNode VisitTypeOrInstanceInitializers(BoundTypeOrInstanceInitializers node)
        {
            ImmutableArray<BoundStatement> statements = (ImmutableArray<BoundStatement>)this.VisitList(node.Statements);
            return node.Update(statements);
        }
        public override BoundNode VisitNameOfOperator(BoundNameOfOperator node)
        {
            BoundExpression argument = (BoundExpression)this.Visit(node.Argument);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(argument, node.ConstantValueOpt, type);
        }
        public override BoundNode VisitInterpolatedString(BoundInterpolatedString node)
        {
            ImmutableArray<BoundExpression> parts = (ImmutableArray<BoundExpression>)this.VisitList(node.Parts);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(parts, type);
        }
        public override BoundNode VisitStringInsert(BoundStringInsert node)
        {
            BoundExpression value = (BoundExpression)this.Visit(node.Value);
            BoundExpression alignment = (BoundExpression)this.Visit(node.Alignment);
            BoundExpression format = (BoundExpression)this.Visit(node.Format);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(value, alignment, format, type);
        }
        public override BoundNode VisitIsPatternExpression(BoundIsPatternExpression node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            BoundPattern pattern = (BoundPattern)this.Visit(node.Pattern);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(expression, pattern, type);
        }
        public override BoundNode VisitDeclarationPattern(BoundDeclarationPattern node)
        {
            BoundExpression variableAccess = (BoundExpression)this.Visit(node.VariableAccess);
            BoundTypeExpression declaredType = (BoundTypeExpression)this.Visit(node.DeclaredType);
            return node.Update(node.Variable, variableAccess, declaredType, node.IsVar);
        }
        public override BoundNode VisitConstantPattern(BoundConstantPattern node)
        {
            BoundExpression value = (BoundExpression)this.Visit(node.Value);
            return node.Update(value, node.ConstantValue);
        }
        public override BoundNode VisitWildcardPattern(BoundWildcardPattern node)
        {
            return node;
        }
        public override BoundNode VisitDiscardExpression(BoundDiscardExpression node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(type);
        }
        public override BoundNode VisitThrowExpression(BoundThrowExpression node)
        {
            BoundExpression expression = (BoundExpression)this.Visit(node.Expression);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(expression, type);
        }
        public override BoundNode VisitOutVariablePendingInference(OutVariablePendingInference node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.VariableSymbol, receiverOpt);
        }
        public override BoundNode VisitDeconstructionVariablePendingInference(DeconstructionVariablePendingInference node)
        {
            BoundExpression receiverOpt = (BoundExpression)this.Visit(node.ReceiverOpt);
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update(node.VariableSymbol, receiverOpt);
        }
        public override BoundNode VisitOutDeconstructVarPendingInference(OutDeconstructVarPendingInference node)
        {
            TypeSymbol type = this.VisitType(node.Type);
            return node.Update();
        }
    }

    internal sealed class BoundTreeDumperNodeProducer : BoundTreeVisitor<object, TreeDumperNode>
    {
        private BoundTreeDumperNodeProducer()
        {
        }
        public static TreeDumperNode MakeTree(BoundNode node)
        {
            return (new BoundTreeDumperNodeProducer()).Visit(node, null);
        }
        public override TreeDumperNode VisitFieldInitializer(BoundFieldInitializer node, object arg)
        {
            return new TreeDumperNode("fieldInitializer", null, new TreeDumperNode[]
            {
                new TreeDumperNode("field", node.Field, null),
                new TreeDumperNode("initialValue", null, new TreeDumperNode[] { Visit(node.InitialValue, null) })
            }
            );
        }
        public override TreeDumperNode VisitFieldEqualsValue(BoundFieldEqualsValue node, object arg)
        {
            return new TreeDumperNode("fieldEqualsValue", null, new TreeDumperNode[]
            {
                new TreeDumperNode("field", node.Field, null),
                new TreeDumperNode("value", null, new TreeDumperNode[] { Visit(node.Value, null) })
            }
            );
        }
        public override TreeDumperNode VisitPropertyEqualsValue(BoundPropertyEqualsValue node, object arg)
        {
            return new TreeDumperNode("propertyEqualsValue", null, new TreeDumperNode[]
            {
                new TreeDumperNode("property", node.Property, null),
                new TreeDumperNode("value", null, new TreeDumperNode[] { Visit(node.Value, null) })
            }
            );
        }
        public override TreeDumperNode VisitParameterEqualsValue(BoundParameterEqualsValue node, object arg)
        {
            return new TreeDumperNode("parameterEqualsValue", null, new TreeDumperNode[]
            {
                new TreeDumperNode("parameter", node.Parameter, null),
                new TreeDumperNode("value", null, new TreeDumperNode[] { Visit(node.Value, null) })
            }
            );
        }
        public override TreeDumperNode VisitGlobalStatementInitializer(BoundGlobalStatementInitializer node, object arg)
        {
            return new TreeDumperNode("globalStatementInitializer", null, new TreeDumperNode[]
            {
                new TreeDumperNode("statement", null, new TreeDumperNode[] { Visit(node.Statement, null) })
            }
            );
        }
        public override TreeDumperNode VisitDeconstructValuePlaceholder(BoundDeconstructValuePlaceholder node, object arg)
        {
            return new TreeDumperNode("deconstructValuePlaceholder", null, new TreeDumperNode[]
            {
                new TreeDumperNode("valEscape", node.ValEscape, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDup(BoundDup node, object arg)
        {
            return new TreeDumperNode("dup", null, new TreeDumperNode[]
            {
                new TreeDumperNode("refKind", node.RefKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitBadExpression(BoundBadExpression node, object arg)
        {
            return new TreeDumperNode("badExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("symbols", node.Symbols, null),
                new TreeDumperNode("childBoundNodes", null, from x in node.ChildBoundNodes select Visit(x, null)),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitBadStatement(BoundBadStatement node, object arg)
        {
            return new TreeDumperNode("badStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("childBoundNodes", null, from x in node.ChildBoundNodes select Visit(x, null))
            }
            );
        }
        public override TreeDumperNode VisitTypeExpression(BoundTypeExpression node, object arg)
        {
            return new TreeDumperNode("typeExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("aliasOpt", node.AliasOpt, null),
                new TreeDumperNode("inferredType", node.InferredType, null),
                new TreeDumperNode("boundContainingTypeOpt", null, new TreeDumperNode[] { Visit(node.BoundContainingTypeOpt, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitTypeOrValueExpression(BoundTypeOrValueExpression node, object arg)
        {
            return new TreeDumperNode("typeOrValueExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("data", node.Data, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitNamespaceExpression(BoundNamespaceExpression node, object arg)
        {
            return new TreeDumperNode("namespaceExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("namespaceSymbol", node.NamespaceSymbol, null),
                new TreeDumperNode("aliasOpt", node.AliasOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitUnaryOperator(BoundUnaryOperator node, object arg)
        {
            return new TreeDumperNode("unaryOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operatorKind", node.OperatorKind, null),
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("methodOpt", node.MethodOpt, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitIncrementOperator(BoundIncrementOperator node, object arg)
        {
            return new TreeDumperNode("incrementOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operatorKind", node.OperatorKind, null),
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("methodOpt", node.MethodOpt, null),
                new TreeDumperNode("operandConversion", node.OperandConversion, null),
                new TreeDumperNode("resultConversion", node.ResultConversion, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitAddressOfOperator(BoundAddressOfOperator node, object arg)
        {
            return new TreeDumperNode("addressOfOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitPointerIndirectionOperator(BoundPointerIndirectionOperator node, object arg)
        {
            return new TreeDumperNode("pointerIndirectionOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitPointerElementAccess(BoundPointerElementAccess node, object arg)
        {
            return new TreeDumperNode("pointerElementAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("index", null, new TreeDumperNode[] { Visit(node.Index, null) }),
                new TreeDumperNode("@checked", node.Checked, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitRefTypeOperator(BoundRefTypeOperator node, object arg)
        {
            return new TreeDumperNode("refTypeOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("getTypeFromHandle", node.GetTypeFromHandle, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitMakeRefOperator(BoundMakeRefOperator node, object arg)
        {
            return new TreeDumperNode("makeRefOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitRefValueOperator(BoundRefValueOperator node, object arg)
        {
            return new TreeDumperNode("refValueOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitBinaryOperator(BoundBinaryOperator node, object arg)
        {
            return new TreeDumperNode("binaryOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operatorKind", node.OperatorKind, null),
                new TreeDumperNode("left", null, new TreeDumperNode[] { Visit(node.Left, null) }),
                new TreeDumperNode("right", null, new TreeDumperNode[] { Visit(node.Right, null) }),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("methodOpt", node.MethodOpt, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitUserDefinedConditionalLogicalOperator(BoundUserDefinedConditionalLogicalOperator node, object arg)
        {
            return new TreeDumperNode("userDefinedConditionalLogicalOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operatorKind", node.OperatorKind, null),
                new TreeDumperNode("left", null, new TreeDumperNode[] { Visit(node.Left, null) }),
                new TreeDumperNode("right", null, new TreeDumperNode[] { Visit(node.Right, null) }),
                new TreeDumperNode("logicalOperator", node.LogicalOperator, null),
                new TreeDumperNode("trueOperator", node.TrueOperator, null),
                new TreeDumperNode("falseOperator", node.FalseOperator, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitCompoundAssignmentOperator(BoundCompoundAssignmentOperator node, object arg)
        {
            return new TreeDumperNode("compoundAssignmentOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("@operator", node.Operator, null),
                new TreeDumperNode("left", null, new TreeDumperNode[] { Visit(node.Left, null) }),
                new TreeDumperNode("right", null, new TreeDumperNode[] { Visit(node.Right, null) }),
                new TreeDumperNode("leftConversion", node.LeftConversion, null),
                new TreeDumperNode("finalConversion", node.FinalConversion, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitAssignmentOperator(BoundAssignmentOperator node, object arg)
        {
            return new TreeDumperNode("assignmentOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("left", null, new TreeDumperNode[] { Visit(node.Left, null) }),
                new TreeDumperNode("right", null, new TreeDumperNode[] { Visit(node.Right, null) }),
                new TreeDumperNode("refKind", node.RefKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDeconstructionAssignmentOperator(BoundDeconstructionAssignmentOperator node, object arg)
        {
            return new TreeDumperNode("deconstructionAssignmentOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("left", null, new TreeDumperNode[] { Visit(node.Left, null) }),
                new TreeDumperNode("right", null, new TreeDumperNode[] { Visit(node.Right, null) }),
                new TreeDumperNode("isUsed", node.IsUsed, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitNullCoalescingOperator(BoundNullCoalescingOperator node, object arg)
        {
            return new TreeDumperNode("nullCoalescingOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("leftOperand", null, new TreeDumperNode[] { Visit(node.LeftOperand, null) }),
                new TreeDumperNode("rightOperand", null, new TreeDumperNode[] { Visit(node.RightOperand, null) }),
                new TreeDumperNode("leftConversion", node.LeftConversion, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitConditionalOperator(BoundConditionalOperator node, object arg)
        {
            return new TreeDumperNode("conditionalOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("isByRef", node.IsByRef, null),
                new TreeDumperNode("condition", null, new TreeDumperNode[] { Visit(node.Condition, null) }),
                new TreeDumperNode("consequence", null, new TreeDumperNode[] { Visit(node.Consequence, null) }),
                new TreeDumperNode("alternative", null, new TreeDumperNode[] { Visit(node.Alternative, null) }),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitArrayAccess(BoundArrayAccess node, object arg)
        {
            return new TreeDumperNode("arrayAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("indices", null, from x in node.Indices select Visit(x, null)),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitArrayLength(BoundArrayLength node, object arg)
        {
            return new TreeDumperNode("arrayLength", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitAwaitExpression(BoundAwaitExpression node, object arg)
        {
            return new TreeDumperNode("awaitExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("getAwaiter", node.GetAwaiter, null),
                new TreeDumperNode("isCompleted", node.IsCompleted, null),
                new TreeDumperNode("getResult", node.GetResult, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitTypeOfOperator(BoundTypeOfOperator node, object arg)
        {
            return new TreeDumperNode("typeOfOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("sourceType", null, new TreeDumperNode[] { Visit(node.SourceType, null) }),
                new TreeDumperNode("getTypeFromHandle", node.GetTypeFromHandle, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitMethodDefIndex(BoundMethodDefIndex node, object arg)
        {
            return new TreeDumperNode("methodDefIndex", null, new TreeDumperNode[]
            {
                new TreeDumperNode("method", node.Method, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitMaximumMethodDefIndex(BoundMaximumMethodDefIndex node, object arg)
        {
            return new TreeDumperNode("maximumMethodDefIndex", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitInstrumentationPayloadRoot(BoundInstrumentationPayloadRoot node, object arg)
        {
            return new TreeDumperNode("instrumentationPayloadRoot", null, new TreeDumperNode[]
            {
                new TreeDumperNode("analysisKind", node.AnalysisKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitModuleVersionId(BoundModuleVersionId node, object arg)
        {
            return new TreeDumperNode("moduleVersionId", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitModuleVersionIdString(BoundModuleVersionIdString node, object arg)
        {
            return new TreeDumperNode("moduleVersionIdString", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitSourceDocumentIndex(BoundSourceDocumentIndex node, object arg)
        {
            return new TreeDumperNode("sourceDocumentIndex", null, new TreeDumperNode[]
            {
                new TreeDumperNode("document", node.Document, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitMethodInfo(BoundMethodInfo node, object arg)
        {
            return new TreeDumperNode("methodInfo", null, new TreeDumperNode[]
            {
                new TreeDumperNode("method", node.Method, null),
                new TreeDumperNode("getMethodFromHandle", node.GetMethodFromHandle, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitFieldInfo(BoundFieldInfo node, object arg)
        {
            return new TreeDumperNode("fieldInfo", null, new TreeDumperNode[]
            {
                new TreeDumperNode("field", node.Field, null),
                new TreeDumperNode("getFieldFromHandle", node.GetFieldFromHandle, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDefaultExpression(BoundDefaultExpression node, object arg)
        {
            return new TreeDumperNode("defaultExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitIsOperator(BoundIsOperator node, object arg)
        {
            return new TreeDumperNode("isOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("targetType", null, new TreeDumperNode[] { Visit(node.TargetType, null) }),
                new TreeDumperNode("conversion", node.Conversion, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitAsOperator(BoundAsOperator node, object arg)
        {
            return new TreeDumperNode("asOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("targetType", null, new TreeDumperNode[] { Visit(node.TargetType, null) }),
                new TreeDumperNode("conversion", node.Conversion, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitSizeOfOperator(BoundSizeOfOperator node, object arg)
        {
            return new TreeDumperNode("sizeOfOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("sourceType", null, new TreeDumperNode[] { Visit(node.SourceType, null) }),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitConversion(BoundConversion node, object arg)
        {
            return new TreeDumperNode("conversion", null, new TreeDumperNode[]
            {
                new TreeDumperNode("operand", null, new TreeDumperNode[] { Visit(node.Operand, null) }),
                new TreeDumperNode("conversion", node.Conversion, null),
                new TreeDumperNode("isBaseConversion", node.IsBaseConversion, null),
                new TreeDumperNode("@checked", node.Checked, null),
                new TreeDumperNode("explicitCastInCode", node.ExplicitCastInCode, null),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitArgList(BoundArgList node, object arg)
        {
            return new TreeDumperNode("argList", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitArgListOperator(BoundArgListOperator node, object arg)
        {
            return new TreeDumperNode("argListOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("argumentRefKindsOpt", node.ArgumentRefKindsOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitFixedLocalCollectionInitializer(BoundFixedLocalCollectionInitializer node, object arg)
        {
            return new TreeDumperNode("fixedLocalCollectionInitializer", null, new TreeDumperNode[]
            {
                new TreeDumperNode("elementPointerType", node.ElementPointerType, null),
                new TreeDumperNode("elementPointerTypeConversion", node.ElementPointerTypeConversion, null),
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitSequencePoint(BoundSequencePoint node, object arg)
        {
            return new TreeDumperNode("sequencePoint", null, new TreeDumperNode[]
            {
                new TreeDumperNode("statementOpt", null, new TreeDumperNode[] { Visit(node.StatementOpt, null) })
            }
            );
        }
        public override TreeDumperNode VisitSequencePointExpression(BoundSequencePointExpression node, object arg)
        {
            return new TreeDumperNode("sequencePointExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitSequencePointWithSpan(BoundSequencePointWithSpan node, object arg)
        {
            return new TreeDumperNode("sequencePointWithSpan", null, new TreeDumperNode[]
            {
                new TreeDumperNode("statementOpt", null, new TreeDumperNode[] { Visit(node.StatementOpt, null) }),
                new TreeDumperNode("span", node.Span, null)
            }
            );
        }
        public override TreeDumperNode VisitBlock(BoundBlock node, object arg)
        {
            return new TreeDumperNode("block", null, new TreeDumperNode[]
            {
                new TreeDumperNode("locals", node.Locals, null),
                new TreeDumperNode("localFunctions", node.LocalFunctions, null),
                new TreeDumperNode("statements", null, from x in node.Statements select Visit(x, null))
            }
            );
        }
        public override TreeDumperNode VisitScope(BoundScope node, object arg)
        {
            return new TreeDumperNode("scope", null, new TreeDumperNode[]
            {
                new TreeDumperNode("locals", node.Locals, null),
                new TreeDumperNode("statements", null, from x in node.Statements select Visit(x, null))
            }
            );
        }
        public override TreeDumperNode VisitStateMachineScope(BoundStateMachineScope node, object arg)
        {
            return new TreeDumperNode("stateMachineScope", null, new TreeDumperNode[]
            {
                new TreeDumperNode("fields", node.Fields, null),
                new TreeDumperNode("statement", null, new TreeDumperNode[] { Visit(node.Statement, null) })
            }
            );
        }
        public override TreeDumperNode VisitLocalDeclaration(BoundLocalDeclaration node, object arg)
        {
            return new TreeDumperNode("localDeclaration", null, new TreeDumperNode[]
            {
                new TreeDumperNode("localSymbol", node.LocalSymbol, null),
                new TreeDumperNode("declaredType", null, new TreeDumperNode[] { Visit(node.DeclaredType, null) }),
                new TreeDumperNode("initializerOpt", null, new TreeDumperNode[] { Visit(node.InitializerOpt, null) }),
                new TreeDumperNode("argumentsOpt", null, node.ArgumentsOpt.IsDefault ? Array.Empty<TreeDumperNode>() : from x in node.ArgumentsOpt select Visit(x, null))
            }
            );
        }
        public override TreeDumperNode VisitMultipleLocalDeclarations(BoundMultipleLocalDeclarations node, object arg)
        {
            return new TreeDumperNode("multipleLocalDeclarations", null, new TreeDumperNode[]
            {
                new TreeDumperNode("localDeclarations", null, from x in node.LocalDeclarations select Visit(x, null))
            }
            );
        }
        public override TreeDumperNode VisitLocalFunctionStatement(BoundLocalFunctionStatement node, object arg)
        {
            return new TreeDumperNode("localFunctionStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("symbol", node.Symbol, null),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) })
            }
            );
        }
        public override TreeDumperNode VisitSequence(BoundSequence node, object arg)
        {
            return new TreeDumperNode("sequence", null, new TreeDumperNode[]
            {
                new TreeDumperNode("locals", node.Locals, null),
                new TreeDumperNode("sideEffects", null, from x in node.SideEffects select Visit(x, null)),
                new TreeDumperNode("value", null, new TreeDumperNode[] { Visit(node.Value, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitNoOpStatement(BoundNoOpStatement node, object arg)
        {
            return new TreeDumperNode("noOpStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("flavor", node.Flavor, null)
            }
            );
        }
        public override TreeDumperNode VisitReturnStatement(BoundReturnStatement node, object arg)
        {
            return new TreeDumperNode("returnStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("refKind", node.RefKind, null),
                new TreeDumperNode("expressionOpt", null, new TreeDumperNode[] { Visit(node.ExpressionOpt, null) })
            }
            );
        }
        public override TreeDumperNode VisitYieldReturnStatement(BoundYieldReturnStatement node, object arg)
        {
            return new TreeDumperNode("yieldReturnStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) })
            }
            );
        }
        public override TreeDumperNode VisitYieldBreakStatement(BoundYieldBreakStatement node, object arg)
        {
            return new TreeDumperNode("yieldBreakStatement", null, Array.Empty<TreeDumperNode>()
            );
        }
        public override TreeDumperNode VisitThrowStatement(BoundThrowStatement node, object arg)
        {
            return new TreeDumperNode("throwStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expressionOpt", null, new TreeDumperNode[] { Visit(node.ExpressionOpt, null) })
            }
            );
        }
        public override TreeDumperNode VisitExpressionStatement(BoundExpressionStatement node, object arg)
        {
            return new TreeDumperNode("expressionStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) })
            }
            );
        }
        public override TreeDumperNode VisitSwitchStatement(BoundSwitchStatement node, object arg)
        {
            return new TreeDumperNode("switchStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("loweredPreambleOpt", null, new TreeDumperNode[] { Visit(node.LoweredPreambleOpt, null) }),
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("constantTargetOpt", node.ConstantTargetOpt, null),
                new TreeDumperNode("innerLocals", node.InnerLocals, null),
                new TreeDumperNode("innerLocalFunctions", node.InnerLocalFunctions, null),
                new TreeDumperNode("switchSections", null, from x in node.SwitchSections select Visit(x, null)),
                new TreeDumperNode("breakLabel", node.BreakLabel, null),
                new TreeDumperNode("stringEquality", node.StringEquality, null)
            }
            );
        }
        public override TreeDumperNode VisitSwitchSection(BoundSwitchSection node, object arg)
        {
            return new TreeDumperNode("switchSection", null, new TreeDumperNode[]
            {
                new TreeDumperNode("switchLabels", null, from x in node.SwitchLabels select Visit(x, null)),
                new TreeDumperNode("statements", null, from x in node.Statements select Visit(x, null))
            }
            );
        }
        public override TreeDumperNode VisitSwitchLabel(BoundSwitchLabel node, object arg)
        {
            return new TreeDumperNode("switchLabel", null, new TreeDumperNode[]
            {
                new TreeDumperNode("label", node.Label, null),
                new TreeDumperNode("expressionOpt", null, new TreeDumperNode[] { Visit(node.ExpressionOpt, null) }),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null)
            }
            );
        }
        public override TreeDumperNode VisitBreakStatement(BoundBreakStatement node, object arg)
        {
            return new TreeDumperNode("breakStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("label", node.Label, null)
            }
            );
        }
        public override TreeDumperNode VisitContinueStatement(BoundContinueStatement node, object arg)
        {
            return new TreeDumperNode("continueStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("label", node.Label, null)
            }
            );
        }
        public override TreeDumperNode VisitPatternSwitchStatement(BoundPatternSwitchStatement node, object arg)
        {
            return new TreeDumperNode("patternSwitchStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("someLabelAlwaysMatches", node.SomeLabelAlwaysMatches, null),
                new TreeDumperNode("innerLocals", node.InnerLocals, null),
                new TreeDumperNode("innerLocalFunctions", node.InnerLocalFunctions, null),
                new TreeDumperNode("switchSections", null, from x in node.SwitchSections select Visit(x, null)),
                new TreeDumperNode("defaultLabel", null, new TreeDumperNode[] { Visit(node.DefaultLabel, null) }),
                new TreeDumperNode("breakLabel", node.BreakLabel, null),
                new TreeDumperNode("binder", node.Binder, null),
                new TreeDumperNode("isComplete", node.IsComplete, null)
            }
            );
        }
        public override TreeDumperNode VisitPatternSwitchSection(BoundPatternSwitchSection node, object arg)
        {
            return new TreeDumperNode("patternSwitchSection", null, new TreeDumperNode[]
            {
                new TreeDumperNode("locals", node.Locals, null),
                new TreeDumperNode("switchLabels", null, from x in node.SwitchLabels select Visit(x, null)),
                new TreeDumperNode("statements", null, from x in node.Statements select Visit(x, null))
            }
            );
        }
        public override TreeDumperNode VisitPatternSwitchLabel(BoundPatternSwitchLabel node, object arg)
        {
            return new TreeDumperNode("patternSwitchLabel", null, new TreeDumperNode[]
            {
                new TreeDumperNode("label", node.Label, null),
                new TreeDumperNode("pattern", null, new TreeDumperNode[] { Visit(node.Pattern, null) }),
                new TreeDumperNode("guard", null, new TreeDumperNode[] { Visit(node.Guard, null) }),
                new TreeDumperNode("isReachable", node.IsReachable, null)
            }
            );
        }
        public override TreeDumperNode VisitIfStatement(BoundIfStatement node, object arg)
        {
            return new TreeDumperNode("ifStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("condition", null, new TreeDumperNode[] { Visit(node.Condition, null) }),
                new TreeDumperNode("consequence", null, new TreeDumperNode[] { Visit(node.Consequence, null) }),
                new TreeDumperNode("alternativeOpt", null, new TreeDumperNode[] { Visit(node.AlternativeOpt, null) })
            }
            );
        }
        public override TreeDumperNode VisitDoStatement(BoundDoStatement node, object arg)
        {
            return new TreeDumperNode("doStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("locals", node.Locals, null),
                new TreeDumperNode("condition", null, new TreeDumperNode[] { Visit(node.Condition, null) }),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) }),
                new TreeDumperNode("breakLabel", node.BreakLabel, null),
                new TreeDumperNode("continueLabel", node.ContinueLabel, null)
            }
            );
        }
        public override TreeDumperNode VisitWhileStatement(BoundWhileStatement node, object arg)
        {
            return new TreeDumperNode("whileStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("locals", node.Locals, null),
                new TreeDumperNode("condition", null, new TreeDumperNode[] { Visit(node.Condition, null) }),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) }),
                new TreeDumperNode("breakLabel", node.BreakLabel, null),
                new TreeDumperNode("continueLabel", node.ContinueLabel, null)
            }
            );
        }
        public override TreeDumperNode VisitForStatement(BoundForStatement node, object arg)
        {
            return new TreeDumperNode("forStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("outerLocals", node.OuterLocals, null),
                new TreeDumperNode("initializer", null, new TreeDumperNode[] { Visit(node.Initializer, null) }),
                new TreeDumperNode("innerLocals", node.InnerLocals, null),
                new TreeDumperNode("condition", null, new TreeDumperNode[] { Visit(node.Condition, null) }),
                new TreeDumperNode("increment", null, new TreeDumperNode[] { Visit(node.Increment, null) }),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) }),
                new TreeDumperNode("breakLabel", node.BreakLabel, null),
                new TreeDumperNode("continueLabel", node.ContinueLabel, null)
            }
            );
        }
        public override TreeDumperNode VisitForEachStatement(BoundForEachStatement node, object arg)
        {
            return new TreeDumperNode("forEachStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("enumeratorInfoOpt", node.EnumeratorInfoOpt, null),
                new TreeDumperNode("elementConversion", node.ElementConversion, null),
                new TreeDumperNode("iterationVariableType", null, new TreeDumperNode[] { Visit(node.IterationVariableType, null) }),
                new TreeDumperNode("iterationVariables", node.IterationVariables, null),
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("deconstructionOpt", null, new TreeDumperNode[] { Visit(node.DeconstructionOpt, null) }),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) }),
                new TreeDumperNode("@checked", node.Checked, null),
                new TreeDumperNode("breakLabel", node.BreakLabel, null),
                new TreeDumperNode("continueLabel", node.ContinueLabel, null)
            }
            );
        }
        public override TreeDumperNode VisitForEachDeconstructStep(BoundForEachDeconstructStep node, object arg)
        {
            return new TreeDumperNode("forEachDeconstructStep", null, new TreeDumperNode[]
            {
                new TreeDumperNode("deconstructionAssignment", null, new TreeDumperNode[] { Visit(node.DeconstructionAssignment, null) }),
                new TreeDumperNode("targetPlaceholder", null, new TreeDumperNode[] { Visit(node.TargetPlaceholder, null) })
            }
            );
        }
        public override TreeDumperNode VisitUsingStatement(BoundUsingStatement node, object arg)
        {
            return new TreeDumperNode("usingStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("locals", node.Locals, null),
                new TreeDumperNode("declarationsOpt", null, new TreeDumperNode[] { Visit(node.DeclarationsOpt, null) }),
                new TreeDumperNode("expressionOpt", null, new TreeDumperNode[] { Visit(node.ExpressionOpt, null) }),
                new TreeDumperNode("iDisposableConversion", node.IDisposableConversion, null),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) })
            }
            );
        }
        public override TreeDumperNode VisitFixedStatement(BoundFixedStatement node, object arg)
        {
            return new TreeDumperNode("fixedStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("locals", node.Locals, null),
                new TreeDumperNode("declarations", null, new TreeDumperNode[] { Visit(node.Declarations, null) }),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) })
            }
            );
        }
        public override TreeDumperNode VisitLockStatement(BoundLockStatement node, object arg)
        {
            return new TreeDumperNode("lockStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("argument", null, new TreeDumperNode[] { Visit(node.Argument, null) }),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) })
            }
            );
        }
        public override TreeDumperNode VisitTryStatement(BoundTryStatement node, object arg)
        {
            return new TreeDumperNode("tryStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("tryBlock", null, new TreeDumperNode[] { Visit(node.TryBlock, null) }),
                new TreeDumperNode("catchBlocks", null, from x in node.CatchBlocks select Visit(x, null)),
                new TreeDumperNode("finallyBlockOpt", null, new TreeDumperNode[] { Visit(node.FinallyBlockOpt, null) }),
                new TreeDumperNode("preferFaultHandler", node.PreferFaultHandler, null)
            }
            );
        }
        public override TreeDumperNode VisitCatchBlock(BoundCatchBlock node, object arg)
        {
            return new TreeDumperNode("catchBlock", null, new TreeDumperNode[]
            {
                new TreeDumperNode("locals", node.Locals, null),
                new TreeDumperNode("exceptionSourceOpt", null, new TreeDumperNode[] { Visit(node.ExceptionSourceOpt, null) }),
                new TreeDumperNode("exceptionTypeOpt", node.ExceptionTypeOpt, null),
                new TreeDumperNode("exceptionFilterOpt", null, new TreeDumperNode[] { Visit(node.ExceptionFilterOpt, null) }),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) }),
                new TreeDumperNode("isSynthesizedAsyncCatchAll", node.IsSynthesizedAsyncCatchAll, null)
            }
            );
        }
        public override TreeDumperNode VisitLiteral(BoundLiteral node, object arg)
        {
            return new TreeDumperNode("literal", null, new TreeDumperNode[]
            {
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitThisReference(BoundThisReference node, object arg)
        {
            return new TreeDumperNode("thisReference", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitPreviousSubmissionReference(BoundPreviousSubmissionReference node, object arg)
        {
            return new TreeDumperNode("previousSubmissionReference", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitHostObjectMemberReference(BoundHostObjectMemberReference node, object arg)
        {
            return new TreeDumperNode("hostObjectMemberReference", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitBaseReference(BoundBaseReference node, object arg)
        {
            return new TreeDumperNode("baseReference", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitLocal(BoundLocal node, object arg)
        {
            return new TreeDumperNode("local", null, new TreeDumperNode[]
            {
                new TreeDumperNode("localSymbol", node.LocalSymbol, null),
                new TreeDumperNode("isDeclaration", node.IsDeclaration, null),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitPseudoVariable(BoundPseudoVariable node, object arg)
        {
            return new TreeDumperNode("pseudoVariable", null, new TreeDumperNode[]
            {
                new TreeDumperNode("localSymbol", node.LocalSymbol, null),
                new TreeDumperNode("emitExpressions", node.EmitExpressions, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitRangeVariable(BoundRangeVariable node, object arg)
        {
            return new TreeDumperNode("rangeVariable", null, new TreeDumperNode[]
            {
                new TreeDumperNode("rangeVariableSymbol", node.RangeVariableSymbol, null),
                new TreeDumperNode("value", null, new TreeDumperNode[] { Visit(node.Value, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitParameter(BoundParameter node, object arg)
        {
            return new TreeDumperNode("parameter", null, new TreeDumperNode[]
            {
                new TreeDumperNode("parameterSymbol", node.ParameterSymbol, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitLabelStatement(BoundLabelStatement node, object arg)
        {
            return new TreeDumperNode("labelStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("label", node.Label, null)
            }
            );
        }
        public override TreeDumperNode VisitGotoStatement(BoundGotoStatement node, object arg)
        {
            return new TreeDumperNode("gotoStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("label", node.Label, null),
                new TreeDumperNode("caseExpressionOpt", null, new TreeDumperNode[] { Visit(node.CaseExpressionOpt, null) }),
                new TreeDumperNode("labelExpressionOpt", null, new TreeDumperNode[] { Visit(node.LabelExpressionOpt, null) })
            }
            );
        }
        public override TreeDumperNode VisitLabeledStatement(BoundLabeledStatement node, object arg)
        {
            return new TreeDumperNode("labeledStatement", null, new TreeDumperNode[]
            {
                new TreeDumperNode("label", node.Label, null),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) })
            }
            );
        }
        public override TreeDumperNode VisitLabel(BoundLabel node, object arg)
        {
            return new TreeDumperNode("label", null, new TreeDumperNode[]
            {
                new TreeDumperNode("label", node.Label, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitStatementList(BoundStatementList node, object arg)
        {
            return new TreeDumperNode("statementList", null, new TreeDumperNode[]
            {
                new TreeDumperNode("statements", null, from x in node.Statements select Visit(x, null))
            }
            );
        }
        public override TreeDumperNode VisitConditionalGoto(BoundConditionalGoto node, object arg)
        {
            return new TreeDumperNode("conditionalGoto", null, new TreeDumperNode[]
            {
                new TreeDumperNode("condition", null, new TreeDumperNode[] { Visit(node.Condition, null) }),
                new TreeDumperNode("jumpIfTrue", node.JumpIfTrue, null),
                new TreeDumperNode("label", node.Label, null)
            }
            );
        }
        public override TreeDumperNode VisitDynamicMemberAccess(BoundDynamicMemberAccess node, object arg)
        {
            return new TreeDumperNode("dynamicMemberAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("receiver", null, new TreeDumperNode[] { Visit(node.Receiver, null) }),
                new TreeDumperNode("typeArgumentsOpt", node.TypeArgumentsOpt, null),
                new TreeDumperNode("name", node.Name, null),
                new TreeDumperNode("invoked", node.Invoked, null),
                new TreeDumperNode("indexed", node.Indexed, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDynamicInvocation(BoundDynamicInvocation node, object arg)
        {
            return new TreeDumperNode("dynamicInvocation", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, null),
                new TreeDumperNode("argumentRefKindsOpt", node.ArgumentRefKindsOpt, null),
                new TreeDumperNode("applicableMethods", node.ApplicableMethods, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitConditionalAccess(BoundConditionalAccess node, object arg)
        {
            return new TreeDumperNode("conditionalAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("receiver", null, new TreeDumperNode[] { Visit(node.Receiver, null) }),
                new TreeDumperNode("accessExpression", null, new TreeDumperNode[] { Visit(node.AccessExpression, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitLoweredConditionalAccess(BoundLoweredConditionalAccess node, object arg)
        {
            return new TreeDumperNode("loweredConditionalAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("receiver", null, new TreeDumperNode[] { Visit(node.Receiver, null) }),
                new TreeDumperNode("hasValueMethodOpt", node.HasValueMethodOpt, null),
                new TreeDumperNode("whenNotNull", null, new TreeDumperNode[] { Visit(node.WhenNotNull, null) }),
                new TreeDumperNode("whenNullOpt", null, new TreeDumperNode[] { Visit(node.WhenNullOpt, null) }),
                new TreeDumperNode("id", node.Id, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitConditionalReceiver(BoundConditionalReceiver node, object arg)
        {
            return new TreeDumperNode("conditionalReceiver", null, new TreeDumperNode[]
            {
                new TreeDumperNode("id", node.Id, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitComplexConditionalReceiver(BoundComplexConditionalReceiver node, object arg)
        {
            return new TreeDumperNode("complexConditionalReceiver", null, new TreeDumperNode[]
            {
                new TreeDumperNode("valueTypeReceiver", null, new TreeDumperNode[] { Visit(node.ValueTypeReceiver, null) }),
                new TreeDumperNode("referenceTypeReceiver", null, new TreeDumperNode[] { Visit(node.ReferenceTypeReceiver, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitMethodGroup(BoundMethodGroup node, object arg)
        {
            return new TreeDumperNode("methodGroup", null, new TreeDumperNode[]
            {
                new TreeDumperNode("typeArgumentsOpt", node.TypeArgumentsOpt, null),
                new TreeDumperNode("name", node.Name, null),
                new TreeDumperNode("methods", node.Methods, null),
                new TreeDumperNode("lookupSymbolOpt", node.LookupSymbolOpt, null),
                new TreeDumperNode("lookupError", node.LookupError, null),
                new TreeDumperNode("flags", node.Flags, null),
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitPropertyGroup(BoundPropertyGroup node, object arg)
        {
            return new TreeDumperNode("propertyGroup", null, new TreeDumperNode[]
            {
                new TreeDumperNode("properties", node.Properties, null),
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitCall(BoundCall node, object arg)
        {
            return new TreeDumperNode("call", null, new TreeDumperNode[]
            {
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("method", node.Method, null),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, null),
                new TreeDumperNode("argumentRefKindsOpt", node.ArgumentRefKindsOpt, null),
                new TreeDumperNode("isDelegateCall", node.IsDelegateCall, null),
                new TreeDumperNode("expanded", node.Expanded, null),
                new TreeDumperNode("invokedAsExtensionMethod", node.InvokedAsExtensionMethod, null),
                new TreeDumperNode("argsToParamsOpt", node.ArgsToParamsOpt, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("binderOpt", node.BinderOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitEventAssignmentOperator(BoundEventAssignmentOperator node, object arg)
        {
            return new TreeDumperNode("eventAssignmentOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("@event", node.Event, null),
                new TreeDumperNode("isAddition", node.IsAddition, null),
                new TreeDumperNode("isDynamic", node.IsDynamic, null),
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("argument", null, new TreeDumperNode[] { Visit(node.Argument, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitAttribute(BoundAttribute node, object arg)
        {
            return new TreeDumperNode("attribute", null, new TreeDumperNode[]
            {
                new TreeDumperNode("constructor", node.Constructor, null),
                new TreeDumperNode("constructorArguments", null, from x in node.ConstructorArguments select Visit(x, null)),
                new TreeDumperNode("constructorArgumentNamesOpt", node.ConstructorArgumentNamesOpt, null),
                new TreeDumperNode("namedArguments", null, from x in node.NamedArguments select Visit(x, null)),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitObjectCreationExpression(BoundObjectCreationExpression node, object arg)
        {
            return new TreeDumperNode("objectCreationExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("constructor", node.Constructor, null),
                new TreeDumperNode("constructorsGroup", node.ConstructorsGroup, null),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, null),
                new TreeDumperNode("argumentRefKindsOpt", node.ArgumentRefKindsOpt, null),
                new TreeDumperNode("expanded", node.Expanded, null),
                new TreeDumperNode("argsToParamsOpt", node.ArgsToParamsOpt, null),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("initializerExpressionOpt", null, new TreeDumperNode[] { Visit(node.InitializerExpressionOpt, null) }),
                new TreeDumperNode("binderOpt", node.BinderOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitTupleLiteral(BoundTupleLiteral node, object arg)
        {
            return new TreeDumperNode("tupleLiteral", null, new TreeDumperNode[]
            {
                new TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, null),
                new TreeDumperNode("inferredNamesOpt", node.InferredNamesOpt, null),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitConvertedTupleLiteral(BoundConvertedTupleLiteral node, object arg)
        {
            return new TreeDumperNode("convertedTupleLiteral", null, new TreeDumperNode[]
            {
                new TreeDumperNode("naturalTypeOpt", node.NaturalTypeOpt, null),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDynamicObjectCreationExpression(BoundDynamicObjectCreationExpression node, object arg)
        {
            return new TreeDumperNode("dynamicObjectCreationExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("name", node.Name, null),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, null),
                new TreeDumperNode("argumentRefKindsOpt", node.ArgumentRefKindsOpt, null),
                new TreeDumperNode("initializerExpressionOpt", null, new TreeDumperNode[] { Visit(node.InitializerExpressionOpt, null) }),
                new TreeDumperNode("applicableMethods", node.ApplicableMethods, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitNoPiaObjectCreationExpression(BoundNoPiaObjectCreationExpression node, object arg)
        {
            return new TreeDumperNode("noPiaObjectCreationExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("guidString", node.GuidString, null),
                new TreeDumperNode("initializerExpressionOpt", null, new TreeDumperNode[] { Visit(node.InitializerExpressionOpt, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitObjectInitializerExpression(BoundObjectInitializerExpression node, object arg)
        {
            return new TreeDumperNode("objectInitializerExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("initializers", null, from x in node.Initializers select Visit(x, null)),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitObjectInitializerMember(BoundObjectInitializerMember node, object arg)
        {
            return new TreeDumperNode("objectInitializerMember", null, new TreeDumperNode[]
            {
                new TreeDumperNode("memberSymbol", node.MemberSymbol, null),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, null),
                new TreeDumperNode("argumentRefKindsOpt", node.ArgumentRefKindsOpt, null),
                new TreeDumperNode("expanded", node.Expanded, null),
                new TreeDumperNode("argsToParamsOpt", node.ArgsToParamsOpt, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("receiverType", node.ReceiverType, null),
                new TreeDumperNode("binderOpt", node.BinderOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDynamicObjectInitializerMember(BoundDynamicObjectInitializerMember node, object arg)
        {
            return new TreeDumperNode("dynamicObjectInitializerMember", null, new TreeDumperNode[]
            {
                new TreeDumperNode("memberName", node.MemberName, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitCollectionInitializerExpression(BoundCollectionInitializerExpression node, object arg)
        {
            return new TreeDumperNode("collectionInitializerExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("initializers", null, from x in node.Initializers select Visit(x, null)),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitCollectionElementInitializer(BoundCollectionElementInitializer node, object arg)
        {
            return new TreeDumperNode("collectionElementInitializer", null, new TreeDumperNode[]
            {
                new TreeDumperNode("addMethod", node.AddMethod, null),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("expanded", node.Expanded, null),
                new TreeDumperNode("argsToParamsOpt", node.ArgsToParamsOpt, null),
                new TreeDumperNode("invokedAsExtensionMethod", node.InvokedAsExtensionMethod, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDynamicCollectionElementInitializer(BoundDynamicCollectionElementInitializer node, object arg)
        {
            return new TreeDumperNode("dynamicCollectionElementInitializer", null, new TreeDumperNode[]
            {
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("applicableMethods", node.ApplicableMethods, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitImplicitReceiver(BoundImplicitReceiver node, object arg)
        {
            return new TreeDumperNode("implicitReceiver", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitAnonymousObjectCreationExpression(BoundAnonymousObjectCreationExpression node, object arg)
        {
            return new TreeDumperNode("anonymousObjectCreationExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("constructor", node.Constructor, null),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("declarations", null, from x in node.Declarations select Visit(x, null)),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitAnonymousPropertyDeclaration(BoundAnonymousPropertyDeclaration node, object arg)
        {
            return new TreeDumperNode("anonymousPropertyDeclaration", null, new TreeDumperNode[]
            {
                new TreeDumperNode("property", node.Property, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitNewT(BoundNewT node, object arg)
        {
            return new TreeDumperNode("newT", null, new TreeDumperNode[]
            {
                new TreeDumperNode("initializerExpressionOpt", null, new TreeDumperNode[] { Visit(node.InitializerExpressionOpt, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDelegateCreationExpression(BoundDelegateCreationExpression node, object arg)
        {
            return new TreeDumperNode("delegateCreationExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("argument", null, new TreeDumperNode[] { Visit(node.Argument, null) }),
                new TreeDumperNode("methodOpt", node.MethodOpt, null),
                new TreeDumperNode("isExtensionMethod", node.IsExtensionMethod, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitArrayCreation(BoundArrayCreation node, object arg)
        {
            return new TreeDumperNode("arrayCreation", null, new TreeDumperNode[]
            {
                new TreeDumperNode("bounds", null, from x in node.Bounds select Visit(x, null)),
                new TreeDumperNode("initializerOpt", null, new TreeDumperNode[] { Visit(node.InitializerOpt, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitArrayInitialization(BoundArrayInitialization node, object arg)
        {
            return new TreeDumperNode("arrayInitialization", null, new TreeDumperNode[]
            {
                new TreeDumperNode("initializers", null, from x in node.Initializers select Visit(x, null)),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitStackAllocArrayCreation(BoundStackAllocArrayCreation node, object arg)
        {
            return new TreeDumperNode("stackAllocArrayCreation", null, new TreeDumperNode[]
            {
                new TreeDumperNode("elementType", node.ElementType, null),
                new TreeDumperNode("count", null, new TreeDumperNode[] { Visit(node.Count, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitConvertedStackAllocExpression(BoundConvertedStackAllocExpression node, object arg)
        {
            return new TreeDumperNode("convertedStackAllocExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("elementType", node.ElementType, null),
                new TreeDumperNode("count", null, new TreeDumperNode[] { Visit(node.Count, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitFieldAccess(BoundFieldAccess node, object arg)
        {
            return new TreeDumperNode("fieldAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("fieldSymbol", node.FieldSymbol, null),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("isByValue", node.IsByValue, null),
                new TreeDumperNode("isDeclaration", node.IsDeclaration, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitHoistedFieldAccess(BoundHoistedFieldAccess node, object arg)
        {
            return new TreeDumperNode("hoistedFieldAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("fieldSymbol", node.FieldSymbol, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitPropertyAccess(BoundPropertyAccess node, object arg)
        {
            return new TreeDumperNode("propertyAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("propertySymbol", node.PropertySymbol, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitEventAccess(BoundEventAccess node, object arg)
        {
            return new TreeDumperNode("eventAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("eventSymbol", node.EventSymbol, null),
                new TreeDumperNode("isUsableAsField", node.IsUsableAsField, null),
                new TreeDumperNode("resultKind", node.ResultKind, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitIndexerAccess(BoundIndexerAccess node, object arg)
        {
            return new TreeDumperNode("indexerAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("indexer", node.Indexer, null),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, null),
                new TreeDumperNode("argumentRefKindsOpt", node.ArgumentRefKindsOpt, null),
                new TreeDumperNode("expanded", node.Expanded, null),
                new TreeDumperNode("argsToParamsOpt", node.ArgsToParamsOpt, null),
                new TreeDumperNode("binderOpt", node.BinderOpt, null),
                new TreeDumperNode("useSetterForDefaultArgumentGeneration", node.UseSetterForDefaultArgumentGeneration, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDynamicIndexerAccess(BoundDynamicIndexerAccess node, object arg)
        {
            return new TreeDumperNode("dynamicIndexerAccess", null, new TreeDumperNode[]
            {
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("arguments", null, from x in node.Arguments select Visit(x, null)),
                new TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, null),
                new TreeDumperNode("argumentRefKindsOpt", node.ArgumentRefKindsOpt, null),
                new TreeDumperNode("applicableIndexers", node.ApplicableIndexers, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitLambda(BoundLambda node, object arg)
        {
            return new TreeDumperNode("lambda", null, new TreeDumperNode[]
            {
                new TreeDumperNode("symbol", node.Symbol, null),
                new TreeDumperNode("body", null, new TreeDumperNode[] { Visit(node.Body, null) }),
                new TreeDumperNode("diagnostics", node.Diagnostics, null),
                new TreeDumperNode("binder", node.Binder, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitUnboundLambda(UnboundLambda node, object arg)
        {
            return new TreeDumperNode("unboundLambda", null, new TreeDumperNode[]
            {
                new TreeDumperNode("data", node.Data, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitQueryClause(BoundQueryClause node, object arg)
        {
            return new TreeDumperNode("queryClause", null, new TreeDumperNode[]
            {
                new TreeDumperNode("value", null, new TreeDumperNode[] { Visit(node.Value, null) }),
                new TreeDumperNode("definedSymbol", node.DefinedSymbol, null),
                new TreeDumperNode("binder", node.Binder, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitTypeOrInstanceInitializers(BoundTypeOrInstanceInitializers node, object arg)
        {
            return new TreeDumperNode("typeOrInstanceInitializers", null, new TreeDumperNode[]
            {
                new TreeDumperNode("statements", null, from x in node.Statements select Visit(x, null))
            }
            );
        }
        public override TreeDumperNode VisitNameOfOperator(BoundNameOfOperator node, object arg)
        {
            return new TreeDumperNode("nameOfOperator", null, new TreeDumperNode[]
            {
                new TreeDumperNode("argument", null, new TreeDumperNode[] { Visit(node.Argument, null) }),
                new TreeDumperNode("constantValueOpt", node.ConstantValueOpt, null),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitInterpolatedString(BoundInterpolatedString node, object arg)
        {
            return new TreeDumperNode("interpolatedString", null, new TreeDumperNode[]
            {
                new TreeDumperNode("parts", null, from x in node.Parts select Visit(x, null)),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitStringInsert(BoundStringInsert node, object arg)
        {
            return new TreeDumperNode("stringInsert", null, new TreeDumperNode[]
            {
                new TreeDumperNode("value", null, new TreeDumperNode[] { Visit(node.Value, null) }),
                new TreeDumperNode("alignment", null, new TreeDumperNode[] { Visit(node.Alignment, null) }),
                new TreeDumperNode("format", null, new TreeDumperNode[] { Visit(node.Format, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitIsPatternExpression(BoundIsPatternExpression node, object arg)
        {
            return new TreeDumperNode("isPatternExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("pattern", null, new TreeDumperNode[] { Visit(node.Pattern, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDeclarationPattern(BoundDeclarationPattern node, object arg)
        {
            return new TreeDumperNode("declarationPattern", null, new TreeDumperNode[]
            {
                new TreeDumperNode("variable", node.Variable, null),
                new TreeDumperNode("variableAccess", null, new TreeDumperNode[] { Visit(node.VariableAccess, null) }),
                new TreeDumperNode("declaredType", null, new TreeDumperNode[] { Visit(node.DeclaredType, null) }),
                new TreeDumperNode("isVar", node.IsVar, null)
            }
            );
        }
        public override TreeDumperNode VisitConstantPattern(BoundConstantPattern node, object arg)
        {
            return new TreeDumperNode("constantPattern", null, new TreeDumperNode[]
            {
                new TreeDumperNode("value", null, new TreeDumperNode[] { Visit(node.Value, null) }),
                new TreeDumperNode("constantValue", node.ConstantValue, null)
            }
            );
        }
        public override TreeDumperNode VisitWildcardPattern(BoundWildcardPattern node, object arg)
        {
            return new TreeDumperNode("wildcardPattern", null, Array.Empty<TreeDumperNode>()
            );
        }
        public override TreeDumperNode VisitDiscardExpression(BoundDiscardExpression node, object arg)
        {
            return new TreeDumperNode("discardExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitThrowExpression(BoundThrowExpression node, object arg)
        {
            return new TreeDumperNode("throwExpression", null, new TreeDumperNode[]
            {
                new TreeDumperNode("expression", null, new TreeDumperNode[] { Visit(node.Expression, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitOutVariablePendingInference(OutVariablePendingInference node, object arg)
        {
            return new TreeDumperNode("outVariablePendingInference", null, new TreeDumperNode[]
            {
                new TreeDumperNode("variableSymbol", node.VariableSymbol, null),
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitDeconstructionVariablePendingInference(DeconstructionVariablePendingInference node, object arg)
        {
            return new TreeDumperNode("deconstructionVariablePendingInference", null, new TreeDumperNode[]
            {
                new TreeDumperNode("variableSymbol", node.VariableSymbol, null),
                new TreeDumperNode("receiverOpt", null, new TreeDumperNode[] { Visit(node.ReceiverOpt, null) }),
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
        public override TreeDumperNode VisitOutDeconstructVarPendingInference(OutDeconstructVarPendingInference node, object arg)
        {
            return new TreeDumperNode("outDeconstructVarPendingInference", null, new TreeDumperNode[]
            {
                new TreeDumperNode("type", node.Type, null)
            }
            );
        }
    }
}
