// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using Xunit;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;

namespace System.SpanTests
{
    public static partial class SpanTests
    {
        [Fact]
        public static void DangerousCreate1()
        {
            TestClass testClass = new TestClass();
            testClass.C0 = 'a';
            testClass.C1 = 'b';
            testClass.C2 = 'c';
            testClass.C3 = 'd';
            testClass.C4 = 'e';
            Span<char> span = Span<char>.DangerousCreate(testClass, ref testClass.C1, 3);
            span.Validate<char>('b', 'c', 'd');

            ref char pc1 = ref span.DangerousGetPinnableReference();
            Assert.True(Unsafe.AreSame<char>(ref testClass.C1, ref pc1));
        }
    }
}
