// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

/*++



Module Name:

    locale/unicode_data.c

Abstract:

    Data definitions.



--*/

#include "pal/unicode_data.h"

#if !HAVE_COREFOUNDATION

CONST UnicodeDataRec UnicodeData[] = {


{ 0x0000,	0x0020,	0x0000,	0 },
{ 0x0001,	0x0020,	0x0000,	0 },
{ 0x0002,	0x0020,	0x0000,	0 },
{ 0x0003,	0x0020,	0x0000,	0 },
{ 0x0004,	0x0020,	0x0000,	0 },
{ 0x0005,	0x0020,	0x0000,	0 },
{ 0x0006,	0x0020,	0x0000,	0 },
{ 0x0007,	0x0020,	0x0000,	0 },
{ 0x0008,	0x0020,	0x0000,	0 },
{ 0x0009,	0x0068,	0x0000,	0 },
{ 0x000a,	0x0028,	0x0000,	0 },
{ 0x000b,	0x0028,	0x0000,	0 },
{ 0x000c,	0x0028,	0x0000,	0 },
{ 0x000d,	0x0028,	0x0000,	0 },
{ 0x000e,	0x0020,	0x0000,	0 },
{ 0x000f,	0x0020,	0x0000,	0 },
{ 0x0010,	0x0020,	0x0000,	0 },
{ 0x0011,	0x0020,	0x0000,	0 },
{ 0x0012,	0x0020,	0x0000,	0 },
{ 0x0013,	0x0020,	0x0000,	0 },
{ 0x0014,	0x0020,	0x0000,	0 },
{ 0x0015,	0x0020,	0x0000,	0 },
{ 0x0016,	0x0020,	0x0000,	0 },
{ 0x0017,	0x0020,	0x0000,	0 },
{ 0x0018,	0x0020,	0x0000,	0 },
{ 0x0019,	0x0020,	0x0000,	0 },
{ 0x001a,	0x0020,	0x0000,	0 },
{ 0x001b,	0x0020,	0x0000,	0 },
{ 0x001c,	0x0020,	0x0000,	0 },
{ 0x001d,	0x0020,	0x0000,	0 },
{ 0x001e,	0x0020,	0x0000,	0 },
{ 0x001f,	0x0020,	0x0000,	0 },
{ 0x0020,	0x0048,	0x0000,	0 },
{ 0x0021,	0x0010,	0x0000,	0 },
{ 0x0022,	0x0010,	0x0000,	0 },
{ 0x0023,	0x0010,	0x0000,	0 },
{ 0x0024,	0x0010,	0x0000,	0 },
{ 0x0025,	0x0010,	0x0000,	0 },
{ 0x0026,	0x0010,	0x0000,	0 },
{ 0x0027,	0x0010,	0x0000,	0 },
{ 0x0028,	0x0010,	0x0000,	0 },
{ 0x0029,	0x0010,	0x0000,	0 },
{ 0x002a,	0x0010,	0x0000,	0 },
{ 0x002b,	0x0010,	0x0000,	0 },
{ 0x002c,	0x0010,	0x0000,	0 },
{ 0x002d,	0x0010,	0x0000,	0 },
{ 0x002e,	0x0010,	0x0000,	0 },
{ 0x002f,	0x0010,	0x0000,	0 },
{ 0x0030,	0x0084,	0x0000,	0 },
{ 0x0031,	0x0084,	0x0000,	0 },
{ 0x0032,	0x0084,	0x0000,	0 },
{ 0x0033,	0x0084,	0x0000,	0 },
{ 0x0034,	0x0084,	0x0000,	0 },
{ 0x0035,	0x0084,	0x0000,	0 },
{ 0x0036,	0x0084,	0x0000,	0 },
{ 0x0037,	0x0084,	0x0000,	0 },
{ 0x0038,	0x0084,	0x0000,	0 },
{ 0x0039,	0x0084,	0x0000,	0 },
{ 0x003a,	0x0010,	0x0000,	0 },
{ 0x003b,	0x0010,	0x0000,	0 },
{ 0x003c,	0x0010,	0x0000,	0 },
{ 0x003d,	0x0010,	0x0000,	0 },
{ 0x003e,	0x0010,	0x0000,	0 },
{ 0x003f,	0x0010,	0x0000,	0 },
{ 0x0040,	0x0010,	0x0000,	0 },
{ 0x0041,	0x0181,	0x0061,	0 },
{ 0x0042,	0x0181,	0x0062,	0 },
{ 0x0043,	0x0181,	0x0063,	0 },
{ 0x0044,	0x0181,	0x0064,	0 },
{ 0x0045,	0x0181,	0x0065,	0 },
{ 0x0046,	0x0181,	0x0066,	0 },
{ 0x0047,	0x0101,	0x0067,	0 },
{ 0x0048,	0x0101,	0x0068,	0 },
{ 0x0049,	0x0101,	0x0069,	0 },
{ 0x004a,	0x0101,	0x006a,	0 },
{ 0x004b,	0x0101,	0x006b,	0 },
{ 0x004c,	0x0101,	0x006c,	0 },
{ 0x004d,	0x0101,	0x006d,	0 },
{ 0x004e,	0x0101,	0x006e,	0 },
{ 0x004f,	0x0101,	0x006f,	0 },
{ 0x0050,	0x0101,	0x0070,	0 },
{ 0x0051,	0x0101,	0x0071,	0 },
{ 0x0052,	0x0101,	0x0072,	0 },
{ 0x0053,	0x0101,	0x0073,	0 },
{ 0x0054,	0x0101,	0x0074,	0 },
{ 0x0055,	0x0101,	0x0075,	0 },
{ 0x0056,	0x0101,	0x0076,	0 },
{ 0x0057,	0x0101,	0x0077,	0 },
{ 0x0058,	0x0101,	0x0078,	0 },
{ 0x0059,	0x0101,	0x0079,	0 },
{ 0x005a,	0x0101,	0x007a,	0 },
{ 0x005b,	0x0010,	0x0000,	0 },
{ 0x005c,	0x0010,	0x0000,	0 },
{ 0x005d,	0x0010,	0x0000,	0 },
{ 0x005e,	0x0010,	0x0000,	0 },
{ 0x005f,	0x0010,	0x0000,	0 },
{ 0x0060,	0x0010,	0x0000,	0 },
{ 0x0061,	0x0182,	0x0041,	0 },
{ 0x0062,	0x0182,	0x0042,	0 },
{ 0x0063,	0x0182,	0x0043,	0 },
{ 0x0064,	0x0182,	0x0044,	0 },
{ 0x0065,	0x0182,	0x0045,	0 },
{ 0x0066,	0x0182,	0x0046,	0 },
{ 0x0067,	0x0102,	0x0047,	0 },
{ 0x0068,	0x0102,	0x0048,	0 },
{ 0x0069,	0x0102,	0x0049,	0 },
{ 0x006a,	0x0102,	0x004a,	0 },
{ 0x006b,	0x0102,	0x004b,	0 },
{ 0x006c,	0x0102,	0x004c,	0 },
{ 0x006d,	0x0102,	0x004d,	0 },
{ 0x006e,	0x0102,	0x004e,	0 },
{ 0x006f,	0x0102,	0x004f,	0 },
{ 0x0070,	0x0102,	0x0050,	0 },
{ 0x0071,	0x0102,	0x0051,	0 },
{ 0x0072,	0x0102,	0x0052,	0 },
{ 0x0073,	0x0102,	0x0053,	0 },
{ 0x0074,	0x0102,	0x0054,	0 },
{ 0x0075,	0x0102,	0x0055,	0 },
{ 0x0076,	0x0102,	0x0056,	0 },
{ 0x0077,	0x0102,	0x0057,	0 },
{ 0x0078,	0x0102,	0x0058,	0 },
{ 0x0079,	0x0102,	0x0059,	0 },
{ 0x007a,	0x0102,	0x005a,	0 },
{ 0x007b,	0x0010,	0x0000,	0 },
{ 0x007c,	0x0010,	0x0000,	0 },
{ 0x007d,	0x0010,	0x0000,	0 },
{ 0x007e,	0x0010,	0x0000,	0 },
{ 0x007f,	0x0020,	0x0000,	0 },
{ 0x0080,	0x0020,	0x0000,	0 },
{ 0x0081,	0x0020,	0x0000,	0 },
{ 0x0082,	0x0020,	0x0000,	0 },
{ 0x0083,	0x0020,	0x0000,	0 },
{ 0x0084,	0x0020,	0x0000,	0 },
{ 0x0085,	0x0020,	0x0000,	0 },
{ 0x0086,	0x0020,	0x0000,	0 },
{ 0x0087,	0x0020,	0x0000,	0 },
{ 0x0088,	0x0020,	0x0000,	0 },
{ 0x0089,	0x0020,	0x0000,	0 },
{ 0x008a,	0x0020,	0x0000,	0 },
{ 0x008b,	0x0020,	0x0000,	0 },
{ 0x008c,	0x0020,	0x0000,	0 },
{ 0x008d,	0x0020,	0x0000,	0 },
{ 0x008e,	0x0020,	0x0000,	0 },
{ 0x008f,	0x0020,	0x0000,	0 },
{ 0x0090,	0x0020,	0x0000,	0 },
{ 0x0091,	0x0020,	0x0000,	0 },
{ 0x0092,	0x0020,	0x0000,	0 },
{ 0x0093,	0x0020,	0x0000,	0 },
{ 0x0094,	0x0020,	0x0000,	0 },
{ 0x0095,	0x0020,	0x0000,	0 },
{ 0x0096,	0x0020,	0x0000,	0 },
{ 0x0097,	0x0020,	0x0000,	0 },
{ 0x0098,	0x0020,	0x0000,	0 },
{ 0x0099,	0x0020,	0x0000,	0 },
{ 0x009a,	0x0020,	0x0000,	0 },
{ 0x009b,	0x0020,	0x0000,	0 },
{ 0x009c,	0x0020,	0x0000,	0 },
{ 0x009d,	0x0020,	0x0000,	0 },
{ 0x009e,	0x0020,	0x0000,	0 },
{ 0x009f,	0x0020,	0x0000,	0 },
{ 0x00a0,	0x0048,	0x0000,	0 },
{ 0x00a1,	0x0010,	0x0000,	0 },
{ 0x00a2,	0x0010,	0x0000,	0 },
{ 0x00a3,	0x0010,	0x0000,	0 },
{ 0x00a4,	0x0010,	0x0000,	0 },
{ 0x00a5,	0x0010,	0x0000,	0 },
{ 0x00a6,	0x0010,	0x0000,	0 },
{ 0x00a7,	0x0010,	0x0000,	0 },
{ 0x00a8,	0x0010,	0x0000,	0 },
{ 0x00a9,	0x0010,	0x0000,	0 },
{ 0x00aa,	0x0010,	0x0000,	0 },
{ 0x00ab,	0x0010,	0x0000,	0 },
{ 0x00ac,	0x0010,	0x0000,	0 },
{ 0x00ad,	0x0010,	0x0000,	0 },
{ 0x00ae,	0x0010,	0x0000,	0 },
{ 0x00af,	0x0010,	0x0000,	0 },
{ 0x00b0,	0x0010,	0x0000,	0 },
{ 0x00b1,	0x0010,	0x0000,	0 },
{ 0x00b2,	0x0014,	0x0000,	0 },
{ 0x00b3,	0x0014,	0x0000,	0 },
{ 0x00b4,	0x0010,	0x0000,	0 },
{ 0x00b5,	0x0010,	0x0000,	0 },
{ 0x00b6,	0x0010,	0x0000,	0 },
{ 0x00b7,	0x0010,	0x0000,	0 },
{ 0x00b8,	0x0010,	0x0000,	0 },
{ 0x00b9,	0x0014,	0x0000,	0 },
{ 0x00ba,	0x0010,	0x0000,	0 },
{ 0x00bb,	0x0010,	0x0000,	0 },
{ 0x00bc,	0x0010,	0x0000,	0 },
{ 0x00bd,	0x0010,	0x0000,	0 },
{ 0x00be,	0x0010,	0x0000,	0 },
{ 0x00bf,	0x0010,	0x0000,	0 },
{ 0x00c0,	0x0101,	0x0000,	0 },
{ 0x00c1,	0x0101,	0x0000,	0 },
{ 0x00c2,	0x0101,	0x0000,	0 },
{ 0x00c3,	0x0101,	0x0000,	0 },
{ 0x00c4,	0x0101,	0x0000,	0 },
{ 0x00c5,	0x0101,	0x0000,	0 },
{ 0x00c6,	0x0101,	0x0000,	0 },
{ 0x00c7,	0x0101,	0x0000,	0 },
{ 0x00c8,	0x0101,	0x0000,	0 },
{ 0x00c9,	0x0101,	0x0000,	0 },
{ 0x00ca,	0x0101,	0x0000,	0 },
{ 0x00cb,	0x0101,	0x0000,	0 },
{ 0x00cc,	0x0101,	0x0000,	0 },
{ 0x00cd,	0x0101,	0x0000,	0 },
{ 0x00ce,	0x0101,	0x0000,	0 },
{ 0x00cf,	0x0101,	0x0000,	0 },
{ 0x00d0,	0x0101,	0x0000,	0 },
{ 0x00d1,	0x0101,	0x0000,	0 },
{ 0x00d2,	0x0101,	0x0000,	0 },
{ 0x00d3,	0x0101,	0x0000,	0 },
{ 0x00d4,	0x0101,	0x0000,	0 },
{ 0x00d5,	0x0101,	0x0000,	0 },
{ 0x00d6,	0x0101,	0x0000,	0 },
{ 0x00d7,	0x0010,	0x0000,	0 },
{ 0x00d8,	0x0101,	0x0000,	0 },
{ 0x00d9,	0x0101,	0x0000,	0 },
{ 0x00da,	0x0101,	0x0000,	0 },
{ 0x00db,	0x0101,	0x0000,	0 },
{ 0x00dc,	0x0101,	0x0000,	0 },
{ 0x00dd,	0x0101,	0x0000,	0 },
{ 0x00de,	0x0101,	0x0000,	0 },
{ 0x00df,	0x0102,	0x0000,	0 },
{ 0x00e0,	0x0102,	0x0000,	0 },
{ 0x00e1,	0x0102,	0x0000,	0 },
{ 0x00e2,	0x0102,	0x0000,	0 },
{ 0x00e3,	0x0102,	0x0000,	0 },
{ 0x00e4,	0x0102,	0x0000,	0 },
{ 0x00e5,	0x0102,	0x0000,	0 },
{ 0x00e6,	0x0102,	0x0000,	0 },
{ 0x00e7,	0x0102,	0x0000,	0 },
{ 0x00e8,	0x0102,	0x0000,	0 },
{ 0x00e9,	0x0102,	0x0000,	0 },
{ 0x00ea,	0x0102,	0x0000,	0 },
{ 0x00eb,	0x0102,	0x0000,	0 },
{ 0x00ec,	0x0102,	0x0000,	0 },
{ 0x00ed,	0x0102,	0x0000,	0 },
{ 0x00ee,	0x0102,	0x0000,	0 },
{ 0x00ef,	0x0102,	0x0000,	0 },
{ 0x00f0,	0x0102,	0x0000,	0 },
{ 0x00f1,	0x0102,	0x0000,	0 },
{ 0x00f2,	0x0102,	0x0000,	0 },
{ 0x00f3,	0x0102,	0x0000,	0 },
{ 0x00f4,	0x0102,	0x0000,	0 },
{ 0x00f5,	0x0102,	0x0000,	0 },
{ 0x00f6,	0x0102,	0x0000,	0 },
{ 0x00f7,	0x0010,	0x0000,	0 },
{ 0x00f8,	0x0102,	0x0000,	0 },
{ 0x00f9,	0x0102,	0x0000,	0 },
{ 0x00fa,	0x0102,	0x0000,	0 },
{ 0x00fb,	0x0102,	0x0000,	0 },
{ 0x00fc,	0x0102,	0x0000,	0 },
{ 0x00fd,	0x0102,	0x0000,	0 },
{ 0x00fe,	0x0102,	0x0000,	0 },
{ 0x00ff,	0x0102,	0x0000,	0 },
{ 0x0100,	0x0101,	0x0100,	0 },
{ 0x0101,	0x0102,	0x0101,	0 },
{ 0x0102,	0x0101,	0x0102,	0 },
{ 0x0103,	0x0102,	0x0103,	0 },
{ 0x0104,	0x0101,	0x0104,	0 },
{ 0x0105,	0x0102,	0x0105,	0 },
{ 0x0106,	0x0101,	0x0106,	0 },
{ 0x0107,	0x0102,	0x0107,	0 },
{ 0x0108,	0x0101,	0x0108,	0 },
{ 0x0109,	0x0102,	0x0109,	0 },
{ 0x010a,	0x0101,	0x010a,	0 },
{ 0x010b,	0x0102,	0x010b,	0 },
{ 0x010c,	0x0101,	0x010c,	0 },
{ 0x010d,	0x0102,	0x010d,	0 },
{ 0x010e,	0x0101,	0x010e,	0 },
{ 0x010f,	0x0102,	0x010f,	0 },
{ 0x0110,	0x0101,	0x0110,	0 },
{ 0x0111,	0x0102,	0x0111,	0 },
{ 0x0112,	0x0101,	0x0112,	0 },
{ 0x0113,	0x0102,	0x0113,	0 },
{ 0x0114,	0x0101,	0x0114,	0 },
{ 0x0115,	0x0102,	0x0115,	0 },
{ 0x0116,	0x0101,	0x0116,	0 },
{ 0x0117,	0x0102,	0x0117,	0 },
{ 0x0118,	0x0101,	0x0118,	0 },
{ 0x0119,	0x0102,	0x0119,	0 },
{ 0x011a,	0x0101,	0x011a,	0 },
{ 0x011b,	0x0102,	0x011b,	0 },
{ 0x011c,	0x0101,	0x011c,	0 },
{ 0x011d,	0x0102,	0x011d,	0 },
{ 0x011e,	0x0101,	0x011e,	0 },
{ 0x011f,	0x0102,	0x011f,	0 },
{ 0x0120,	0x0101,	0x0120,	0 },
{ 0x0121,	0x0102,	0x0121,	0 },
{ 0x0122,	0x0101,	0x0122,	0 },
{ 0x0123,	0x0102,	0x0123,	0 },
{ 0x0124,	0x0101,	0x0124,	0 },
{ 0x0125,	0x0102,	0x0125,	0 },
{ 0x0126,	0x0101,	0x0126,	0 },
{ 0x0127,	0x0102,	0x0127,	0 },
{ 0x0128,	0x0101,	0x0128,	0 },
{ 0x0129,	0x0102,	0x0129,	0 },
{ 0x012a,	0x0101,	0x012a,	0 },
{ 0x012b,	0x0102,	0x012b,	0 },
{ 0x012c,	0x0101,	0x012c,	0 },
{ 0x012d,	0x0102,	0x012d,	0 },
{ 0x012e,	0x0101,	0x012e,	0 },
{ 0x012f,	0x0102,	0x012f,	0 },
{ 0x0130,	0x0101,	0x0130,	0 },
{ 0x0131,	0x0102,	0x0131,	0 },
{ 0x0132,	0x0101,	0x0132,	0 },
{ 0x0133,	0x0102,	0x0133,	0 },
{ 0x0134,	0x0101,	0x0134,	0 },
{ 0x0135,	0x0102,	0x0135,	0 },
{ 0x0136,	0x0101,	0x0136,	0 },
{ 0x0137,	0x0102,	0x0137,	0 },
{ 0x0138,	0x0102,	0x0138,	0 },
{ 0x0139,	0x0101,	0x0139,	0 },
{ 0x013a,	0x0102,	0x013a,	0 },
{ 0x013b,	0x0101,	0x013b,	0 },
{ 0x013c,	0x0102,	0x013c,	0 },
{ 0x013d,	0x0101,	0x013d,	0 },
{ 0x013e,	0x0102,	0x013e,	0 },
{ 0x013f,	0x0101,	0x013f,	0 },
{ 0x0140,	0x0102,	0x0140,	0 },
{ 0x0141,	0x0101,	0x0141,	0 },
{ 0x0142,	0x0102,	0x0142,	0 },
{ 0x0143,	0x0101,	0x0143,	0 },
{ 0x0144,	0x0102,	0x0144,	0 },
{ 0x0145,	0x0101,	0x0145,	0 },
{ 0x0146,	0x0102,	0x0146,	0 },
{ 0x0147,	0x0101,	0x0147,	0 },
{ 0x0148,	0x0102,	0x0148,	0 },
{ 0x0149,	0x0102,	0x0149,	0 },
{ 0x014a,	0x0101,	0x014a,	0 },
{ 0x014b,	0x0102,	0x014b,	0 },
{ 0x014c,	0x0101,	0x014c,	0 },
{ 0x014d,	0x0102,	0x014d,	0 },
{ 0x014e,	0x0101,	0x014e,	0 },
{ 0x014f,	0x0102,	0x014f,	0 },
{ 0x0150,	0x0101,	0x0150,	0 },
{ 0x0151,	0x0102,	0x0151,	0 },
{ 0x0152,	0x0101,	0x0152,	0 },
{ 0x0153,	0x0102,	0x0153,	0 },
{ 0x0154,	0x0101,	0x0154,	0 },
{ 0x0155,	0x0102,	0x0155,	0 },
{ 0x0156,	0x0101,	0x0156,	0 },
{ 0x0157,	0x0102,	0x0157,	0 },
{ 0x0158,	0x0101,	0x0158,	0 },
{ 0x0159,	0x0102,	0x0159,	0 },
{ 0x015a,	0x0101,	0x015a,	0 },
{ 0x015b,	0x0102,	0x015b,	0 },
{ 0x015c,	0x0101,	0x015c,	0 },
{ 0x015d,	0x0102,	0x015d,	0 },
{ 0x015e,	0x0101,	0x015e,	0 },
{ 0x015f,	0x0102,	0x015f,	0 },
{ 0x0160,	0x0101,	0x0160,	0 },
{ 0x0161,	0x0102,	0x0161,	0 },
{ 0x0162,	0x0101,	0x0162,	0 },
{ 0x0163,	0x0102,	0x0163,	0 },
{ 0x0164,	0x0101,	0x0164,	0 },
{ 0x0165,	0x0102,	0x0165,	0 },
{ 0x0166,	0x0101,	0x0166,	0 },
{ 0x0167,	0x0102,	0x0167,	0 },
{ 0x0168,	0x0101,	0x0168,	0 },
{ 0x0169,	0x0102,	0x0169,	0 },
{ 0x016a,	0x0101,	0x016a,	0 },
{ 0x016b,	0x0102,	0x016b,	0 },
{ 0x016c,	0x0101,	0x016c,	0 },
{ 0x016d,	0x0102,	0x016d,	0 },
{ 0x016e,	0x0101,	0x016e,	0 },
{ 0x016f,	0x0102,	0x016f,	0 },
{ 0x0170,	0x0101,	0x0170,	0 },
{ 0x0171,	0x0102,	0x0171,	0 },
{ 0x0172,	0x0101,	0x0172,	0 },
{ 0x0173,	0x0102,	0x0173,	0 },
{ 0x0174,	0x0101,	0x0174,	0 },
{ 0x0175,	0x0102,	0x0175,	0 },
{ 0x0176,	0x0101,	0x0176,	0 },
{ 0x0177,	0x0102,	0x0177,	0 },
{ 0x0178,	0x0101,	0x0178,	0 },
{ 0x0179,	0x0101,	0x0179,	0 },
{ 0x017a,	0x0102,	0x017a,	0 },
{ 0x017b,	0x0101,	0x017b,	0 },
{ 0x017c,	0x0102,	0x017c,	0 },
{ 0x017d,	0x0101,	0x017d,	0 },
{ 0x017e,	0x0102,	0x017e,	0 },
{ 0x017f,	0x0102,	0x017f,	0 },
{ 0x0180,	0x0102,	0x0180,	0 },
{ 0x0181,	0x0101,	0x0181,	0 },
{ 0x0182,	0x0101,	0x0182,	0 },
{ 0x0183,	0x0102,	0x0183,	0 },
{ 0x0184,	0x0101,	0x0184,	0 },
{ 0x0185,	0x0102,	0x0185,	0 },
{ 0x0186,	0x0101,	0x0186,	0 },
{ 0x0187,	0x0101,	0x0187,	0 },
{ 0x0188,	0x0102,	0x0188,	0 },
{ 0x0189,	0x0101,	0x0189,	0 },
{ 0x018a,	0x0101,	0x018a,	0 },
{ 0x018b,	0x0101,	0x018b,	0 },
{ 0x018c,	0x0102,	0x018c,	0 },
{ 0x018d,	0x0102,	0x018d,	0 },
{ 0x018e,	0x0101,	0x018e,	0 },
{ 0x018f,	0x0101,	0x018f,	0 },
{ 0x0190,	0x0101,	0x0190,	0 },
{ 0x0191,	0x0101,	0x0191,	0 },
{ 0x0192,	0x0112,	0x0192,	0 },
{ 0x0193,	0x0101,	0x0193,	0 },
{ 0x0194,	0x0101,	0x0194,	0 },
{ 0x0195,	0x0102,	0x0195,	0 },
{ 0x0196,	0x0101,	0x0196,	0 },
{ 0x0197,	0x0101,	0x0197,	0 },
{ 0x0198,	0x0101,	0x0198,	0 },
{ 0x0199,	0x0102,	0x0199,	0 },
{ 0x019a,	0x0102,	0x019a,	0 },
{ 0x019b,	0x0102,	0x019b,	0 },
{ 0x019c,	0x0101,	0x019c,	0 },
{ 0x019d,	0x0101,	0x019d,	0 },
{ 0x019e,	0x0102,	0x019e,	0 },
{ 0x019f,	0x0101,	0x019f,	0 },
{ 0x01a0,	0x0101,	0x01a0,	0 },
{ 0x01a1,	0x0102,	0x01a1,	0 },
{ 0x01a2,	0x0101,	0x01a2,	0 },
{ 0x01a3,	0x0102,	0x01a3,	0 },
{ 0x01a4,	0x0101,	0x01a4,	0 },
{ 0x01a5,	0x0102,	0x01a5,	0 },
{ 0x01a6,	0x0100,	0x0000,	0 },
{ 0x01a7,	0x0101,	0x01a7,	0 },
{ 0x01a8,	0x0102,	0x01a8,	0 },
{ 0x01a9,	0x0101,	0x01a9,	0 },
{ 0x01aa,	0x0100,	0x0000,	0 },
{ 0x01ab,	0x0102,	0x01ab,	0 },
{ 0x01ac,	0x0101,	0x01ac,	0 },
{ 0x01ad,	0x0102,	0x01ad,	0 },
{ 0x01ae,	0x0101,	0x01ae,	0 },
{ 0x01af,	0x0101,	0x01af,	0 },
{ 0x01b0,	0x0102,	0x01b0,	0 },
{ 0x01b1,	0x0101,	0x01b1,	0 },
{ 0x01b2,	0x0101,	0x01b2,	0 },
{ 0x01b3,	0x0101,	0x01b3,	0 },
{ 0x01b4,	0x0102,	0x01b4,	0 },
{ 0x01b5,	0x0101,	0x01b5,	0 },
{ 0x01b6,	0x0102,	0x01b6,	0 },
{ 0x01b7,	0x0101,	0x01b7,	0 },
{ 0x01b8,	0x0101,	0x01b8,	0 },
{ 0x01b9,	0x0102,	0x01b9,	0 },
{ 0x01ba,	0x0102,	0x01ba,	0 },
{ 0x01bb,	0x0100,	0x0000,	0 },
{ 0x01bc,	0x0101,	0x01bc,	0 },
{ 0x01bd,	0x0102,	0x01bd,	0 },
{ 0x01be,	0x0100,	0x0000,	5 },
{ 0x01c4,	0x0101,	0x01c4,	0 },
{ 0x01c5,	0x0103,	0x01c5,	0 },
{ 0x01c6,	0x0102,	0x01c6,	0 },
{ 0x01c7,	0x0101,	0x01c7,	0 },
{ 0x01c8,	0x0103,	0x01c8,	0 },
{ 0x01c9,	0x0102,	0x01c9,	0 },
{ 0x01ca,	0x0101,	0x01ca,	0 },
{ 0x01cb,	0x0103,	0x01cb,	0 },
{ 0x01cc,	0x0102,	0x01cc,	0 },
{ 0x01cd,	0x0101,	0x01cd,	0 },
{ 0x01ce,	0x0102,	0x01ce,	0 },
{ 0x01cf,	0x0101,	0x01cf,	0 },
{ 0x01d0,	0x0102,	0x01d0,	0 },
{ 0x01d1,	0x0101,	0x01d1,	0 },
{ 0x01d2,	0x0102,	0x01d2,	0 },
{ 0x01d3,	0x0101,	0x01d3,	0 },
{ 0x01d4,	0x0102,	0x01d4,	0 },
{ 0x01d5,	0x0101,	0x01d5,	0 },
{ 0x01d6,	0x0102,	0x01d6,	0 },
{ 0x01d7,	0x0101,	0x01d7,	0 },
{ 0x01d8,	0x0102,	0x01d8,	0 },
{ 0x01d9,	0x0101,	0x01d9,	0 },
{ 0x01da,	0x0102,	0x01da,	0 },
{ 0x01db,	0x0101,	0x01db,	0 },
{ 0x01dc,	0x0102,	0x01dc,	0 },
{ 0x01dd,	0x0102,	0x01dd,	0 },
{ 0x01de,	0x0101,	0x01de,	0 },
{ 0x01df,	0x0102,	0x01df,	0 },
{ 0x01e0,	0x0101,	0x01e0,	0 },
{ 0x01e1,	0x0102,	0x01e1,	0 },
{ 0x01e2,	0x0101,	0x01e2,	0 },
{ 0x01e3,	0x0102,	0x01e3,	0 },
{ 0x01e4,	0x0101,	0x01e4,	0 },
{ 0x01e5,	0x0102,	0x01e5,	0 },
{ 0x01e6,	0x0101,	0x01e6,	0 },
{ 0x01e7,	0x0102,	0x01e7,	0 },
{ 0x01e8,	0x0101,	0x01e8,	0 },
{ 0x01e9,	0x0102,	0x01e9,	0 },
{ 0x01ea,	0x0101,	0x01ea,	0 },
{ 0x01eb,	0x0102,	0x01eb,	0 },
{ 0x01ec,	0x0101,	0x01ec,	0 },
{ 0x01ed,	0x0102,	0x01ed,	0 },
{ 0x01ee,	0x0101,	0x01ee,	0 },
{ 0x01ef,	0x0102,	0x01ef,	0 },
{ 0x01f0,	0x0102,	0x01f0,	0 },
{ 0x01f1,	0x0101,	0x01f1,	0 },
{ 0x01f2,	0x0103,	0x01f2,	0 },
{ 0x01f3,	0x0102,	0x01f3,	0 },
{ 0x01f4,	0x0101,	0x01f4,	0 },
{ 0x01f5,	0x0102,	0x01f5,	0 },
{ 0x01fa,	0x0101,	0x01fa,	0 },
{ 0x01fb,	0x0102,	0x01fb,	0 },
{ 0x01fc,	0x0101,	0x01fc,	0 },
{ 0x01fd,	0x0102,	0x01fd,	0 },
{ 0x01fe,	0x0101,	0x01fe,	0 },
{ 0x01ff,	0x0102,	0x01ff,	0 },
{ 0x0200,	0x0101,	0x0200,	0 },
{ 0x0201,	0x0102,	0x0201,	0 },
{ 0x0202,	0x0101,	0x0202,	0 },
{ 0x0203,	0x0102,	0x0203,	0 },
{ 0x0204,	0x0101,	0x0204,	0 },
{ 0x0205,	0x0102,	0x0205,	0 },
{ 0x0206,	0x0101,	0x0206,	0 },
{ 0x0207,	0x0102,	0x0207,	0 },
{ 0x0208,	0x0101,	0x0208,	0 },
{ 0x0209,	0x0102,	0x0209,	0 },
{ 0x020a,	0x0101,	0x020a,	0 },
{ 0x020b,	0x0102,	0x020b,	0 },
{ 0x020c,	0x0101,	0x020c,	0 },
{ 0x020d,	0x0102,	0x020d,	0 },
{ 0x020e,	0x0101,	0x020e,	0 },
{ 0x020f,	0x0102,	0x020f,	0 },
{ 0x0210,	0x0101,	0x0210,	0 },
{ 0x0211,	0x0102,	0x0211,	0 },
{ 0x0212,	0x0101,	0x0212,	0 },
{ 0x0213,	0x0102,	0x0213,	0 },
{ 0x0214,	0x0101,	0x0214,	0 },
{ 0x0215,	0x0102,	0x0215,	0 },
{ 0x0216,	0x0101,	0x0216,	0 },
{ 0x0217,	0x0102,	0x0217,	0 },
{ 0x0250,	0x0102,	0x0250,	0 },
{ 0x0251,	0x0102,	0x0251,	0 },
{ 0x0252,	0x0102,	0x0252,	0 },
{ 0x0253,	0x0102,	0x0253,	0 },
{ 0x0254,	0x0102,	0x0254,	0 },
{ 0x0255,	0x0102,	0x0255,	0 },
{ 0x0256,	0x0102,	0x0256,	0 },
{ 0x0257,	0x0102,	0x0257,	0 },
{ 0x0258,	0x0102,	0x0258,	0 },
{ 0x0259,	0x0102,	0x0259,	0 },
{ 0x025a,	0x0102,	0x025a,	0 },
{ 0x025b,	0x0102,	0x025b,	0 },
{ 0x025c,	0x0102,	0x025c,	0 },
{ 0x025d,	0x0102,	0x025d,	0 },
{ 0x025e,	0x0102,	0x025e,	0 },
{ 0x025f,	0x0102,	0x025f,	0 },
{ 0x0260,	0x0102,	0x0260,	0 },
{ 0x0261,	0x0102,	0x0261,	0 },
{ 0x0262,	0x0100,	0x0000,	0 },
{ 0x0263,	0x0102,	0x0263,	0 },
{ 0x0264,	0x0102,	0x0264,	0 },
{ 0x0265,	0x0102,	0x0265,	0 },
{ 0x0266,	0x0102,	0x0266,	0 },
{ 0x0267,	0x0102,	0x0267,	0 },
{ 0x0268,	0x0102,	0x0268,	0 },
{ 0x0269,	0x0102,	0x0269,	0 },
{ 0x026a,	0x0100,	0x0000,	0 },
{ 0x026b,	0x0102,	0x026b,	0 },
{ 0x026c,	0x0102,	0x026c,	0 },
{ 0x026d,	0x0102,	0x026d,	0 },
{ 0x026e,	0x0102,	0x026e,	0 },
{ 0x026f,	0x0102,	0x026f,	0 },
{ 0x0270,	0x0102,	0x0270,	0 },
{ 0x0271,	0x0102,	0x0271,	0 },
{ 0x0272,	0x0102,	0x0272,	0 },
{ 0x0273,	0x0102,	0x0273,	0 },
{ 0x0274,	0x0100,	0x0000,	0 },
{ 0x0275,	0x0102,	0x0275,	0 },
{ 0x0276,	0x0100,	0x0000,	0 },
{ 0x0277,	0x0102,	0x0277,	0 },
{ 0x0278,	0x0102,	0x0278,	0 },
{ 0x0279,	0x0102,	0x0279,	0 },
{ 0x027a,	0x0102,	0x027a,	0 },
{ 0x027b,	0x0102,	0x027b,	0 },
{ 0x027c,	0x0102,	0x027c,	0 },
{ 0x027d,	0x0102,	0x027d,	0 },
{ 0x027e,	0x0102,	0x027e,	0 },
{ 0x027f,	0x0102,	0x027f,	0 },
{ 0x0280,	0x0100,	0x0000,	1 },
{ 0x0282,	0x0102,	0x0282,	0 },
{ 0x0283,	0x0102,	0x0283,	0 },
{ 0x0284,	0x0102,	0x0284,	0 },
{ 0x0285,	0x0102,	0x0285,	0 },
{ 0x0286,	0x0102,	0x0286,	0 },
{ 0x0287,	0x0102,	0x0287,	0 },
{ 0x0288,	0x0102,	0x0288,	0 },
{ 0x0289,	0x0102,	0x0289,	0 },
{ 0x028a,	0x0102,	0x028a,	0 },
{ 0x028b,	0x0102,	0x028b,	0 },
{ 0x028c,	0x0102,	0x028c,	0 },
{ 0x028d,	0x0102,	0x028d,	0 },
{ 0x028e,	0x0102,	0x028e,	0 },
{ 0x028f,	0x0100,	0x0000,	0 },
{ 0x0290,	0x0102,	0x0290,	0 },
{ 0x0291,	0x0102,	0x0291,	0 },
{ 0x0292,	0x0102,	0x0292,	0 },
{ 0x0293,	0x0102,	0x0293,	0 },
{ 0x0294,	0x0100,	0x0000,	5 },
{ 0x029a,	0x0102,	0x029a,	0 },
{ 0x029b,	0x0100,	0x0000,	1 },
{ 0x029d,	0x0102,	0x029d,	0 },
{ 0x029e,	0x0102,	0x029e,	0 },
{ 0x029f,	0x0100,	0x0000,	0 },
{ 0x02a0,	0x0102,	0x02a0,	0 },
{ 0x02a1,	0x0100,	0x0000,	1 },
{ 0x02a3,	0x0102,	0x02a3,	0 },
{ 0x02a4,	0x0102,	0x02a4,	0 },
{ 0x02a5,	0x0102,	0x02a5,	0 },
{ 0x02a6,	0x0102,	0x02a6,	0 },
{ 0x02a7,	0x0102,	0x02a7,	0 },
{ 0x02a8,	0x0102,	0x02a8,	0 },
{ 0x02b0,	0x0010,	0x0000,	134 },
{ 0x0386,	0x0101,	0x0386,	0 },
{ 0x0387,	0x0010,	0x0000,	0 },
{ 0x0388,	0x0101,	0x0388,	0 },
{ 0x0389,	0x0101,	0x0389,	0 },
{ 0x038a,	0x0101,	0x038a,	0 },
{ 0x038c,	0x0101,	0x038c,	0 },
{ 0x038e,	0x0101,	0x038e,	0 },
{ 0x038f,	0x0101,	0x038f,	0 },
{ 0x0390,	0x0102,	0x0390,	0 },
{ 0x0391,	0x0101,	0x0391,	0 },
{ 0x0392,	0x0101,	0x0392,	0 },
{ 0x0393,	0x0101,	0x0393,	0 },
{ 0x0394,	0x0101,	0x0394,	0 },
{ 0x0395,	0x0101,	0x0395,	0 },
{ 0x0396,	0x0101,	0x0396,	0 },
{ 0x0397,	0x0101,	0x0397,	0 },
{ 0x0398,	0x0101,	0x0398,	0 },
{ 0x0399,	0x0101,	0x0399,	0 },
{ 0x039a,	0x0101,	0x039a,	0 },
{ 0x039b,	0x0101,	0x039b,	0 },
{ 0x039c,	0x0101,	0x039c,	0 },
{ 0x039d,	0x0101,	0x039d,	0 },
{ 0x039e,	0x0101,	0x039e,	0 },
{ 0x039f,	0x0101,	0x039f,	0 },
{ 0x03a0,	0x0101,	0x03a0,	0 },
{ 0x03a1,	0x0101,	0x03a1,	0 },
{ 0x03a3,	0x0101,	0x03a3,	0 },
{ 0x03a4,	0x0101,	0x03a4,	0 },
{ 0x03a5,	0x0101,	0x03a5,	0 },
{ 0x03a6,	0x0101,	0x03a6,	0 },
{ 0x03a7,	0x0101,	0x03a7,	0 },
{ 0x03a8,	0x0101,	0x03a8,	0 },
{ 0x03a9,	0x0101,	0x03a9,	0 },
{ 0x03aa,	0x0101,	0x03aa,	0 },
{ 0x03ab,	0x0101,	0x03ab,	0 },
{ 0x03ac,	0x0102,	0x03ac,	0 },
{ 0x03ad,	0x0102,	0x03ad,	0 },
{ 0x03ae,	0x0102,	0x03ae,	0 },
{ 0x03af,	0x0102,	0x03af,	0 },
{ 0x03b0,	0x0102,	0x03b0,	0 },
{ 0x03b1,	0x0102,	0x03b1,	0 },
{ 0x03b2,	0x0102,	0x03b2,	0 },
{ 0x03b3,	0x0102,	0x03b3,	0 },
{ 0x03b4,	0x0102,	0x03b4,	0 },
{ 0x03b5,	0x0102,	0x03b5,	0 },
{ 0x03b6,	0x0102,	0x03b6,	0 },
{ 0x03b7,	0x0102,	0x03b7,	0 },
{ 0x03b8,	0x0102,	0x03b8,	0 },
{ 0x03b9,	0x0102,	0x03b9,	0 },
{ 0x03ba,	0x0102,	0x03ba,	0 },
{ 0x03bb,	0x0102,	0x03bb,	0 },
{ 0x03bc,	0x0102,	0x03bc,	0 },
{ 0x03bd,	0x0102,	0x03bd,	0 },
{ 0x03be,	0x0102,	0x03be,	0 },
{ 0x03bf,	0x0102,	0x03bf,	0 },
{ 0x03c0,	0x0102,	0x03c0,	0 },
{ 0x03c1,	0x0102,	0x03c1,	0 },
{ 0x03c2,	0x0102,	0x03c2,	0 },
{ 0x03c3,	0x0102,	0x03c3,	0 },
{ 0x03c4,	0x0102,	0x03c4,	0 },
{ 0x03c5,	0x0102,	0x03c5,	0 },
{ 0x03c6,	0x0102,	0x03c6,	0 },
{ 0x03c7,	0x0102,	0x03c7,	0 },
{ 0x03c8,	0x0102,	0x03c8,	0 },
{ 0x03c9,	0x0102,	0x03c9,	0 },
{ 0x03ca,	0x0102,	0x03ca,	0 },
{ 0x03cb,	0x0102,	0x03cb,	0 },
{ 0x03cc,	0x0102,	0x03cc,	0 },
{ 0x03cd,	0x0102,	0x03cd,	0 },
{ 0x03ce,	0x0102,	0x03ce,	0 },
{ 0x03d0,	0x0102,	0x03d0,	0 },
{ 0x03d1,	0x0102,	0x03d1,	0 },
{ 0x03d2,	0x0101,	0x03d2,	0 },
{ 0x03d3,	0x0101,	0x03d3,	0 },
{ 0x03d4,	0x0101,	0x03d4,	0 },
{ 0x03d5,	0x0102,	0x03d5,	0 },
{ 0x03d6,	0x0102,	0x03d6,	0 },
{ 0x03da,	0x0101,	0x03da,	0 },
{ 0x03dc,	0x0101,	0x03dc,	0 },
{ 0x03de,	0x0101,	0x03de,	0 },
{ 0x03e0,	0x0101,	0x03e0,	0 },
{ 0x03e2,	0x0101,	0x03e2,	0 },
{ 0x03e3,	0x0102,	0x03e3,	0 },
{ 0x03e4,	0x0101,	0x03e4,	0 },
{ 0x03e5,	0x0102,	0x03e5,	0 },
{ 0x03e6,	0x0101,	0x03e6,	0 },
{ 0x03e7,	0x0102,	0x03e7,	0 },
{ 0x03e8,	0x0101,	0x03e8,	0 },
{ 0x03e9,	0x0102,	0x03e9,	0 },
{ 0x03ea,	0x0101,	0x03ea,	0 },
{ 0x03eb,	0x0102,	0x03eb,	0 },
{ 0x03ec,	0x0101,	0x03ec,	0 },
{ 0x03ed,	0x0102,	0x03ed,	0 },
{ 0x03ee,	0x0101,	0x03ee,	0 },
{ 0x03ef,	0x0102,	0x03ef,	0 },
{ 0x03f0,	0x0102,	0x03f0,	0 },
{ 0x03f1,	0x0102,	0x03f1,	0 },
{ 0x03f2,	0x0102,	0x03f2,	0 },
{ 0x03f3,	0x0102,	0x03f3,	0 },
{ 0x0401,	0x0101,	0x0401,	0 },
{ 0x0402,	0x0101,	0x0402,	0 },
{ 0x0403,	0x0101,	0x0403,	0 },
{ 0x0404,	0x0101,	0x0404,	0 },
{ 0x0405,	0x0101,	0x0405,	0 },
{ 0x0406,	0x0101,	0x0406,	0 },
{ 0x0407,	0x0101,	0x0407,	0 },
{ 0x0408,	0x0101,	0x0408,	0 },
{ 0x0409,	0x0101,	0x0409,	0 },
{ 0x040a,	0x0101,	0x040a,	0 },
{ 0x040b,	0x0101,	0x040b,	0 },
{ 0x040c,	0x0101,	0x040c,	0 },
{ 0x040e,	0x0101,	0x040e,	0 },
{ 0x040f,	0x0101,	0x040f,	0 },
{ 0x0410,	0x0101,	0x0410,	0 },
{ 0x0411,	0x0101,	0x0411,	0 },
{ 0x0412,	0x0101,	0x0412,	0 },
{ 0x0413,	0x0101,	0x0413,	0 },
{ 0x0414,	0x0101,	0x0414,	0 },
{ 0x0415,	0x0101,	0x0415,	0 },
{ 0x0416,	0x0101,	0x0416,	0 },
{ 0x0417,	0x0101,	0x0417,	0 },
{ 0x0418,	0x0101,	0x0418,	0 },
{ 0x0419,	0x0101,	0x0419,	0 },
{ 0x041a,	0x0101,	0x041a,	0 },
{ 0x041b,	0x0101,	0x041b,	0 },
{ 0x041c,	0x0101,	0x041c,	0 },
{ 0x041d,	0x0101,	0x041d,	0 },
{ 0x041e,	0x0101,	0x041e,	0 },
{ 0x041f,	0x0101,	0x041f,	0 },
{ 0x0420,	0x0101,	0x0420,	0 },
{ 0x0421,	0x0101,	0x0421,	0 },
{ 0x0422,	0x0101,	0x0422,	0 },
{ 0x0423,	0x0101,	0x0423,	0 },
{ 0x0424,	0x0101,	0x0424,	0 },
{ 0x0425,	0x0101,	0x0425,	0 },
{ 0x0426,	0x0101,	0x0426,	0 },
{ 0x0427,	0x0101,	0x0427,	0 },
{ 0x0428,	0x0101,	0x0428,	0 },
{ 0x0429,	0x0101,	0x0429,	0 },
{ 0x042a,	0x0101,	0x042a,	0 },
{ 0x042b,	0x0101,	0x042b,	0 },
{ 0x042c,	0x0101,	0x042c,	0 },
{ 0x042d,	0x0101,	0x042d,	0 },
{ 0x042e,	0x0101,	0x042e,	0 },
{ 0x042f,	0x0101,	0x042f,	0 },
{ 0x0430,	0x0102,	0x0430,	0 },
{ 0x0431,	0x0102,	0x0431,	0 },
{ 0x0432,	0x0102,	0x0432,	0 },
{ 0x0433,	0x0102,	0x0433,	0 },
{ 0x0434,	0x0102,	0x0434,	0 },
{ 0x0435,	0x0102,	0x0435,	0 },
{ 0x0436,	0x0102,	0x0436,	0 },
{ 0x0437,	0x0102,	0x0437,	0 },
{ 0x0438,	0x0102,	0x0438,	0 },
{ 0x0439,	0x0102,	0x0439,	0 },
{ 0x043a,	0x0102,	0x043a,	0 },
{ 0x043b,	0x0102,	0x043b,	0 },
{ 0x043c,	0x0102,	0x043c,	0 },
{ 0x043d,	0x0102,	0x043d,	0 },
{ 0x043e,	0x0102,	0x043e,	0 },
{ 0x043f,	0x0102,	0x043f,	0 },
{ 0x0440,	0x0102,	0x0440,	0 },
{ 0x0441,	0x0102,	0x0441,	0 },
{ 0x0442,	0x0102,	0x0442,	0 },
{ 0x0443,	0x0102,	0x0443,	0 },
{ 0x0444,	0x0102,	0x0444,	0 },
{ 0x0445,	0x0102,	0x0445,	0 },
{ 0x0446,	0x0102,	0x0446,	0 },
{ 0x0447,	0x0102,	0x0447,	0 },
{ 0x0448,	0x0102,	0x0448,	0 },
{ 0x0449,	0x0102,	0x0449,	0 },
{ 0x044a,	0x0102,	0x044a,	0 },
{ 0x044b,	0x0102,	0x044b,	0 },
{ 0x044c,	0x0102,	0x044c,	0 },
{ 0x044d,	0x0102,	0x044d,	0 },
{ 0x044e,	0x0102,	0x044e,	0 },
{ 0x044f,	0x0102,	0x044f,	0 },
{ 0x0451,	0x0102,	0x0451,	0 },
{ 0x0452,	0x0102,	0x0452,	0 },
{ 0x0453,	0x0102,	0x0453,	0 },
{ 0x0454,	0x0102,	0x0454,	0 },
{ 0x0455,	0x0102,	0x0455,	0 },
{ 0x0456,	0x0102,	0x0456,	0 },
{ 0x0457,	0x0102,	0x0457,	0 },
{ 0x0458,	0x0102,	0x0458,	0 },
{ 0x0459,	0x0102,	0x0459,	0 },
{ 0x045a,	0x0102,	0x045a,	0 },
{ 0x045b,	0x0102,	0x045b,	0 },
{ 0x045c,	0x0102,	0x045c,	0 },
{ 0x045e,	0x0102,	0x045e,	0 },
{ 0x045f,	0x0102,	0x045f,	0 },
{ 0x0460,	0x0101,	0x0460,	0 },
{ 0x0461,	0x0102,	0x0461,	0 },
{ 0x0462,	0x0101,	0x0462,	0 },
{ 0x0463,	0x0102,	0x0463,	0 },
{ 0x0464,	0x0101,	0x0464,	0 },
{ 0x0465,	0x0102,	0x0465,	0 },
{ 0x0466,	0x0101,	0x0466,	0 },
{ 0x0467,	0x0102,	0x0467,	0 },
{ 0x0468,	0x0101,	0x0468,	0 },
{ 0x0469,	0x0102,	0x0469,	0 },
{ 0x046a,	0x0101,	0x046a,	0 },
{ 0x046b,	0x0102,	0x046b,	0 },
{ 0x046c,	0x0101,	0x046c,	0 },
{ 0x046d,	0x0102,	0x046d,	0 },
{ 0x046e,	0x0101,	0x046e,	0 },
{ 0x046f,	0x0102,	0x046f,	0 },
{ 0x0470,	0x0101,	0x0470,	0 },
{ 0x0471,	0x0102,	0x0471,	0 },
{ 0x0472,	0x0101,	0x0472,	0 },
{ 0x0473,	0x0102,	0x0473,	0 },
{ 0x0474,	0x0101,	0x0474,	0 },
{ 0x0475,	0x0102,	0x0475,	0 },
{ 0x0476,	0x0101,	0x0476,	0 },
{ 0x0477,	0x0102,	0x0477,	0 },
{ 0x0478,	0x0101,	0x0478,	0 },
{ 0x0479,	0x0102,	0x0479,	0 },
{ 0x047a,	0x0101,	0x047a,	0 },
{ 0x047b,	0x0102,	0x047b,	0 },
{ 0x047c,	0x0101,	0x047c,	0 },
{ 0x047d,	0x0102,	0x047d,	0 },
{ 0x047e,	0x0101,	0x047e,	0 },
{ 0x047f,	0x0102,	0x047f,	0 },
{ 0x0480,	0x0101,	0x0480,	0 },
{ 0x0481,	0x0102,	0x0481,	0 },
{ 0x0482,	0x0010,	0x0000,	4 },
{ 0x0490,	0x0101,	0x0490,	0 },
{ 0x0491,	0x0102,	0x0491,	0 },
{ 0x0492,	0x0101,	0x0492,	0 },
{ 0x0493,	0x0102,	0x0493,	0 },
{ 0x0494,	0x0101,	0x0494,	0 },
{ 0x0495,	0x0102,	0x0495,	0 },
{ 0x0496,	0x0101,	0x0496,	0 },
{ 0x0497,	0x0102,	0x0497,	0 },
{ 0x0498,	0x0101,	0x0498,	0 },
{ 0x0499,	0x0102,	0x0499,	0 },
{ 0x049a,	0x0101,	0x049a,	0 },
{ 0x049b,	0x0102,	0x049b,	0 },
{ 0x049c,	0x0101,	0x049c,	0 },
{ 0x049d,	0x0102,	0x049d,	0 },
{ 0x049e,	0x0101,	0x049e,	0 },
{ 0x049f,	0x0102,	0x049f,	0 },
{ 0x04a0,	0x0101,	0x04a0,	0 },
{ 0x04a1,	0x0102,	0x04a1,	0 },
{ 0x04a2,	0x0101,	0x04a2,	0 },
{ 0x04a3,	0x0102,	0x04a3,	0 },
{ 0x04a4,	0x0101,	0x04a4,	0 },
{ 0x04a5,	0x0102,	0x04a5,	0 },
{ 0x04a6,	0x0101,	0x04a6,	0 },
{ 0x04a7,	0x0102,	0x04a7,	0 },
{ 0x04a8,	0x0101,	0x04a8,	0 },
{ 0x04a9,	0x0102,	0x04a9,	0 },
{ 0x04aa,	0x0101,	0x04aa,	0 },
{ 0x04ab,	0x0102,	0x04ab,	0 },
{ 0x04ac,	0x0101,	0x04ac,	0 },
{ 0x04ad,	0x0102,	0x04ad,	0 },
{ 0x04ae,	0x0101,	0x04ae,	0 },
{ 0x04af,	0x0102,	0x04af,	0 },
{ 0x04b0,	0x0101,	0x04b0,	0 },
{ 0x04b1,	0x0102,	0x04b1,	0 },
{ 0x04b2,	0x0101,	0x04b2,	0 },
{ 0x04b3,	0x0102,	0x04b3,	0 },
{ 0x04b4,	0x0101,	0x04b4,	0 },
{ 0x04b5,	0x0102,	0x04b5,	0 },
{ 0x04b6,	0x0101,	0x04b6,	0 },
{ 0x04b7,	0x0102,	0x04b7,	0 },
{ 0x04b8,	0x0101,	0x04b8,	0 },
{ 0x04b9,	0x0102,	0x04b9,	0 },
{ 0x04ba,	0x0101,	0x04ba,	0 },
{ 0x04bb,	0x0102,	0x04bb,	0 },
{ 0x04bc,	0x0101,	0x04bc,	0 },
{ 0x04bd,	0x0102,	0x04bd,	0 },
{ 0x04be,	0x0101,	0x04be,	0 },
{ 0x04bf,	0x0102,	0x04bf,	0 },
{ 0x04c0,	0x0100,	0x0000,	0 },
{ 0x04c1,	0x0101,	0x04c1,	0 },
{ 0x04c2,	0x0102,	0x04c2,	0 },
{ 0x04c3,	0x0101,	0x04c3,	0 },
{ 0x04c4,	0x0102,	0x04c4,	0 },
{ 0x04c7,	0x0101,	0x04c7,	0 },
{ 0x04c8,	0x0102,	0x04c8,	0 },
{ 0x04cb,	0x0101,	0x04cb,	0 },
{ 0x04cc,	0x0102,	0x04cc,	0 },
{ 0x04d0,	0x0101,	0x04d0,	0 },
{ 0x04d1,	0x0102,	0x04d1,	0 },
{ 0x04d2,	0x0101,	0x04d2,	0 },
{ 0x04d3,	0x0102,	0x04d3,	0 },
{ 0x04d4,	0x0101,	0x04d4,	0 },
{ 0x04d5,	0x0102,	0x04d5,	0 },
{ 0x04d6,	0x0101,	0x04d6,	0 },
{ 0x04d7,	0x0102,	0x04d7,	0 },
{ 0x04d8,	0x0101,	0x04d8,	0 },
{ 0x04d9,	0x0102,	0x04d9,	0 },
{ 0x04da,	0x0101,	0x04da,	0 },
{ 0x04db,	0x0102,	0x04db,	0 },
{ 0x04dc,	0x0101,	0x04dc,	0 },
{ 0x04dd,	0x0102,	0x04dd,	0 },
{ 0x04de,	0x0101,	0x04de,	0 },
{ 0x04df,	0x0102,	0x04df,	0 },
{ 0x04e0,	0x0101,	0x04e0,	0 },
{ 0x04e1,	0x0102,	0x04e1,	0 },
{ 0x04e2,	0x0101,	0x04e2,	0 },
{ 0x04e3,	0x0102,	0x04e3,	0 },
{ 0x04e4,	0x0101,	0x04e4,	0 },
{ 0x04e5,	0x0102,	0x04e5,	0 },
{ 0x04e6,	0x0101,	0x04e6,	0 },
{ 0x04e7,	0x0102,	0x04e7,	0 },
{ 0x04e8,	0x0101,	0x04e8,	0 },
{ 0x04e9,	0x0102,	0x04e9,	0 },
{ 0x04ea,	0x0101,	0x04ea,	0 },
{ 0x04eb,	0x0102,	0x04eb,	0 },
{ 0x04ee,	0x0101,	0x04ee,	0 },
{ 0x04ef,	0x0102,	0x04ef,	0 },
{ 0x04f0,	0x0101,	0x04f0,	0 },
{ 0x04f1,	0x0102,	0x04f1,	0 },
{ 0x04f2,	0x0101,	0x04f2,	0 },
{ 0x04f3,	0x0102,	0x04f3,	0 },
{ 0x04f4,	0x0101,	0x04f4,	0 },
{ 0x04f5,	0x0102,	0x04f5,	0 },
{ 0x04f8,	0x0101,	0x04f8,	0 },
{ 0x04f9,	0x0102,	0x04f9,	0 },
{ 0x0531,	0x0101,	0x0531,	0 },
{ 0x0532,	0x0101,	0x0532,	0 },
{ 0x0533,	0x0101,	0x0533,	0 },
{ 0x0534,	0x0101,	0x0534,	0 },
{ 0x0535,	0x0101,	0x0535,	0 },
{ 0x0536,	0x0101,	0x0536,	0 },
{ 0x0537,	0x0101,	0x0537,	0 },
{ 0x0538,	0x0101,	0x0538,	0 },
{ 0x0539,	0x0101,	0x0539,	0 },
{ 0x053a,	0x0101,	0x053a,	0 },
{ 0x053b,	0x0101,	0x053b,	0 },
{ 0x053c,	0x0101,	0x053c,	0 },
{ 0x053d,	0x0101,	0x053d,	0 },
{ 0x053e,	0x0101,	0x053e,	0 },
{ 0x053f,	0x0101,	0x053f,	0 },
{ 0x0540,	0x0101,	0x0540,	0 },
{ 0x0541,	0x0101,	0x0541,	0 },
{ 0x0542,	0x0101,	0x0542,	0 },
{ 0x0543,	0x0101,	0x0543,	0 },
{ 0x0544,	0x0101,	0x0544,	0 },
{ 0x0545,	0x0101,	0x0545,	0 },
{ 0x0546,	0x0101,	0x0546,	0 },
{ 0x0547,	0x0101,	0x0547,	0 },
{ 0x0548,	0x0101,	0x0548,	0 },
{ 0x0549,	0x0101,	0x0549,	0 },
{ 0x054a,	0x0101,	0x054a,	0 },
{ 0x054b,	0x0101,	0x054b,	0 },
{ 0x054c,	0x0101,	0x054c,	0 },
{ 0x054d,	0x0101,	0x054d,	0 },
{ 0x054e,	0x0101,	0x054e,	0 },
{ 0x054f,	0x0101,	0x054f,	0 },
{ 0x0550,	0x0101,	0x0550,	0 },
{ 0x0551,	0x0101,	0x0551,	0 },
{ 0x0552,	0x0101,	0x0552,	0 },
{ 0x0553,	0x0101,	0x0553,	0 },
{ 0x0554,	0x0101,	0x0554,	0 },
{ 0x0555,	0x0101,	0x0555,	0 },
{ 0x0556,	0x0101,	0x0556,	0 },
{ 0x0559,	0x0010,	0x0000,	6 },
{ 0x0561,	0x0102,	0x0561,	0 },
{ 0x0562,	0x0102,	0x0562,	0 },
{ 0x0563,	0x0102,	0x0563,	0 },
{ 0x0564,	0x0102,	0x0564,	0 },
{ 0x0565,	0x0102,	0x0565,	0 },
{ 0x0566,	0x0102,	0x0566,	0 },
{ 0x0567,	0x0102,	0x0567,	0 },
{ 0x0568,	0x0102,	0x0568,	0 },
{ 0x0569,	0x0102,	0x0569,	0 },
{ 0x056a,	0x0102,	0x056a,	0 },
{ 0x056b,	0x0102,	0x056b,	0 },
{ 0x056c,	0x0102,	0x056c,	0 },
{ 0x056d,	0x0102,	0x056d,	0 },
{ 0x056e,	0x0102,	0x056e,	0 },
{ 0x056f,	0x0102,	0x056f,	0 },
{ 0x0570,	0x0102,	0x0570,	0 },
{ 0x0571,	0x0102,	0x0571,	0 },
{ 0x0572,	0x0102,	0x0572,	0 },
{ 0x0573,	0x0102,	0x0573,	0 },
{ 0x0574,	0x0102,	0x0574,	0 },
{ 0x0575,	0x0102,	0x0575,	0 },
{ 0x0576,	0x0102,	0x0576,	0 },
{ 0x0577,	0x0102,	0x0577,	0 },
{ 0x0578,	0x0102,	0x0578,	0 },
{ 0x0579,	0x0102,	0x0579,	0 },
{ 0x057a,	0x0102,	0x057a,	0 },
{ 0x057b,	0x0102,	0x057b,	0 },
{ 0x057c,	0x0102,	0x057c,	0 },
{ 0x057d,	0x0102,	0x057d,	0 },
{ 0x057e,	0x0102,	0x057e,	0 },
{ 0x057f,	0x0102,	0x057f,	0 },
{ 0x0580,	0x0102,	0x0580,	0 },
{ 0x0581,	0x0102,	0x0581,	0 },
{ 0x0582,	0x0102,	0x0582,	0 },
{ 0x0583,	0x0102,	0x0583,	0 },
{ 0x0584,	0x0102,	0x0584,	0 },
{ 0x0585,	0x0102,	0x0585,	0 },
{ 0x0586,	0x0102,	0x0586,	0 },
{ 0x0587,	0x0102,	0x0587,	0 },
{ 0x0589,	0x0010,	0x0000,	51 },
{ 0x05d0,	0x0100,	0x0000,	29 },
{ 0x05f3,	0x0010,	0x0000,	4 },
{ 0x0621,	0x0100,	0x0000,	25 },
{ 0x0640,	0x0010,	0x0000,	0 },
{ 0x0641,	0x0100,	0x0000,	9 },
{ 0x064b,	0x0010,	0x0000,	7 },
{ 0x0660,	0x0004,	0x0000,	9 },
{ 0x066a,	0x0010,	0x0000,	4 },
{ 0x0671,	0x0100,	0x0000,	94 },
{ 0x06d4,	0x0010,	0x0000,	0 },
{ 0x06d5,	0x0100,	0x0000,	0 },
{ 0x06d6,	0x0010,	0x0000,	23 },
{ 0x06f0,	0x0004,	0x0000,	9 },
{ 0x0901,	0x0010,	0x0000,	2 },
{ 0x0905,	0x0100,	0x0000,	52 },
{ 0x093c,	0x0010,	0x0000,	22 },
{ 0x0958,	0x0100,	0x0000,	9 },
{ 0x0962,	0x0010,	0x0000,	3 },
{ 0x0966,	0x0004,	0x0000,	9 },
{ 0x0970,	0x0010,	0x0000,	3 },
{ 0x0985,	0x0100,	0x0000,	43 },
{ 0x09bc,	0x0010,	0x0000,	13 },
{ 0x09dc,	0x0100,	0x0000,	4 },
{ 0x09e2,	0x0010,	0x0000,	1 },
{ 0x09e6,	0x0004,	0x0000,	9 },
{ 0x09f0,	0x0100,	0x0000,	1 },
{ 0x09f2,	0x0010,	0x0000,	9 },
{ 0x0a05,	0x0100,	0x0000,	42 },
{ 0x0a3c,	0x0010,	0x0000,	10 },
{ 0x0a59,	0x0100,	0x0000,	4 },
{ 0x0a66,	0x0004,	0x0000,	9 },
{ 0x0a70,	0x0010,	0x0000,	7 },
{ 0x0a85,	0x0100,	0x0000,	46 },
{ 0x0abc,	0x0010,	0x0000,	16 },
{ 0x0ae0,	0x0100,	0x0000,	0 },
{ 0x0ae6,	0x0004,	0x0000,	9 },
{ 0x0b01,	0x0010,	0x0000,	2 },
{ 0x0b05,	0x0100,	0x0000,	44 },
{ 0x0b3c,	0x0010,	0x0000,	14 },
{ 0x0b5c,	0x0100,	0x0000,	4 },
{ 0x0b66,	0x0004,	0x0000,	9 },
{ 0x0b70,	0x0010,	0x0000,	2 },
{ 0x0b85,	0x0100,	0x0000,	33 },
{ 0x0bbe,	0x0010,	0x0000,	12 },
{ 0x0be7,	0x0004,	0x0000,	11 },
{ 0x0c01,	0x0010,	0x0000,	2 },
{ 0x0c05,	0x0100,	0x0000,	48 },
{ 0x0c3e,	0x0010,	0x0000,	15 },
{ 0x0c60,	0x0100,	0x0000,	1 },
{ 0x0c66,	0x0004,	0x0000,	9 },
{ 0x0c82,	0x0010,	0x0000,	1 },
{ 0x0c85,	0x0100,	0x0000,	48 },
{ 0x0cbe,	0x0010,	0x0000,	15 },
{ 0x0cde,	0x0100,	0x0000,	2 },
{ 0x0ce6,	0x0004,	0x0000,	9 },
{ 0x0d02,	0x0010,	0x0000,	1 },
{ 0x0d05,	0x0100,	0x0000,	49 },
{ 0x0d3e,	0x0010,	0x0000,	13 },
{ 0x0d60,	0x0100,	0x0000,	1 },
{ 0x0d66,	0x0004,	0x0000,	9 },
{ 0x0e01,	0x0100,	0x0000,	57 },
{ 0x0e3f,	0x0010,	0x0000,	0 },
{ 0x0e40,	0x0100,	0x0000,	14 },
{ 0x0e4f,	0x0010,	0x0000,	0 },
{ 0x0e50,	0x0004,	0x0000,	9 },
{ 0x0e5a,	0x0010,	0x0000,	1 },
{ 0x0e81,	0x0100,	0x0000,	26 },
{ 0x0eaf,	0x0010,	0x0000,	25 },
{ 0x0ed0,	0x0004,	0x0000,	9 },
{ 0x0edc,	0x0100,	0x0000,	1 },
{ 0x0f00,	0x0010,	0x0000,	31 },
{ 0x0f20,	0x0004,	0x0000,	19 },
{ 0x0f34,	0x0010,	0x0000,	11 },
{ 0x0f40,	0x0100,	0x0000,	40 },
{ 0x0f71,	0x0010,	0x0000,	26 },
{ 0x0f90,	0x0100,	0x0000,	35 },
{ 0x10a0,	0x0101,	0x10a0,	0 },
{ 0x10a1,	0x0101,	0x10a1,	0 },
{ 0x10a2,	0x0101,	0x10a2,	0 },
{ 0x10a3,	0x0101,	0x10a3,	0 },
{ 0x10a4,	0x0101,	0x10a4,	0 },
{ 0x10a5,	0x0101,	0x10a5,	0 },
{ 0x10a6,	0x0101,	0x10a6,	0 },
{ 0x10a7,	0x0101,	0x10a7,	0 },
{ 0x10a8,	0x0101,	0x10a8,	0 },
{ 0x10a9,	0x0101,	0x10a9,	0 },
{ 0x10aa,	0x0101,	0x10aa,	0 },
{ 0x10ab,	0x0101,	0x10ab,	0 },
{ 0x10ac,	0x0101,	0x10ac,	0 },
{ 0x10ad,	0x0101,	0x10ad,	0 },
{ 0x10ae,	0x0101,	0x10ae,	0 },
{ 0x10af,	0x0101,	0x10af,	0 },
{ 0x10b0,	0x0101,	0x10b0,	0 },
{ 0x10b1,	0x0101,	0x10b1,	0 },
{ 0x10b2,	0x0101,	0x10b2,	0 },
{ 0x10b3,	0x0101,	0x10b3,	0 },
{ 0x10b4,	0x0101,	0x10b4,	0 },
{ 0x10b5,	0x0101,	0x10b5,	0 },
{ 0x10b6,	0x0101,	0x10b6,	0 },
{ 0x10b7,	0x0101,	0x10b7,	0 },
{ 0x10b8,	0x0101,	0x10b8,	0 },
{ 0x10b9,	0x0101,	0x10b9,	0 },
{ 0x10ba,	0x0101,	0x10ba,	0 },
{ 0x10bb,	0x0101,	0x10bb,	0 },
{ 0x10bc,	0x0101,	0x10bc,	0 },
{ 0x10bd,	0x0101,	0x10bd,	0 },
{ 0x10be,	0x0101,	0x10be,	0 },
{ 0x10bf,	0x0101,	0x10bf,	0 },
{ 0x10c0,	0x0101,	0x10c0,	0 },
{ 0x10c1,	0x0101,	0x10c1,	0 },
{ 0x10c2,	0x0101,	0x10c2,	0 },
{ 0x10c3,	0x0101,	0x10c3,	0 },
{ 0x10c4,	0x0101,	0x10c4,	0 },
{ 0x10c5,	0x0101,	0x10c5,	0 },
{ 0x10d0,	0x0102,	0x10d0,	0 },
{ 0x10d1,	0x0102,	0x10d1,	0 },
{ 0x10d2,	0x0102,	0x10d2,	0 },
{ 0x10d3,	0x0102,	0x10d3,	0 },
{ 0x10d4,	0x0102,	0x10d4,	0 },
{ 0x10d5,	0x0102,	0x10d5,	0 },
{ 0x10d6,	0x0102,	0x10d6,	0 },
{ 0x10d7,	0x0102,	0x10d7,	0 },
{ 0x10d8,	0x0102,	0x10d8,	0 },
{ 0x10d9,	0x0102,	0x10d9,	0 },
{ 0x10da,	0x0102,	0x10da,	0 },
{ 0x10db,	0x0102,	0x10db,	0 },
{ 0x10dc,	0x0102,	0x10dc,	0 },
{ 0x10dd,	0x0102,	0x10dd,	0 },
{ 0x10de,	0x0102,	0x10de,	0 },
{ 0x10df,	0x0102,	0x10df,	0 },
{ 0x10e0,	0x0102,	0x10e0,	0 },
{ 0x10e1,	0x0102,	0x10e1,	0 },
{ 0x10e2,	0x0102,	0x10e2,	0 },
{ 0x10e3,	0x0102,	0x10e3,	0 },
{ 0x10e4,	0x0102,	0x10e4,	0 },
{ 0x10e5,	0x0102,	0x10e5,	0 },
{ 0x10e6,	0x0102,	0x10e6,	0 },
{ 0x10e7,	0x0102,	0x10e7,	0 },
{ 0x10e8,	0x0102,	0x10e8,	0 },
{ 0x10e9,	0x0102,	0x10e9,	0 },
{ 0x10ea,	0x0102,	0x10ea,	0 },
{ 0x10eb,	0x0102,	0x10eb,	0 },
{ 0x10ec,	0x0102,	0x10ec,	0 },
{ 0x10ed,	0x0102,	0x10ed,	0 },
{ 0x10ee,	0x0102,	0x10ee,	0 },
{ 0x10ef,	0x0102,	0x10ef,	0 },
{ 0x10f0,	0x0102,	0x10f0,	0 },
{ 0x10f1,	0x0102,	0x10f1,	0 },
{ 0x10f2,	0x0102,	0x10f2,	0 },
{ 0x10f3,	0x0102,	0x10f3,	0 },
{ 0x10f4,	0x0102,	0x10f4,	0 },
{ 0x10f5,	0x0102,	0x10f5,	0 },
{ 0x10f6,	0x0102,	0x10f6,	0 },
{ 0x10fb,	0x0010,	0x0000,	0 },
{ 0x1100,	0x0100,	0x0000,	239 },
{ 0x1e00,	0x0101,	0x1e00,	0 },
{ 0x1e01,	0x0102,	0x1e01,	0 },
{ 0x1e02,	0x0101,	0x1e02,	0 },
{ 0x1e03,	0x0102,	0x1e03,	0 },
{ 0x1e04,	0x0101,	0x1e04,	0 },
{ 0x1e05,	0x0102,	0x1e05,	0 },
{ 0x1e06,	0x0101,	0x1e06,	0 },
{ 0x1e07,	0x0102,	0x1e07,	0 },
{ 0x1e08,	0x0101,	0x1e08,	0 },
{ 0x1e09,	0x0102,	0x1e09,	0 },
{ 0x1e0a,	0x0101,	0x1e0a,	0 },
{ 0x1e0b,	0x0102,	0x1e0b,	0 },
{ 0x1e0c,	0x0101,	0x1e0c,	0 },
{ 0x1e0d,	0x0102,	0x1e0d,	0 },
{ 0x1e0e,	0x0101,	0x1e0e,	0 },
{ 0x1e0f,	0x0102,	0x1e0f,	0 },
{ 0x1e10,	0x0101,	0x1e10,	0 },
{ 0x1e11,	0x0102,	0x1e11,	0 },
{ 0x1e12,	0x0101,	0x1e12,	0 },
{ 0x1e13,	0x0102,	0x1e13,	0 },
{ 0x1e14,	0x0101,	0x1e14,	0 },
{ 0x1e15,	0x0102,	0x1e15,	0 },
{ 0x1e16,	0x0101,	0x1e16,	0 },
{ 0x1e17,	0x0102,	0x1e17,	0 },
{ 0x1e18,	0x0101,	0x1e18,	0 },
{ 0x1e19,	0x0102,	0x1e19,	0 },
{ 0x1e1a,	0x0101,	0x1e1a,	0 },
{ 0x1e1b,	0x0102,	0x1e1b,	0 },
{ 0x1e1c,	0x0101,	0x1e1c,	0 },
{ 0x1e1d,	0x0102,	0x1e1d,	0 },
{ 0x1e1e,	0x0101,	0x1e1e,	0 },
{ 0x1e1f,	0x0102,	0x1e1f,	0 },
{ 0x1e20,	0x0101,	0x1e20,	0 },
{ 0x1e21,	0x0102,	0x1e21,	0 },
{ 0x1e22,	0x0101,	0x1e22,	0 },
{ 0x1e23,	0x0102,	0x1e23,	0 },
{ 0x1e24,	0x0101,	0x1e24,	0 },
{ 0x1e25,	0x0102,	0x1e25,	0 },
{ 0x1e26,	0x0101,	0x1e26,	0 },
{ 0x1e27,	0x0102,	0x1e27,	0 },
{ 0x1e28,	0x0101,	0x1e28,	0 },
{ 0x1e29,	0x0102,	0x1e29,	0 },
{ 0x1e2a,	0x0101,	0x1e2a,	0 },
{ 0x1e2b,	0x0102,	0x1e2b,	0 },
{ 0x1e2c,	0x0101,	0x1e2c,	0 },
{ 0x1e2d,	0x0102,	0x1e2d,	0 },
{ 0x1e2e,	0x0101,	0x1e2e,	0 },
{ 0x1e2f,	0x0102,	0x1e2f,	0 },
{ 0x1e30,	0x0101,	0x1e30,	0 },
{ 0x1e31,	0x0102,	0x1e31,	0 },
{ 0x1e32,	0x0101,	0x1e32,	0 },
{ 0x1e33,	0x0102,	0x1e33,	0 },
{ 0x1e34,	0x0101,	0x1e34,	0 },
{ 0x1e35,	0x0102,	0x1e35,	0 },
{ 0x1e36,	0x0101,	0x1e36,	0 },
{ 0x1e37,	0x0102,	0x1e37,	0 },
{ 0x1e38,	0x0101,	0x1e38,	0 },
{ 0x1e39,	0x0102,	0x1e39,	0 },
{ 0x1e3a,	0x0101,	0x1e3a,	0 },
{ 0x1e3b,	0x0102,	0x1e3b,	0 },
{ 0x1e3c,	0x0101,	0x1e3c,	0 },
{ 0x1e3d,	0x0102,	0x1e3d,	0 },
{ 0x1e3e,	0x0101,	0x1e3e,	0 },
{ 0x1e3f,	0x0102,	0x1e3f,	0 },
{ 0x1e40,	0x0101,	0x1e40,	0 },
{ 0x1e41,	0x0102,	0x1e41,	0 },
{ 0x1e42,	0x0101,	0x1e42,	0 },
{ 0x1e43,	0x0102,	0x1e43,	0 },
{ 0x1e44,	0x0101,	0x1e44,	0 },
{ 0x1e45,	0x0102,	0x1e45,	0 },
{ 0x1e46,	0x0101,	0x1e46,	0 },
{ 0x1e47,	0x0102,	0x1e47,	0 },
{ 0x1e48,	0x0101,	0x1e48,	0 },
{ 0x1e49,	0x0102,	0x1e49,	0 },
{ 0x1e4a,	0x0101,	0x1e4a,	0 },
{ 0x1e4b,	0x0102,	0x1e4b,	0 },
{ 0x1e4c,	0x0101,	0x1e4c,	0 },
{ 0x1e4d,	0x0102,	0x1e4d,	0 },
{ 0x1e4e,	0x0101,	0x1e4e,	0 },
{ 0x1e4f,	0x0102,	0x1e4f,	0 },
{ 0x1e50,	0x0101,	0x1e50,	0 },
{ 0x1e51,	0x0102,	0x1e51,	0 },
{ 0x1e52,	0x0101,	0x1e52,	0 },
{ 0x1e53,	0x0102,	0x1e53,	0 },
{ 0x1e54,	0x0101,	0x1e54,	0 },
{ 0x1e55,	0x0102,	0x1e55,	0 },
{ 0x1e56,	0x0101,	0x1e56,	0 },
{ 0x1e57,	0x0102,	0x1e57,	0 },
{ 0x1e58,	0x0101,	0x1e58,	0 },
{ 0x1e59,	0x0102,	0x1e59,	0 },
{ 0x1e5a,	0x0101,	0x1e5a,	0 },
{ 0x1e5b,	0x0102,	0x1e5b,	0 },
{ 0x1e5c,	0x0101,	0x1e5c,	0 },
{ 0x1e5d,	0x0102,	0x1e5d,	0 },
{ 0x1e5e,	0x0101,	0x1e5e,	0 },
{ 0x1e5f,	0x0102,	0x1e5f,	0 },
{ 0x1e60,	0x0101,	0x1e60,	0 },
{ 0x1e61,	0x0102,	0x1e61,	0 },
{ 0x1e62,	0x0101,	0x1e62,	0 },
{ 0x1e63,	0x0102,	0x1e63,	0 },
{ 0x1e64,	0x0101,	0x1e64,	0 },
{ 0x1e65,	0x0102,	0x1e65,	0 },
{ 0x1e66,	0x0101,	0x1e66,	0 },
{ 0x1e67,	0x0102,	0x1e67,	0 },
{ 0x1e68,	0x0101,	0x1e68,	0 },
{ 0x1e69,	0x0102,	0x1e69,	0 },
{ 0x1e6a,	0x0101,	0x1e6a,	0 },
{ 0x1e6b,	0x0102,	0x1e6b,	0 },
{ 0x1e6c,	0x0101,	0x1e6c,	0 },
{ 0x1e6d,	0x0102,	0x1e6d,	0 },
{ 0x1e6e,	0x0101,	0x1e6e,	0 },
{ 0x1e6f,	0x0102,	0x1e6f,	0 },
{ 0x1e70,	0x0101,	0x1e70,	0 },
{ 0x1e71,	0x0102,	0x1e71,	0 },
{ 0x1e72,	0x0101,	0x1e72,	0 },
{ 0x1e73,	0x0102,	0x1e73,	0 },
{ 0x1e74,	0x0101,	0x1e74,	0 },
{ 0x1e75,	0x0102,	0x1e75,	0 },
{ 0x1e76,	0x0101,	0x1e76,	0 },
{ 0x1e77,	0x0102,	0x1e77,	0 },
{ 0x1e78,	0x0101,	0x1e78,	0 },
{ 0x1e79,	0x0102,	0x1e79,	0 },
{ 0x1e7a,	0x0101,	0x1e7a,	0 },
{ 0x1e7b,	0x0102,	0x1e7b,	0 },
{ 0x1e7c,	0x0101,	0x1e7c,	0 },
{ 0x1e7d,	0x0102,	0x1e7d,	0 },
{ 0x1e7e,	0x0101,	0x1e7e,	0 },
{ 0x1e7f,	0x0102,	0x1e7f,	0 },
{ 0x1e80,	0x0101,	0x1e80,	0 },
{ 0x1e81,	0x0102,	0x1e81,	0 },
{ 0x1e82,	0x0101,	0x1e82,	0 },
{ 0x1e83,	0x0102,	0x1e83,	0 },
{ 0x1e84,	0x0101,	0x1e84,	0 },
{ 0x1e85,	0x0102,	0x1e85,	0 },
{ 0x1e86,	0x0101,	0x1e86,	0 },
{ 0x1e87,	0x0102,	0x1e87,	0 },
{ 0x1e88,	0x0101,	0x1e88,	0 },
{ 0x1e89,	0x0102,	0x1e89,	0 },
{ 0x1e8a,	0x0101,	0x1e8a,	0 },
{ 0x1e8b,	0x0102,	0x1e8b,	0 },
{ 0x1e8c,	0x0101,	0x1e8c,	0 },
{ 0x1e8d,	0x0102,	0x1e8d,	0 },
{ 0x1e8e,	0x0101,	0x1e8e,	0 },
{ 0x1e8f,	0x0102,	0x1e8f,	0 },
{ 0x1e90,	0x0101,	0x1e90,	0 },
{ 0x1e91,	0x0102,	0x1e91,	0 },
{ 0x1e92,	0x0101,	0x1e92,	0 },
{ 0x1e93,	0x0102,	0x1e93,	0 },
{ 0x1e94,	0x0101,	0x1e94,	0 },
{ 0x1e95,	0x0102,	0x1e95,	0 },
{ 0x1e96,	0x0102,	0x1e96,	0 },
{ 0x1e97,	0x0102,	0x1e97,	0 },
{ 0x1e98,	0x0102,	0x1e98,	0 },
{ 0x1e99,	0x0102,	0x1e99,	0 },
{ 0x1e9a,	0x0102,	0x1e9a,	0 },
{ 0x1e9b,	0x0102,	0x1e9b,	0 },
{ 0x1ea0,	0x0101,	0x1ea0,	0 },
{ 0x1ea1,	0x0102,	0x1ea1,	0 },
{ 0x1ea2,	0x0101,	0x1ea2,	0 },
{ 0x1ea3,	0x0102,	0x1ea3,	0 },
{ 0x1ea4,	0x0101,	0x1ea4,	0 },
{ 0x1ea5,	0x0102,	0x1ea5,	0 },
{ 0x1ea6,	0x0101,	0x1ea6,	0 },
{ 0x1ea7,	0x0102,	0x1ea7,	0 },
{ 0x1ea8,	0x0101,	0x1ea8,	0 },
{ 0x1ea9,	0x0102,	0x1ea9,	0 },
{ 0x1eaa,	0x0101,	0x1eaa,	0 },
{ 0x1eab,	0x0102,	0x1eab,	0 },
{ 0x1eac,	0x0101,	0x1eac,	0 },
{ 0x1ead,	0x0102,	0x1ead,	0 },
{ 0x1eae,	0x0101,	0x1eae,	0 },
{ 0x1eaf,	0x0102,	0x1eaf,	0 },
{ 0x1eb0,	0x0101,	0x1eb0,	0 },
{ 0x1eb1,	0x0102,	0x1eb1,	0 },
{ 0x1eb2,	0x0101,	0x1eb2,	0 },
{ 0x1eb3,	0x0102,	0x1eb3,	0 },
{ 0x1eb4,	0x0101,	0x1eb4,	0 },
{ 0x1eb5,	0x0102,	0x1eb5,	0 },
{ 0x1eb6,	0x0101,	0x1eb6,	0 },
{ 0x1eb7,	0x0102,	0x1eb7,	0 },
{ 0x1eb8,	0x0101,	0x1eb8,	0 },
{ 0x1eb9,	0x0102,	0x1eb9,	0 },
{ 0x1eba,	0x0101,	0x1eba,	0 },
{ 0x1ebb,	0x0102,	0x1ebb,	0 },
{ 0x1ebc,	0x0101,	0x1ebc,	0 },
{ 0x1ebd,	0x0102,	0x1ebd,	0 },
{ 0x1ebe,	0x0101,	0x1ebe,	0 },
{ 0x1ebf,	0x0102,	0x1ebf,	0 },
{ 0x1ec0,	0x0101,	0x1ec0,	0 },
{ 0x1ec1,	0x0102,	0x1ec1,	0 },
{ 0x1ec2,	0x0101,	0x1ec2,	0 },
{ 0x1ec3,	0x0102,	0x1ec3,	0 },
{ 0x1ec4,	0x0101,	0x1ec4,	0 },
{ 0x1ec5,	0x0102,	0x1ec5,	0 },
{ 0x1ec6,	0x0101,	0x1ec6,	0 },
{ 0x1ec7,	0x0102,	0x1ec7,	0 },
{ 0x1ec8,	0x0101,	0x1ec8,	0 },
{ 0x1ec9,	0x0102,	0x1ec9,	0 },
{ 0x1eca,	0x0101,	0x1eca,	0 },
{ 0x1ecb,	0x0102,	0x1ecb,	0 },
{ 0x1ecc,	0x0101,	0x1ecc,	0 },
{ 0x1ecd,	0x0102,	0x1ecd,	0 },
{ 0x1ece,	0x0101,	0x1ece,	0 },
{ 0x1ecf,	0x0102,	0x1ecf,	0 },
{ 0x1ed0,	0x0101,	0x1ed0,	0 },
{ 0x1ed1,	0x0102,	0x1ed1,	0 },
{ 0x1ed2,	0x0101,	0x1ed2,	0 },
{ 0x1ed3,	0x0102,	0x1ed3,	0 },
{ 0x1ed4,	0x0101,	0x1ed4,	0 },
{ 0x1ed5,	0x0102,	0x1ed5,	0 },
{ 0x1ed6,	0x0101,	0x1ed6,	0 },
{ 0x1ed7,	0x0102,	0x1ed7,	0 },
{ 0x1ed8,	0x0101,	0x1ed8,	0 },
{ 0x1ed9,	0x0102,	0x1ed9,	0 },
{ 0x1eda,	0x0101,	0x1eda,	0 },
{ 0x1edb,	0x0102,	0x1edb,	0 },
{ 0x1edc,	0x0101,	0x1edc,	0 },
{ 0x1edd,	0x0102,	0x1edd,	0 },
{ 0x1ede,	0x0101,	0x1ede,	0 },
{ 0x1edf,	0x0102,	0x1edf,	0 },
{ 0x1ee0,	0x0101,	0x1ee0,	0 },
{ 0x1ee1,	0x0102,	0x1ee1,	0 },
{ 0x1ee2,	0x0101,	0x1ee2,	0 },
{ 0x1ee3,	0x0102,	0x1ee3,	0 },
{ 0x1ee4,	0x0101,	0x1ee4,	0 },
{ 0x1ee5,	0x0102,	0x1ee5,	0 },
{ 0x1ee6,	0x0101,	0x1ee6,	0 },
{ 0x1ee7,	0x0102,	0x1ee7,	0 },
{ 0x1ee8,	0x0101,	0x1ee8,	0 },
{ 0x1ee9,	0x0102,	0x1ee9,	0 },
{ 0x1eea,	0x0101,	0x1eea,	0 },
{ 0x1eeb,	0x0102,	0x1eeb,	0 },
{ 0x1eec,	0x0101,	0x1eec,	0 },
{ 0x1eed,	0x0102,	0x1eed,	0 },
{ 0x1eee,	0x0101,	0x1eee,	0 },
{ 0x1eef,	0x0102,	0x1eef,	0 },
{ 0x1ef0,	0x0101,	0x1ef0,	0 },
{ 0x1ef1,	0x0102,	0x1ef1,	0 },
{ 0x1ef2,	0x0101,	0x1ef2,	0 },
{ 0x1ef3,	0x0102,	0x1ef3,	0 },
{ 0x1ef4,	0x0101,	0x1ef4,	0 },
{ 0x1ef5,	0x0102,	0x1ef5,	0 },
{ 0x1ef6,	0x0101,	0x1ef6,	0 },
{ 0x1ef7,	0x0102,	0x1ef7,	0 },
{ 0x1ef8,	0x0101,	0x1ef8,	0 },
{ 0x1ef9,	0x0102,	0x1ef9,	0 },
{ 0x1f00,	0x0102,	0x1f00,	0 },
{ 0x1f01,	0x0102,	0x1f01,	0 },
{ 0x1f02,	0x0102,	0x1f02,	0 },
{ 0x1f03,	0x0102,	0x1f03,	0 },
{ 0x1f04,	0x0102,	0x1f04,	0 },
{ 0x1f05,	0x0102,	0x1f05,	0 },
{ 0x1f06,	0x0102,	0x1f06,	0 },
{ 0x1f07,	0x0102,	0x1f07,	0 },
{ 0x1f08,	0x0101,	0x1f08,	0 },
{ 0x1f09,	0x0101,	0x1f09,	0 },
{ 0x1f0a,	0x0101,	0x1f0a,	0 },
{ 0x1f0b,	0x0101,	0x1f0b,	0 },
{ 0x1f0c,	0x0101,	0x1f0c,	0 },
{ 0x1f0d,	0x0101,	0x1f0d,	0 },
{ 0x1f0e,	0x0101,	0x1f0e,	0 },
{ 0x1f0f,	0x0101,	0x1f0f,	0 },
{ 0x1f10,	0x0102,	0x1f10,	0 },
{ 0x1f11,	0x0102,	0x1f11,	0 },
{ 0x1f12,	0x0102,	0x1f12,	0 },
{ 0x1f13,	0x0102,	0x1f13,	0 },
{ 0x1f14,	0x0102,	0x1f14,	0 },
{ 0x1f15,	0x0102,	0x1f15,	0 },
{ 0x1f18,	0x0101,	0x1f18,	0 },
{ 0x1f19,	0x0101,	0x1f19,	0 },
{ 0x1f1a,	0x0101,	0x1f1a,	0 },
{ 0x1f1b,	0x0101,	0x1f1b,	0 },
{ 0x1f1c,	0x0101,	0x1f1c,	0 },
{ 0x1f1d,	0x0101,	0x1f1d,	0 },
{ 0x1f20,	0x0102,	0x1f20,	0 },
{ 0x1f21,	0x0102,	0x1f21,	0 },
{ 0x1f22,	0x0102,	0x1f22,	0 },
{ 0x1f23,	0x0102,	0x1f23,	0 },
{ 0x1f24,	0x0102,	0x1f24,	0 },
{ 0x1f25,	0x0102,	0x1f25,	0 },
{ 0x1f26,	0x0102,	0x1f26,	0 },
{ 0x1f27,	0x0102,	0x1f27,	0 },
{ 0x1f28,	0x0101,	0x1f28,	0 },
{ 0x1f29,	0x0101,	0x1f29,	0 },
{ 0x1f2a,	0x0101,	0x1f2a,	0 },
{ 0x1f2b,	0x0101,	0x1f2b,	0 },
{ 0x1f2c,	0x0101,	0x1f2c,	0 },
{ 0x1f2d,	0x0101,	0x1f2d,	0 },
{ 0x1f2e,	0x0101,	0x1f2e,	0 },
{ 0x1f2f,	0x0101,	0x1f2f,	0 },
{ 0x1f30,	0x0102,	0x1f30,	0 },
{ 0x1f31,	0x0102,	0x1f31,	0 },
{ 0x1f32,	0x0102,	0x1f32,	0 },
{ 0x1f33,	0x0102,	0x1f33,	0 },
{ 0x1f34,	0x0102,	0x1f34,	0 },
{ 0x1f35,	0x0102,	0x1f35,	0 },
{ 0x1f36,	0x0102,	0x1f36,	0 },
{ 0x1f37,	0x0102,	0x1f37,	0 },
{ 0x1f38,	0x0101,	0x1f38,	0 },
{ 0x1f39,	0x0101,	0x1f39,	0 },
{ 0x1f3a,	0x0101,	0x1f3a,	0 },
{ 0x1f3b,	0x0101,	0x1f3b,	0 },
{ 0x1f3c,	0x0101,	0x1f3c,	0 },
{ 0x1f3d,	0x0101,	0x1f3d,	0 },
{ 0x1f3e,	0x0101,	0x1f3e,	0 },
{ 0x1f3f,	0x0101,	0x1f3f,	0 },
{ 0x1f40,	0x0102,	0x1f40,	0 },
{ 0x1f41,	0x0102,	0x1f41,	0 },
{ 0x1f42,	0x0102,	0x1f42,	0 },
{ 0x1f43,	0x0102,	0x1f43,	0 },
{ 0x1f44,	0x0102,	0x1f44,	0 },
{ 0x1f45,	0x0102,	0x1f45,	0 },
{ 0x1f48,	0x0101,	0x1f48,	0 },
{ 0x1f49,	0x0101,	0x1f49,	0 },
{ 0x1f4a,	0x0101,	0x1f4a,	0 },
{ 0x1f4b,	0x0101,	0x1f4b,	0 },
{ 0x1f4c,	0x0101,	0x1f4c,	0 },
{ 0x1f4d,	0x0101,	0x1f4d,	0 },
{ 0x1f50,	0x0102,	0x1f50,	0 },
{ 0x1f51,	0x0102,	0x1f51,	0 },
{ 0x1f52,	0x0102,	0x1f52,	0 },
{ 0x1f53,	0x0102,	0x1f53,	0 },
{ 0x1f54,	0x0102,	0x1f54,	0 },
{ 0x1f55,	0x0102,	0x1f55,	0 },
{ 0x1f56,	0x0102,	0x1f56,	0 },
{ 0x1f57,	0x0102,	0x1f57,	0 },
{ 0x1f59,	0x0101,	0x1f59,	0 },
{ 0x1f5b,	0x0101,	0x1f5b,	0 },
{ 0x1f5d,	0x0101,	0x1f5d,	0 },
{ 0x1f5f,	0x0101,	0x1f5f,	0 },
{ 0x1f60,	0x0102,	0x1f60,	0 },
{ 0x1f61,	0x0102,	0x1f61,	0 },
{ 0x1f62,	0x0102,	0x1f62,	0 },
{ 0x1f63,	0x0102,	0x1f63,	0 },
{ 0x1f64,	0x0102,	0x1f64,	0 },
{ 0x1f65,	0x0102,	0x1f65,	0 },
{ 0x1f66,	0x0102,	0x1f66,	0 },
{ 0x1f67,	0x0102,	0x1f67,	0 },
{ 0x1f68,	0x0101,	0x1f68,	0 },
{ 0x1f69,	0x0101,	0x1f69,	0 },
{ 0x1f6a,	0x0101,	0x1f6a,	0 },
{ 0x1f6b,	0x0101,	0x1f6b,	0 },
{ 0x1f6c,	0x0101,	0x1f6c,	0 },
{ 0x1f6d,	0x0101,	0x1f6d,	0 },
{ 0x1f6e,	0x0101,	0x1f6e,	0 },
{ 0x1f6f,	0x0101,	0x1f6f,	0 },
{ 0x1f70,	0x0102,	0x1f70,	0 },
{ 0x1f71,	0x0102,	0x1f71,	0 },
{ 0x1f72,	0x0102,	0x1f72,	0 },
{ 0x1f73,	0x0102,	0x1f73,	0 },
{ 0x1f74,	0x0102,	0x1f74,	0 },
{ 0x1f75,	0x0102,	0x1f75,	0 },
{ 0x1f76,	0x0102,	0x1f76,	0 },
{ 0x1f77,	0x0102,	0x1f77,	0 },
{ 0x1f78,	0x0102,	0x1f78,	0 },
{ 0x1f79,	0x0102,	0x1f79,	0 },
{ 0x1f7a,	0x0102,	0x1f7a,	0 },
{ 0x1f7b,	0x0102,	0x1f7b,	0 },
{ 0x1f7c,	0x0102,	0x1f7c,	0 },
{ 0x1f7d,	0x0102,	0x1f7d,	0 },
{ 0x1f80,	0x0102,	0x1f80,	0 },
{ 0x1f81,	0x0102,	0x1f81,	0 },
{ 0x1f82,	0x0102,	0x1f82,	0 },
{ 0x1f83,	0x0102,	0x1f83,	0 },
{ 0x1f84,	0x0102,	0x1f84,	0 },
{ 0x1f85,	0x0102,	0x1f85,	0 },
{ 0x1f86,	0x0102,	0x1f86,	0 },
{ 0x1f87,	0x0102,	0x1f87,	0 },
{ 0x1f88,	0x0101,	0x1f88,	0 },
{ 0x1f89,	0x0101,	0x1f89,	0 },
{ 0x1f8a,	0x0101,	0x1f8a,	0 },
{ 0x1f8b,	0x0101,	0x1f8b,	0 },
{ 0x1f8c,	0x0101,	0x1f8c,	0 },
{ 0x1f8d,	0x0101,	0x1f8d,	0 },
{ 0x1f8e,	0x0101,	0x1f8e,	0 },
{ 0x1f8f,	0x0101,	0x1f8f,	0 },
{ 0x1f90,	0x0102,	0x1f90,	0 },
{ 0x1f91,	0x0102,	0x1f91,	0 },
{ 0x1f92,	0x0102,	0x1f92,	0 },
{ 0x1f93,	0x0102,	0x1f93,	0 },
{ 0x1f94,	0x0102,	0x1f94,	0 },
{ 0x1f95,	0x0102,	0x1f95,	0 },
{ 0x1f96,	0x0102,	0x1f96,	0 },
{ 0x1f97,	0x0102,	0x1f97,	0 },
{ 0x1f98,	0x0101,	0x1f98,	0 },
{ 0x1f99,	0x0101,	0x1f99,	0 },
{ 0x1f9a,	0x0101,	0x1f9a,	0 },
{ 0x1f9b,	0x0101,	0x1f9b,	0 },
{ 0x1f9c,	0x0101,	0x1f9c,	0 },
{ 0x1f9d,	0x0101,	0x1f9d,	0 },
{ 0x1f9e,	0x0101,	0x1f9e,	0 },
{ 0x1f9f,	0x0101,	0x1f9f,	0 },
{ 0x1fa0,	0x0102,	0x1fa0,	0 },
{ 0x1fa1,	0x0102,	0x1fa1,	0 },
{ 0x1fa2,	0x0102,	0x1fa2,	0 },
{ 0x1fa3,	0x0102,	0x1fa3,	0 },
{ 0x1fa4,	0x0102,	0x1fa4,	0 },
{ 0x1fa5,	0x0102,	0x1fa5,	0 },
{ 0x1fa6,	0x0102,	0x1fa6,	0 },
{ 0x1fa7,	0x0102,	0x1fa7,	0 },
{ 0x1fa8,	0x0101,	0x1fa8,	0 },
{ 0x1fa9,	0x0101,	0x1fa9,	0 },
{ 0x1faa,	0x0101,	0x1faa,	0 },
{ 0x1fab,	0x0101,	0x1fab,	0 },
{ 0x1fac,	0x0101,	0x1fac,	0 },
{ 0x1fad,	0x0101,	0x1fad,	0 },
{ 0x1fae,	0x0101,	0x1fae,	0 },
{ 0x1faf,	0x0101,	0x1faf,	0 },
{ 0x1fb0,	0x0102,	0x1fb0,	0 },
{ 0x1fb1,	0x0102,	0x1fb1,	0 },
{ 0x1fb2,	0x0102,	0x1fb2,	0 },
{ 0x1fb3,	0x0102,	0x1fb3,	0 },
{ 0x1fb4,	0x0102,	0x1fb4,	0 },
{ 0x1fb6,	0x0102,	0x1fb6,	0 },
{ 0x1fb7,	0x0102,	0x1fb7,	0 },
{ 0x1fb8,	0x0101,	0x1fb8,	0 },
{ 0x1fb9,	0x0101,	0x1fb9,	0 },
{ 0x1fba,	0x0101,	0x1fba,	0 },
{ 0x1fbb,	0x0101,	0x1fbb,	0 },
{ 0x1fbc,	0x0101,	0x1fbc,	0 },
{ 0x1fbd,	0x0010,	0x0000,	4 },
{ 0x1fc2,	0x0102,	0x1fc2,	0 },
{ 0x1fc3,	0x0102,	0x1fc3,	0 },
{ 0x1fc4,	0x0102,	0x1fc4,	0 },
{ 0x1fc6,	0x0102,	0x1fc6,	0 },
{ 0x1fc7,	0x0102,	0x1fc7,	0 },
{ 0x1fc8,	0x0101,	0x1fc8,	0 },
{ 0x1fc9,	0x0101,	0x1fc9,	0 },
{ 0x1fca,	0x0101,	0x1fca,	0 },
{ 0x1fcb,	0x0101,	0x1fcb,	0 },
{ 0x1fcc,	0x0101,	0x1fcc,	0 },
{ 0x1fcd,	0x0010,	0x0000,	2 },
{ 0x1fd0,	0x0102,	0x1fd0,	0 },
{ 0x1fd1,	0x0102,	0x1fd1,	0 },
{ 0x1fd2,	0x0102,	0x1fd2,	0 },
{ 0x1fd3,	0x0102,	0x1fd3,	0 },
{ 0x1fd6,	0x0102,	0x1fd6,	0 },
{ 0x1fd7,	0x0102,	0x1fd7,	0 },
{ 0x1fd8,	0x0101,	0x1fd8,	0 },
{ 0x1fd9,	0x0101,	0x1fd9,	0 },
{ 0x1fda,	0x0101,	0x1fda,	0 },
{ 0x1fdb,	0x0101,	0x1fdb,	0 },
{ 0x1fdd,	0x0010,	0x0000,	2 },
{ 0x1fe0,	0x0102,	0x1fe0,	0 },
{ 0x1fe1,	0x0102,	0x1fe1,	0 },
{ 0x1fe2,	0x0102,	0x1fe2,	0 },
{ 0x1fe3,	0x0102,	0x1fe3,	0 },
{ 0x1fe4,	0x0102,	0x1fe4,	0 },
{ 0x1fe5,	0x0102,	0x1fe5,	0 },
{ 0x1fe6,	0x0102,	0x1fe6,	0 },
{ 0x1fe7,	0x0102,	0x1fe7,	0 },
{ 0x1fe8,	0x0101,	0x1fe8,	0 },
{ 0x1fe9,	0x0101,	0x1fe9,	0 },
{ 0x1fea,	0x0101,	0x1fea,	0 },
{ 0x1feb,	0x0101,	0x1feb,	0 },
{ 0x1fec,	0x0101,	0x1fec,	0 },
{ 0x1fed,	0x0010,	0x0000,	2 },
{ 0x1ff2,	0x0102,	0x1ff2,	0 },
{ 0x1ff3,	0x0102,	0x1ff3,	0 },
{ 0x1ff4,	0x0102,	0x1ff4,	0 },
{ 0x1ff6,	0x0102,	0x1ff6,	0 },
{ 0x1ff7,	0x0102,	0x1ff7,	0 },
{ 0x1ff8,	0x0101,	0x1ff8,	0 },
{ 0x1ff9,	0x0101,	0x1ff9,	0 },
{ 0x1ffa,	0x0101,	0x1ffa,	0 },
{ 0x1ffb,	0x0101,	0x1ffb,	0 },
{ 0x1ffc,	0x0101,	0x1ffc,	0 },
{ 0x1ffd,	0x0010,	0x0000,	1 },
{ 0x2000,	0x0018,	0x0000,	11 },
{ 0x200c,	0x0030,	0x0000,	3 },
{ 0x2010,	0x0010,	0x0000,	23 },
{ 0x2028,	0x0030,	0x0000,	6 },
{ 0x2030,	0x0010,	0x0000,	22 },
{ 0x206a,	0x0030,	0x0000,	5 },
{ 0x2070,	0x0004,	0x0000,	6 },
{ 0x207a,	0x0010,	0x0000,	5 },
{ 0x2080,	0x0004,	0x0000,	9 },
{ 0x208a,	0x0010,	0x0000,	703 },
{ 0x249c,	0x0112,	0x249c,	0 },
{ 0x249d,	0x0112,	0x249d,	0 },
{ 0x249e,	0x0112,	0x249e,	0 },
{ 0x249f,	0x0112,	0x249f,	0 },
{ 0x24a0,	0x0112,	0x24a0,	0 },
{ 0x24a1,	0x0112,	0x24a1,	0 },
{ 0x24a2,	0x0112,	0x24a2,	0 },
{ 0x24a3,	0x0112,	0x24a3,	0 },
{ 0x24a4,	0x0112,	0x24a4,	0 },
{ 0x24a5,	0x0112,	0x24a5,	0 },
{ 0x24a6,	0x0112,	0x24a6,	0 },
{ 0x24a7,	0x0112,	0x24a7,	0 },
{ 0x24a8,	0x0112,	0x24a8,	0 },
{ 0x24a9,	0x0112,	0x24a9,	0 },
{ 0x24aa,	0x0112,	0x24aa,	0 },
{ 0x24ab,	0x0112,	0x24ab,	0 },
{ 0x24ac,	0x0112,	0x24ac,	0 },
{ 0x24ad,	0x0112,	0x24ad,	0 },
{ 0x24ae,	0x0112,	0x24ae,	0 },
{ 0x24af,	0x0112,	0x24af,	0 },
{ 0x24b0,	0x0112,	0x24b0,	0 },
{ 0x24b1,	0x0112,	0x24b1,	0 },
{ 0x24b2,	0x0112,	0x24b2,	0 },
{ 0x24b3,	0x0112,	0x24b3,	0 },
{ 0x24b4,	0x0112,	0x24b4,	0 },
{ 0x24b5,	0x0112,	0x24b5,	0 },
{ 0x24b6,	0x0111,	0x24b6,	0 },
{ 0x24b7,	0x0111,	0x24b7,	0 },
{ 0x24b8,	0x0111,	0x24b8,	0 },
{ 0x24b9,	0x0111,	0x24b9,	0 },
{ 0x24ba,	0x0111,	0x24ba,	0 },
{ 0x24bb,	0x0111,	0x24bb,	0 },
{ 0x24bc,	0x0111,	0x24bc,	0 },
{ 0x24bd,	0x0111,	0x24bd,	0 },
{ 0x24be,	0x0111,	0x24be,	0 },
{ 0x24bf,	0x0111,	0x24bf,	0 },
{ 0x24c0,	0x0111,	0x24c0,	0 },
{ 0x24c1,	0x0111,	0x24c1,	0 },
{ 0x24c2,	0x0111,	0x24c2,	0 },
{ 0x24c3,	0x0111,	0x24c3,	0 },
{ 0x24c4,	0x0111,	0x24c4,	0 },
{ 0x24c5,	0x0111,	0x24c5,	0 },
{ 0x24c6,	0x0111,	0x24c6,	0 },
{ 0x24c7,	0x0111,	0x24c7,	0 },
{ 0x24c8,	0x0111,	0x24c8,	0 },
{ 0x24c9,	0x0111,	0x24c9,	0 },
{ 0x24ca,	0x0111,	0x24ca,	0 },
{ 0x24cb,	0x0111,	0x24cb,	0 },
{ 0x24cc,	0x0111,	0x24cc,	0 },
{ 0x24cd,	0x0111,	0x24cd,	0 },
{ 0x24ce,	0x0111,	0x24ce,	0 },
{ 0x24cf,	0x0111,	0x24cf,	0 },
{ 0x24d0,	0x0112,	0x24d0,	0 },
{ 0x24d1,	0x0112,	0x24d1,	0 },
{ 0x24d2,	0x0112,	0x24d2,	0 },
{ 0x24d3,	0x0112,	0x24d3,	0 },
{ 0x24d4,	0x0112,	0x24d4,	0 },
{ 0x24d5,	0x0112,	0x24d5,	0 },
{ 0x24d6,	0x0112,	0x24d6,	0 },
{ 0x24d7,	0x0112,	0x24d7,	0 },
{ 0x24d8,	0x0112,	0x24d8,	0 },
{ 0x24d9,	0x0112,	0x24d9,	0 },
{ 0x24da,	0x0112,	0x24da,	0 },
{ 0x24db,	0x0112,	0x24db,	0 },
{ 0x24dc,	0x0112,	0x24dc,	0 },
{ 0x24dd,	0x0112,	0x24dd,	0 },
{ 0x24de,	0x0112,	0x24de,	0 },
{ 0x24df,	0x0112,	0x24df,	0 },
{ 0x24e0,	0x0112,	0x24e0,	0 },
{ 0x24e1,	0x0112,	0x24e1,	0 },
{ 0x24e2,	0x0112,	0x24e2,	0 },
{ 0x24e3,	0x0112,	0x24e3,	0 },
{ 0x24e4,	0x0112,	0x24e4,	0 },
{ 0x24e5,	0x0112,	0x24e5,	0 },
{ 0x24e6,	0x0112,	0x24e6,	0 },
{ 0x24e7,	0x0112,	0x24e7,	0 },
{ 0x24e8,	0x0112,	0x24e8,	0 },
{ 0x24e9,	0x0112,	0x24e9,	0 },
{ 0x24ea,	0x0010,	0x0000,	496 },
{ 0x3000,	0x0048,	0x0000,	0 },
{ 0x3001,	0x0010,	0x0000,	3 },
{ 0x3005,	0x0110,	0x0000,	0 },
{ 0x3006,	0x0010,	0x0000,	0 },
{ 0x3007,	0x0110,	0x0000,	0 },
{ 0x3008,	0x0010,	0x0000,	48 },
{ 0x3041,	0x0100,	0x0000,	83 },
{ 0x3099,	0x0010,	0x0000,	1 },
{ 0x309b,	0x0110,	0x0000,	3 },
{ 0x30a1,	0x0100,	0x0000,	89 },
{ 0x30fb,	0x0010,	0x0000,	0 },
{ 0x30fc,	0x0110,	0x0000,	2 },
{ 0x3105,	0x0100,	0x0000,	133 },
{ 0x3190,	0x0010,	0x0000,	466 },
{ 0x4e00,	0x0100,	0x0000,	32375 },
{ 0xfb00,	0x0102,	0xfb00,	0 },
{ 0xfb01,	0x0102,	0xfb01,	0 },
{ 0xfb02,	0x0102,	0xfb02,	0 },
{ 0xfb03,	0x0102,	0xfb03,	0 },
{ 0xfb04,	0x0102,	0xfb04,	0 },
{ 0xfb05,	0x0102,	0xfb05,	0 },
{ 0xfb06,	0x0102,	0xfb06,	0 },
{ 0xfb13,	0x0102,	0xfb13,	0 },
{ 0xfb14,	0x0102,	0xfb14,	0 },
{ 0xfb15,	0x0102,	0xfb15,	0 },
{ 0xfb16,	0x0102,	0xfb16,	0 },
{ 0xfb17,	0x0102,	0xfb17,	0 },
{ 0xfb1e,	0x0010,	0x0000,	0 },
{ 0xfb1f,	0x0100,	0x0000,	504 },
{ 0xfd3e,	0x0010,	0x0000,	1 },
{ 0xfd50,	0x0100,	0x0000,	129 },
{ 0xfe20,	0x0010,	0x0000,	71 },
{ 0xfe80,	0x0110,	0x0000,	124 },
{ 0xfeff,	0x0048,	0x0000,	0 },
{ 0xff01,	0x0010,	0x0000,	14 },
{ 0xff10,	0x0084,	0x0000,	9 },
{ 0xff1a,	0x0010,	0x0000,	6 },
{ 0xff21,	0x0181,	0xff21,	0 },
{ 0xff22,	0x0181,	0xff22,	0 },
{ 0xff23,	0x0181,	0xff23,	0 },
{ 0xff24,	0x0181,	0xff24,	0 },
{ 0xff25,	0x0181,	0xff25,	0 },
{ 0xff26,	0x0181,	0xff26,	0 },
{ 0xff27,	0x0101,	0xff27,	0 },
{ 0xff28,	0x0101,	0xff28,	0 },
{ 0xff29,	0x0101,	0xff29,	0 },
{ 0xff2a,	0x0101,	0xff2a,	0 },
{ 0xff2b,	0x0101,	0xff2b,	0 },
{ 0xff2c,	0x0101,	0xff2c,	0 },
{ 0xff2d,	0x0101,	0xff2d,	0 },
{ 0xff2e,	0x0101,	0xff2e,	0 },
{ 0xff2f,	0x0101,	0xff2f,	0 },
{ 0xff30,	0x0101,	0xff30,	0 },
{ 0xff31,	0x0101,	0xff31,	0 },
{ 0xff32,	0x0101,	0xff32,	0 },
{ 0xff33,	0x0101,	0xff33,	0 },
{ 0xff34,	0x0101,	0xff34,	0 },
{ 0xff35,	0x0101,	0xff35,	0 },
{ 0xff36,	0x0101,	0xff36,	0 },
{ 0xff37,	0x0101,	0xff37,	0 },
{ 0xff38,	0x0101,	0xff38,	0 },
{ 0xff39,	0x0101,	0xff39,	0 },
{ 0xff3a,	0x0101,	0xff3a,	0 },
{ 0xff3b,	0x0010,	0x0000,	5 },
{ 0xff41,	0x0182,	0xff41,	0 },
{ 0xff42,	0x0182,	0xff42,	0 },
{ 0xff43,	0x0182,	0xff43,	0 },
{ 0xff44,	0x0182,	0xff44,	0 },
{ 0xff45,	0x0182,	0xff45,	0 },
{ 0xff46,	0x0182,	0xff46,	0 },
{ 0xff47,	0x0102,	0xff47,	0 },
{ 0xff48,	0x0102,	0xff48,	0 },
{ 0xff49,	0x0102,	0xff49,	0 },
{ 0xff4a,	0x0102,	0xff4a,	0 },
{ 0xff4b,	0x0102,	0xff4b,	0 },
{ 0xff4c,	0x0102,	0xff4c,	0 },
{ 0xff4d,	0x0102,	0xff4d,	0 },
{ 0xff4e,	0x0102,	0xff4e,	0 },
{ 0xff4f,	0x0102,	0xff4f,	0 },
{ 0xff50,	0x0102,	0xff50,	0 },
{ 0xff51,	0x0102,	0xff51,	0 },
{ 0xff52,	0x0102,	0xff52,	0 },
{ 0xff53,	0x0102,	0xff53,	0 },
{ 0xff54,	0x0102,	0xff54,	0 },
{ 0xff55,	0x0102,	0xff55,	0 },
{ 0xff56,	0x0102,	0xff56,	0 },
{ 0xff57,	0x0102,	0xff57,	0 },
{ 0xff58,	0x0102,	0xff58,	0 },
{ 0xff59,	0x0102,	0xff59,	0 },
{ 0xff5a,	0x0102,	0xff5a,	0 },
{ 0xff5b,	0x0010,	0x0000,	8 },
{ 0xff66,	0x0100,	0x0000,	9 },
{ 0xff70,	0x0110,	0x0000,	0 },
{ 0xff71,	0x0100,	0x0000,	44 },
{ 0xff9e,	0x0110,	0x0000,	1 },
{ 0xffa0,	0x0010,	0x0000,	0 },
{ 0xffa1,	0x0100,	0x0000,	50 },
{ 0xffe0,	0x0010,	0x0000,	13 },
};

CONST UINT UNICODE_DATA_SIZE = sizeof(UnicodeData)/sizeof(UnicodeDataRec);
CONST UINT UNICODE_DATA_DIRECT_ACCESS = 256;

#endif // !HAVE_COREFOUNDATION
