﻿// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using NuGet.Packaging.Core;

namespace NuGet.Protocol.Core.Types
{
    public abstract class PackageMetadataResource : INuGetResource
    {
        /// <summary>
        /// Returns all versions of a package
        /// </summary>
        public abstract Task<IEnumerable<IPackageSearchMetadata>> GetMetadataAsync(
            string packageId,
            bool includePrerelease,
            bool includeUnlisted,
            Common.ILogger log,
            CancellationToken token);

        /// <summary>
        /// Return package metadata for the input PackageIdentity
        /// </summary>
        public abstract Task<IPackageSearchMetadata> GetMetadataAsync(
            PackageIdentity package,
            Common.ILogger log,
            CancellationToken token);
    }
}
