"""Generated client library for monitoring version v3."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.monitoring.v3 import monitoring_v3_messages as messages


class MonitoringV3(base_api.BaseApiClient):
  """Generated client library for service monitoring version v3."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://monitoring.googleapis.com/'

  _PACKAGE = u'monitoring'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/monitoring', u'https://www.googleapis.com/auth/monitoring.read', u'https://www.googleapis.com/auth/monitoring.write']
  _VERSION = u'v3'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'MonitoringV3'
  _URL_VERSION = u'v3'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new monitoring handle."""
    url = url or self.BASE_URL
    super(MonitoringV3, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_alertPolicies = self.ProjectsAlertPoliciesService(self)
    self.projects_collectdTimeSeries = self.ProjectsCollectdTimeSeriesService(self)
    self.projects_groups_members = self.ProjectsGroupsMembersService(self)
    self.projects_groups = self.ProjectsGroupsService(self)
    self.projects_metricDescriptors = self.ProjectsMetricDescriptorsService(self)
    self.projects_monitoredResourceDescriptors = self.ProjectsMonitoredResourceDescriptorsService(self)
    self.projects_notificationChannelDescriptors = self.ProjectsNotificationChannelDescriptorsService(self)
    self.projects_notificationChannels = self.ProjectsNotificationChannelsService(self)
    self.projects_timeSeries = self.ProjectsTimeSeriesService(self)
    self.projects_uptimeCheckConfigs = self.ProjectsUptimeCheckConfigsService(self)
    self.projects = self.ProjectsService(self)
    self.uptimeCheckIps = self.UptimeCheckIpsService(self)

  class ProjectsAlertPoliciesService(base_api.BaseApiService):
    """Service class for the projects_alertPolicies resource."""

    _NAME = u'projects_alertPolicies'

    def __init__(self, client):
      super(MonitoringV3.ProjectsAlertPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new alerting policy.

      Args:
        request: (MonitoringProjectsAlertPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AlertPolicy) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/alertPolicies',
        http_method=u'POST',
        method_id=u'monitoring.projects.alertPolicies.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}/alertPolicies',
        request_field=u'alertPolicy',
        request_type_name=u'MonitoringProjectsAlertPoliciesCreateRequest',
        response_type_name=u'AlertPolicy',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an alerting policy.

      Args:
        request: (MonitoringProjectsAlertPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/alertPolicies/{alertPoliciesId}',
        http_method=u'DELETE',
        method_id=u'monitoring.projects.alertPolicies.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsAlertPoliciesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a single alerting policy.

      Args:
        request: (MonitoringProjectsAlertPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AlertPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/alertPolicies/{alertPoliciesId}',
        http_method=u'GET',
        method_id=u'monitoring.projects.alertPolicies.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsAlertPoliciesGetRequest',
        response_type_name=u'AlertPolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the existing alerting policies for the project.

      Args:
        request: (MonitoringProjectsAlertPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAlertPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/alertPolicies',
        http_method=u'GET',
        method_id=u'monitoring.projects.alertPolicies.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v3/{+name}/alertPolicies',
        request_field='',
        request_type_name=u'MonitoringProjectsAlertPoliciesListRequest',
        response_type_name=u'ListAlertPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an alerting policy. You can either replace the entire policy with a new one or replace only certain fields in the current alerting policy by specifying the fields to be updated via updateMask. Returns the updated alerting policy.

      Args:
        request: (MonitoringProjectsAlertPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AlertPolicy) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/alertPolicies/{alertPoliciesId}',
        http_method=u'PATCH',
        method_id=u'monitoring.projects.alertPolicies.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v3/{+name}',
        request_field=u'alertPolicy',
        request_type_name=u'MonitoringProjectsAlertPoliciesPatchRequest',
        response_type_name=u'AlertPolicy',
        supports_download=False,
    )

  class ProjectsCollectdTimeSeriesService(base_api.BaseApiService):
    """Service class for the projects_collectdTimeSeries resource."""

    _NAME = u'projects_collectdTimeSeries'

    def __init__(self, client):
      super(MonitoringV3.ProjectsCollectdTimeSeriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Stackdriver Monitoring Agent only: Creates a new time series.<aside class="caution">This method is only for use by the Stackdriver Monitoring Agent. Use projects.timeSeries.create instead.</aside>.

      Args:
        request: (MonitoringProjectsCollectdTimeSeriesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CreateCollectdTimeSeriesResponse) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/collectdTimeSeries',
        http_method=u'POST',
        method_id=u'monitoring.projects.collectdTimeSeries.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}/collectdTimeSeries',
        request_field=u'createCollectdTimeSeriesRequest',
        request_type_name=u'MonitoringProjectsCollectdTimeSeriesCreateRequest',
        response_type_name=u'CreateCollectdTimeSeriesResponse',
        supports_download=False,
    )

  class ProjectsGroupsMembersService(base_api.BaseApiService):
    """Service class for the projects_groups_members resource."""

    _NAME = u'projects_groups_members'

    def __init__(self, client):
      super(MonitoringV3.ProjectsGroupsMembersService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the monitored resources that are members of a group.

      Args:
        request: (MonitoringProjectsGroupsMembersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGroupMembersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/groups/{groupsId}/members',
        http_method=u'GET',
        method_id=u'monitoring.projects.groups.members.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'interval_endTime', u'interval_startTime', u'pageSize', u'pageToken'],
        relative_path=u'v3/{+name}/members',
        request_field='',
        request_type_name=u'MonitoringProjectsGroupsMembersListRequest',
        response_type_name=u'ListGroupMembersResponse',
        supports_download=False,
    )

  class ProjectsGroupsService(base_api.BaseApiService):
    """Service class for the projects_groups resource."""

    _NAME = u'projects_groups'

    def __init__(self, client):
      super(MonitoringV3.ProjectsGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new group.

      Args:
        request: (MonitoringProjectsGroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Group) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/groups',
        http_method=u'POST',
        method_id=u'monitoring.projects.groups.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'validateOnly'],
        relative_path=u'v3/{+name}/groups',
        request_field=u'group',
        request_type_name=u'MonitoringProjectsGroupsCreateRequest',
        response_type_name=u'Group',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing group.

      Args:
        request: (MonitoringProjectsGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/groups/{groupsId}',
        http_method=u'DELETE',
        method_id=u'monitoring.projects.groups.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsGroupsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a single group.

      Args:
        request: (MonitoringProjectsGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Group) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/groups/{groupsId}',
        http_method=u'GET',
        method_id=u'monitoring.projects.groups.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsGroupsGetRequest',
        response_type_name=u'Group',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the existing groups.

      Args:
        request: (MonitoringProjectsGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/groups',
        http_method=u'GET',
        method_id=u'monitoring.projects.groups.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'ancestorsOfGroup', u'childrenOfGroup', u'descendantsOfGroup', u'pageSize', u'pageToken'],
        relative_path=u'v3/{+name}/groups',
        request_field='',
        request_type_name=u'MonitoringProjectsGroupsListRequest',
        response_type_name=u'ListGroupsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an existing group. You can change any group attributes except name.

      Args:
        request: (MonitoringProjectsGroupsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Group) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/groups/{groupsId}',
        http_method=u'PUT',
        method_id=u'monitoring.projects.groups.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'validateOnly'],
        relative_path=u'v3/{+name}',
        request_field=u'group',
        request_type_name=u'MonitoringProjectsGroupsUpdateRequest',
        response_type_name=u'Group',
        supports_download=False,
    )

  class ProjectsMetricDescriptorsService(base_api.BaseApiService):
    """Service class for the projects_metricDescriptors resource."""

    _NAME = u'projects_metricDescriptors'

    def __init__(self, client):
      super(MonitoringV3.ProjectsMetricDescriptorsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new metric descriptor. User-created metric descriptors define custom metrics.

      Args:
        request: (MetricDescriptor) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MetricDescriptor) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/metricDescriptors',
        http_method=u'POST',
        method_id=u'monitoring.projects.metricDescriptors.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}/metricDescriptors',
        request_field='<request>',
        request_type_name=u'MetricDescriptor',
        response_type_name=u'MetricDescriptor',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a metric descriptor. Only user-created custom metrics can be deleted.

      Args:
        request: (MonitoringProjectsMetricDescriptorsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/metricDescriptors/{metricDescriptorsId}',
        http_method=u'DELETE',
        method_id=u'monitoring.projects.metricDescriptors.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsMetricDescriptorsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a single metric descriptor. This method does not require a Stackdriver account.

      Args:
        request: (MonitoringProjectsMetricDescriptorsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MetricDescriptor) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/metricDescriptors/{metricDescriptorsId}',
        http_method=u'GET',
        method_id=u'monitoring.projects.metricDescriptors.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsMetricDescriptorsGetRequest',
        response_type_name=u'MetricDescriptor',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists metric descriptors that match a filter. This method does not require a Stackdriver account.

      Args:
        request: (MonitoringProjectsMetricDescriptorsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMetricDescriptorsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/metricDescriptors',
        http_method=u'GET',
        method_id=u'monitoring.projects.metricDescriptors.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v3/{+name}/metricDescriptors',
        request_field='',
        request_type_name=u'MonitoringProjectsMetricDescriptorsListRequest',
        response_type_name=u'ListMetricDescriptorsResponse',
        supports_download=False,
    )

  class ProjectsMonitoredResourceDescriptorsService(base_api.BaseApiService):
    """Service class for the projects_monitoredResourceDescriptors resource."""

    _NAME = u'projects_monitoredResourceDescriptors'

    def __init__(self, client):
      super(MonitoringV3.ProjectsMonitoredResourceDescriptorsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a single monitored resource descriptor. This method does not require a Stackdriver account.

      Args:
        request: (MonitoringProjectsMonitoredResourceDescriptorsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MonitoredResourceDescriptor) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/monitoredResourceDescriptors/{monitoredResourceDescriptorsId}',
        http_method=u'GET',
        method_id=u'monitoring.projects.monitoredResourceDescriptors.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsMonitoredResourceDescriptorsGetRequest',
        response_type_name=u'MonitoredResourceDescriptor',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists monitored resource descriptors that match a filter. This method does not require a Stackdriver account.

      Args:
        request: (MonitoringProjectsMonitoredResourceDescriptorsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMonitoredResourceDescriptorsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/monitoredResourceDescriptors',
        http_method=u'GET',
        method_id=u'monitoring.projects.monitoredResourceDescriptors.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v3/{+name}/monitoredResourceDescriptors',
        request_field='',
        request_type_name=u'MonitoringProjectsMonitoredResourceDescriptorsListRequest',
        response_type_name=u'ListMonitoredResourceDescriptorsResponse',
        supports_download=False,
    )

  class ProjectsNotificationChannelDescriptorsService(base_api.BaseApiService):
    """Service class for the projects_notificationChannelDescriptors resource."""

    _NAME = u'projects_notificationChannelDescriptors'

    def __init__(self, client):
      super(MonitoringV3.ProjectsNotificationChannelDescriptorsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a single channel descriptor. The descriptor indicates which fields are expected / permitted for a notification channel of the given type.

      Args:
        request: (MonitoringProjectsNotificationChannelDescriptorsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationChannelDescriptor) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannelDescriptors/{notificationChannelDescriptorsId}',
        http_method=u'GET',
        method_id=u'monitoring.projects.notificationChannelDescriptors.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsNotificationChannelDescriptorsGetRequest',
        response_type_name=u'NotificationChannelDescriptor',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the descriptors for supported channel types. The use of descriptors makes it possible for new channel types to be dynamically added.

      Args:
        request: (MonitoringProjectsNotificationChannelDescriptorsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNotificationChannelDescriptorsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannelDescriptors',
        http_method=u'GET',
        method_id=u'monitoring.projects.notificationChannelDescriptors.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v3/{+name}/notificationChannelDescriptors',
        request_field='',
        request_type_name=u'MonitoringProjectsNotificationChannelDescriptorsListRequest',
        response_type_name=u'ListNotificationChannelDescriptorsResponse',
        supports_download=False,
    )

  class ProjectsNotificationChannelsService(base_api.BaseApiService):
    """Service class for the projects_notificationChannels resource."""

    _NAME = u'projects_notificationChannels'

    def __init__(self, client):
      super(MonitoringV3.ProjectsNotificationChannelsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new notification channel, representing a single notification endpoint such as an email address, SMS number, or pagerduty service.

      Args:
        request: (MonitoringProjectsNotificationChannelsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationChannel) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannels',
        http_method=u'POST',
        method_id=u'monitoring.projects.notificationChannels.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}/notificationChannels',
        request_field=u'notificationChannel',
        request_type_name=u'MonitoringProjectsNotificationChannelsCreateRequest',
        response_type_name=u'NotificationChannel',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a notification channel.

      Args:
        request: (MonitoringProjectsNotificationChannelsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}',
        http_method=u'DELETE',
        method_id=u'monitoring.projects.notificationChannels.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'force'],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsNotificationChannelsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a single notification channel. The channel includes the relevant configuration details with which the channel was created. However, the response may truncate or omit passwords, API keys, or other private key matter and thus the response may not be 100% identical to the information that was supplied in the call to the create method.

      Args:
        request: (MonitoringProjectsNotificationChannelsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationChannel) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}',
        http_method=u'GET',
        method_id=u'monitoring.projects.notificationChannels.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsNotificationChannelsGetRequest',
        response_type_name=u'NotificationChannel',
        supports_download=False,
    )

    def GetVerificationCode(self, request, global_params=None):
      r"""Requests a verification code for an already verified channel that can then be used in a call to VerifyNotificationChannel() on a different channel with an equivalent identity in the same or in a different project. This makes it possible to copy a channel between projects without requiring manual reverification of the channel. If the channel is not in the verified state, this method will fail (in other words, this may only be used if the SendNotificationChannelVerificationCode and VerifyNotificationChannel paths have already been used to put the given channel into the verified state).There is no guarantee that the verification codes returned by this method will be of a similar structure or form as the ones that are delivered to the channel via SendNotificationChannelVerificationCode; while VerifyNotificationChannel() will recognize both the codes delivered via SendNotificationChannelVerificationCode() and returned from GetNotificationChannelVerificationCode(), it is typically the case that the verification codes delivered via SendNotificationChannelVerificationCode() will be shorter and also have a shorter expiration (e.g. codes such as "G-123456") whereas GetVerificationCode() will typically return a much longer, websafe base 64 encoded string that has a longer expiration time.

      Args:
        request: (MonitoringProjectsNotificationChannelsGetVerificationCodeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetNotificationChannelVerificationCodeResponse) The response message.
      """
      config = self.GetMethodConfig('GetVerificationCode')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetVerificationCode.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}:getVerificationCode',
        http_method=u'POST',
        method_id=u'monitoring.projects.notificationChannels.getVerificationCode',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}:getVerificationCode',
        request_field=u'getNotificationChannelVerificationCodeRequest',
        request_type_name=u'MonitoringProjectsNotificationChannelsGetVerificationCodeRequest',
        response_type_name=u'GetNotificationChannelVerificationCodeResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the notification channels that have been created for the project.

      Args:
        request: (MonitoringProjectsNotificationChannelsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNotificationChannelsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannels',
        http_method=u'GET',
        method_id=u'monitoring.projects.notificationChannels.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v3/{+name}/notificationChannels',
        request_field='',
        request_type_name=u'MonitoringProjectsNotificationChannelsListRequest',
        response_type_name=u'ListNotificationChannelsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a notification channel. Fields not specified in the field mask remain unchanged.

      Args:
        request: (MonitoringProjectsNotificationChannelsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationChannel) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}',
        http_method=u'PATCH',
        method_id=u'monitoring.projects.notificationChannels.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v3/{+name}',
        request_field=u'notificationChannel',
        request_type_name=u'MonitoringProjectsNotificationChannelsPatchRequest',
        response_type_name=u'NotificationChannel',
        supports_download=False,
    )

    def SendVerificationCode(self, request, global_params=None):
      r"""Causes a verification code to be delivered to the channel. The code can then be supplied in VerifyNotificationChannel to verify the channel.

      Args:
        request: (MonitoringProjectsNotificationChannelsSendVerificationCodeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('SendVerificationCode')
      return self._RunMethod(
          config, request, global_params=global_params)

    SendVerificationCode.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}:sendVerificationCode',
        http_method=u'POST',
        method_id=u'monitoring.projects.notificationChannels.sendVerificationCode',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}:sendVerificationCode',
        request_field=u'sendNotificationChannelVerificationCodeRequest',
        request_type_name=u'MonitoringProjectsNotificationChannelsSendVerificationCodeRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Verify(self, request, global_params=None):
      r"""Verifies a NotificationChannel by proving receipt of the code delivered to the channel as a result of calling SendNotificationChannelVerificationCode.

      Args:
        request: (MonitoringProjectsNotificationChannelsVerifyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationChannel) The response message.
      """
      config = self.GetMethodConfig('Verify')
      return self._RunMethod(
          config, request, global_params=global_params)

    Verify.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}:verify',
        http_method=u'POST',
        method_id=u'monitoring.projects.notificationChannels.verify',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}:verify',
        request_field=u'verifyNotificationChannelRequest',
        request_type_name=u'MonitoringProjectsNotificationChannelsVerifyRequest',
        response_type_name=u'NotificationChannel',
        supports_download=False,
    )

  class ProjectsTimeSeriesService(base_api.BaseApiService):
    """Service class for the projects_timeSeries resource."""

    _NAME = u'projects_timeSeries'

    def __init__(self, client):
      super(MonitoringV3.ProjectsTimeSeriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates or adds data to one or more time series. The response is empty if all time series in the request were written. If any time series could not be written, a corresponding failure message is included in the error response.

      Args:
        request: (MonitoringProjectsTimeSeriesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/timeSeries',
        http_method=u'POST',
        method_id=u'monitoring.projects.timeSeries.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}/timeSeries',
        request_field=u'createTimeSeriesRequest',
        request_type_name=u'MonitoringProjectsTimeSeriesCreateRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists time series that match a filter. This method does not require a Stackdriver account.

      Args:
        request: (MonitoringProjectsTimeSeriesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTimeSeriesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/timeSeries',
        http_method=u'GET',
        method_id=u'monitoring.projects.timeSeries.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'aggregation_alignmentPeriod', u'aggregation_crossSeriesReducer', u'aggregation_groupByFields', u'aggregation_perSeriesAligner', u'filter', u'interval_endTime', u'interval_startTime', u'orderBy', u'pageSize', u'pageToken', u'view'],
        relative_path=u'v3/{+name}/timeSeries',
        request_field='',
        request_type_name=u'MonitoringProjectsTimeSeriesListRequest',
        response_type_name=u'ListTimeSeriesResponse',
        supports_download=False,
    )

  class ProjectsUptimeCheckConfigsService(base_api.BaseApiService):
    """Service class for the projects_uptimeCheckConfigs resource."""

    _NAME = u'projects_uptimeCheckConfigs'

    def __init__(self, client):
      super(MonitoringV3.ProjectsUptimeCheckConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new uptime check configuration.

      Args:
        request: (MonitoringProjectsUptimeCheckConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UptimeCheckConfig) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/uptimeCheckConfigs',
        http_method=u'POST',
        method_id=u'monitoring.projects.uptimeCheckConfigs.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v3/{+parent}/uptimeCheckConfigs',
        request_field=u'uptimeCheckConfig',
        request_type_name=u'MonitoringProjectsUptimeCheckConfigsCreateRequest',
        response_type_name=u'UptimeCheckConfig',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an uptime check configuration. Note that this method will fail if the uptime check configuration is referenced by an alert policy or other dependent configs that would be rendered invalid by the deletion.

      Args:
        request: (MonitoringProjectsUptimeCheckConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/uptimeCheckConfigs/{uptimeCheckConfigsId}',
        http_method=u'DELETE',
        method_id=u'monitoring.projects.uptimeCheckConfigs.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsUptimeCheckConfigsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a single uptime check configuration.

      Args:
        request: (MonitoringProjectsUptimeCheckConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UptimeCheckConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/uptimeCheckConfigs/{uptimeCheckConfigsId}',
        http_method=u'GET',
        method_id=u'monitoring.projects.uptimeCheckConfigs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v3/{+name}',
        request_field='',
        request_type_name=u'MonitoringProjectsUptimeCheckConfigsGetRequest',
        response_type_name=u'UptimeCheckConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the existing valid uptime check configurations for the project, leaving out any invalid configurations.

      Args:
        request: (MonitoringProjectsUptimeCheckConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListUptimeCheckConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/uptimeCheckConfigs',
        http_method=u'GET',
        method_id=u'monitoring.projects.uptimeCheckConfigs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v3/{+parent}/uptimeCheckConfigs',
        request_field='',
        request_type_name=u'MonitoringProjectsUptimeCheckConfigsListRequest',
        response_type_name=u'ListUptimeCheckConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an uptime check configuration. You can either replace the entire configuration with a new one or replace only certain fields in the current configuration by specifying the fields to be updated via "updateMask". Returns the updated configuration.

      Args:
        request: (MonitoringProjectsUptimeCheckConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UptimeCheckConfig) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v3/projects/{projectsId}/uptimeCheckConfigs/{uptimeCheckConfigsId}',
        http_method=u'PATCH',
        method_id=u'monitoring.projects.uptimeCheckConfigs.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v3/{+name}',
        request_field=u'uptimeCheckConfig',
        request_type_name=u'MonitoringProjectsUptimeCheckConfigsPatchRequest',
        response_type_name=u'UptimeCheckConfig',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(MonitoringV3.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class UptimeCheckIpsService(base_api.BaseApiService):
    """Service class for the uptimeCheckIps resource."""

    _NAME = u'uptimeCheckIps'

    def __init__(self, client):
      super(MonitoringV3.UptimeCheckIpsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns the list of IPs that checkers run from.

      Args:
        request: (MonitoringUptimeCheckIpsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListUptimeCheckIpsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'monitoring.uptimeCheckIps.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v3/uptimeCheckIps',
        request_field='',
        request_type_name=u'MonitoringUptimeCheckIpsListRequest',
        response_type_name=u'ListUptimeCheckIpsResponse',
        supports_download=False,
    )
