# Copyright 2019 Alibaba Cloud Inc. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import json
import os.path
import aliyunsdkcore


def _load_json_from_data_dir(basename):
    base_dir = os.path.dirname(os.path.abspath(aliyunsdkcore.__file__))
    json_file = os.path.join(base_dir, "data", basename)
    with open(json_file) as fp:
        return json.loads(fp.read())
