# Copyright 2018 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# pylint: disable=g-import-not-at-top
"""Classes and methods for predictions on a trained machine learning model.
"""
from ._interfaces import Model
from ._interfaces import PredictionClient

from .prediction_lib import BaseModel
from .prediction_lib import canonicalize_single_tensor_input
from .prediction_lib import columnarize
from .prediction_lib import COLUMNARIZE_TIME
from .prediction_lib import create_client
from .prediction_lib import create_model
from .prediction_lib import create_sklearn_model
from .prediction_lib import create_xgboost_model
from .prediction_lib import decode_base64
from .prediction_lib import encode_base64
from .prediction_lib import ENGINE
from .prediction_lib import FRAMEWORK
from .prediction_lib import INPUTS_KEY
from .prediction_lib import load_model
from .prediction_lib import local_predict
from .prediction_lib import OUTPUTS_KEY
from .prediction_lib import PredictionError
from .prediction_lib import rowify
from .prediction_lib import ROWIFY_TIME
from .prediction_lib import SCIKIT_LEARN_FRAMEWORK_NAME
from .prediction_lib import SESSION_RUN_ENGINE_NAME
from .prediction_lib import SESSION_RUN_TIME
from .prediction_lib import SessionClient
from .prediction_lib import SklearnModel
from .prediction_lib import Stats
from .prediction_lib import TENSORFLOW_FRAMEWORK_NAME
from .prediction_lib import TensorFlowClient
from .prediction_lib import TensorFlowModel
from .prediction_lib import Timer
from .prediction_lib import XGBOOST_FRAMEWORK_NAME
from .prediction_lib import XGBoostModel
