# Copyright 2015 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""A command that lists the resource collections for a given API."""

from __future__ import absolute_import
from __future__ import unicode_literals

from apitools.base.protorpclite import messages as _messages
from googlecloudsdk.calliope import base
from googlecloudsdk.command_lib.meta.apis import flags
from googlecloudsdk.command_lib.util.apis import registry


class List(base.ListCommand):
  """List the proto messages for an API."""

  @staticmethod
  def Args(parser):
    base.PAGE_SIZE_FLAG.RemoveFromParser(parser)
    base.URI_FLAG.RemoveFromParser(parser)
    flags.API_REQUIRED_FLAG.AddToParser(parser)
    flags.API_VERSION_FLAG.AddToParser(parser)
    parser.display_info.AddFormat('table(name)')

  def Run(self, args):
    api = registry.GetAPI(args.api, api_version=args.api_version)
    messages_module = api.GetMessagesModule()
    messages = [
        m for m in messages_module.__dict__.values()
        if issubclass(type(m), type) and issubclass(m, _messages.Message)]
    return [{'name': m.__name__} for m in messages]
