/* Generated by re2c */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef PHP_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename();
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle)
{
	const char *file_path = NULL;
	char *buf;
	size_t size, offset = 0;
	zend_string *compiled_filename;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, (unsigned int)size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	compiled_filename = zend_string_init(file_path, strlen(file_path), 0);
	zend_set_compiled_filename(compiled_filename);
	zend_string_release(compiled_filename);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	int compiler_result;
	zend_bool compilation_successful=0;
	zval retval_zv;
	zend_bool original_in_compilation = CG(in_compilation);

	ZVAL_LONG(&retval_zv, 1);

	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context));
		zend_init_compiler_context();
		CG(ast_arena) = zend_arena_create(1024 * 32);
		compiler_result = zendparse();
		if (compiler_result != 0) { /* parser error */
			zend_bailout();
		}
		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}
		zend_compile_top_stmt(CG(ast));
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		zend_do_end_compilation();
		zend_emit_final_return(&retval_zv);
		CG(in_compilation) = original_in_compilation;
		compilation_successful=1;
	}

	CG(active_op_array) = original_active_op_array;
	if (compilation_successful) {
		pass_two(op_array);
		zend_release_labels(0);
	} else {
		efree_size(op_array, sizeof(zend_op_array));
		op_array = NULL;
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}


zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = Z_STRVAL_P(filename);
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(Z_STRVAL_P(filename), Z_STRLEN_P(filename));
		}

		zend_hash_str_add_empty_element(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path));

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_realloc(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, (unsigned int)size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release(new_compiled_filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;
	zend_bool original_in_compilation = CG(in_compilation);

	if (Z_STRLEN_P(source_string)==0) {
		return NULL;
	}

	ZVAL_DUP(&tmp, source_string);
	convert_to_string(&tmp);
	source_string = &tmp;

	CG(in_compilation) = 1;
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(source_string, filename) == SUCCESS) {
		CG(ast) = NULL;
		CG(ast_arena) = zend_arena_create(1024 * 32);
		BEGIN(ST_IN_SCRIPTING);

		if (!zendparse()) {
			zend_op_array *original_active_op_array = CG(active_op_array);
			op_array = emalloc(sizeof(zend_op_array));
			init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE);
			CG(active_op_array) = op_array;

			zend_stack_push(&CG(context_stack), (void *) &CG(context));
			zend_init_compiler_context();
			if (zend_ast_process) {
				zend_ast_process(CG(ast));
			}
			zend_compile_top_stmt(CG(ast));
			zend_do_end_compilation();
			zend_emit_final_return(NULL);
			pass_two(op_array);
			zend_release_labels(0);

			CG(active_op_array) = original_active_op_array;
		}

		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
	}

	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return op_array;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(str, str_name)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'r':
					*t++ = '\r';
					Z_STRLEN_P(zendlval)--;
					break;
				case 't':
					*t++ = '\t';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'f':
					*t++ = '\f';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'v':
					*t++ = '\v';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'e':
#ifdef PHP_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					Z_STRLEN_P(zendlval)--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						Z_STRLEN_P(zendlval)--; /* for the 'x' */

						hex_buf[0] = *(++s);
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;
						size_t byte_len = 0;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_error(E_COMPILE_ERROR, "Invalid UTF-8 codepoint escape sequence");
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_error_noreturn(E_COMPILE_ERROR, "Invalid UTF-8 codepoint escape sequence: Codepoint too large");
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							byte_len = 1;
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							byte_len = 2;
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							byte_len = 3;
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							byte_len = 4;
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}

						Z_STRLEN_P(zendlval) -= 2; /* \u */
						Z_STRLEN_P(zendlval) -= (len - byte_len);
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								Z_STRLEN_P(zendlval)--;
							}
						}
						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
}


int lex_scan(zval *zendlval)
{
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[10] = {
		&&yyc_ST_IN_SCRIPTING,
		&&yyc_ST_LOOKING_FOR_PROPERTY,
		&&yyc_ST_BACKQUOTE,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_HEREDOC,
		&&yyc_ST_LOOKING_FOR_VARNAME,
		&&yyc_ST_VAR_OFFSET,
		&&yyc_INITIAL,
		&&yyc_ST_END_HEREDOC,
		&&yyc_ST_NOWDOC,
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(1, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych != '<') goto yy5;
	YYDEBUG(3, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '?') goto yy6;
yy4:
	YYDEBUG(4, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */

				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy4;
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy8;
	} else {
		if (yych <= 'P') goto yy10;
		if (yych == 'p') goto yy10;
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy8:
	YYDEBUG(8, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(9, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG_WITH_ECHO;
}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy12;
	if (yych == 'h') goto yy12;
yy11:
	YYDEBUG(11, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy7;
yy12:
	YYDEBUG(12, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy13;
	if (yych != 'p') goto yy11;
yy13:
	YYDEBUG(13, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy11;
		if (yych >= '\v') goto yy11;
	} else {
		if (yych <= '\r') goto yy16;
		if (yych != ' ') goto yy11;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	++YYCURSOR;
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
yy16:
	YYDEBUG(16, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '\n') goto yy14;
	goto yy15;
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(17, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy24;
		} else {
			if (yych <= '`') goto yy22;
			if (yych == '{') goto yy21;
			goto yy24;
		}
		YYDEBUG(19, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20,
				&&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20,
				&&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20,
				&&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20,
				&&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20,
				&&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20,
				&&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20,
				&&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20, &&yy20,
				&&yy20, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy20, &&yy20, &&yy20, &&yy20, &&yy27,
				&&yy20, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy30, &&yy20, &&yy20, &&yy20, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`');
	return T_ENCAPSED_AND_WHITESPACE;
}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy25;
		goto yy20;
yy22:
		YYDEBUG(22, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(23, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy20;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	return T_CURLY_OPEN;
}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy27;
		}
		if (yych == '-') goto yy32;
		if (yych <= '@') goto yy29;
		if (yych <= '[') goto yy34;
yy29:
		YYDEBUG(29, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy30:
		YYDEBUG(30, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(31, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy36;
yy33:
		YYDEBUG(33, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy29;
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(35, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy33;
			if (yych <= 'Z') goto yy37;
			if (yych <= '^') goto yy33;
		} else {
			if (yych <= '`') goto yy33;
			if (yych <= 'z') goto yy37;
			if (yych <= '~') goto yy33;
		}
yy37:
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(38, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(39, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy44;
			goto yy46;
		} else {
			if (yych <= '$') goto yy41;
			if (yych == '{') goto yy43;
			goto yy46;
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy42, &&yy42, &&yy42, &&yy42, &&yy49,
				&&yy42, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy52, &&yy42, &&yy42, &&yy42, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49,
				&&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49, &&yy49
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"');
	return T_ENCAPSED_AND_WHITESPACE;
}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy47;
		goto yy42;
yy44:
		YYDEBUG(44, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(45, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy42;
yy47:
		YYDEBUG(47, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(48, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	return T_CURLY_OPEN;
}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(50, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy49;
		}
		if (yych == '-') goto yy54;
		if (yych <= '@') goto yy51;
		if (yych <= '[') goto yy56;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(53, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy58;
yy55:
		YYDEBUG(55, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy51;
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(57, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy58:
		YYDEBUG(58, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy55;
			if (yych <= 'Z') goto yy59;
			if (yych <= '^') goto yy55;
		} else {
			if (yych <= '`') goto yy55;
			if (yych <= 'z') goto yy59;
			if (yych <= '~') goto yy55;
		}
yy59:
		YYDEBUG(59, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(60, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(61, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(63, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(64, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(65, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy67;
		if (yych == '{') goto yy69;
		goto yy70;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy68, &&yy68, &&yy68, &&yy68, &&yy73,
				&&yy68, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy76, &&yy68, &&yy68, &&yy68, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy68:
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy71;
		goto yy68;
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy68;
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(72, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	return T_CURLY_OPEN;
}
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy73;
		}
		if (yych == '-') goto yy78;
		if (yych <= '@') goto yy75;
		if (yych <= '[') goto yy80;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy82;
yy79:
		YYDEBUG(79, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy75;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy79;
			if (yych <= 'Z') goto yy83;
			if (yych <= '^') goto yy79;
		} else {
			if (yych <= '`') goto yy79;
			if (yych <= 'z') goto yy83;
			if (yych <= '~') goto yy79;
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 60,  60,  44,  44,  44,  44,  44,  44, 
			 44,  44,   0,   0,   0,   0,   0,   0, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
		};
		YYDEBUG(85, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy148, &&yy148, &&yy148, &&yy148, &&yy148, &&yy148, &&yy148, &&yy148,
				&&yy148, &&yy104, &&yy104, &&yy148, &&yy148, &&yy104, &&yy148, &&yy148,
				&&yy148, &&yy148, &&yy148, &&yy148, &&yy148, &&yy148, &&yy148, &&yy148,
				&&yy148, &&yy148, &&yy148, &&yy148, &&yy148, &&yy148, &&yy148, &&yy148,
				&&yy104, &&yy119, &&yy144, &&yy140, &&yy130, &&yy124, &&yy125, &&yy142,
				&&yy113, &&yy131, &&yy122, &&yy118, &&yy131, &&yy102, &&yy109, &&yy123,
				&&yy136, &&yy138, &&yy138, &&yy138, &&yy138, &&yy138, &&yy138, &&yy138,
				&&yy138, &&yy138, &&yy106, &&yy131, &&yy120, &&yy116, &&yy121, &&yy110,
				&&yy131, &&yy97,  &&yy99,  &&yy91,  &&yy89,  &&yy87,  &&yy90,  &&yy100,
				&&yy139, &&yy95,  &&yy139, &&yy139, &&yy117, &&yy139, &&yy111, &&yy128,
				&&yy101, &&yy139, &&yy92,  &&yy98,  &&yy94,  &&yy114, &&yy112, &&yy96,
				&&yy129, &&yy93,  &&yy139, &&yy131, &&yy107, &&yy131, &&yy127, &&yy115,
				&&yy146, &&yy97,  &&yy99,  &&yy91,  &&yy89,  &&yy87,  &&yy90,  &&yy100,
				&&yy139, &&yy95,  &&yy139, &&yy139, &&yy117, &&yy139, &&yy111, &&yy128,
				&&yy101, &&yy139, &&yy92,  &&yy98,  &&yy94,  &&yy114, &&yy112, &&yy96,
				&&yy129, &&yy93,  &&yy139, &&yy132, &&yy126, &&yy134, &&yy131, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139,
				&&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139, &&yy139
			};
			goto *yytarget[yych];
		}
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy696, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy697, &&yy698, &&yy699, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy700, &&yy151,
				&&yy701, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy696, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy697, &&yy698, &&yy699, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy700, &&yy151,
				&&yy701, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	return T_STRING;
}
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy678, &&yy151, &&yy151,
				&&yy151, &&yy679, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy680,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy678, &&yy151, &&yy151,
				&&yy151, &&yy679, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy680,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy654, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy655,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy656, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy654, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy655,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy656, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy619, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy620, &&yy151, &&yy151, &&yy621,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy619, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy620, &&yy151, &&yy151, &&yy621,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy601;
		if (yych == 'e') goto yy601;
		goto yy151;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy596;
		if (yych == 'i') goto yy596;
		goto yy151;
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy584, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy585, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy584, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy585, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy531, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy533, &&yy534, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy535, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy531, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy533, &&yy534, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy535, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy526;
		if (yych == 'h') goto yy526;
		goto yy151;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy508, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy509, &&yy151,
				&&yy151, &&yy151, &&yy510, &&yy511, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy508, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy509, &&yy151,
				&&yy151, &&yy151, &&yy510, &&yy511, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy496, &&yy151, &&yy151, &&yy497,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy496, &&yy151, &&yy151, &&yy497,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy488, &&yy151, &&yy151, &&yy151, &&yy151, &&yy489,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy487, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy490, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy490, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy477, &&yy151, &&yy151, &&yy478,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy477, &&yy151, &&yy151, &&yy478,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy453, &&yy151, &&yy151, &&yy454, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy453, &&yy151, &&yy151, &&yy454, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy449;
		} else {
			if (yych <= '=') goto yy447;
			if (yych <= '>') goto yy451;
		}
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return yytext[0];
}
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy446;
yy105:
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy443;
		goto yy103;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NS_SEPARATOR;
}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy440;
			goto yy103;
		} else {
			if (yych <= '9') goto yy436;
			if (yych == '=') goto yy438;
			goto yy103;
		}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '=') goto yy103;
		if (yych <= '>') goto yy430;
		if (yych <= '?') goto yy432;
		goto yy103;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy418, &&yy151, &&yy151, &&yy151, &&yy419, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy418, &&yy151, &&yy151, &&yy151, &&yy419, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy415;
		if (yych == 'a') goto yy415;
		goto yy151;
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy340, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy340, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy340, &&yy340, &&yy103, &&yy340, &&yy103, &&yy340, &&yy103,
				&&yy103, &&yy340, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy340,
				&&yy103, &&yy103, &&yy340, &&yy340, &&yy103, &&yy340, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy340, &&yy340, &&yy103, &&yy340, &&yy103, &&yy340, &&yy103,
				&&yy103, &&yy340, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy340,
				&&yy103, &&yy103, &&yy340, &&yy340, &&yy103, &&yy340, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103
			};
			goto *yytarget[yych];
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy331, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy332, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy331, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy332, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy115:
		YYDEBUG(115, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy249;
		goto yy151;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy103;
		if (yych <= '=') goto yy243;
		if (yych <= '>') goto yy245;
		goto yy103;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy239;
		if (yych == 'i') goto yy239;
		goto yy151;
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy237;
		if (yych == '=') goto yy235;
		goto yy103;
yy119:
		YYDEBUG(119, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy232;
		goto yy103;
yy120:
		YYDEBUG(120, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy103;
		if (yych <= '<') goto yy210;
		if (yych <= '=') goto yy212;
		if (yych <= '>') goto yy214;
		goto yy103;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy103;
		if (yych <= '=') goto yy206;
		if (yych <= '>') goto yy204;
		goto yy103;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy198;
		if (yych == '=') goto yy200;
		goto yy103;
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy190;
			goto yy103;
		} else {
			if (yych <= '/') goto yy192;
			if (yych == '=') goto yy193;
			goto yy103;
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy188;
		goto yy103;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy184;
		if (yych == '=') goto yy186;
		goto yy103;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy182;
		if (yych == '|') goto yy180;
		goto yy103;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy178;
		goto yy103;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy176;
		if (yych == 'r') goto yy176;
		goto yy151;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy173;
		if (yych == 'o') goto yy173;
		goto yy151;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy103;
			if (yych <= 'Z') goto yy170;
			if (yych <= '^') goto yy103;
			goto yy170;
		} else {
			if (yych <= '`') goto yy103;
			if (yych <= 'z') goto yy170;
			if (yych <= '~') goto yy103;
			goto yy170;
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy103;
yy132:
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(133, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	return '{';
}
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	return '}';
}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy152, &&yy137,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy163, &&yy137, &&yy137, &&yy157, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy163, &&yy137, &&yy137, &&yy157, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *end;
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		/* This isn't an assert, we need to ensure 019 isn't valid octal
		 * Because the lexing itself doesn't do that for us
		 */
		if (end != yytext + yyleng) {
			zend_error_noreturn(E_COMPILE_ERROR, "Invalid numeric literal");
		}
		ZEND_ASSERT(!errno);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (yytext[0] == '0') { /* octal overflow */
				errno = 0;
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(yytext, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(yytext, (const char **)&end));
			}
			/* Also not an assert for the same reason */
			if (end != yytext + yyleng) {
				zend_error_noreturn(E_COMPILE_ERROR, "Invalid numeric literal");
			}
			ZEND_ASSERT(!errno);
			return T_DNUMBER;
		}
		/* Also not an assert for the same reason */
		if (end != yytext + yyleng) {
			zend_error_noreturn(E_COMPILE_ERROR, "Invalid numeric literal");
		}
		ZEND_ASSERT(!errno);
	}
	return T_LNUMBER;
}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy152, &&yy137,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy157, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy157, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy151;
yy140:
		YYDEBUG(140, *YYCURSOR);
		++YYCURSOR;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		ZVAL_STRINGL(zendlval, str, sz);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"');
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
yy146:
		YYDEBUG(146, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(147, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy150:
		YYDEBUG(150, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy151:
		YYDEBUG(151, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy150;
		}
		goto yy88;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(153, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy152;
		}
		if (yych == 'E') goto yy157;
		if (yych == 'e') goto yy157;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;

	ZVAL_DOUBLE(zendlval, zend_strtod(yytext, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == yytext + yyleng);
	return T_DNUMBER;
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(156, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy152, &&yy137,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy157, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy157, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy159;
		} else {
			if (yych <= '-') goto yy159;
			if (yych <= '/') goto yy158;
			if (yych <= '9') goto yy160;
		}
yy158:
		YYDEBUG(158, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy88;
				} else {
					goto yy103;
				}
			} else {
				goto yy137;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy154;
				} else {
					goto yy191;
				}
			} else {
				goto yy211;
			}
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy158;
		if (yych >= ':') goto yy158;
yy160:
		YYDEBUG(160, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(161, *YYCURSOR);
		if (yych <= '/') goto yy154;
		if (yych <= '9') goto yy160;
		goto yy154;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy167;
		}
		goto yy158;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy164;
		}
		goto yy158;
yy164:
		YYDEBUG(164, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(165, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy164;
		}
		YYDEBUG(166, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == yytext + yyleng);
		}
		return T_LNUMBER;
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == yytext + yyleng);
		return T_DNUMBER;
	}
}
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(168, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy167;
		}
		YYDEBUG(169, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		return T_LNUMBER;
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		return T_DNUMBER;
	}
}
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(171, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172,
				&&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172,
				&&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172,
				&&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172,
				&&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172,
				&&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172, &&yy172,
				&&yy172, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy172, &&yy172, &&yy172, &&yy172, &&yy170,
				&&yy172, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy172, &&yy172, &&yy172, &&yy172, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170,
				&&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170, &&yy170
			};
			goto *yytarget[yych];
		}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy174;
		if (yych != 'r') goto yy151;
yy174:
		YYDEBUG(174, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(175, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_XOR;
}
yy176:
		YYDEBUG(176, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(177, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_OR;
}
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_XOR_EQUAL;
}
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_OR;
}
yy182:
		YYDEBUG(182, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(183, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OR_EQUAL;
}
yy184:
		YYDEBUG(184, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(185, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_AND;
}
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AND_EQUAL;
}
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MOD_EQUAL;
}
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy195;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
yy192:
		YYDEBUG(192, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy141;
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DIV_EQUAL;
}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy196;
		}
		goto yy158;
yy196:
		YYDEBUG(196, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(197, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy196;
		}
		goto yy191;
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy202;
		YYDEBUG(199, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_POW;
}
yy200:
		YYDEBUG(200, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(201, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MUL_EQUAL;
}
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(203, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_POW_EQUAL;
}
yy204:
		YYDEBUG(204, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy208;
		YYDEBUG(205, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR;
}
yy206:
		YYDEBUG(206, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(207, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_GREATER_OR_EQUAL;
}
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(209, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR_EQUAL;
}
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy211;
		if (yych <= '<') goto yy218;
		if (yych <= '=') goto yy216;
yy211:
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL;
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_SMALLER_OR_EQUAL;
}
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
yy215:
		YYDEBUG(215, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_EQUAL;
}
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL_EQUAL;
}
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(219, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy218, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy218, &&yy158, &&yy223, &&yy158, &&yy158, &&yy158, &&yy158, &&yy222,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy158, &&yy158, &&yy158, &&yy158, &&yy220,
				&&yy158, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy158, &&yy158, &&yy158, &&yy158, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220
			};
			goto *yytarget[yych];
		}
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy227, &&yy158, &&yy158, &&yy229, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy158, &&yy158, &&yy158, &&yy158, &&yy220,
				&&yy158, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy158, &&yy158, &&yy158, &&yy158, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220,
				&&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220, &&yy220
			};
			goto *yytarget[yych];
		}
yy222:
		YYDEBUG(222, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy158;
		if (yych <= '/') goto yy231;
		if (yych <= '9') goto yy158;
		goto yy231;
yy223:
		YYDEBUG(223, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy158;
		if (yych <= '/') goto yy225;
		if (yych <= '9') goto yy158;
		goto yy225;
yy224:
		YYDEBUG(224, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy225:
		YYDEBUG(225, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy226, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy158, &&yy158, &&yy158, &&yy158, &&yy224,
				&&yy158, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy158, &&yy158, &&yy158, &&yy158, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224,
				&&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224, &&yy224
			};
			goto *yytarget[yych];
		}
yy226:
		YYDEBUG(226, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy227;
		if (yych == '\r') goto yy229;
		goto yy158;
yy227:
		YYDEBUG(227, *YYCURSOR);
		++YYCURSOR;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	return T_START_HEREDOC;
}
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy227;
		goto yy228;
yy230:
		YYDEBUG(230, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy231:
		YYDEBUG(231, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy226,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy158, &&yy158, &&yy158, &&yy158, &&yy230,
				&&yy158, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy158, &&yy158, &&yy158, &&yy158, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230
			};
			goto *yytarget[yych];
		}
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy215;
		YYDEBUG(233, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_IDENTICAL;
}
yy235:
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PLUS_EQUAL;
}
yy237:
		YYDEBUG(237, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INC;
}
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy240;
		if (yych != 's') goto yy151;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy241;
		if (yych != 't') goto yy151;
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LIST;
}
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy247;
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_EQUAL;
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_ARROW;
}
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(248, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_IDENTICAL;
}
yy249:
		YYDEBUG(249, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy251, &&yy256, &&yy151, &&yy253, &&yy151,
				&&yy250, &&yy151, &&yy151, &&yy151, &&yy255, &&yy254, &&yy257, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy252, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy251, &&yy256, &&yy151, &&yy253, &&yy151,
				&&yy250, &&yy151, &&yy151, &&yy151, &&yy255, &&yy254, &&yy257, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy252, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy250:
		YYDEBUG(250, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy318;
		if (yych == 'a') goto yy318;
		goto yy151;
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy311;
		if (yych == 'l') goto yy311;
		goto yy151;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy304;
		if (yych == 'r') goto yy304;
		goto yy151;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy288, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy289, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy288, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy289, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy280;
		if (yych == 'e') goto yy280;
		goto yy151;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy274;
		if (yych == 'i') goto yy274;
		goto yy151;
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy269;
		if (yych == 'i') goto yy269;
		goto yy151;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy258;
		if (yych != 'a') goto yy151;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy259;
		if (yych != 'm') goto yy151;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy260;
		if (yych != 'e') goto yy151;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy261;
		if (yych != 's') goto yy151;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy262;
		if (yych != 'p') goto yy151;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy263;
		if (yych != 'a') goto yy151;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy264;
		if (yych != 'c') goto yy151;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy265;
		if (yych != 'e') goto yy151;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(267, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(268, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NS_C;
}
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy270;
		if (yych != 'r') goto yy151;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(272, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(273, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DIR;
}
yy274:
		YYDEBUG(274, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy275;
		if (yych != 'n') goto yy151;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy276;
		if (yych != 'e') goto yy151;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(278, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(279, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LINE;
}
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy281;
		if (yych != 't') goto yy151;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy282;
		if (yych != 'h') goto yy151;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy283;
		if (yych != 'o') goto yy151;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy284;
		if (yych != 'd') goto yy151;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(285, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(286, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(287, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_METHOD_C;
}
yy288:
		YYDEBUG(288, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy299;
		if (yych == 'l') goto yy299;
		goto yy151;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy290;
		if (yych != 'n') goto yy151;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy291;
		if (yych != 'c') goto yy151;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy292;
		if (yych != 't') goto yy151;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy293;
		if (yych != 'i') goto yy151;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy294;
		if (yych != 'o') goto yy151;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy295;
		if (yych != 'n') goto yy151;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(297, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(298, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FUNC_C;
}
yy299:
		YYDEBUG(299, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy300;
		if (yych != 'e') goto yy151;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(302, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(303, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FILE;
}
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy305;
		if (yych != 'a') goto yy151;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy306;
		if (yych != 'i') goto yy151;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy307;
		if (yych != 't') goto yy151;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(309, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(310, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRAIT_C;
}
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy312;
		if (yych != 'a') goto yy151;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy313;
		if (yych != 's') goto yy151;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy314;
		if (yych != 's') goto yy151;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(316, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(317, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLASS_C;
}
yy318:
		YYDEBUG(318, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy319;
		if (yych != 'l') goto yy151;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy320;
		if (yych != 't') goto yy151;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy151;
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy322;
		if (yych != 'c') goto yy151;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy323;
		if (yych != 'o') goto yy151;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy324;
		if (yych != 'm') goto yy151;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy325;
		if (yych != 'p') goto yy151;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy326;
		if (yych != 'i') goto yy151;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy327;
		if (yych != 'l') goto yy151;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy328;
		if (yych != 'e') goto yy151;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy329;
		if (yych != 'r') goto yy151;
yy329:
		YYDEBUG(329, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(330, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_HALT_COMPILER;
}
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy335;
		if (yych == 's') goto yy335;
		goto yy151;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy333;
		if (yych != 'e') goto yy151;
yy333:
		YYDEBUG(333, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(334, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_USE;
}
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy336;
		if (yych != 'e') goto yy151;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy337;
		if (yych != 't') goto yy151;
yy337:
		YYDEBUG(337, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(338, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET;
}
yy339:
		YYDEBUG(339, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy340:
		YYDEBUG(340, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy339, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy339, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy344, &&yy342, &&yy158, &&yy347, &&yy158, &&yy348, &&yy158,
				&&yy158, &&yy349, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy343,
				&&yy158, &&yy158, &&yy346, &&yy345, &&yy158, &&yy341, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy344, &&yy342, &&yy158, &&yy347, &&yy158, &&yy348, &&yy158,
				&&yy158, &&yy349, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy343,
				&&yy158, &&yy158, &&yy346, &&yy345, &&yy158, &&yy341, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158
			};
			goto *yytarget[yych];
		}
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy408;
		if (yych == 'n') goto yy408;
		goto yy158;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy395, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy396,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy395, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy396,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158,
				&&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158, &&yy158
			};
			goto *yytarget[yych];
		}
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy387;
		if (yych == 'b') goto yy387;
		goto yy158;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy380;
		if (yych == 'r') goto yy380;
		goto yy158;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy372;
		if (yych == 't') goto yy372;
		goto yy158;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy370;
		if (yych == 'e') goto yy370;
		goto yy158;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy366;
		if (yych == 'o') goto yy366;
		goto yy158;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy359;
		if (yych == 'l') goto yy359;
		goto yy158;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy350;
		if (yych != 'n') goto yy158;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy351;
		if (yych != 't') goto yy158;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy352;
		if (yych != 'e') goto yy354;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy357;
		if (yych == 'g') goto yy357;
		goto yy158;
yy353:
		YYDEBUG(353, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy354:
		YYDEBUG(354, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy353;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy353;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(355, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(356, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INT_CAST;
}
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy358;
		if (yych != 'e') goto yy158;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy353;
		if (yych == 'r') goto yy353;
		goto yy158;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy360;
		if (yych != 'o') goto yy158;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy361;
		if (yych != 'a') goto yy158;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy362;
		if (yych != 't') goto yy158;
yy362:
		YYDEBUG(362, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(363, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy362;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy362;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(364, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(365, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_CAST;
}
yy366:
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy367;
		if (yych != 'u') goto yy158;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy368;
		if (yych != 'b') goto yy158;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy369;
		if (yych != 'l') goto yy158;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy362;
		if (yych == 'e') goto yy362;
		goto yy158;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy371;
		if (yych != 'a') goto yy158;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy362;
		if (yych == 'l') goto yy362;
		goto yy158;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy373;
		if (yych != 'r') goto yy158;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy374;
		if (yych != 'i') goto yy158;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy375;
		if (yych != 'n') goto yy158;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy376;
		if (yych != 'g') goto yy158;
yy376:
		YYDEBUG(376, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(377, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy376;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy376;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(378, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(379, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STRING_CAST;
}
yy380:
		YYDEBUG(380, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy381;
		if (yych != 'r') goto yy158;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy382;
		if (yych != 'a') goto yy158;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy383;
		if (yych != 'y') goto yy158;
yy383:
		YYDEBUG(383, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(384, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy383;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy383;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(385, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(386, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY_CAST;
}
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy388;
		if (yych != 'j') goto yy158;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy389;
		if (yych != 'e') goto yy158;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy390;
		if (yych != 'c') goto yy158;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy391;
		if (yych != 't') goto yy158;
yy391:
		YYDEBUG(391, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(392, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy391;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy391;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(393, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(394, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_CAST;
}
yy395:
		YYDEBUG(395, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy405;
		if (yych == 'n') goto yy405;
		goto yy158;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy397;
		if (yych != 'o') goto yy158;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy398;
		if (yych != 'l') goto yy158;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy403;
		if (yych == 'e') goto yy403;
		goto yy400;
yy399:
		YYDEBUG(399, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy400:
		YYDEBUG(400, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy399;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy399;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(401, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(402, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOL_CAST;
}
yy403:
		YYDEBUG(403, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy404;
		if (yych != 'a') goto yy158;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy399;
		if (yych == 'n') goto yy399;
		goto yy158;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy406;
		if (yych != 'a') goto yy158;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy407;
		if (yych != 'r') goto yy158;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy376;
		if (yych == 'y') goto yy376;
		goto yy158;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy409;
		if (yych != 's') goto yy158;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy410;
		if (yych != 'e') goto yy158;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy411;
		if (yych != 't') goto yy158;
yy411:
		YYDEBUG(411, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(412, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy411;
			goto yy158;
		} else {
			if (yych <= ' ') goto yy411;
			if (yych != ')') goto yy158;
		}
		YYDEBUG(413, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(414, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET_CAST;
}
yy415:
		YYDEBUG(415, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy416;
		if (yych != 'r') goto yy151;
yy416:
		YYDEBUG(416, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(417, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_VAR;
}
yy418:
		YYDEBUG(418, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy422;
		if (yych == 'm') goto yy422;
		goto yy151;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy420;
		if (yych != 'w') goto yy151;
yy420:
		YYDEBUG(420, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(421, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NEW;
}
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy423;
		if (yych != 'e') goto yy151;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy424;
		if (yych != 's') goto yy151;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy425;
		if (yych != 'p') goto yy151;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy426;
		if (yych != 'a') goto yy151;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy427;
		if (yych != 'c') goto yy151;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy428;
		if (yych != 'e') goto yy151;
yy428:
		YYDEBUG(428, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(429, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NAMESPACE;
}
yy430:
		YYDEBUG(430, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy434;
		if (yych == '\r') goto yy435;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
yy432:
		YYDEBUG(432, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(433, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_COALESCE;
}
yy434:
		YYDEBUG(434, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy431;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy434;
		goto yy431;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(437, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy154;
			if (yych <= '9') goto yy436;
			goto yy154;
		} else {
			if (yych <= 'E') goto yy157;
			if (yych == 'e') goto yy157;
			goto yy154;
		}
yy438:
		YYDEBUG(438, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(439, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONCAT_EQUAL;
}
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '.') goto yy158;
		YYDEBUG(441, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(442, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELLIPSIS;
}
yy443:
		YYDEBUG(443, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(444, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
yy445:
		YYDEBUG(445, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy446:
		YYDEBUG(446, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy105;
			if (yych <= '\n') goto yy445;
			goto yy105;
		} else {
			if (yych <= '\r') goto yy445;
			if (yych == ' ') goto yy445;
			goto yy105;
		}
yy447:
		YYDEBUG(447, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(448, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MINUS_EQUAL;
}
yy449:
		YYDEBUG(449, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(450, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEC;
}
yy451:
		YYDEBUG(451, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(452, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	return T_OBJECT_OPERATOR;
}
yy453:
		YYDEBUG(453, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy460, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy461,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy460, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy461,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy454:
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy455;
		if (yych != 'b') goto yy151;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy456;
		if (yych != 'l') goto yy151;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy457;
		if (yych != 'i') goto yy151;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy458;
		if (yych != 'c') goto yy151;
yy458:
		YYDEBUG(458, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(459, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PUBLIC;
}
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy469, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy470, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy469, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy470, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy462;
		if (yych != 't') goto yy151;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy463;
		if (yych != 'e') goto yy151;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy464;
		if (yych != 'c') goto yy151;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy465;
		if (yych != 't') goto yy151;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy466;
		if (yych != 'e') goto yy151;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy467;
		if (yych != 'd') goto yy151;
yy467:
		YYDEBUG(467, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(468, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PROTECTED;
}
yy469:
		YYDEBUG(469, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy475;
		if (yych == 't') goto yy475;
		goto yy151;
yy470:
		YYDEBUG(470, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy471;
		if (yych != 'a') goto yy151;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy472;
		if (yych != 't') goto yy151;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy473;
		if (yych != 'e') goto yy151;
yy473:
		YYDEBUG(473, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(474, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRIVATE;
}
yy475:
		YYDEBUG(475, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(476, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRINT;
}
yy477:
		YYDEBUG(477, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy482;
		if (yych == 'o') goto yy482;
		goto yy151;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy479;
		if (yych != 't') goto yy151;
yy479:
		YYDEBUG(479, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy480;
		if (yych != 'o') goto yy151;
yy480:
		YYDEBUG(480, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(481, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GOTO;
}
yy482:
		YYDEBUG(482, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy483;
		if (yych != 'b') goto yy151;
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy484;
		if (yych != 'a') goto yy151;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy485;
		if (yych != 'l') goto yy151;
yy485:
		YYDEBUG(485, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(486, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GLOBAL;
}
yy487:
		YYDEBUG(487, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy495;
		goto yy158;
yy488:
		YYDEBUG(488, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy145;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy143;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy491;
		if (yych != 'e') goto yy151;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy492;
		if (yych != 'a') goto yy151;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy493;
		if (yych != 'k') goto yy151;
yy493:
		YYDEBUG(493, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(494, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BREAK;
}
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy218;
		goto yy158;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy503;
		if (yych == 'a') goto yy503;
		goto yy151;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy498;
		if (yych != 'i') goto yy151;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy499;
		if (yych != 't') goto yy151;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy500;
		if (yych != 'c') goto yy151;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy501;
		if (yych != 'h') goto yy151;
yy501:
		YYDEBUG(501, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(502, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SWITCH;
}
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy504;
		if (yych != 't') goto yy151;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy505;
		if (yych != 'i') goto yy151;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy506;
		if (yych != 'c') goto yy151;
yy506:
		YYDEBUG(506, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(507, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STATIC;
}
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy519;
		if (yych == 's') goto yy519;
		goto yy151;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy517;
		if (yych == 'd') goto yy517;
		goto yy151;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy513;
		if (yych == 'r') goto yy513;
		goto yy151;
yy511:
		YYDEBUG(511, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(512, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AS;
}
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy514;
		if (yych != 'a') goto yy151;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy515;
		if (yych != 'y') goto yy151;
yy515:
		YYDEBUG(515, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(516, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY;
}
yy517:
		YYDEBUG(517, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(518, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_AND;
}
yy519:
		YYDEBUG(519, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy520;
		if (yych != 't') goto yy151;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy521;
		if (yych != 'r') goto yy151;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy522;
		if (yych != 'a') goto yy151;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy523;
		if (yych != 'c') goto yy151;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy524;
		if (yych != 't') goto yy151;
yy524:
		YYDEBUG(524, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(525, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ABSTRACT;
}
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy527;
		if (yych != 'i') goto yy151;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy528;
		if (yych != 'l') goto yy151;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy529;
		if (yych != 'e') goto yy151;
yy529:
		YYDEBUG(529, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(530, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_WHILE;
}
yy531:
		YYDEBUG(531, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(532, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IF;
}
yy533:
		YYDEBUG(533, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy575;
		if (yych == 'p') goto yy575;
		goto yy151;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy542, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy540, &&yy541, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy542, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy540, &&yy541, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy535:
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy536;
		if (yych != 's') goto yy151;
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy537;
		if (yych != 'e') goto yy151;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy538;
		if (yych != 't') goto yy151;
yy538:
		YYDEBUG(538, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(539, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ISSET;
}
yy540:
		YYDEBUG(540, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy561;
		if (yych == 't') goto yy561;
		goto yy151;
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy554;
		if (yych == 'e') goto yy554;
		goto yy151;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy543;
		if (yych != 'l') goto yy151;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy544;
		if (yych != 'u') goto yy151;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy545;
		if (yych != 'd') goto yy151;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy546;
		if (yych != 'e') goto yy151;
yy546:
		YYDEBUG(546, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547,
				&&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547,
				&&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547,
				&&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547,
				&&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547,
				&&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547, &&yy547,
				&&yy547, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy547, &&yy547, &&yy547, &&yy547, &&yy548,
				&&yy547, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy547, &&yy547, &&yy547, &&yy547, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy547:
		YYDEBUG(547, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE;
}
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy549;
		if (yych != 'o') goto yy151;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy550;
		if (yych != 'n') goto yy151;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy551;
		if (yych != 'c') goto yy151;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy552;
		if (yych != 'e') goto yy151;
yy552:
		YYDEBUG(552, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(553, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE_ONCE;
}
yy554:
		YYDEBUG(554, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy555;
		if (yych != 'r') goto yy151;
yy555:
		YYDEBUG(555, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy556;
		if (yych != 'f') goto yy151;
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy557;
		if (yych != 'a') goto yy151;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy558;
		if (yych != 'c') goto yy151;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy559;
		if (yych != 'e') goto yy151;
yy559:
		YYDEBUG(559, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(560, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INTERFACE;
}
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy562, &&yy151, &&yy151, &&yy151, &&yy563, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy562, &&yy151, &&yy151, &&yy151, &&yy563, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy562:
		YYDEBUG(562, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy569;
		if (yych == 'n') goto yy569;
		goto yy151;
yy563:
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy564;
		if (yych != 'a') goto yy151;
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy565;
		if (yych != 'd') goto yy151;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy566;
		if (yych != 'o') goto yy151;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy567;
		if (yych != 'f') goto yy151;
yy567:
		YYDEBUG(567, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(568, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
        return T_INSTEADOF;
}
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy570;
		if (yych != 'c') goto yy151;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy571;
		if (yych != 'e') goto yy151;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy572;
		if (yych != 'o') goto yy151;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy573;
		if (yych != 'f') goto yy151;
yy573:
		YYDEBUG(573, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(574, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INSTANCEOF;
}
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy576;
		if (yych != 'l') goto yy151;
yy576:
		YYDEBUG(576, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy577;
		if (yych != 'e') goto yy151;
yy577:
		YYDEBUG(577, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy578;
		if (yych != 'm') goto yy151;
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy579;
		if (yych != 'e') goto yy151;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy580;
		if (yych != 'n') goto yy151;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy581;
		if (yych != 't') goto yy151;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy582;
		if (yych != 's') goto yy151;
yy582:
		YYDEBUG(582, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(583, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IMPLEMENTS;
}
yy584:
		YYDEBUG(584, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy592;
		if (yych == 'r') goto yy592;
		goto yy151;
yy585:
		YYDEBUG(585, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy588, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy586, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy588, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy586, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy586:
		YYDEBUG(586, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(587, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRY;
}
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy589;
		if (yych != 'i') goto yy151;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy590;
		if (yych != 't') goto yy151;
yy590:
		YYDEBUG(590, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(591, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRAIT;
}
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy593;
		if (yych != 'o') goto yy151;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy594;
		if (yych != 'w') goto yy151;
yy594:
		YYDEBUG(594, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(595, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_THROW;
}
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy597;
		if (yych != 'e') goto yy151;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy598;
		if (yych != 'l') goto yy151;
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy599;
		if (yych != 'd') goto yy151;
yy599:
		YYDEBUG(599, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(600, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_YIELD;
}
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy603, &&yy151, &&yy151, &&yy602, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy603, &&yy151, &&yy151, &&yy602, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy615;
		if (yych == 'u') goto yy615;
		goto yy151;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy604;
		if (yych != 'u') goto yy151;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy605;
		if (yych != 'i') goto yy151;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy606;
		if (yych != 'r') goto yy151;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy607;
		if (yych != 'e') goto yy151;
yy607:
		YYDEBUG(607, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
				&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
				&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
				&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
				&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
				&&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608, &&yy608,
				&&yy608, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy608, &&yy608, &&yy608, &&yy608, &&yy609,
				&&yy608, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy608, &&yy608, &&yy608, &&yy608, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy608:
		YYDEBUG(608, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE;
}
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy610;
		if (yych != 'o') goto yy151;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy611;
		if (yych != 'n') goto yy151;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy612;
		if (yych != 'c') goto yy151;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy613;
		if (yych != 'e') goto yy151;
yy613:
		YYDEBUG(613, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(614, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE_ONCE;
}
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy616;
		if (yych != 'r') goto yy151;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy617;
		if (yych != 'n') goto yy151;
yy617:
		YYDEBUG(617, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(618, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_RETURN;
}
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy642, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy641, &&yy640, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy642, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy641, &&yy640, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy620:
		YYDEBUG(620, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy632, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy633,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy632, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy633,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy621:
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy622;
		if (yych != 'n') goto yy151;
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy151;
			if (yych >= 'T') goto yy624;
		} else {
			if (yych <= 'r') goto yy151;
			if (yych <= 's') goto yy623;
			if (yych <= 't') goto yy624;
			goto yy151;
		}
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy630;
		if (yych == 't') goto yy630;
		goto yy151;
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy625;
		if (yych != 'i') goto yy151;
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy626;
		if (yych != 'n') goto yy151;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy627;
		if (yych != 'u') goto yy151;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy628;
		if (yych != 'e') goto yy151;
yy628:
		YYDEBUG(628, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONTINUE;
}
yy630:
		YYDEBUG(630, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(631, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONST;
}
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy637;
		if (yych == 's') goto yy637;
		goto yy151;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy634;
		if (yych != 'n') goto yy151;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy635;
		if (yych != 'e') goto yy151;
yy635:
		YYDEBUG(635, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(636, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLONE;
}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy638;
		if (yych != 's') goto yy151;
yy638:
		YYDEBUG(638, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(639, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLASS;
}
yy640:
		YYDEBUG(640, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy651;
		if (yych == 'c') goto yy651;
		goto yy151;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy649;
		if (yych == 'e') goto yy649;
		goto yy151;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy643;
		if (yych != 'l') goto yy151;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy644;
		if (yych != 'a') goto yy151;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy645;
		if (yych != 'b') goto yy151;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy646;
		if (yych != 'l') goto yy151;
yy646:
		YYDEBUG(646, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy647;
		if (yych != 'e') goto yy151;
yy647:
		YYDEBUG(647, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(648, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
 return T_CALLABLE;
}
yy649:
		YYDEBUG(649, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(650, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CASE;
}
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy652;
		if (yych != 'h') goto yy151;
yy652:
		YYDEBUG(652, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(653, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CATCH;
}
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy671;
		if (yych == 'n') goto yy671;
		goto yy151;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy664;
		if (yych == 'r') goto yy664;
		goto yy151;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy657;
		if (yych != 'n') goto yy151;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy658;
		if (yych != 'c') goto yy151;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy659;
		if (yych != 't') goto yy151;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy660;
		if (yych != 'i') goto yy151;
yy660:
		YYDEBUG(660, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy661;
		if (yych != 'o') goto yy151;
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy662;
		if (yych != 'n') goto yy151;
yy662:
		YYDEBUG(662, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(663, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FUNCTION;
}
yy664:
		YYDEBUG(664, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665,
				&&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665,
				&&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665,
				&&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665,
				&&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665,
				&&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665, &&yy665,
				&&yy665, &&yy150, &&yy150, &&yy150, &&yy150, &&yy666, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy665, &&yy665, &&yy665, &&yy665, &&yy150,
				&&yy665, &&yy150, &&yy150, &&yy150, &&yy150, &&yy666, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy665, &&yy665, &&yy665, &&yy665, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy665:
		YYDEBUG(665, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOR;
}
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy667;
		if (yych != 'a') goto yy151;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy668;
		if (yych != 'c') goto yy151;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy669;
		if (yych != 'h') goto yy151;
yy669:
		YYDEBUG(669, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(670, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOREACH;
}
yy671:
		YYDEBUG(671, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy672;
		if (yych != 'a') goto yy151;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy673;
		if (yych != 'l') goto yy151;
yy673:
		YYDEBUG(673, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674, &&yy674,
				&&yy674, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy675, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy674, &&yy674, &&yy674, &&yy674, &&yy150,
				&&yy674, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy675, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy674, &&yy674, &&yy674, &&yy674, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy674:
		YYDEBUG(674, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINAL;
}
yy675:
		YYDEBUG(675, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy676;
		if (yych != 'y') goto yy151;
yy676:
		YYDEBUG(676, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(677, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINALLY;
}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy684, &&yy151, &&yy151, &&yy685, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy684, &&yy151, &&yy151, &&yy685, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy682;
		if (yych == 'e') goto yy682;
		goto yy151;
yy680:
		YYDEBUG(680, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(681, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DO;
}
yy682:
		YYDEBUG(682, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(683, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy684:
		YYDEBUG(684, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy691;
		if (yych == 'l') goto yy691;
		goto yy151;
yy685:
		YYDEBUG(685, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy686;
		if (yych != 'a') goto yy151;
yy686:
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy687;
		if (yych != 'u') goto yy151;
yy687:
		YYDEBUG(687, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy688;
		if (yych != 'l') goto yy151;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy689;
		if (yych != 't') goto yy151;
yy689:
		YYDEBUG(689, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(690, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEFAULT;
}
yy691:
		YYDEBUG(691, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy692;
		if (yych != 'a') goto yy151;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy693;
		if (yych != 'r') goto yy151;
yy693:
		YYDEBUG(693, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy694;
		if (yych != 'e') goto yy151;
yy694:
		YYDEBUG(694, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(695, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DECLARE;
}
yy696:
		YYDEBUG(696, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy758;
		if (yych == 'h') goto yy758;
		goto yy151;
yy697:
		YYDEBUG(697, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy752;
		if (yych == 's') goto yy752;
		goto yy151;
yy698:
		YYDEBUG(698, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy748;
		if (yych == 'p') goto yy748;
		goto yy151;
yy699:
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy714;
		if (yych == 'd') goto yy714;
		goto yy151;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy711;
		if (yych == 'a') goto yy711;
		goto yy151;
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy702, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy703, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy702, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy703, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy702:
		YYDEBUG(702, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy709;
		if (yych == 't') goto yy709;
		goto yy151;
yy703:
		YYDEBUG(703, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy704;
		if (yych != 'e') goto yy151;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy705;
		if (yych != 'n') goto yy151;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy706;
		if (yych != 'd') goto yy151;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy707;
		if (yych != 's') goto yy151;
yy707:
		YYDEBUG(707, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(708, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXTENDS;
}
yy709:
		YYDEBUG(709, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(710, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy711:
		YYDEBUG(711, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy712;
		if (yych != 'l') goto yy151;
yy712:
		YYDEBUG(712, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(713, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EVAL;
}
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy715, &&yy151, &&yy716, &&yy151,
				&&yy151, &&yy717, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy718, &&yy151, &&yy151, &&yy151, &&yy719,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy715, &&yy151, &&yy716, &&yy151,
				&&yy151, &&yy717, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy718, &&yy151, &&yy151, &&yy151, &&yy719,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151,
				&&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151, &&yy151
			};
			goto *yytarget[yych];
		}
yy715:
		YYDEBUG(715, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy741;
		if (yych == 'e') goto yy741;
		goto yy151;
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy733;
		if (yych == 'o') goto yy733;
		goto yy151;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy731;
		if (yych == 'f') goto yy731;
		goto yy151;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy725;
		if (yych == 'w') goto yy725;
		goto yy151;
yy719:
		YYDEBUG(719, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy720;
		if (yych != 'h') goto yy151;
yy720:
		YYDEBUG(720, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy721;
		if (yych != 'i') goto yy151;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy722;
		if (yych != 'l') goto yy151;
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy723;
		if (yych != 'e') goto yy151;
yy723:
		YYDEBUG(723, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(724, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDWHILE;
}
yy725:
		YYDEBUG(725, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy726;
		if (yych != 'i') goto yy151;
yy726:
		YYDEBUG(726, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy727;
		if (yych != 't') goto yy151;
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy728;
		if (yych != 'c') goto yy151;
yy728:
		YYDEBUG(728, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy729;
		if (yych != 'h') goto yy151;
yy729:
		YYDEBUG(729, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(730, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDSWITCH;
}
yy731:
		YYDEBUG(731, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(732, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDIF;
}
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy734;
		if (yych != 'r') goto yy151;
yy734:
		YYDEBUG(734, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735, &&yy735,
				&&yy735, &&yy150, &&yy150, &&yy150, &&yy150, &&yy736, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy735, &&yy735, &&yy735, &&yy735, &&yy150,
				&&yy735, &&yy150, &&yy150, &&yy150, &&yy150, &&yy736, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy735, &&yy735, &&yy735, &&yy735, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy735:
		YYDEBUG(735, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOR;
}
yy736:
		YYDEBUG(736, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy737;
		if (yych != 'a') goto yy151;
yy737:
		YYDEBUG(737, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy738;
		if (yych != 'c') goto yy151;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy739;
		if (yych != 'h') goto yy151;
yy739:
		YYDEBUG(739, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(740, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOREACH;
}
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy742;
		if (yych != 'c') goto yy151;
yy742:
		YYDEBUG(742, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy743;
		if (yych != 'l') goto yy151;
yy743:
		YYDEBUG(743, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy744;
		if (yych != 'a') goto yy151;
yy744:
		YYDEBUG(744, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy745;
		if (yych != 'r') goto yy151;
yy745:
		YYDEBUG(745, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy746;
		if (yych != 'e') goto yy151;
yy746:
		YYDEBUG(746, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(747, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDDECLARE;
}
yy748:
		YYDEBUG(748, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy749;
		if (yych != 't') goto yy151;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy750;
		if (yych != 'y') goto yy151;
yy750:
		YYDEBUG(750, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(751, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EMPTY;
}
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy753;
		if (yych != 'e') goto yy151;
yy753:
		YYDEBUG(753, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754,
				&&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754,
				&&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754,
				&&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754,
				&&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754,
				&&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754, &&yy754,
				&&yy754, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy755, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy754, &&yy754, &&yy754, &&yy754, &&yy150,
				&&yy754, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy755, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy754, &&yy754, &&yy754, &&yy754, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150,
				&&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150, &&yy150
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy754:
		YYDEBUG(754, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSE;
}
yy755:
		YYDEBUG(755, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy756;
		if (yych != 'f') goto yy151;
yy756:
		YYDEBUG(756, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(757, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSEIF;
}
yy758:
		YYDEBUG(758, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy759;
		if (yych != 'o') goto yy151;
yy759:
		YYDEBUG(759, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy150;
		}
		YYDEBUG(760, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ECHO;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(761, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy763, &&yy763, &&yy769, &&yy769, &&yy763, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy763, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy765, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy769, &&yy769, &&yy769, &&yy769, &&yy767,
				&&yy769, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy769, &&yy769, &&yy769, &&yy769, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767
			};
			goto *yytarget[yych];
		}
yy763:
		YYDEBUG(763, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy775;
yy764:
		YYDEBUG(764, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy765:
		YYDEBUG(765, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy772;
yy766:
		YYDEBUG(766, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy767:
		YYDEBUG(767, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy771;
yy768:
		YYDEBUG(768, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	zend_copy_value(zendlval, yytext, yyleng);
	return T_STRING;
}
yy769:
		YYDEBUG(769, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy766;
yy770:
		YYDEBUG(770, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy771:
		YYDEBUG(771, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy770;
		}
		goto yy768;
yy772:
		YYDEBUG(772, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_OPERATOR;
}
yy774:
		YYDEBUG(774, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy775:
		YYDEBUG(775, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy774;
		}
		goto yy764;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(776, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy780;
			if (yych <= 'Z') goto yy778;
			if (yych <= '^') goto yy780;
		} else {
			if (yych <= '`') goto yy780;
			if (yych <= 'z') goto yy778;
			if (yych <= '~') goto yy780;
		}
yy778:
		YYDEBUG(778, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779, &&yy779,
				&&yy779, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy779, &&yy779, &&yy779, &&yy782,
				&&yy779, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy779, &&yy779, &&yy782, &&yy779, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782,
				&&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782, &&yy782
			};
			goto *yytarget[yych];
		}
yy779:
		YYDEBUG(779, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy780:
		YYDEBUG(780, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy779;
yy781:
		YYDEBUG(781, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy782:
		YYDEBUG(782, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy781;
		}
		if (yych <= '@') goto yy783;
		if (yych <= '[') goto yy784;
		if (yych == '}') goto yy784;
yy783:
		YYDEBUG(783, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy779;
yy784:
		YYDEBUG(784, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(785, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	return T_STRING_VARNAME;
}
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(786, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(788, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(789, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 112, 112, 112, 112, 112, 112, 
			112, 112,   0,   0,   0,   0,   0,   0, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(790, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy804, &&yy804, &&yy804, &&yy804, &&yy804, &&yy804, &&yy804, &&yy804,
				&&yy804, &&yy800, &&yy800, &&yy804, &&yy804, &&yy800, &&yy804, &&yy804,
				&&yy804, &&yy804, &&yy804, &&yy804, &&yy804, &&yy804, &&yy804, &&yy804,
				&&yy804, &&yy804, &&yy804, &&yy804, &&yy804, &&yy804, &&yy804, &&yy804,
				&&yy800, &&yy799, &&yy799, &&yy800, &&yy795, &&yy799, &&yy799, &&yy800,
				&&yy799, &&yy799, &&yy799, &&yy799, &&yy799, &&yy799, &&yy799, &&yy799,
				&&yy792, &&yy794, &&yy794, &&yy794, &&yy794, &&yy794, &&yy794, &&yy794,
				&&yy794, &&yy794, &&yy799, &&yy799, &&yy799, &&yy799, &&yy799, &&yy799,
				&&yy799, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy799, &&yy800, &&yy797, &&yy799, &&yy802,
				&&yy799, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy799, &&yy799, &&yy799, &&yy799, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802,
				&&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802, &&yy802
			};
			goto *yytarget[yych];
		}
yy792:
		YYDEBUG(792, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy816, &&yy816, &&yy816, &&yy816, &&yy816, &&yy816, &&yy816, &&yy816,
				&&yy816, &&yy816, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy813, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy815, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy813, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy815, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793,
				&&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793, &&yy793
			};
			goto *yytarget[yych];
		}
yy793:
		YYDEBUG(793, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	return T_NUM_STRING;
}
yy794:
		YYDEBUG(794, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy812;
yy795:
		YYDEBUG(795, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy796;
			if (yych <= 'Z') goto yy808;
			if (yych >= '_') goto yy808;
		} else {
			if (yych <= '`') goto yy796;
			if (yych <= 'z') goto yy808;
			if (yych >= 0x7F) goto yy808;
		}
yy796:
		YYDEBUG(796, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
yy797:
		YYDEBUG(797, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	return ']';
}
yy799:
		YYDEBUG(799, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy796;
yy800:
		YYDEBUG(800, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(801, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy802:
		YYDEBUG(802, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy807;
yy803:
		YYDEBUG(803, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	return T_STRING;
}
yy804:
		YYDEBUG(804, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(805, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy806:
		YYDEBUG(806, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy807:
		YYDEBUG(807, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy806;
		}
		goto yy803;
yy808:
		YYDEBUG(808, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(809, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy810, &&yy810, &&yy810, &&yy810, &&yy808,
				&&yy810, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy810, &&yy810, &&yy810, &&yy810, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808
			};
			goto *yytarget[yych];
		}
yy810:
		YYDEBUG(810, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy811:
		YYDEBUG(811, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy812:
		YYDEBUG(812, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy811;
		}
		goto yy793;
yy813:
		YYDEBUG(813, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy821;
		}
yy814:
		YYDEBUG(814, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy793;
yy815:
		YYDEBUG(815, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy819;
		}
		goto yy814;
yy816:
		YYDEBUG(816, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(817, *YYCURSOR);
		if (yych <= '/') goto yy818;
		if (yych <= '9') goto yy816;
yy818:
		YYDEBUG(818, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	ZVAL_STRINGL(zendlval, yytext, yyleng);
	return T_NUM_STRING;
}
yy819:
		YYDEBUG(819, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(820, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy819;
		}
		goto yy818;
yy821:
		YYDEBUG(821, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(822, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy821;
		}
		goto yy818;
	}
}

}
