/*
 * This file is provided under a dual BSD/GPLv2 license.  When using or
 *   redistributing this file, you may do so under either license.
 * 
 *   GPL LICENSE SUMMARY
 * 
 *   Copyright(c) 2007-2021 Intel Corporation. All rights reserved.
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of version 2 of the GNU General Public License as
 *   published by the Free Software Foundation.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *   The full GNU General Public License is included in this distribution
 *   in the file called LICENSE.GPL.
 * 
 *   Contact Information:
 *   Intel Corporation
 * 
 *   BSD LICENSE
 * 
 *   Copyright(c) 2007-2021 Intel Corporation. All rights reserved.
 *   All rights reserved.
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 * 
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * 
 */
/*
 ****************************************************************************
 * @file icp_qat_hw_20_comp_defs.h, (autogenerated at 04-19-18 16:06)
 * @defgroup icp_qat_hw_comp_20
 * @ingroup icp_qat_hw_comp_20
 * @description
 * This file represents the HW configuration CSR definitions
 ****************************************************************************
 */

#ifndef _ICP_QAT_HW_20_COMP_DEFS_H
#define _ICP_QAT_HW_20_COMP_DEFS_H

/*****************************************************************************/
/* SCB Disabled - Set by FW, located in upper 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_CONTROL_BITPOS 31
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_CONTROL_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible SCB_CONTROL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_SCB_CONTROL_ENABLE = 0x0,
    /* Normal Mode using SCB (Default) */
    ICP_QAT_HW_COMP_20_SCB_CONTROL_DISABLE = 0x1,
    /* Legacy CPM1.x Mode with SCB disabled. */
} icp_qat_hw_comp_20_scb_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_CONTROL_DEFAULT_VAL                  \
    ICP_QAT_HW_COMP_20_SCB_CONTROL_DISABLE

/*****************************************************************************/
/* Reset Bit Mask Disabled - Set by FW , located in upper 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RMB_CONTROL_BITPOS 30
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RMB_CONTROL_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible RMB_CONTROL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_RMB_CONTROL_RESET_ALL = 0x0,
    /* Reset all data structures with a set_config command. (Set by FW) */
    ICP_QAT_HW_COMP_20_RMB_CONTROL_RESET_FC_ONLY = 0x1,
    /* Reset only the Frequency Counters (LFCT) with a set_config command. */
} icp_qat_hw_comp_20_rmb_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RMB_CONTROL_DEFAULT_VAL                  \
    ICP_QAT_HW_COMP_20_RMB_CONTROL_RESET_ALL

/*****************************************************************************/
/* Slice Operation Mode (SOM) - Set By FW, located in upper 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SOM_CONTROL_BITPOS 28
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SOM_CONTROL_MASK 0x3
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible SOM_CONTROL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_SOM_CONTROL_NORMAL_MODE = 0x0,
    /* Normal mode. */
    ICP_QAT_HW_COMP_20_SOM_CONTROL_RESERVED0_MODE = 0x1,
    /* Reserved0 mode */
    ICP_QAT_HW_COMP_20_SOM_CONTROL_INPUT_CRC = 0x2,
    /* Input CRC Mode */
    ICP_QAT_HW_COMP_20_SOM_CONTROL_RESERVED_MODE = 0x3,
    /* Reserved. */
} icp_qat_hw_comp_20_som_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SOM_CONTROL_DEFAULT_VAL                  \
    ICP_QAT_HW_COMP_20_SOM_CONTROL_NORMAL_MODE

/*****************************************************************************/
/* Skip Hash Read (Set By FW) , located in upper 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_RD_CONTROL_BITPOS 27
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_RD_CONTROL_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible SKIP_HASH_RD_CONTROL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_SKIP_HASH_RD_CONTROL_NO_SKIP = 0x0,
    /* When set to 0, hash reads are not skipped.  */
    ICP_QAT_HW_COMP_20_SKIP_HASH_RD_CONTROL_SKIP_HASH_READS = 0x1,
    /* Hash reads are skipped. */
} icp_qat_hw_comp_20_skip_hash_rd_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_RD_CONTROL_DEFAULT_VAL         \
    ICP_QAT_HW_COMP_20_SKIP_HASH_RD_CONTROL_NO_SKIP

/*****************************************************************************/
/* SCB Unload Disable, located in upper 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_UNLOAD_CONTROL_BITPOS 26
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_UNLOAD_CONTROL_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible SCB_UNLOAD_CONTROL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_SCB_UNLOAD_CONTROL_UNLOAD = 0x0,
    /* Unloads the LFCT and flushes the State Registers.  */
    ICP_QAT_HW_COMP_20_SCB_UNLOAD_CONTROL_NO_UNLOAD = 0x1,
    /* Does not unload the LFCT, but flushes the State Registers. */
} icp_qat_hw_comp_20_scb_unload_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_UNLOAD_CONTROL_DEFAULT_VAL           \
    ICP_QAT_HW_COMP_20_SCB_UNLOAD_CONTROL_UNLOAD

/*****************************************************************************/
/* Disable token fusion, located in upper 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_DISABLE_TOKEN_FUSION_CONTROL_BITPOS 21
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_DISABLE_TOKEN_FUSION_CONTROL_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible DISABLE_TOKEN_FUSION_CONTROL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_DISABLE_TOKEN_FUSION_CONTROL_ENABLE = 0x0,
    /* Enables token fusion.  */
    ICP_QAT_HW_COMP_20_DISABLE_TOKEN_FUSION_CONTROL_DISABLE = 0x1,
    /* Disables token fusion. */
} icp_qat_hw_comp_20_disable_token_fusion_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_DISABLE_TOKEN_FUSION_CONTROL_DEFAULT_VAL \
    ICP_QAT_HW_COMP_20_DISABLE_TOKEN_FUSION_CONTROL_ENABLE

/*****************************************************************************/
/* Lazy - For iLZ77 and Static DEFLATE, Lazy = 102h , located in upper
 * 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LAZY_PARAM_BITPOS 9
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LAZY_PARAM_MASK 0x1ff
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LAZY_PARAM_DEFAULT_VAL 258

/*****************************************************************************/
/* Nice - For iLZ77 and Static DEFLATE, Nice = 102h , located in upper
 * 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_NICE_PARAM_BITPOS 0
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_NICE_PARAM_MASK 0x1ff
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_NICE_PARAM_DEFAULT_VAL 258

/*****************************************************************************/
/* History Buffer Size (Set By the Driver/ Application), located in lower 32bit
 */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HBS_CONTROL_BITPOS 14
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HBS_CONTROL_MASK 0x7
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible HBS_CONTROL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_HBS_CONTROL_HBS_IS_32KB = 0x0,
    /* 000b - 32KB  */
} icp_qat_hw_comp_20_hbs_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HBS_CONTROL_DEFAULT_VAL                  \
    ICP_QAT_HW_COMP_20_HBS_CONTROL_HBS_IS_32KB

/*****************************************************************************/
/* Reserved1 (Set By FW if Dynamic), located in lower 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RESERVED1_BITPOS 13
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RESERVED1_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible reserved1 field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_RESERVED1_ENABLED = 0x0,
    /* 0b - Feature enabled.  */
    ICP_QAT_HW_COMP_20_RESERVED1_DISABLED = 0x1,
    /* 1b - Feature disabled. */
} icp_qat_hw_comp_20_reserved1_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RESERVED1_DEFAULT_VAL                    \
    ICP_QAT_HW_COMP_20_RESERVED1_ENABLED

/*****************************************************************************/
/* Reserved2, (Set By FW if Dynamic) , located
 * in lower 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RESERVED2_CTRL_BITPOS 12
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RESERVED2_CTRL_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible RESERVED2_CTRL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_RESERVED2_CTRL_ENABLED = 0x0,
    /* 0b - Feature enabled.  */
    ICP_QAT_HW_COMP_20_RESERVED2_CTRL_DISABLED = 0x1,
    /* 1b - Feature disabled. */
} icp_qat_hw_comp_20_reserved2_ctrl_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RESERVED2_CTRL_DEFAULT_VAL               \
    ICP_QAT_HW_COMP_20_RESERVED2_CTRL_ENABLED

/*****************************************************************************/
/* Search Depth (SD) (Set By Driver/Application), located in lower 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SEARCH_DEPTH_BITPOS 8
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SEARCH_DEPTH_MASK 0xf
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible SEARCH_DEPTH field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_SEARCH_DEPTH_LEVEL_1 = 0x1,
    /* 0001b - Level 1 (search depth = 2^1 = 2) */
    ICP_QAT_HW_COMP_20_SEARCH_DEPTH_LEVEL_6 = 0x3,
    /* 0001b - Level 6 (search depth = 2^3 = 8) */
    ICP_QAT_HW_COMP_20_SEARCH_DEPTH_LEVEL_9 = 0x4,
    /* 0001b - Level 9 (search depth = 2^4 = 16) */
    ICP_QAT_HW_COMP_20_SEARCH_DEPTH_LEVEL_9P = 0x12,
    /* 0001b - Level 9P (search depth = 2^12 = 4096) */
} icp_qat_hw_comp_20_search_depth_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SEARCH_DEPTH_DEFAULT_VAL                 \
    ICP_QAT_HW_COMP_20_SEARCH_DEPTH_LEVEL_1

/*****************************************************************************/
/* Compression Format (Set By Driver/Application. Also See CMD ID), located in
 * lower 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HW_COMP_FORMAT_BITPOS 5
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HW_COMP_FORMAT_MASK 0x7
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible HW_COMP_FORMAT field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_HW_COMP_FORMAT_ILZ77 = 0x0,
    /* 000 - iLZ77. (Must set RESERVED3 = 3 bytes and HB size = 32KB.) */
    ICP_QAT_HW_COMP_20_HW_COMP_FORMAT_DEFLATE = 0x1,
    /* 001 - Static DEFLATE. (Must set RESERVED3 = 3 bytes and HB size = 32KB.)
     */
} icp_qat_hw_comp_20_hw_comp_format_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HW_COMP_FORMAT_DEFAULT_VAL               \
    ICP_QAT_HW_COMP_20_HW_COMP_FORMAT_DEFLATE

/*****************************************************************************/
/* Reserved3 (Set By FW to default value), located in lower 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RESERVED3_CONTROL_BITPOS 4
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RESERVED3_CONTROL_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible RESERVED3 field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_RESERVED3_CONTROL_3B = 0x0,
    /* 0 - Match 3 B */
    ICP_QAT_HW_COMP_20_RESERVED3_CONTROL_4B = 0x1,
    /* 1 - Match 4 B */
} icp_qat_hw_comp_20_reserved3_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RESERVED3_CONTROL_DEFAULT_VAL            \
    ICP_QAT_HW_COMP_20_RESERVED3_CONTROL_3B

/*****************************************************************************/
/* Skip Hash Collision (Set By FW to default value), located in lower 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_COLLISION_BITPOS 3
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_COLLISION_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible SKIP_HASH_COLLISION field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_SKIP_HASH_COLLISION_ALLOW = 0x0,
    /* When set to 0, hash collisions are allowed.  */
    ICP_QAT_HW_COMP_20_SKIP_HASH_COLLISION_DONT_ALLOW = 0x1,
    /* When set to 0, hash collisions are allowed.  */
} icp_qat_hw_comp_20_skip_hash_collision_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_COLLISION_DEFAULT_VAL          \
    ICP_QAT_HW_COMP_20_SKIP_HASH_COLLISION_ALLOW

/*****************************************************************************/
/* Skip Hash Update (Set By FW to default value) , located in lower 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_UPDATE_BITPOS 2
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_UPDATE_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible SKIP_HASH_UPDATE field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_SKIP_HASH_UPDATE_ALLOW = 0x0,
    /* 0 - hash updates are not skipped.  */
    ICP_QAT_HW_COMP_20_SKIP_HASH_UPDATE_DONT_ALLOW = 0x1,
    /* 1 - hash updates are skipped.  */
} icp_qat_hw_comp_20_skip_hash_update_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_UPDATE_DEFAULT_VAL             \
    ICP_QAT_HW_COMP_20_SKIP_HASH_UPDATE_ALLOW

/*****************************************************************************/
/* 3-Byte Match Skip (Set By FW to default value), located in lower 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_BYTE_SKIP_BITPOS 1
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_BYTE_SKIP_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible BYTE_SKIP field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_BYTE_SKIP_3BYTE_TOKEN = 0x0,
    /* 0 - Use 3-byte token  */
    ICP_QAT_HW_COMP_20_BYTE_SKIP_3BYTE_LITERAL = 0x1,
    /* 0 - Use 3-byte literal  */
} icp_qat_hw_comp_20_byte_skip_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_BYTE_SKIP_DEFAULT_VAL                    \
    ICP_QAT_HW_COMP_20_BYTE_SKIP_3BYTE_TOKEN

/*****************************************************************************/
/* Extended Delayed Match Mode enabled (Set By the Driver), located in lower
 * 32bit */
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_EXTENDED_DELAY_MATCH_MODE_BITPOS 0
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_EXTENDED_DELAY_MATCH_MODE_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible EXTENDED_DELAY_MATCH_MODE field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_COMP_20_EXTENDED_DELAY_MATCH_MODE_EDMM_DISABLED = 0x0,
    /* 0 - EXTENDED_DELAY_MATCH_MODE disabled  */
    ICP_QAT_HW_COMP_20_EXTENDED_DELAY_MATCH_MODE_EDMM_ENABLED = 0x1,
    /* 1 - EXTENDED_DELAY_MATCH_MODE enabled  */
} icp_qat_hw_comp_20_extended_delay_match_mode_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_EXTENDED_DELAY_MATCH_MODE_DEFAULT_VAL    \
    ICP_QAT_HW_COMP_20_EXTENDED_DELAY_MATCH_MODE_EDMM_DISABLED

/*****************************************************************************/
/* Speculative Decoder Disable (Set By the Driver/ Application), located in
 * upper 32bit */
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_SPECULATIVE_DECODER_CONTROL_BITPOS 31
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_SPECULATIVE_DECODER_CONTROL_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible SPECULATIVE_DECODER_CONTROL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_DECOMP_20_SPECULATIVE_DECODER_CONTROL_ENABLE = 0x0,
    /* 0b - Enabled  */
    ICP_QAT_HW_DECOMP_20_SPECULATIVE_DECODER_CONTROL_DISABLE = 0x1,
    /* 1b - Disabled  */
} icp_qat_hw_decomp_20_speculative_decoder_control_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_SPECULATIVE_DECODER_CONTROL_DEFAULT_VAL \
    ICP_QAT_HW_DECOMP_20_SPECULATIVE_DECODER_CONTROL_ENABLE

/*****************************************************************************/
/* RESERVED4 Disable (Set By the Driver/ Application), located in upper 32bit */
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_RESERVED4_CONTROL_BITPOS 30
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_RESERVED4_CONTROL_MASK 0x1
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible RESERVED4 field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_DECOMP_20_RESERVED4_CONTROL_ENABLE = 0x0,
    /* 0b - Enabled  */
    ICP_QAT_HW_DECOMP_20_RESERVED4_CONTROL_DISABLE = 0x1,
    /* 1b - Disabled  */
} icp_qat_hw_decomp_20_reserved4_control_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_RESERVED4_CONTROL_DEFAULT_VAL          \
    ICP_QAT_HW_DECOMP_20_RESERVED4_CONTROL_ENABLE

/*****************************************************************************/
/* History Buffer Size (Set By the Driver/ Application), located in lower 32bit
 */
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HBS_CONTROL_BITPOS 14
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HBS_CONTROL_MASK 0x7
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible HBS_CONTROL field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_DECOMP_20_HBS_CONTROL_HBS_IS_32KB = 0x0,
    /* 000b - 32KB  */
} icp_qat_hw_decomp_20_hbs_control_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HBS_CONTROL_DEFAULT_VAL                \
    ICP_QAT_HW_DECOMP_20_HBS_CONTROL_HBS_IS_32KB

/*****************************************************************************/
/* Decompression Format (Set By Driver/Application. Also See CMD ID), located in
 * lower 32bit */
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HW_DECOMP_FORMAT_BITPOS 5
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HW_DECOMP_FORMAT_MASK 0x7
/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible HW_DECOMP_FORMAT field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_DECOMP_20_HW_DECOMP_FORMAT_DEFLATE = 0x1,
    /* 001 - Static DEFLATE. (Must set RESERVED3 = 3 bytes and HB size = 32KB.)
     */
} icp_qat_hw_decomp_20_hw_comp_format_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HW_DECOMP_FORMAT_DEFAULT_VAL           \
    ICP_QAT_HW_DECOMP_20_HW_DECOMP_FORMAT_DEFLATE

/*****************************************************************************/
/* Decompression Format (Set By Driver/Application. Also See CMD ID), located in
 * lower 32bit */
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_RESERVED3_CONTROL_BITPOS 4
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_RESERVED3_CONTROL_MASK 0x1

/*
 ****************************************************************************
 * @ingroup icp_qat_hw_defs
 * @description
 *      Enumeration of possible RESERVED3 field values
 *****************************************************************************/
typedef enum
{
    ICP_QAT_HW_DECOMP_20_RESERVED3_CONTROL_MATCH_3B = 0x0,
    /* 0 - Match 3 B */
    ICP_QAT_HW_DECOMP_20_RESERVED3_CONTROL_MATCH_4B = 0x1,
    /* 1 - Match 4 B */
} icp_qat_hw_decomp_20_reserved3_control_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_RESERVED3_CONTROL_DEFAULT_VAL          \
    ICP_QAT_HW_DECOMP_20_RESERVED_CONTROL_MATCH_3B

#endif /* _ICP_QAT_HW_20_COMP_DEFS_H */
