# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FileVersion(Model):
    """Information about the version of image store file.

    :param version_number: The current image store version number for the file
     is used in image store for checking whether it need to be updated.
    :type version_number: str
    :param epoch_data_loss_number: The epoch data loss number of image store
     replica when this file entry was updated or created.
    :type epoch_data_loss_number: str
    :param epoch_configuration_number: The epoch configuration version number
     of the image store replica when this file entry was created or updated.
    :type epoch_configuration_number: str
    """

    _attribute_map = {
        'version_number': {'key': 'VersionNumber', 'type': 'str'},
        'epoch_data_loss_number': {'key': 'EpochDataLossNumber', 'type': 'str'},
        'epoch_configuration_number': {'key': 'EpochConfigurationNumber', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FileVersion, self).__init__(**kwargs)
        self.version_number = kwargs.get('version_number', None)
        self.epoch_data_loss_number = kwargs.get('epoch_data_loss_number', None)
        self.epoch_configuration_number = kwargs.get('epoch_configuration_number', None)
