# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobStepOutput(Model):
    """The output configuration of a job step.

    All required parameters must be populated in order to send to Azure.

    :param type: The output destination type. Possible values include:
     'SqlDatabase'. Default value: "SqlDatabase" .
    :type type: str or ~azure.mgmt.sql.models.JobStepOutputType
    :param subscription_id: The output destination subscription id.
    :type subscription_id: str
    :param resource_group_name: The output destination resource group.
    :type resource_group_name: str
    :param server_name: Required. The output destination server name.
    :type server_name: str
    :param database_name: Required. The output destination database.
    :type database_name: str
    :param schema_name: The output destination schema. Default value: "dbo" .
    :type schema_name: str
    :param table_name: Required. The output destination table.
    :type table_name: str
    :param credential: Required. The resource ID of the credential to use to
     connect to the output destination.
    :type credential: str
    """

    _validation = {
        'server_name': {'required': True},
        'database_name': {'required': True},
        'table_name': {'required': True},
        'credential': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'table_name': {'key': 'tableName', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'str'},
    }

    def __init__(self, *, server_name: str, database_name: str, table_name: str, credential: str, type="SqlDatabase", subscription_id: str=None, resource_group_name: str=None, schema_name: str="dbo", **kwargs) -> None:
        super(JobStepOutput, self).__init__(**kwargs)
        self.type = type
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.server_name = server_name
        self.database_name = database_name
        self.schema_name = schema_name
        self.table_name = table_name
        self.credential = credential
