# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TransformOutput(Model):
    """Describes the properties of a TransformOutput, which are the rules to be
    applied while generating the desired output.

    All required parameters must be populated in order to send to Azure.

    :param on_error: A Transform can define more than one outputs. This
     property defines what the service should do when one output fails - either
     continue to produce other outputs, or, stop the other outputs. The default
     is stop. Possible values include: 'StopProcessingJob', 'ContinueJob'
    :type on_error: str or ~azure.mgmt.media.models.OnErrorType
    :param relative_priority: Sets the relative priority of the
     TransformOutputs within a Transform. This sets the priority that the
     service uses for processing TransformOutputs. The default priority is
     Normal. Possible values include: 'Low', 'Normal', 'High'
    :type relative_priority: str or ~azure.mgmt.media.models.Priority
    :param preset: Required. Preset that describes the operations that will be
     used to modify, transcode, or extract insights from the source file to
     generate the output.
    :type preset: ~azure.mgmt.media.models.Preset
    """

    _validation = {
        'preset': {'required': True},
    }

    _attribute_map = {
        'on_error': {'key': 'onError', 'type': 'OnErrorType'},
        'relative_priority': {'key': 'relativePriority', 'type': 'Priority'},
        'preset': {'key': 'preset', 'type': 'Preset'},
    }

    def __init__(self, **kwargs):
        super(TransformOutput, self).__init__(**kwargs)
        self.on_error = kwargs.get('on_error', None)
        self.relative_priority = kwargs.get('relative_priority', None)
        self.preset = kwargs.get('preset', None)
