# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DatabaseObjectName(Model):
    """A representation of the name of an object in a database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar database_name: The unescaped name of the database containing the
     object
    :vartype database_name: str
    :ivar object_name: The unescaped name of the object
    :vartype object_name: str
    :ivar schema_name: The unescaped name of the schema containing the object
    :vartype schema_name: str
    :param object_type: Type of the object in the database. Possible values
     include: 'StoredProcedures', 'Table', 'User', 'View', 'Function'
    :type object_type: str or ~azure.mgmt.datamigration.models.ObjectType
    """

    _validation = {
        'database_name': {'readonly': True},
        'object_name': {'readonly': True},
        'schema_name': {'readonly': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabaseObjectName, self).__init__(**kwargs)
        self.database_name = None
        self.object_name = None
        self.schema_name = None
        self.object_type = kwargs.get('object_type', None)
