# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Job(Model):
    """The Job object.

    :param id: The job id.
    :type id: str
    :param team_name: The team name associated with the job.
    :type team_name: str
    :param status: The status string (<Pending, Failed, Completed>).
    :type status: str
    :param workflow_id: The Id of the workflow.
    :type workflow_id: str
    :param type: Type of the content.
    :type type: str
    :param call_back_endpoint: The callback endpoint.
    :type call_back_endpoint: str
    :param review_id: Review Id if one is created.
    :type review_id: str
    :param result_meta_data: Array of KeyValue pairs.
    :type result_meta_data:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param job_execution_report: Job execution report- Array of KeyValue pairs
     object.
    :type job_execution_report:
     list[~azure.cognitiveservices.vision.contentmoderator.models.JobExecutionReportDetails]
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'team_name': {'key': 'TeamName', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'workflow_id': {'key': 'WorkflowId', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'call_back_endpoint': {'key': 'CallBackEndpoint', 'type': 'str'},
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'result_meta_data': {'key': 'ResultMetaData', 'type': '[KeyValuePair]'},
        'job_execution_report': {'key': 'JobExecutionReport', 'type': '[JobExecutionReportDetails]'},
    }

    def __init__(self, id=None, team_name=None, status=None, workflow_id=None, type=None, call_back_endpoint=None, review_id=None, result_meta_data=None, job_execution_report=None):
        super(Job, self).__init__()
        self.id = id
        self.team_name = team_name
        self.status = status
        self.workflow_id = workflow_id
        self.type = type
        self.call_back_endpoint = call_back_endpoint
        self.review_id = review_id
        self.result_meta_data = result_meta_data
        self.job_execution_report = job_execution_report
