# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeCounts(Model):
    """The number of nodes in each node state.

    :param creating: The number of nodes in the creating state.
    :type creating: int
    :param idle: The number of nodes in the idle state.
    :type idle: int
    :param offline: The number of nodes in the offline state.
    :type offline: int
    :param preempted: The number of nodes in the preempted state.
    :type preempted: int
    :param rebooting: The count of nodes in the rebooting state.
    :type rebooting: int
    :param reimaging: The number of nodes in the reimaging state.
    :type reimaging: int
    :param running: The number of nodes in the running state.
    :type running: int
    :param starting: The number of nodes in the starting state.
    :type starting: int
    :param start_task_failed: The number of nodes in the startTaskFailed
     state.
    :type start_task_failed: int
    :param leaving_pool: The number of nodes in the leavingPool state.
    :type leaving_pool: int
    :param unknown: The number of nodes in the unknown state.
    :type unknown: int
    :param unusable: The number of nodes in the unusable state.
    :type unusable: int
    :param waiting_for_start_task: The number of nodes in the
     waitingForStartTask state.
    :type waiting_for_start_task: int
    :param total: The total number of nodes.
    :type total: int
    """

    _validation = {
        'creating': {'required': True},
        'idle': {'required': True},
        'offline': {'required': True},
        'preempted': {'required': True},
        'rebooting': {'required': True},
        'reimaging': {'required': True},
        'running': {'required': True},
        'starting': {'required': True},
        'start_task_failed': {'required': True},
        'leaving_pool': {'required': True},
        'unknown': {'required': True},
        'unusable': {'required': True},
        'waiting_for_start_task': {'required': True},
        'total': {'required': True},
    }

    _attribute_map = {
        'creating': {'key': 'creating', 'type': 'int'},
        'idle': {'key': 'idle', 'type': 'int'},
        'offline': {'key': 'offline', 'type': 'int'},
        'preempted': {'key': 'preempted', 'type': 'int'},
        'rebooting': {'key': 'rebooting', 'type': 'int'},
        'reimaging': {'key': 'reimaging', 'type': 'int'},
        'running': {'key': 'running', 'type': 'int'},
        'starting': {'key': 'starting', 'type': 'int'},
        'start_task_failed': {'key': 'startTaskFailed', 'type': 'int'},
        'leaving_pool': {'key': 'leavingPool', 'type': 'int'},
        'unknown': {'key': 'unknown', 'type': 'int'},
        'unusable': {'key': 'unusable', 'type': 'int'},
        'waiting_for_start_task': {'key': 'waitingForStartTask', 'type': 'int'},
        'total': {'key': 'total', 'type': 'int'},
    }

    def __init__(self, creating, idle, offline, preempted, rebooting, reimaging, running, starting, start_task_failed, leaving_pool, unknown, unusable, waiting_for_start_task, total):
        super(NodeCounts, self).__init__()
        self.creating = creating
        self.idle = idle
        self.offline = offline
        self.preempted = preempted
        self.rebooting = rebooting
        self.reimaging = reimaging
        self.running = running
        self.starting = starting
        self.start_task_failed = start_task_failed
        self.leaving_pool = leaving_pool
        self.unknown = unknown
        self.unusable = unusable
        self.waiting_for_start_task = waiting_for_start_task
        self.total = total
