# -*- coding: utf-8 -*-

from tests.baseclass import BaseTestCase
from meh import Config, ConfigError

def callback1():
    return "This was generated by the callback1"

def callback2():
    return "This was generated by the callback2"

def callback3():
    raise RuntimeError("Testing callback raising exception")

def callback4():
    return "This was generated by the callback4"

def callback5():
    return ""

class Callbacks_TestCase(BaseTestCase):
    def runTest(self):
        conf = Config(programName="CallbacksTest",
                      programVersion="1.0",
                      callbackDict={"callback1": (callback1, False),
                                    "callback2": (callback2, False)})

        # another way to register callback
        conf.register_callback("callback3", callback2)

        # callback with given item name already registered
        with self.assertRaises(ConfigError):
            conf.register_callback("callback3", callback3)

        # should not raise exception
        conf.register_callback("callback3", callback3, override=True)

        conf.register_callback("callback4", callback4, attchmnt_only=True)
        conf.register_callback("callback5", callback5, attchmnt_only=False)

        # should not raise exception
        dump = self.dump(conf, None)

        self.assertIn("callback1:\nThis was generated by the callback1\n",
                      dump)
        self.assertIn("callback2:\nThis was generated by the callback2\n",
                      dump)
        self.assertIn("callback3: Caused error", dump)

        # should not appear in the dump (attachment only)
        self.assertNotIn("callback4", dump)

        # should not appear in the dump (nothing provided)
        self.assertNotIn("callback5", dump)


