from .. import Provider as AddressProvider


class Provider(AddressProvider):
    city_formats = ('{{city_name}}', )

    street_name_formats = ('{{street_name}}', )
    street_address_formats = ('{{street_name}} {{building_number}}', )
    address_formats = ('{{street_address}}\n{{postcode}} {{city}}', )

    building_number_formats = ('%', '%#', '%##')

    street_suffixes_long = ('ulica', 'trieda', 'nábrežie', 'námestie')
    street_suffixes_short = ('ul.', 'tr.', 'nábr.', 'nám.')

    postcode_formats = (
        "8## ##",
        "9## ##",
        "0## ##",
    )

    cities = (
        'Ábelová', 'Abovce', 'Abrahám', 'Abrahámovce', 'Abrahámovce',
        'Abramová', 'Abranovce', 'Adidovce', 'Alekšince', 'Andovce',
        'Andrejová', 'Ardanovce', 'Ardovo', 'Arnutovce', 'Báb', 'Babie',
        'Babín', 'Babiná', 'Babindol', 'Babinec', 'Bacúch', 'Bacúrov', 'Báč',
        'Bačka', 'Bačkov', 'Bačkovík', 'Badín', 'Baďan', 'Báhoň', 'Bajany',
        'Bajč', 'Bajerov', 'Bajerovce', 'Bajka', 'Bajtava', 'Baka', 'Baláže',
        'Baldovce', 'Balog nad Ipľom', 'Baloň', 'Banka', 'Bánov',
        'Bánovce nad Bebravou', 'Bánovce nad Ondavou', 'Banská Belá',
        'Banská Štiavnica', 'Banská Bystrica', 'Banské', 'Banský Studenec',
        'Baňa', 'Bara', 'Barca', 'Bartošovce', 'Bardoňovo',
        'Bartošova Lehôtka', 'Bardejov', 'Baška', 'Baškovce', 'Baškovce',
        'Bašovce', 'Batizovce', 'Bátorová', 'Bátka', 'Bátorove Kosihy',
        'Bátovce', 'Beharovce', 'Beckov', 'Becherov', 'Belá', 'Belá',
        'Belá - Dulice', 'Belá nad Cirochou', 'Beladice', 'Belejovce', 'Belín',
        'Belina', 'Belince', 'Bellova Ves', 'Beloveža', 'Beluj', 'Beluša',
        'Belža', 'Beniakovce', 'Benice', 'Benkovce', 'Beňadiková',
        'Beňadikovce', 'Beňadovo', 'Beňatina', 'Beňuš', 'Bernolákovo',
        'Bertotovce', 'Beša', 'Beša', 'Bešeňov', 'Bešeňová', 'Betlanovce',
        'Betliar', 'Bežovce', 'Bidovce', 'Biel', 'Bielovce', 'Biely Kostol',
        'Bijacovce', 'Bílkove Humence', 'Bíňa', 'Bíňovce', 'Biskupice',
        'Biskupová', 'Bitarová', 'Blahová', 'Blatná na Ostrove',
        'Blatná Polianka', 'Blatné', 'Blatné Remety', 'Blatné Revištia',
        'Blatnica', 'Blažice', 'Blažovce', 'Blesovce', 'Blhovce', 'Bobot',
        'Bobrov', 'Bobrovček', 'Bobrovec', 'Bobrovník', 'Bočiar', 'Bodíky',
        'Bodiná', 'Bodorová', 'Bodovce', 'Bodružal', 'Bodza',
        'Bodzianske Lúky', 'Bogliarka', 'Bohdanovce', 'Bohdanovce nad Trnavou',
        'Boheľov', 'Bohunice', 'Bohunice', 'Bohúňovo', 'Bojná', 'Bojnice',
        'Bojničky', 'Boldog', 'Boleráz', 'Bolešov', 'Boliarov', 'Boľ',
        'Boľkovce', 'Borcová', 'Borčany', 'Borčice', 'Borinka', 'Borová',
        'Borovce', 'Borský Mikuláš', 'Borský Svätý Jur', 'Borša', 'Bory',
        'Bošáca', 'Bošany', 'Bottovo', 'Boťany', 'Bôrka', 'Bracovce', 'Branč',
        'Branovo', 'Bratislava', 'Okres Bratislava II', 'Okres Bratislava III',
        'Okres Bratislava IV', 'Okres Bratislava V', 'Braväcovo', 'Brdárka',
        'Brehov', 'Brehy', 'Brekov', 'Brestov', 'Brestov',
        'Brestov nad Laborcom', 'Brestovany', 'Brestovec', 'Brestovec',
        'Bretejovce', 'Bretka', 'Breza', 'Brezany', 'Brezina', 'Breziny',
        'Breznica', 'Breznička', 'Breznička', 'Brezno', 'Brezolupy', 'Brezov',
        'Brezová pod Bradlom', 'Brezovec', 'Brezovica', 'Brezovica',
        'Brezovička', 'Brezovka', 'Brežany', 'Brhlovce', 'Brieštie', 'Brodské',
        'Brodzany', 'Brunovce', 'Brusnica', 'Brusník', 'Brusno', 'Brutovce',
        'Bruty', 'Brvnište', 'Brzotín', 'Buclovany', 'Búč', 'Bučany', 'Budča',
        'Budikovany', 'Budimír', 'Budiná', 'Budince', 'Budiš', 'Budkovce',
        'Budmerice', 'Buglovce', 'Buková', 'Bukovce', 'Bukovec', 'Bukovec',
        'Bukovina', 'Bulhary', 'Bunetice', 'Bunkovce', 'Bušince', 'Bušovce',
        'Buzica', 'Buzitka', 'Bystrá', 'Bystrá', 'Bystrany', 'Bystré',
        'Bystričany', 'Bystrička', 'Byšta', 'Bytča', 'Bzenica', 'Bzenov',
        'Bzince pod Javorinou', 'Bziny', 'Bzovík', 'Bzovská Lehôtka', 'Bžany',
        'Cabaj - Čápor', 'Cabov', 'Cakov', 'Cejkov', 'Cernina', 'Cerová',
        'Cerovo', 'Cestice', 'Cífer', 'Cigeľ', 'Cigeľka', 'Cigla', 'Cimenná',
        'Cinobaňa', 'Čabalovce', 'Čabiny', 'Čabradský Vrbovok', 'Čadca',
        'Čachtice', 'Čajkov', 'Čaka', 'Čakajovce', 'Čakanovce', 'Čakanovce',
        'Čakany', 'Čaklov', 'Čalovec', 'Čamovce', 'Čaňa', 'Čaradice', 'Čáry',
        'Častá', 'Častkov', 'Častkovce', 'Čata', 'Čataj', 'Čavoj', 'Čebovce',
        'Čečehov', 'Čečejovce', 'Čechy', 'Čechynce', 'Čekovce', 'Čeláre',
        'Čelkova Lehota', 'Čelovce', 'Čelovce', 'Čeľadice', 'Čeľadince',
        'Čeľovce', 'Čenkovce', 'Čerenčany', 'Čereňany', 'Čerhov', 'Čerín',
        'Čermany', 'Černík', 'Černina', 'Černochov', 'Čertižné',
        'Červená Voda', 'Červenica', 'Červenica pri Sabinove', 'Červeník',
        'Červený Hrádok', 'Červený Kameň', 'Červený Kláštor', 'Červeňany',
        'České Brezovo', 'Čičarovce', 'Čičava', 'Čičmany', 'Číčov', 'Čierna',
        'Čierna Lehota', 'Čierna Lehota', 'Čierna nad Tisou', 'Čierna Voda',
        'Čierne', 'Čierne Kľačany', 'Čierne nad Topľou', 'Čierne Pole',
        'Čierny Balog', 'Čierny Brod', 'Čierny Potok', 'Čifáre',
        'Čiližská Radvaň', 'Čimhová', 'Čirč', 'Číž', 'Čižatice', 'Čoltovo',
        'Čremošné', 'Čučma', 'Čukalovce', 'Dačov Lom', 'Daletice', 'Danišovce',
        'Dargov', 'Davidov', 'Debraď', 'Dedačov', 'Dedina Mládeže', 'Dedinka',
        'Dedinky', 'Dechtice', 'Dekýš', 'Demandice', 'Demänovská Dolina',
        'Demjata', 'Detrík', 'Detva', 'Detvianska Huta', 'Devičany', 'Devičie',
        'Dežerice', 'Diaková', 'Diakovce', 'Diviacka Nová Ves',
        'Diviaky nad Nitricou', 'Divín', 'Divina', 'Divinka', 'Dlhá',
        'Dlhá nad Kysucou', 'Dlhá nad Oravou', 'Dlhá nad Váhom', 'Dlhá Ves',
        'Dlhé Klčovo', 'Dlhé nad Cirochou', 'Dlhé Pole', 'Dlhé Stráže',
        'Dlhoňa', 'Dlžín', 'Dobrá', 'Dobrá Niva', 'Dobrá Voda', 'Dobroč',
        'Dobrohošť', 'Dobroslava', 'Dobšiná', 'Dohňany', 'Dojč', 'Dolinka',
        'Dolná Breznica', 'Dolná Krupá', 'Dolná Lehota', 'Dolná Mariková',
        'Dolná Mičiná', 'Dolná Poruba', 'Dolná Seč', 'Dolná Streda',
        'Dolná Strehová', 'Dolná Súča', 'Dolná Tižina', 'Dolná Trnávka',
        'Dolná Ves', 'Dolná Ždaňa', 'Dolné Dubové', 'Dolné Kočkovce',
        'Dolné Lefantovce', 'Dolné Lovčice', 'Dolné Mladonice',
        'Dolné Naštice', 'Dolné Obdokovce', 'Dolné Orešany', 'Dolné Otrokovce',
        'Dolné Plachtince', 'Dolné Saliby', 'Dolné Semerovce', 'Dolné Srnie',
        'Dolné Strháre', 'Dolné Trhovište', 'Dolné Vestenice', 'Dolné Zahorany',
        'Dolné Zelenice', 'Dolný Badín', 'Dolný Bar', 'Dolný Harmanec',
        'Dolný Hričov', 'Dolný Chotár', 'Dolný Kalník', 'Dolný Kubín',
        'Dolný Lieskov', 'Dolný Lopašov', 'Dolný Ohaj', 'Dolný Pial',
        'Dolný Štál', 'Dolný Vadičov', 'Doľany', 'Doľany', 'Domadice',
        'Domaníky', 'Domaniža', 'Domaňovce', 'Donovaly', 'Drábsko', 'Drahňov',
        'Drahovce', 'Dravce', 'Dražice', 'Dražkovce', 'Drážovce', 'Drienčany',
        'Drienica', 'Drienov', 'Drienovec', 'Drienovo', 'Drienovská Nová Ves',
        'Drietoma', 'Drnava', 'Drňa', 'Družstevná pri Hornáde', 'Drženice',
        'Držkovce', 'Dubinné', 'Dubnica nad Váhom', 'Dubnička', 'Dubník',
        'Dubno', 'Dubodiel', 'Dubová', 'Dubová', 'Dubovany', 'Dubovce',
        'Dubové', 'Dubové', 'Dubovec', 'Dubovica', 'Dúbrava', 'Dúbrava',
        'Dúbrava', 'Dúbravica', 'Dúbravka', 'Dúbravy', 'Ducové', 'Dudince',
        'Dukovce', 'Dulov', 'Dulova Ves', 'Dulovce', 'Dulovo',
        'Dunajská Lužná', 'Dunajov', 'Dunajská Streda', 'Dunajský Klátov',
        'Duplín', 'Dvorany nad Nitrou', 'Dvorec', 'Dvorianky', 'Dvorníky',
        'Dvorníky - Včeláre', 'Dvory nad Žitavou', 'Ďačov', 'Ďanová',
        'Ďapalovce', 'Ďubákovo', 'Ďurčiná', 'Ďurďoš', 'Ďurďošík', 'Ďurďové',
        'Ďurkov', 'Ďurková', 'Ďurkovce', 'Egreš', 'Fačkov', 'Falkušovce',
        'Farná', 'Fekišovce', 'Figa', 'Fijaš', 'Fiľakovo', 'Fiľakovské Kováče',
        'Fintice', 'Folkušová', 'Forbasy', 'Frička', 'Fričkovce', 'Fričovce',
        'Fulianka', 'Gabčíkovo', 'Gaboltov', 'Gajary', 'Galanta', 'Galovany',
        'Gánovce', 'Gáň', 'Gbelce', 'Gbely', 'Gbeľany', 'Geča', 'Gelnica',
        'Gemer', 'Gemerček', 'Gemerská Hôrka', 'Gemerská Panica',
        'Gemerská Poloma', 'Gemerská Ves', 'Gemerské Dechtáre',
        'Gemerské Michalovce', 'Gemerské Teplice', 'Gemerský Jablonec',
        'Gemerský Sad', 'Geraltov', 'Gerlachov', 'Gerlachov', 'Giglovce',
        'Giraltovce', 'Girovce', 'Glabušovce', 'Gočaltovo', 'Gočovo',
        'Golianovo', 'Gortva', 'Gôtovany', 'Granč - Petrovce',
        'Gregorova Vieska', 'Gregorovce', 'Gribov', 'Gruzovce', 'Gyňov',
        'Habovka', 'Habura', 'Hačava', 'Háj', 'Háj', 'Hajná Nová Ves',
        'Hajnáčka', 'Hájske', 'Hajtovka', 'Haláčovce', 'Halič', 'Haligovce',
        'Haluzice', 'Hamuliakovo', 'Handlová', 'Hanigovce', 'Haniska',
        'Haniska', 'Hanková', 'Hankovce', 'Hankovce', 'Hanušovce nad Topľou',
        'Harakovce', 'Harhaj', 'Harichovce', 'Harmanec', 'Hatalov', 'Hatné',
        'Havaj', 'Havka', 'Havranec', 'Hažín', 'Hažín nad Cirochou', 'Hažlín',
        'Helcmanovce', 'Heľpa', 'Henckovce', 'Henclová', 'Hencovce',
        'Hendrichovce', 'Herľany', 'Hermanovce', 'Hermanovce nad Topľou',
        'Hertník', 'Hervartov', 'Hiadeľ', 'Hincovce', 'Hladovka', 'Hlboké',
        'Hliník nad Hronom', 'Hlinné', 'Hlivištia', 'Hlohovec', 'Hniezdne',
        'Hnilčík', 'Hnilec', 'Hnojné', 'Hnúšťa', 'Hodejov', 'Hodejovec',
        'Hodkovce', 'Hodruša - Hámre', 'Hokovce', 'Holčíkovce', 'Holiare',
        'Holice', 'Holíč', 'Holiša', 'Holumnica', 'Honce', 'Hontianska Vrbica',
        'Hontianske Moravce', 'Hontianske Nemce', 'Hontianske Tesáre',
        'Hontianske Trsťany', 'Horná Breznica', 'Horná Kráľová', 'Horná Krupá',
        'Horná Lehota', 'Horná Lehota', 'Horná Mariková', 'Horná Mičiná',
        'Horná Poruba', 'Horná Potôň', 'Horná Seč', 'Horná Streda',
        'Horná Strehová', 'Horná Súča', 'Horná Štubňa', 'Horná Ves',
        'Horná Ves', 'Horná Ždaňa', 'Horné Dubové', 'Horné Hámre',
        'Horné Chlebany', 'Horné Lefantovce', 'Horné Mladonice', 'Horné Mýto',
        'Horné Naštice', 'Horné Obdokovce', 'Horné Orešany', 'Horné Otrokovce',
        'Horné Plachtince', 'Horné Pršany', 'Horné Saliby', 'Horné Semerovce',
        'Horné Srnie', 'Horné Strháre', 'Horné Štitáre', 'Horné Trhovište',
        'Horné Turovce', 'Horné Vestenice', 'Horné Zahorany', 'Horné Zelenice',
        'Horný Badín', 'Horný Bar', 'Horný Hričov', 'Horný Kalník',
        'Horný Lieskov', 'Horný Pial', 'Horný Tisovník', 'Horný Vadičov',
        'Horňa', 'Horňany', 'Horovce', 'Horovce', 'Hoste', 'Hostice', 'Hostie',
        'Hostišovce', 'Hostovice', 'Hosťová', 'Hosťovce', 'Hosťovce',
        'Hozelec', 'Hôrka', 'Hôrka nad Váhom', 'Hôrky', 'Hrabičov', 'Hrabkov',
        'Hrabová Roztoka', 'Hrabovčík', 'Hrabovec', 'Hrabovec nad Laborcom',
        'Hrabské', 'Hrabušice', 'Hradisko', 'Hradište', 'Hradište',
        'Hradište pod Vrátnom', 'Hrádok', 'Hrachovište', 'Hrachovo',
        'Hraničné', 'Hranovnica', 'Hraň', 'Hrašné', 'Hrašovík', 'Hrčeľ',
        'Hrhov', 'Hriadky', 'Hričovské Podhradie', 'Hriňová', 'Hrišovce',
        'Hrkovce', 'Hrlica', 'Hrnčiarovce nad Parnou', 'Hrnčiarska Ves',
        'Hrnčiarske Zalužany', 'Hrochoť', 'Hromoš', 'Hronec', 'Hronovce',
        'Hronsek', 'Hronská Breznica', 'Hronská Dúbrava', 'Hronské Kľačany',
        'Hronské Kosihy', 'Hronský Beňadik', 'Hrubá Borša', 'Hruboňovo',
        'Hrubov', 'Hrubý Šúr', 'Hrušov', 'Hrušov', 'Hrušovany', 'Hrušovo',
        'Hruštín', 'Hubice', 'Hubina', 'Hubošovce', 'Hubová', 'Hubovo',
        'Hucín', 'Hudcovce', 'Hul', 'Humenné', 'Huncovce', 'Hunkovce',
        'Hurbanova Ves', 'Hurbanovo', 'Husák', 'Husiná', 'Hutka', 'Huty',
        'Hviezdoslavov', 'Hvozdnica', 'Hybe', 'Hýľov', 'Chanava', 'Chlebnice',
        'Chlmec', 'Chľaba', 'Chmeľnica', 'Chmeľov', 'Chmeľová', 'Chmeľovec',
        'Chminianska Nová Ves', 'Chminianske Jakubovany', 'Chmiňany', 'Choča',
        'Chocholná - Velčice', 'Choňkovce', 'Chorvátsky Grob', 'Chorváty',
        'Chotča', 'Chotín', 'Chrabrany', 'Chrámec', 'Chrastince', 'Chrastné',
        'Chrasť nad Hornádom', 'Chrenovec - Brusno', 'Chropov', 'Chrťany',
        'Chtelnica', 'Chudá Lehota', 'Chvalová', 'Chvojnica', 'Chvojnica',
        'Chynorany', 'Chyžné', 'Igram', 'Ihľany', 'Ihráč', 'Ilava', 'Iliašovce',
        'Ilija', 'Imeľ', 'Inovce', 'Iňa', 'Iňačovce', 'Ipeľské Predmostie',
        'Ipeľské Úľany', 'Ipeľský Sokolec', 'Istebné', 'Ivachnová', 'Ivančiná',
        'Ivanice', 'Ivanka pri Dunaji', 'Ivanka pri Nitre', 'Ivanovce', 'Iža',
        'Ižipovce', 'Ižkovce', 'Jablonec', 'Jablonica', 'Jablonka', 'Jablonov',
        'Jablonov nad Turňou', 'Jablonové', 'Jablonové', 'Jabloň', 'Jabloňovce',
        'Jacovce', 'Jahodná', 'Jaklovce', 'Jakovany', 'Jakubany', 'Jakubov',
        'Jakubova Voľa', 'Jakubovany', 'Jakubovany', 'Jakušovce', 'Jalová',
        'Jalovec', 'Jalovec', 'Jalšové', 'Jalšovík', 'Jamník', 'Jamník',
        'Janice', 'Janík', 'Janíky', 'Jankovce', 'Janov', 'Janova Lehota',
        'Janovce', 'Jánovce', 'Jánovce', 'Janovík', 'Jarabá', 'Jarabina',
        'Jarok', 'Jarovnice', 'Jasenica', 'Jasenie', 'Jasenov', 'Jasenov',
        'Jasenová', 'Jasenovce', 'Jasenové', 'Jasenovo', 'Jaslovské Bohunice',
        'Jasov', 'Jasová', 'Jastrabá', 'Jastrabie nad Topľou',
        'Jastrabie pri Michalovciach', 'Jatov', 'Javorina (vojenský obvod)',
        'Jazernica', 'Jedlinka', 'Jedľové Kostoľany', 'Jelenec', 'Jelka',
        'Jelšava', 'Jelšovce', 'Jelšovec', 'Jenkovce', 'Jesenské', 'Jesenské',
        'Jestice', 'Ješkova Ves', 'Jezersko', 'Jovice', 'Jovsa',
        'Jur nad Hronom', 'Jurkova Voľa', 'Jurová', 'Jurské', 'Juskova Voľa',
        'Kačanov', 'Kajal', 'Kalameny', 'Kalinkovo', 'Kalinov', 'Kalinovo',
        'Kalná nad Hronom', 'Kalná Roztoka', 'Kálnica', 'Kalnište', 'Kalonda',
        'Kalša', 'Kaloša', 'Kaluža', 'Kaľamenová', 'Kaľava', 'Kamanová',
        'Kamenec pod Vtáčnikom', 'Kamenica', 'Kamenica nad Cirochou',
        'Kamenica nad Hronom', 'Kameničany', 'Kameničná', 'Kamenín',
        'Kamenná Poruba', 'Kamenná Poruba', 'Kamenné Kosihy', 'Kamenný Most',
        'Kameňany', 'Kamienka', 'Kamienka', 'Kanianka', 'Kapišová', 'Kaplna',
        'Kapušany', 'Kapušianske Kľačany', 'Karlová', 'Karná', 'Kašov',
        'Kátlovce', 'Kátov', 'Kazimír', 'Kecerovce', 'Kecerovský Lipovec',
        'Kečkovce', 'Kečovo', 'Kechnec', 'Kendice', 'Kesovce', 'Keť',
        'Kežmarok', 'Kiarov', 'Kladzany', 'Klasov', 'Kláštor pod Znievom',
        'Klátova Nová Ves', 'Klčov', 'Klenov', 'Klenová', 'Klenovec',
        'Kleňany', 'Klieština', 'Klin', 'Klin nad Bodrogom', 'Klížska Nemá',
        'Klokoč', 'Klokočov', 'Klokočov', 'Klubina', 'Kluknava', 'Kľačany',
        'Kľače', 'Kľačno', 'Kľak', 'Kľúčovec', 'Kľušov', 'Kmeťovo',
        'Kobeliarovo', 'Kobylnice', 'Kobyly', 'Koceľovce', 'Kociha',
        'Kocurany', 'Kočín - Lančár', 'Kočovce', 'Kochanovce', 'Kochanovce',
        'Kojatice', 'Kojšov', 'Kokava nad Rimavicou', 'Kokošovce',
        'Kokšov - Bakša', 'Kolačkov', 'Kolačno', 'Koláre', 'Kolárovice',
        'Kolárovo', 'Kolbasov', 'Kolbovce', 'Kolibabovce', 'Kolinovce',
        'Kolíňany', 'Kolonica', 'Kolta', 'Komárany', 'Komárno', 'Komárov',
        'Komárovce', 'Komjatice', 'Komjatná', 'Komoča', 'Koniarovce',
        'Konrádovce', 'Konská', 'Konská', 'Koňuš', 'Kopčany', 'Kopernica',
        'Koplotovce', 'Koprivnica', 'Kordíky', 'Korejovce', 'Korňa', 'Koromľa',
        'Korunková', 'Korytárky', 'Korytné', 'Kosihovce', 'Kosihy nad Ipľom',
        'Kosorín', 'Kostolec', 'Kostolište', 'Kostolná pri Dunaji',
        'Kostolná Ves', 'Kostolná - Záriečie', 'Kostolné', 'Kostolné Kračany',
        'Kostoľany pod Tribečom', 'Koš', 'Košariská', 'Košarovce', 'Košeca',
        'Košecké Podhradie', 'Košice', 'Okres Košice II', 'Okres Košice III',
        'Okres Košice IV', 'Košická Belá', 'Košická Polianka',
        'Košické Oľšany', 'Košický Klečenov', 'Koškovce', 'Košolná', 'Košúty',
        'Košťany nad Turcom', 'Kotešová', 'Kotmanová', 'Kotrčiná Lúčka',
        'Kováčová', 'Kováčová', 'Kováčovce', 'Koválov', 'Koválovec', 'Kovarce',
        'Kozárovce', 'Kozelník', 'Kozí Vrbovok', 'Kožany', 'Kožuchov',
        'Kožuchovce', 'Kračúnovce', 'Krahule', 'Krajná Bystrá', 'Krajná Poľana',
        'Krajná Porúbka', 'Krajné', 'Krajné Čierno', 'Krakovany', 'Králiky',
        'Kráľ', 'Kráľov Brod', 'Kráľova Lehota', 'Kráľová nad Váhom',
        'Kráľová pri Senci', 'Kraľovany', 'Kráľovce', 'Kráľovce - Krnišov',
        'Kráľovičove Kračany', 'Kráľovský Chlmec', 'Kraskovo', 'Krásna Lúka',
        'Krásna Ves', 'Krásno', 'Krásno nad Kysucou', 'Krásnohorská Dlhá Lúka',
        'Krásnohorské Podhradie', 'Krásnovce', 'Krásny Brod', 'Krasňany',
        'Kravany', 'Kravany', 'Kravany nad Dunajom', 'Krčava', 'Kremná',
        'Kremnica', 'Kremnické Bane', 'Kristy', 'Krišľovce',
        'Krišovská Liesková', 'Krivá', 'Krivany', 'Kriváň', 'Krivé',
        'Krivoklát', 'Krivosúd - Bodovka', 'Kríže', 'Krížová Ves', 'Krížovany',
        'Križovany nad Dudváhom', 'Krná', 'Krnča', 'Krokava', 'Krompachy',
        'Krpeľany', 'Krškany', 'Krtovce', 'Kručov', 'Krupina', 'Krušetnica',
        'Krušinec', 'Krušovce', 'Kružlov', 'Kružlová', 'Kružná', 'Kružno',
        'Kšinná', 'Kubáňovo', 'Kučín', 'Kučín', 'Kuchyňa', 'Kuklov', 'Kuková',
        'Kukučínov', 'Kunerad', 'Kunešov', 'Kunova Teplica', 'Kuraľany',
        'Kurima', 'Kurimany', 'Kurimka', 'Kurov', 'Kusín', 'Kútniky', 'Kúty',
        'Kuzmice', 'Kuzmice', 'Kvačany', 'Kvačany', 'Kvakovce', 'Kvašov',
        'Kvetoslavov', 'Kyjatice', 'Kyjov', 'Kynceľová', 'Kysak', 'Kyselica',
        'Kysta', 'Kysucké Nové Mesto', 'Kysucký Lieskovec', 'Láb', 'Lackov',
        'Lacková', 'Lada', 'Ladce', 'Ladice', 'Ladmovce', 'Ladomerská Vieska',
        'Ladomirov', 'Ladomirová', 'Ladzany', 'Lakšárska Nová Ves', 'Lascov',
        'Laskár', 'Lastomír', 'Lastovce', 'Laškovce', 'Látky', 'Lazany',
        'Lazisko', 'Lazy pod Makytou', 'Lažany', 'Lednica', 'Lednické Rovne',
        'Legnava', 'Lehnice', 'Lehota', 'Lehota nad Rimavicou',
        'Lehota pod Vtáčnikom', 'Lehôtka', 'Lehôtka pod Brehmi', 'Lechnica',
        'Lekárovce', 'Leles', 'Leľa', 'Lemešany', 'Lenartov', 'Lenartovce',
        'Lendak', 'Lenka', 'Lentvora', 'Leopoldov', 'Lesenice', 'Lesíček',
        'Lesné', 'Lesnica', 'Leštiny', 'Lešť (vojenský obvod)', 'Letanovce',
        'Letničie', 'Leváre', 'Levice', 'Levkuška', 'Levoča', 'Ležiachov',
        'Libichava', 'Licince', 'Ličartovce', 'Liesek', 'Lieskovany',
        'Lieskovec', 'Lieskovec', 'Liešno', 'Liešťany', 'Lietava',
        'Lietavská Lúčka', 'Lietavská Svinná - Babkov', 'Likavka', 'Limbach',
        'Lipany', 'Lipník', 'Lipníky', 'Lipová', 'Lipová', 'Lipovany',
        'Lipovce', 'Lipové', 'Lipovec', 'Lipovec', 'Lipovník', 'Lipovník',
        'Liptovská Anna', 'Liptovská Kokava', 'Liptovská Lúžna',
        'Liptovská Osada', 'Liptovská Porúbka', 'Liptovská Sielnica',
        'Liptovská Štiavnica', 'Liptovská Teplá', 'Liptovská Teplička',
        'Liptovské Beharovce', 'Liptovské Kľačany', 'Liptovské Matiašovce',
        'Liptovské Revúce', 'Liptovské Sliače', 'Liptovský Hrádok',
        'Liptovský Ján', 'Liptovský Michal', 'Liptovský Mikuláš',
        'Liptovský Ondrej', 'Liptovský Peter', 'Liptovský Trnovec', 'Lisková',
        'Lišov', 'Litava', 'Litmanová', 'Livina', 'Livinské Opatovce', 'Livov',
        'Livovská Huta', 'Lodno', 'Lok', 'Lokca', 'Lom nad Rimavicou', 'Lomná',
        'Lomné', 'Lomnička', 'Lontov', 'Lopašov', 'Lopúchov', 'Lopušné Pažite',
        'Lošonec', 'Lovce', 'Lovča', 'Lovčica - Trubín', 'Lovinobaňa',
        'Lozorno', 'Ložín', 'Lubeník', 'Lubina', 'Lúč na Ostrove', 'Lučatín',
        'Lučenec', 'Lúčina', 'Lučivná', 'Lúčka', 'Lúčka', 'Lúčka', 'Lúčka',
        'Lúčky', 'Lúčky', 'Lúčky', 'Lúčnica nad Žitavou', 'Ludanice',
        'Ludrová', 'Luhyňa', 'Lúka', 'Lukačovce', 'Lukáčovce', 'Lukavica',
        'Lukavica', 'Lukov', 'Lukovištia', 'Lúky', 'Lula', 'Lupoč', 'Lutila',
        'Lutiše', 'Lužany', 'Lužany pri Topli', 'Lužianky', 'Lysá pod Makytou',
        'Lysica', 'Ľubá', 'Ľubela', 'Ľubica', 'Ľubietová', 'Ľubiša', 'Ľubochňa',
        'Ľuboreč', 'Ľuboriečka', 'Ľubotice', 'Ľubotín', 'Ľubovec', 'Ľudovítová',
        'Ľutina', 'Ľutov', 'Macov', 'Mad', 'Madunice', 'Magnezitovce',
        'Machulince', 'Majcichov', 'Majere', 'Majerovce', 'Makov', 'Makovce',
        'Malacky', 'Malachov', 'Malá Čalomija', 'Malá Čausa', 'Malá Čierna',
        'Malá Domaša', 'Malá Franková', 'Malá Hradná', 'Malá Ida',
        'Malá Lehota', 'Malá Lodina', 'Malá nad Hronom', 'Malá Poľana',
        'Malá Tŕňa', 'Málaš', 'Malatiná', 'Malatíny', 'Malcov', 'Malčice',
        'Malé Borové', 'Malé Dvorníky', 'Malé Chyndice', 'Malé Hoste',
        'Malé Kosihy', 'Malé Kozmálovce', 'Malé Kršteňany', 'Malé Lednice',
        'Malé Leváre', 'Malé Ludince', 'Malé Ozorovce', 'Malé Raškovce',
        'Malé Ripňany', 'Malé Straciny', 'Malé Trakany', 'Malé Uherce',
        'Malé Vozokany', 'Malé Zálužie', 'Malé Zlievce', 'Málinec', 'Malinová',
        'Malinovo', 'Malužiná', 'Malý Cetín', 'Malý Čepčín', 'Malý Horeš',
        'Malý Kamenec', 'Malý Krtíš', 'Malý Lapáš', 'Malý Lipník',
        'Malý Slavkov', 'Malý Slivník', 'Malý Šariš', 'Malženice', 'Mankovce',
        'Maňa', 'Marcelová', 'Margecany', 'Marhaň', 'Marianka', 'Markovce',
        'Markuška', 'Markušovce', 'Maršová - Rašov', 'Martin',
        'Martin nad Žitavou', 'Martinček', 'Martinová', 'Martovce', 'Mašková',
        'Maškovce', 'Matejovce nad Hornádom', 'Matiaška', 'Matiašovce',
        'Matovce', 'Matúškovo', 'Matysová', 'Maťovské Vojkovce', 'Medovarce',
        'Medvedie', 'Medveďov', 'Medzany', 'Medzev', 'Medzianky', 'Medzibrod',
        'Medzibrodie nad Oravou', 'Medzilaborce', 'Melčice - Lieskové', 'Melek',
        'Meliata', 'Mengusovce', 'Merašice', 'Merník', 'Mestečko', 'Mestisko',
        'Mičakovce', 'Mierovo', 'Miezgovce', 'Michajlov', 'Michal na Ostrove',
        'Michal nad Žitavou', 'Michalková', 'Michalok', 'Michalová',
        'Michalovce', 'Michaľany', 'Miklušovce', 'Miková', 'Mikulášová',
        'Mikušovce', 'Mikušovce', 'Milhosť', 'Miloslavov', 'Milpoš', 'Miňovce',
        'Mirkovce', 'Miroľa', 'Mládzovo', 'Mlynárovce', 'Mlynčeky', 'Mlynica',
        'Mlynky', 'Mníchova Lehota', 'Mníšek nad Hnilcom',
        'Mníšek nad Popradom', 'Moča', 'Močenok', 'Močiar', 'Modra',
        'Modra nad Cirochou', 'Modrany', 'Modrová', 'Modrovka', 'Modrý Kameň',
        'Mojmírovce', 'Mojš', 'Mojtín', 'Mojzesovo', 'Mokrá Lúka', 'Mokrance',
        'Mokroluh', 'Mokrý Háj', 'Moldava nad Bodvou', 'Moravany',
        'Moravany nad Váhom', 'Moravské Lieskové', 'Moravský Svätý Ján',
        'Most pri Bratislave', 'Mostová', 'Moškovec', 'Mošovce', 'Moštenica',
        'Mošurov', 'Motešice', 'Motyčky', 'Môlča', 'Mrázovce', 'Mučín',
        'Mudroňovo', 'Mudrovce', 'Muľa', 'Muráň', 'Muránska Dlhá Lúka',
        'Muránska Huta', 'Muránska Lehota', 'Muránska Zdychava', 'Mútne',
        'Mužla', 'Myjava', 'Myslina', 'Mýtna', 'Mýtne Ludany',
        'Mýto pod Ďumbierom', 'Nacina Ves', 'Nadlice', 'Naháč', 'Nálepkovo',
        'Námestovo', 'Nána', 'Nandraž', 'Necpaly', 'Nedanovce', 'Nedašovce',
        'Neded', 'Nededza', 'Nedožery - Brezany', 'Nechválova Polianka',
        'Nemce', 'Nemcovce', 'Nemcovce', 'Nemčice', 'Nemčiňany', 'Nemecká',
        'Nemečky', 'Nemešany', 'Nemšová', 'Nenince', 'Neporadza', 'Neporadza',
        'Nesvady', 'Nesluša', 'Neverice', 'Nevidzany', 'Nevidzany', 'Nevoľné',
        'Nezbudská Lúčka', 'Nimnica', 'Nitra', 'Nitra nad Ipľom',
        'Nitrianska Blatnica', 'Nitrianska Streda', 'Nitrianske Hrnčiarovce',
        'Nitrianske Pravno', 'Nitrianske Rudno', 'Nitrianske Sučany', 'Nitrica',
        'Nižná', 'Nižná', 'Nižná Boca', 'Nižná Hutka', 'Nižná Jablonka',
        'Nižná Jedľová', 'Nižná Kamenica', 'Nižná Myšľa', 'Nižná Olšava',
        'Nižná Pisaná', 'Nižná Polianka', 'Nižná Rybnica', 'Nižná Sitnica',
        'Nižná Slaná', 'Nižná Voľa', 'Nižné Ladičkovce', 'Nižné Nemecké',
        'Nižné Repaše', 'Nižné Ružbachy', 'Nižný Čaj', 'Nižný Hrabovec',
        'Nižný Hrušov', 'Nižný Klátov', 'Nižný Komárnik', 'Nižný Kručov',
        'Nižný Lánec', 'Nižný Mirošov', 'Nižný Orlík', 'Nižný Skálnik',
        'Nižný Slavkov', 'Nižný Tvarožec', 'Nižný Žipov', 'Nolčovo', 'Norovce',
        'Nová Baňa', 'Nová Bašta', 'Nová Bošáca', 'Nová Bystrica',
        'Nová Dedina', 'Nová Dedinka', 'Nová Dubnica', 'Nová Kelča',
        'Nová Lehota', 'Nová Lesná', 'Nová Ľubovňa', 'Nová Polhora',
        'Nová Polianka', 'Nová Sedlica', 'Nová Ves', 'Nová Ves nad Váhom',
        'Nová Ves nad Žitavou', 'Nová Vieska', 'Nováčany', 'Nováky', 'Nové Hony',
        'Nové Mesto nad Váhom', 'Nové Sady', 'Nové Zámky', 'Novosad', 'Novoť',
        'Nový Ruskov', 'Nový Salaš', 'Nový Tekov', 'Nový Život', 'Nýrovce',
        'Ňagov', 'Ňárad', 'Obeckov', 'Obišovce', 'Oborín', 'Obručné', 'Obyce',
        'Očkov', 'Očová', 'Odorín', 'Ohrady', 'Ohradzany', 'Ochodnica',
        'Ochtiná', 'Okoč', 'Okoličná na Ostrove', 'Okrúhle', 'Okružná',
        'Olcnava', 'Olejníkov', 'Olešná', 'Olováry', 'Olšovany', 'Oľdza',
        'Oľka', 'Oľšavce', 'Oľšavica', 'Oľšavka', 'Oľšavka', 'Oľšinkov',
        'Oľšov', 'Omastiná', 'Omšenie', 'Ondavka', 'Ondavské Matiašovce',
        'Ondrašovce', 'Ondrašová', 'Ondrejovce', 'Opátka', 'Opatovce',
        'Opatovce nad Nitrou', 'Opatovská Nová Ves', 'Opava', 'Opiná', 'Opoj',
        'Oponice', 'Oravce', 'Orávka', 'Oravská Jasenica', 'Oravská Lesná',
        'Oravská Polhora', 'Oravská Poruba', 'Oravský Biely Potok',
        'Oravský Podzámok', 'Ordzovany', 'Orechová', 'Orechová Potôň',
        'Oravské Veselé', 'Oreské', 'Oreské', 'Orešany', 'Orlov', 'Orovnica',
        'Ortuťová', 'Osádka', 'Osadné', 'Osikov', 'Oslany', 'Osrblie',
        'Ostrá Lúka', 'Ostratice', 'Ostrov', 'Ostrov', 'Ostrovany',
        'Ostrý Grúň', 'Osturňa', 'Osuské', 'Oščadnica', 'Otrhánky', 'Otročok',
        'Ovčiarsko', 'Ovčie', 'Ozdín', 'Ožďany', 'Pača', 'Padáň', 'Padarovce',
        'Pakostov', 'Palárikovo', 'Palín', 'Palota', 'Panické Dravce', 'Paňa',
        'Paňovce', 'Papín', 'Papradno', 'Parchovany', 'Parihuzovce', 'Párnica',
        'Partizánska Ľupča', 'Partizánske', 'Pastovce', 'Pastuchov', 'Pašková',
        'Paština Závada', 'Pata', 'Pataš', 'Pavčina Lehota', 'Pavlice',
        'Pavlová', 'Pavlova Ves', 'Pavlovce', 'Pavlovce', 'Pavlovce nad Uhom',
        'Pavľany', 'Pažiť', 'Pčoliné', 'Pečenice', 'Pečeňady', 'Pečeňany',
        'Pečovská Nová Ves', 'Peder', 'Perín - Chym', 'Pernek', 'Petkovce',
        'Petrikovce', 'Petrová', 'Petrova Lehota', 'Petrova Ves', 'Petrovany',
        'Petrovce', 'Petrovce', 'Petrovce', 'Petrovce nad Laborcom',
        'Petrovice', 'Petrovo', 'Pezinok', 'Piešťany', 'Pichne', 'Píla',
        'Píla', 'Píla', 'Pinciná', 'Pinkovce', 'Piskorovce', 'Pitelová',
        'Plášťovce', 'Plavé Vozokany', 'Plavecké Podhradie', 'Plavecký Mikuláš',
        'Plavecký Peter', 'Plavecký Štvrtok', 'Plaveč', 'Plavnica',
        'Plechotice', 'Pleš', 'Plešivec', 'Plevník - Drienové', 'Pliešovce',
        'Ploské', 'Ploské', 'Pobedim', 'Počarová', 'Počúvadlo', 'Podbiel',
        'Podbranč', 'Podbrezová', 'Podhájska', 'Podhorany', 'Podhorany',
        'Podhorany', 'Podhorie', 'Podhorie', 'Podhoroď', 'Podhradie',
        'Podhradie', 'Podhradie', 'Podhradík', 'Podkonice', 'Podkriváň',
        'Podkylava', 'Podlužany', 'Podlužany', 'Podolie', 'Podolínec',
        'Podrečany', 'Podskalie', 'Podtureň', 'Podvysoká', 'Podzámčok',
        'Pohorelá', 'Pohranice', 'Pohronská Polhora', 'Pohronský Bukovec',
        'Pohronský Ruskov', 'Pochabany', 'Pokryváč', 'Poliakovce', 'Polianka',
        'Polichno', 'Polina', 'Poloma', 'Polomka', 'Poltár', 'Poluvsie',
        'Poľanovce', 'Poľany', 'Poľný Kesov', 'Pongrácovce', 'Poniky',
        'Poprad', 'Poproč', 'Poproč', 'Popudinské Močidľany', 'Poráč',
        'Poriadie', 'Porostov', 'Poruba', 'Poruba pod Vihorlatom', 'Porúbka',
        'Porúbka', 'Porúbka', 'Porúbka', 'Poša', 'Potok', 'Potok', 'Potoky',
        'Potôčky', 'Potvorice', 'Považany', 'Považská Bystrica', 'Povina',
        'Povoda', 'Povrazník', 'Pozba', 'Pozdišovce', 'Pôtor', 'Praha',
        'Prakovce', 'Prašice', 'Prašník', 'Pravenec', 'Pravica', 'Pravotice',
        'Práznovce', 'Prečín', 'Predajná', 'Predmier', 'Prenčov', 'Preseľany',
        'Prestavlky', 'Prešov', 'Príbelce', 'Pribeník', 'Pribeta', 'Pribiš',
        'Príbovce', 'Pribylina', 'Priechod', 'Priekopa', 'Priepasné',
        'Prietrž', 'Prietržka', 'Prievaly', 'Prievidza', 'Prihradzany',
        'Príkra', 'Príslop', 'Prituľany', 'Proč', 'Prochot', 'Prosačov',
        'Prosiek', 'Prša', 'Pruské', 'Prusy', 'Pružina', 'Pstriná', 'Ptičie',
        'Ptrukša', 'Pucov', 'Púchov', 'Pukanec', 'Pusté Čemerné', 'Pusté Pole',
        'Pusté Sady', 'Pusté Úľany', 'Pušovce', 'Rabča', 'Rabčice', 'Rad',
        'Radatice', 'Radava', 'Radimov', 'Radnovce', 'Radobica', 'Radoľa',
        'Radoma', 'Radošina', 'Radošovce', 'Radošovce', 'Radôstka',
        'Radvanovce', 'Radvaň nad Dunajom', 'Radvaň nad Laborcom', 'Radzovce',
        'Rafajovce', 'Rajčany', 'Rajec', 'Rajecká Lesná', 'Rajecké Teplice',
        'Rákoš', 'Rákoš', 'Raková', 'Rakovčík', 'Rakovec nad Ondavou',
        'Rakovice', 'Rakovnica', 'Rakovo', 'Rakša', 'Rakúsy', 'Rakytník',
        'Rankovce', 'Rapovce', 'Raslavice', 'Rastislavice', 'Rašice', 'Ratka',
        'Ratková', 'Ratkovce', 'Ratkovo', 'Ratkovská Lehota', 'Ratkovská Suchá',
        'Ratkovské Bystré', 'Ratnovce', 'Ratvaj', 'Ráztočno', 'Ráztoka',
        'Ražňany', 'Reca', 'Regetovka', 'Rejdová', 'Reľov', 'Remeniny',
        'Remetské Hámre', 'Renčišov', 'Repejov', 'Repište', 'Rešica', 'Rešov',
        'Revúca', 'Revúcka Lehota', 'Riečka', 'Riečka', 'Richnava', 'Richvald',
        'Rimavská Baňa', 'Rimavská Seč', 'Rimavská Sobota', 'Rimavské Brezovo',
        'Rimavské Janovce', 'Rimavské Zalužany', 'Rohov', 'Rohovce', 'Rohožník',
        'Rohožník', 'Rochovce', 'Rokycany', 'Rokytov', 'Rokytov pri Humennom',
        'Rokytovce', 'Rosina', 'Roškovce', 'Roštár', 'Rovensko', 'Rovinka',
        'Rovné', 'Rovné', 'Rovné', 'Rovňany', 'Rozhanovce', 'Rozložná',
        'Roztoky', 'Rožkovany', 'Rožňava', 'Rožňavské Bystré', 'Rúbaň',
        'Rudina', 'Rudinka', 'Rudinská', 'Rudlov', 'Rudná', 'Rudnianska Lehota',
        'Rudník', 'Rudník', 'Rudno', 'Rudno nad Hronom', 'Rudňany', 'Rumanová',
        'Rumince', 'Runina', 'Ruská', 'Ruská Bystrá', 'Ruská Kajňa',
        'Ruská Nová Ves', 'Ruská Poruba', 'Ruská Volová', 'Ruská Voľa',
        'Ruská Voľa nad Popradom', 'Ruskov', 'Ruskovce', 'Ruskovce',
        'Ruský Hrabovec', 'Ruský Potok', 'Ružiná', 'Ružindol', 'Ružomberok',
        'Rybany', 'Rybky', 'Rybník', 'Rybník', 'Rykynčice', 'Sabinov',
        'Sačurov', 'Sádočné', 'Sady nad Torysou', 'Salka', 'Santovka', 'Sap',
        'Sása', 'Sása', 'Sasinkovo', 'Sazdice', 'Sebedín - Bečov', 'Sebedražie',
        'Sebechleby', 'Seč', 'Sečianky', 'Sečovce', 'Sečovská Polianka',
        'Sedliacka Dubová', 'Sedliská', 'Sedmerovec', 'Sejkov', 'Sekule',
        'Selce', 'Selce', 'Selce', 'Selec', 'Selice', 'Seľany', 'Semerovo',
        'Senec', 'Seniakovce', 'Senica', 'Senné', 'Senné', 'Senohrad', 'Seňa',
        'Sereď', 'Sielnica', 'Sihelné', 'Sihla', 'Sikenica', 'Sikenička',
        'Siladice', 'Silica', 'Silická Brezová', 'Silická Jablonica', 'Sirk',
        'Sirník', 'Skačany', 'Skalica', 'Skalité', 'Skalka nad Váhom', 'Skároš',
        'Skerešovo', 'Sklabiná', 'Sklabinský Podzámok', 'Sklabiňa', 'Sklené',
        'Sklené Teplice', 'Skrabské', 'Skýcov', 'Sládkovičovo', 'Slančík',
        'Slanec', 'Slanská Huta', 'Slanské Nové Mesto', 'Slaská', 'Slatina',
        'Slatina nad Bebravou', 'Slatinka nad Bebravou', 'Slatinské Lazy',
        'Slatvina', 'Slavec', 'Slavkovce', 'Slavnica', 'Slavoška', 'Slavošovce',
        'Slepčany', 'Sliač', 'Sliepkovce', 'Slizké', 'Slivník', 'Slopná',
        'Slovany', 'Slovenská Kajňa', 'Slovenská Ľupča', 'Slovenská Nová Ves',
        'Slovenská Ves', 'Slovenská Volová', 'Slovenské Ďarmoty',
        'Slovenské Kľačany', 'Slovenské Krivé', 'Slovenské Nové Mesto',
        'Slovenské Pravno', 'Slovenský Grob', 'Slovinky', 'Sľažany', 'Smilno',
        'Smižany', 'Smolenice', 'Smolinské', 'Smolnícka Huta', 'Smolník',
        'Smrdáky', 'Smrečany', 'Snakov', 'Snežnica', 'Snina', 'Socovce',
        'Soblahov', 'Soboš', 'Sobotište', 'Sobrance', 'Sokolce', 'Sokolovce',
        'Sokoľ', 'Sokoľany', 'Solčany', 'Solčianky', 'Sološnica', 'Soľ',
        'Soľnička', 'Soľník', 'Somotor', 'Sopkovce', 'Spišská Belá',
        'Spišská Nová Ves', 'Spišská Stará Ves', 'Spišská Teplica',
        'Spišské Bystré', 'Spišské Hanušovce', 'Spišské Podhradie',
        'Spišské Tomášovce', 'Spišské Vlachy', 'Spišský Hrhov', 'Spišský Hrušov',
        'Spišský Štiavnik', 'Spišský Štvrtok', 'Stakčín', 'Stakčínska Roztoka',
        'Stanča', 'Stankovany', 'Stankovce', 'Stará Bašta', 'Stará Bystrica',
        'Stará Halič', 'Stará Huta', 'Stará Kremnička', 'Stará Lehota',
        'Stará Lesná', 'Stará Ľubovňa', 'Stará Myjava', 'Stará Turá',
        'Stará Voda', 'Staré', 'Staré Hory', 'Starina', 'Starý Hrádok',
        'Starý Tekov', 'Staškov', 'Staškovce', 'Stebnícka Huta', 'Stebník',
        'Stožok', 'Stráne pod Tatrami', 'Stránska', 'Stránske', 'Stráňany',
        'Stráňavy', 'Stratená', 'Stráža', 'Strážne', 'Strážske', 'Strečno',
        'Streda nad Bodrogom', 'Stredné Plachtince', 'Strekov', 'Strelníky',
        'Stretava', 'Stretavka', 'Streženice', 'Strihovce', 'Stročín',
        'Stropkov', 'Studená', 'Studenec', 'Studienka', 'Stuľany', 'Stupava',
        'Stupné', 'Sučany', 'Sudince', 'Súdovce', 'Suchá Dolina', 'Suchá Hora',
        'Suchá nad Parnou', 'Sucháň', 'Suché', 'Suché Brezovo', 'Suchohrad',
        'Sukov', 'Sulín', 'Súlovce', 'Súľov - Hradná', 'Sušany', 'Sútor',
        'Svätá Mária', 'Svätoplukovo', 'Svätuš', 'Svätuše', 'Svätý Anton',
        'Svätý Jur', 'Svätý Kríž', 'Svätý Peter', 'Svederník', 'Sverepec',
        'Sveržov', 'Svetlice', 'Svidnička', 'Svidník', 'Svinia', 'Svinica',
        'Svinice', 'Svinná', 'Svit', 'Svodín', 'Svrbice', 'Svrčinovec', 'Šahy',
        'Šajdíkove Humence', 'Šalgovce', 'Šalgočka', 'Šalov', 'Šaľa', 'Šambron',
        'Šamorín', 'Šamudovce', 'Šandal', 'Šarbov', 'Šarišská Poruba',
        'Šarišská Trstená', 'Šarišské Bohdanovce', 'Šarišské Čierne',
        'Šarišské Dravce', 'Šarišské Jastrabie', 'Šarišské Michaľany',
        'Šarišské Sokolovce', 'Šarišský Štiavnik', 'Šarkan', 'Šarovce',
        'Šašová', 'Šaštín - Stráže', 'Šávoľ', 'Šelpice', 'Šemetkovce', 'Šemša',
        'Šenkvice', 'Šiatorská Bukovinka', 'Šiba', 'Šíd', 'Šimonovce',
        'Šindliar', 'Šintava', 'Šípkov', 'Šípkové', 'Širákov', 'Širkovce',
        'Široké', 'Šišov', 'Šivetice', 'Šmigovec', 'Šoltýska', 'Šoporňa',
        'Špačince', 'Špania Dolina', 'Španie Pole', 'Šrobárová', 'Štefanov',
        'Štefanov nad Oravou', 'Štefanová', 'Štefanovce', 'Štefanovce',
        'Štefanovičová', 'Štefurov', 'Šterusy', 'Štiavnické Bane',
        'Štiavnička', 'Štiavnik', 'Štítnik', 'Štós', 'Štôla', 'Štrba',
        'Štrkovec', 'Štúrovo', 'Štvrtok', 'Štvrtok na Ostrove', 'Šuľa',
        'Šumiac', 'Šuňava', 'Šurany', 'Šurianky', 'Šurice', 'Šúrovce',
        'Šútovo', 'Šútovce', 'Švábovce', 'Švedlár', 'Švošov', 'Tachty',
        'Tajná', 'Tajov', 'Tarnov', 'Tatranská Javorina', 'Tašuľa', 'Tehla',
        'Tekolďany', 'Tekovská Breznica', 'Tekovské Lužany', 'Tekovské Nemce',
        'Tekovský Hrádok', 'Telgárt', 'Telince', 'Temeš', 'Teplička',
        'Teplička nad Váhom', 'Tepličky', 'Teplý Vrch', 'Terany', 'Terchová',
        'Teriakovce', 'Terňa', 'Tesáre', 'Tesárske Mlyňany', 'Tešedíkovo',
        'Tibava', 'Tichý Potok', 'Timoradza', 'Tisinec', 'Tisovec', 'Tlmače',
        'Točnica', 'Tokajík', 'Tomášikovo', 'Tomášov', 'Tomášovce',
        'Tomášovce', 'Topoľa', 'Topoľčany', 'Topoľčianky', 'Topoľnica',
        'Topoľníky', 'Topoľovka', 'Toporec', 'Tornaľa', 'Torysa', 'Torysky',
        'Tovarné', 'Tovarnianska Polianka', 'Tovarníky', 'Tôň', 'Trakovice',
        'Trávnica', 'Trávnik', 'Trebatice', 'Trebejov', 'Trebeľovce',
        'Trebichava', 'Trebišov', 'Trebostovo', 'Trebušovce', 'Trenč',
        'Trenčianska Teplá', 'Trenčianska Turná', 'Trenčianske Bohuslavice',
        'Trenčianske Jastrabie', 'Trenčianske Mitice', 'Trenčianske Stankovce',
        'Trenčianske Teplice', 'Trenčín', 'Trhová Hradská', 'Trhovište',
        'Trnava', 'Trnavá Hora', 'Trnava pri Laborci', 'Trnávka', 'Trnávka',
        'Trnkov', 'Trnovec', 'Trnovec nad Váhom', 'Trnovo', 'Tročany', 'Trpín',
        'Trstená', 'Trstená na Ostrove', 'Trstené', 'Trstené pri Hornáde',
        'Trstice', 'Trstín', 'Trsťany', 'Tŕnie', 'Tuhár', 'Tuhrina', 'Tuchyňa',
        'Tulčík', 'Tupá', 'Turá', 'Turany', 'Turany nad Ondavou', 'Turcovce',
        'Turček', 'Turčianky', 'Turčianska Štiavnička', 'Turčianske Jaseno',
        'Turčianske Kľačany', 'Turčianske Teplice', 'Turčiansky Ďur',
        'Turčiansky Peter', 'Turčok', 'Turecká', 'Tureň', 'Turie', 'Turík',
        'Turnianska Nová Ves', 'Turňa nad Bodvou', 'Turová', 'Turzovka',
        'Tušice', 'Tušická Nová Ves', 'Tužina', 'Tvarožná', 'Tvrdomestice',
        'Tvrdošín', 'Tvrdošovce', 'Ťapešovo', 'Ubľa', 'Úbrež', 'Udavské',
        'Udiča', 'Údol', 'Uhliská', 'Úhorná', 'Uhorská Ves', 'Uhorské',
        'Uhrovec', 'Uhrovské Podhradie', 'Ulič', 'Uličské Krivé', 'Uloža',
        'Úľany nad Žitavou', 'Unín', 'Uňatín', 'Urmince', 'Utekáč', 'Uzovce',
        'Uzovská Panica', 'Uzovské Pekľany', 'Uzovský Šalgov', 'Vaďovce',
        'Vagrinec', 'Váhovce', 'Vajkovce', 'Valaliky', 'Valaská',
        'Valaská Belá', 'Valaská Dubová', 'Valaškovce (vojenský obvod)',
        'Valča', 'Valentovce', 'Valice', 'Valkovce', 'Vaľkovňa', 'Vaniškovce',
        'Vápeník', 'Varadka', 'Varechovce', 'Varhaňovce', 'Varín', 'Vasiľov',
        'Vavrečka', 'Vavrinec', 'Vavrišovo', 'Važec', 'Vechec', 'Velčice',
        'Veličná', 'Velušovce', 'Veľaty', 'Veľká Čausa', 'Veľká Čierna',
        'Veľká Dolina', 'Veľká Franková', 'Veľká Hradná', 'Veľká Ida',
        'Veľká Lesná', 'Veľká Lodina', 'Veľká Lomnica', 'Veľká Mača',
        'Veľká Paka', 'Veľká Tŕňa', 'Veľké Bierovce', 'Veľké Blahovo',
        'Veľké Borové', 'Veľké Držkovce', 'Veľké Dvorany', 'Veľké Dvorníky',
        'Veľké Hoste', 'Veľké Chlievany', 'Veľké Chyndice', 'Veľké Kapušany',
        'Veľké Kosihy', 'Veľké Kostoľany', 'Veľké Kozmálovce', 'Veľké Kršteňany',
        'Veľké Leváre', 'Veľké Lovce', 'Veľké Ludince', 'Veľké Orvište',
        'Veľké Ozorovce', 'Veľké Raškovce', 'Veľké Revištia', 'Veľké Ripňany',
        'Veľké Rovné', 'Veľké Slemence', 'Veľké Trakany', 'Veľké Turovce',
        'Veľké Uherce', 'Veľké Úľany', 'Veľké Vozokany', 'Veľké Zálužie',
        'Veľkrop', 'Veľký Biel', 'Veľký Cetín', 'Veľký Čepčín', 'Veľký Ďur',
        'Veľký Folkmar', 'Veľký Grob', 'Veľký Horeš', 'Veľký Kamenec',
        'Veľký Klíž', 'Veľký Krtíš', 'Veľký Kýr', 'Veľký Lapáš', 'Veľký Lipník',
        'Veľký Meder', 'Veľký Slavkov', 'Veľký Slivník', 'Veľký Šariš',
        'Veľopolie', 'Vernár', 'Veselé', 'Veterná Poruba', 'Vieska', 'Vieska',
        'Vieska nad Žitavou', 'Vikartovce', 'Vinica', 'Viničky', 'Viničné',
        'Vinné', 'Vinodol', 'Vinohrady nad Váhom', 'Vinosady', 'Virt',
        'Vislanka', 'Vislava', 'Visolaje', 'Višňov', 'Višňové', 'Višňové',
        'Vištuk', 'Vitanová', 'Vítkovce', 'Víťaz', 'Víťazovce', 'Vlača',
        'Vladiča', 'Vlachovo', 'Vlachy', 'Vlčany', 'Vlčkovce', 'Vlkas',
        'Vlková', 'Vlkovce', 'Vlky', 'Voderady', 'Vojany', 'Vojčice', 'Vojka',
        'Vojka nad Dunajom', 'Vojkovce', 'Vojnatina', 'Vojňany', 'Vojtovce',
        'Volica', 'Volkovce', 'Voľa', 'Vozokany', 'Vozokany', 'Vráble',
        'Vrádište', 'Vrakúň', 'Vranov nad Topľou', 'Vrbnica', 'Vrbov',
        'Vrbovce', 'Vrbová nad Váhom', 'Vrbové', 'Vrchteplá', 'Vrícko',
        'Vršatské Podhradie', 'Vrútky', 'Vtáčkovce', 'Výborná',
        'Výčapy - Opatovce', 'Vydrany', 'Vydrná', 'Vydrník', 'Východná',
        'Výrava', 'Vysočany', 'Vysoká', 'Vysoká', 'Vysoká nad Kysucou',
        'Vysoká nad Uhom', 'Vysoká pri Morave', 'Vysoké Tatry', 'Vyškovce',
        'Vyškovce nad Ipľom', 'Vyšná Boca', 'Vyšná Hutka', 'Vyšná Jablonka',
        'Vyšná Jedľová', 'Vyšná Kamenica', 'Vyšná Myšľa', 'Vyšná Olšava',
        'Vyšná Pisaná', 'Vyšná Polianka', 'Vyšná Rybnica', 'Vyšná Sitnica',
        'Vyšná Slaná', 'Vyšná Šebastová', 'Vyšná Voľa', 'Vyšné Ladičkovce',
        'Vyšné nad Hronom', 'Vyšné Nemecké', 'Vyšné Remety', 'Vyšné Repaše',
        'Vyšné Ružbachy', 'Vyšný Čaj', 'Vyšný Hrabovec', 'Vyšný Hrušov',
        'Vyšný Kazimír', 'Vyšný Klátov', 'Vyšný Komárnik', 'Vyšný Kručov',
        'Vyšný Kubín', 'Vyšný Mirošov', 'Vyšný Orlík', 'Vyšný Slavkov',
        'Vyšný Tvarožec', 'Vyšný Žipov', 'Zábiedovo', 'Záborie', 'Záborské',
        'Zádiel', 'Záhor', 'Záhorie (vojenský obvod)', 'Záhorská Ves',
        'Záhradné', 'Zákamenné', 'Zákopčie', 'Zalaba', 'Zálesie', 'Zálesie',
        'Zalužice', 'Zamarovce', 'Zámutov', 'Záriečie', 'Záskalie', 'Zatín',
        'Závada', 'Závada', 'Závadka', 'Závadka', 'Závadka', 'Zavar',
        'Závažná Poruba', 'Závod', 'Zázrivá', 'Zbehňov', 'Zbehy', 'Zboj',
        'Zbojné', 'Zborov', 'Zborov nad Bystricou', 'Zbrojníky',
        'Zbudská Belá', 'Zbudské Dlhé', 'Zbudza', 'Zbyňov', 'Zeleneč',
        'Zemianska Olča', 'Zemianske Kostoľany', 'Zemianske Podhradie',
        'Zemianske Sady', 'Zemné', 'Zemplín', 'Zemplínska Nová Ves',
        'Zemplínska Široká', 'Zemplínska Teplica', 'Zemplínske Hámre',
        'Zemplínske Hradište', 'Zemplínske Jastrabie', 'Zemplínske Kopčany',
        'Zemplínsky Branč', 'Zlatá Baňa', 'Zlatá Idka', 'Zlaté', 'Zlaté Klasy',
        'Zlaté Moravce', 'Zlatná na Ostrove', 'Zlatník', 'Zlatníky', 'Zlatno',
        'Zlatno', 'Zliechov', 'Zohor', 'Zubák', 'Zuberec', 'Zubné',
        'Zubrohlava', 'Zvolen', 'Zvončín', 'Žabokreky', 'Žabokreky nad Nitrou',
        'Žakarovce', 'Žakovce', 'Žalobín', 'Žarnov', 'Žarnovica', 'Žaškov',
        'Žbince', 'Ždaňa', 'Ždiar', 'Žehňa', 'Žehra', 'Železník', 'Želiezovce',
        'Želmanovce', 'Žemberovce', 'Žemliare', 'Žiar', 'Žiar',
        'Žiar nad Hronom', 'Žihárec', 'Žikava', 'Žilina', 'Žipov', 'Žirany',
        'Žitavany', 'Žitavce', 'Žitná - Radiša', 'Žlkovce', 'Župčany',
    )

    streets = (
        'Adámiho', 'Agátová', 'Ahoj', 'Albánska', 'Albrechtova', 'Alejová',
        'Alešova', 'Alstrova', 'Alžbetínska', 'Alžbety Gwerkovej',
        'Amarelková', 'Ambroseho', 'Ambrova', 'Ambrušova', 'Americká',
        'Americké námestie', 'Americké námestie', 'Amurská', 'Andreja Mráza',
        'Andreja Plávku', 'Andrusovova', 'Anenská', 'Anenská', 'Anízová',
        'Antická', 'Antolská', 'Arménska', 'Astronomická', 'Astrová',
        'Avarská', 'Azalková', 'Azovská', 'Babuškova', 'Bagarova', 'Báger',
        'Bahniatková', 'Bachova', 'Bajkalská', 'Bajkalská', 'Bajkalská',
        'Bajkalská', 'Bajkalská', 'Bajkalská', 'Bajzova', 'Bakošova',
        'Balkánska', 'Baltská', 'Bancíkovej', 'Banícka', 'Baničova',
        'Baníkova', 'Banskobystrická', 'Banšelova', 'Bardejovská', 'Bárdošova',
        'Barónka', 'Bartókova', 'Bartoňova', 'Bartoškova', 'Baštová',
        'Batkova', 'Bazalková', 'Bazová', 'Bazovského', 'Bažantia',
        'Beblavého', 'Bebravská', 'Beckovská', 'Bedľová', 'Begóniová',
        'Belániková', 'Belehradská', 'Belianska', 'Belinského', 'Bellova',
        'Belopotockého', 'Beňadická', 'Bencúrova', 'Benediktiho', 'Beniakova',
        'Beňovského', 'Bernolákova', 'Beskydská', 'Betliarska', 'Bezekova',
        'Bezručova', 'Biela', 'Bielkova', 'Bieloruská', 'Bilíkova',
        'Biskupická', 'Björnsonova', 'Blagoevova', 'Blatnická', 'Blatúchová',
        'Bleduľová', 'Blumentálska', 'Blyskáčová', 'Bočná', 'Bodliaková',
        'Bodrocká', 'Bodvianska', 'Bohrova', 'Bohúňova', 'Bojnická',
        'Boragová', 'Borekova', 'Borievková', 'Borinská', 'Borodáčova',
        'Borovicová', 'Borská', 'Bosákova', 'Boskovičova', 'Bošániho',
        'Botanická', 'Bottova', 'Boženy Němcovej', 'Bôrik', 'Bradáčova',
        'Bradlianska', 'Brančská', 'Bratislava-Vinohrady', 'Bratislavská',
        'Bratská', 'Brečtanová', 'Brestová', 'Brezová', 'Brezovská', 'Brežná',
        'Bridlicová', 'Briežky', 'Brigádnická', 'Brižitská', 'Brnianska',
        'Brodná', 'Brodská', 'Brokolicová', 'Bronzová', 'Broskyňová',
        'Bršlenová', 'Brumovická', 'Brusnicová', 'Břeclavská', 'Bučinová',
        'Budatínska', 'Budatínska', 'Budatínska', 'Búdkova cesta',
        'Budovateľská', 'Budyšínska', 'Budyšínska', 'Bujnáková', 'Buková',
        'Bukovinská', 'Bukureštská', 'Bulharská', 'Bulíkova', 'Bullova',
        'Burgundská', 'Buzalkova', 'Bystrého', 'Bystrická', 'BzovIcka',
        'Cabanova', 'Cablkova', 'Cádrova', 'Cesta mládeže', 'Cesta mládeže',
        'Cesta na Červený most', 'Cesta na Červený most', 'Cesta na Kamzík',
        'Cesta na Klanec', 'Cesta na Senec', 'Cígeľská', 'Cikkerova',
        'Cintorínska', 'Cintulova', 'Colnícka', 'Cukrová', 'Cyklámenová',
        'Cyprichova', 'Cyprichova', 'Cyrilova', 'Čachtická', 'Čajakova',
        'Čajakova', 'Čajkovského', 'Čakanková', 'Čaklovská', 'Čalovská',
        'Čapajevova', 'Čapkova', 'Čárskeho', 'Čavojského', 'Čečinová',
        'Čelakovského', 'Čerešňová', 'Černicová', 'Černockého', 'Černockého',
        'Černyševského', 'Červená', 'Červeňákova', 'Červeňova', 'Česká',
        'Československých par', 'Československých tan', 'Čiernohorská',
        'Čiernovodská', 'Čierny chodník', 'Čiližská', 'Čipkárska', 'Čmelíkova',
        'Čmeľovec', 'Čremchová', 'Čučoriedková', 'Čulenova',
        'Daliborovo námestie', 'Damborského', 'Dankovského', 'Dargovská',
        'Ďatelinová', 'Daxnerovo námestie', 'Delená', 'Delená cesta',
        'Demänovská', 'Desiata', 'Detvianska', 'Devätinová', 'Deviata',
        'Devínska cesta', 'Devínska cesta - kam', 'Devínske jazero', 'Dlhá',
        'Dlhé diely I.', 'Dlhé diely II.', 'Dlhé diely III.', 'Dneperská',
        'Dobrovičova', 'Dobrovičova', 'Dobrovského', 'Dobšinského',
        'Dohnalova', 'Dohnányho', 'Doležalova', 'Dolná', 'Dolné Koruny',
        'Dolnokorunská', 'Dolnozemská cesta', 'Domašská', 'Domkárska',
        'Domové role', 'Donnerova', 'Donovalova', 'Donská', 'Dopravná',
        'Dorastenecká', 'Dostojevského rad', 'Dr. Vladimíra Clemen',
        'Dražická', 'Drevená', 'Drieňová', 'Drieňová', 'Drieňová', 'Drobného',
        'Drotárska cesta', 'Drotárska cesta', 'Drotárska cesta', 'Druhá',
        'Druidská', 'Družicová', 'Družobná', 'Družstevná', 'Dubnická',
        'Dubová', 'Dúbravčická', 'Dúbravská cesta', 'Dudova', 'Dudvážska',
        'Dulovo námestie', 'Dulovo námestie', 'Ďumbierska', 'Dunajská',
        'Ďurgalova', 'Dvanásta', 'Dvojkrížna', 'Dvojkrížna',
        'Dvořákovo nábrežie', 'Edisonova', 'Egrešová', 'Einsteinova',
        'Eisnerova', 'Elektrárenská', 'Estónska', 'Estónska', 'Exnárova',
        'F. Kostku', 'Fadruszova', 'Fajnorovo nábrežie', 'Fándlyho', 'Farebná',
        'Farská', 'Farského', 'Fazuľová', 'Fedákova', 'Fedinova',
        'Ferienčíkova', 'Fialkové údolie', 'Fibichova', 'Fikusová',
        'Filiálne nádražie', 'Fláviovská', 'Flöglova', 'Floriánske námestie',
        'Fraňa Kráľa', 'Francisciho', 'Francúzskych partizá', 'Frankovská',
        'Františkánska', 'Františkánske námest', 'Františka Schmuckera',
        'Furdekova', 'Furdekova', 'Furmanská', 'Furmintská', 'Gabčíkova',
        'Gagarinova', 'Gagarinova', 'Gagarinova', 'Gajarská', 'Gajc', 'Gajova',
        'Galaktická', 'Galandova', 'Galbavého', 'Gallayova', 'Gallova',
        'Galvaniho', 'Gašparíkova', 'Gaštanová', 'Gavlovičova', 'Gbelská',
        'Gelnická', 'Gemerská', 'Geologická', 'Georgínová', 'Gercenova',
        'Gerulatská', 'Gessayova', 'Gettingová', 'Glavica', 'Godrova',
        'Gogoľova', 'Goláňova', 'Gondova', 'Goralská', 'Gorazdova', 'Gorkého',
        'Gregorovej', 'Gronárska', 'Grösslingova', 'Gruzínska', 'Gunduličova',
        'Guothova', 'Gusevova', 'Haanova', 'Haburská', 'Hadia cesta',
        'Hadriánová', 'Hagarova', 'Hagarova', 'Hájová', 'Halašova', 'Hálkova',
        'Hálova', 'Hamuliakova', 'Hanácka', 'Handlovská', 'Hanulova',
        'Hanulova', 'Hany Meličkovej', 'Hargašova', 'Harmanecká', 'Harmincova',
        'Hasičská', 'Hattalova', 'Havelkova', 'Havlíčkova', 'Havrania',
        'Haydnova', 'Hečkova', 'Herlianska', 'Herlianska', 'Heydukova',
        'Heyrovského', 'Hlaváčikova', 'Hlavatého', 'Hlavná', 'Hlavné námestie',
        'Hlbinná', 'Hlboká cesta', 'Hlboká cesta', 'Hlinická', 'Hlinická',
        'Hlivová', 'Hlohová', 'Hlučínska', 'Hnilecká', 'Hodálova',
        'Hodonínska', 'Hodonínska', 'Hodonínska', 'Hodžovo námestie',
        'Holekova', 'Holíčska', 'Hollého', 'Holubyho', 'Homolova',
        'Hontianska', 'Horárska', 'Horcová', 'Horčičná', 'Horná',
        'Horná Vančurová', 'Hornádska', 'Horné Židiny', 'Horská', 'Horská',
        'Horská', 'Hospodárska', 'Hrabový chodník', 'Hrad', 'Hradištná',
        'Hradná', 'Hradné údolie', 'Hradská', 'Hrachová', 'Hraničiarska',
        'Hraničná', 'Hraničný priechod-Ču', 'Hrdličkova', 'Hrebendova',
        'Hríbová', 'Hriňovská', 'Hrobákova', 'Hrobárska', 'Hroboňova',
        'Hronska', 'Hroznová', 'Hrušková', 'Hrušovská', 'Hubeného', 'Hubeného',
        'Hudecova', 'Humenské námestie', 'Hummelova', 'Hurbanovo námestie',
        'Hurbanovo námestie', 'Husova', 'Húščavova', 'Hutnícka', 'Hviezdna',
        'Hviezdicová', 'Hviezdoslavova', 'Hviezdoslavovo námes', 'Hyacintová',
        'Hybešova', 'Hydinárska', 'Hýrošova', 'Chalupkova', 'Charkovská',
        'Chemická', 'Chladná', 'Chlumeckého', 'Chmeľová', 'Chorvátska',
        'Chorvátska', 'Chotárna', 'Chrasťová', 'Chrenová', 'Chrobákova',
        'Ihličnatá', 'Ihrisková', 'Iľjušinova', 'Ilkovičova', 'Ílová',
        'Ilýrska', 'Imelová', 'Inovecká', 'Inovecká', 'Ipeľská', 'Irisová',
        'Irkutská', 'Iršajská', 'Iskerníková', 'Istrijská', 'Ivana Blazeviča',
        'Ivana Bukovčana', 'Ivana Horvátha', 'Ivánska cesta', 'J.C.Hronského',
        'Jabloňová', 'Jačmenná', 'Jadranská', 'Jadrová', 'Jahodová',
        'Jakabova', 'Jakubíkova', 'Jakubovo námestie', 'Jakubská', 'Jalovcová',
        'Jamnického', 'Jána Jonáša', 'Jána Poničana', 'Jána Raka',
        'Jána Smreka', 'Jána Stanislava', 'Janáčkova', 'Jančova',
        'Janíkove role', 'Janka Kráľa', 'Jankolova', 'Jánošíkova', 'Jánoškova',
        'Janotova', 'Janšákova', 'Jantárová', 'Jantárová', 'Jantárová cesta',
        'Jarabinková', 'Jarná', 'Jaroslavova', 'Jarošova', 'Jasencová',
        'Jaseňová', 'Jaskový rad', 'Jasná', 'Jasovská', 'Jastrabia', 'Jašíkova',
        'Javorinská', 'Javorová', 'Jazdecká', 'Jazerná', 'Jazmínová',
        'Jedenásta', 'Jedlíkova', 'Jedľová', 'Jégého', 'Jegeneš', 'Jelačičova',
        'Jelenia', 'Jelšová', 'Jeséniova', 'Jesenná', 'Jesenského',
        'Jesienková', 'Jiráskova', 'Jiskrova', 'Jókaiho', 'Jozefa Mikisitsa',
        'Jozefa Vachovského', 'Jozefská', 'Júlová', 'Junácka', 'Jungmannova',
        'Júnová', 'Jurigovo námestie', 'Jurkovičova', 'Jurovského', 'Jurská',
        'Justičná', 'K horárskej studni', 'K lomu', 'K pasienkom',
        'K Železnej studienke', 'Kadnárova', 'Kadnárova', 'Kadnárova',
        'Kadnárova', 'Kadnárova', 'Kafendova', 'Kalinčiakova', 'Kalinová',
        'Kalištná', 'Kaméliová', 'Kamenárska', 'Kamenné námestie', 'Kamilková',
        'Kamilková', 'Kamzík', 'Kapicova', 'Kapitulská', 'Kapitulský dvor',
        'Kaplinská', 'Kapucínska', 'Kapušianska', 'Karadžičova', 'Karadžičova',
        'Karadžičova', 'Karadžičova', 'Karloveská', 'Karloveské rameno',
        'Karpatská', 'Karpatské námestie', 'Kašmírska', 'Kaštielska',
        'Kataríny Brúderovej', 'Kaukazská', 'Kazanská', 'Kazanská', 'Kazanská',
        'Keltská', 'Kempelenova', 'Ketelec', 'Kežmarské námestie',
        'Kladnianska', 'Klariská', 'Klásková', 'Kláštorská', 'Klatovská',
        'Klatovská', 'Klemensova', 'Klenová', 'Klimkovičova', 'Klincová',
        'Klobučnícka', 'Klokočova', 'Kľukatá', 'Kĺzavá', 'Kmeťovo námestie',
        'Knižková dolina', 'Koceľova', 'Kočánkova', 'Kohútova', 'Koľajná',
        'Kolárska', 'Kolískova', 'Kollárova', 'Kollárovo námestie',
        'Kollárovo námestie', 'Kolmá', 'Komárňanská', 'Komárnická',
        'Komárnická', 'Komárovská', 'Komenského námestie', 'Kominárska',
        'Komonicová', 'Koncová', 'Koniarkova', 'Konopná', 'Konvalinková',
        'Konventná', 'Kopanice', 'Kopčianska', 'Koperníkova', 'Koprivnická',
        'Koprivnická', 'Koprivnická', 'Korabinského', 'Kórejská', 'Koreničova',
        'Koreňová', 'Korunská', 'Korytnická', 'Kosatcová', 'Kosodrevinová',
        'Kostlivého', 'Kostolná', 'Košická', 'Košická', 'Košická', 'Kovácsova',
        'Kováčska', 'Kovorobotnícka', 'Kovová', 'Kozia', 'Koziarka',
        'Kozičova', 'Kozmonautická', 'Kožušnícka', 'Kôprová', 'Kôstková',
        'Krahulčia', 'Krajinská', 'Krajinská cesta', 'Krajná', 'Krakovská',
        'Kráľovské údolie', 'Krasinského', 'Kraskova', 'Krásna',
        'Krásnohorská', 'Krasovského', 'Kratiny', 'Krátka', 'Krčméryho',
        'Kremeľská', 'Kremencová', 'Kremnická', 'Kresánkova', 'Kríková',
        'Krivá', 'Križkova', 'Krížna', 'Krížna', 'Krížna', 'Krížna',
        'Krmanova', 'Krokusová', 'Krompašská', 'Krupinská', 'Kubačova',
        'Kubániho', 'Kubínska', 'Kudlákova', 'Kuklovská', 'Kúkoľová',
        'Kukučínova', 'Kukuričná', 'Kulíškova', 'Kultúrna', 'Kuneradská',
        'Kupeckého', 'Kúpeľná', 'Kurucova', 'Kutlíkova', 'Kútska',
        'Kutuzovova', 'Kuzmányho', 'Kvačalova', 'Kvetinárska', 'Kvetná',
        'Kýčerského', 'Kyjevská', 'Kysucká', 'Laborecká', 'Lackova',
        'Ladislava Batthyányh', 'Ladislava Dérera', 'Ladislava Sáru', 'Ľadová',
        'Ladzianskeho', 'Lachova', 'Ľaliová', 'Lamačská cesta',
        'Lamačská cesta', 'Lamačská cesta', 'Lamanského', 'Landauova',
        'Landererova', 'Langsfeldova', 'Ľanová', 'Laskomerského', 'Laténská',
        'Latorická', 'Laučekova', 'Laurinská', 'Lazaretská', 'Lazaretská',
        'Leánska', 'Lediny', 'Legerského', 'Legionárska', 'Legionárska',
        'Lehotského', 'Lehotského', 'Leknová', 'Lenardova', 'Lermontovova',
        'Lesná', 'Lesnícka', 'Leškova', 'Letecká', 'Letisko M.R.Štefánik',
        'Letná', 'Levanduľová', 'Levárska', 'Levická', 'Levočská', 'Lidická',
        'Lieskovec', 'Lieskovcová', 'Lieskovská cesta', 'Lietavská',
        'Lichardova', 'Likavská', 'Limbová', 'Linzbothova', 'Lipnicová',
        'Lipová', 'Lipského', 'Liptovská', 'Lisovňa', 'Listová', 'Líščie nivy',
        'Líščie údolie', 'Litovská', 'Lodná', 'Lombardiniho', 'Lomnická',
        'Lomonosovova', 'Longobardská', 'Lónyaiová', 'Lopenícka', 'Lotyšská',
        'Lovinského', 'Lozornianská', 'Ľubietovská', 'Ľubinská', 'Ľubľanská',
        'Ľubochnianska', 'Ľubovnianska', 'Ľubovníková', 'Ľudové námestie',
        'Ľudovíta Fullu', 'Luhačovická', 'Lužická', 'Lúčna', 'Lužná',
        'Lýcejná', 'Lykovcová', 'Lysákova', 'M. Hella', 'Madáchova', 'Maďarská',
        'Magnetová', 'Magnezitová', 'Magnóliová', 'Magurská', 'Macharova',
        'Máchova', 'Majakovského', 'Majerníkova', 'Majerská', 'Májkova',
        'Majoránová', 'Májová', 'Maková', 'Makovického', 'Malá', 'Malagová',
        'Malé pálenisko', 'Malinová', 'Malodunajská', 'Malokarpatské námest',
        'Malý Draždiak', 'Malý trh', 'Mamateyova', 'Mamateyova', 'Mandľová',
        'Mandľovníková', 'Mánesovo námestie', 'Margarétková', 'Marhuľová',
        'Mariánska', 'Marie Curie-Sklodows', 'Márie Medveďovej', 'Markova',
        'Marótyho', 'Martákovej', 'Martinčekova', 'Martinčekova',
        'Martinengova', 'Martinská', 'Mateja Bela', 'Matejkova', 'Matičná',
        'Mätová', 'Matúškova', 'Matúšova', 'Mečíkova', 'Medená', 'Medová',
        'Medovková', 'Medzierka', 'Medzilaborecká', 'Mesačná', 'Mestská',
        'Meteorová', 'Metodova', 'Mickiewiczova', 'Mierová', 'Michalská',
        'Mikovíniho', 'Mikulášska', 'Milana Marečka', 'Milana Pišúta',
        'Miletičova', 'Miletičova', 'Mišíkova', 'Mišíkova', 'Mišíkova',
        'Mládežnícka', 'Mliekárenská', 'Mlynarovičova', 'Mlynská',
        'Mlynská dolina', 'Mlynská dolina', 'Mlynská dolina', 'Mlynské luhy',
        'Mlynské nivy', 'Mlynské nivy', 'Mlynské nivy', 'Mlynské nivy',
        'Mlynské nivy', 'Modranská', 'Modricová', 'Modrý chodník', 'Mojmírova',
        'Mokráň záhon', 'Mokrohájska cesta', 'Moldavská', 'Molecova',
        'Monardová', 'Morava', 'Moravská', 'Morušova', 'Moskovská', 'Most SNP',
        'Mostná', 'Mostová', 'Mošovského', 'Motýlia', 'Moyšova', 'Moyzesova',
        'Mozartova', 'Mramorová', 'Mraziarenská', 'Mrázova', 'Mudrochova',
        'Mudroňova', 'Mudroňova', 'Mudroňova', 'Muchovo námestie', 'Muránska',
        'Murgašova', 'Murnice', 'Muškátová', 'Muštová', 'Múzejná', 'Myjavská',
        'Mýtna', 'Mýtna', 'Na Baránku', 'Na barine', 'Na Brezinách',
        'Na doline', 'Na grbe', 'Na Grunte', 'Na Holom vrchu', 'Na hrádzi',
        'Na Hrebienku', 'Na hriadkach', 'Na Kalvárii', 'Na kaštieli',
        'Na kopci', 'Na križovatkách', 'Na lánoch', 'Na medzi', 'Na mýte',
        'Na pántoch', 'Na pasekách', 'Na paši', 'Na pažiti', 'Na piesku',
        'Na Revíne', 'Na Riviére', 'Na rozhliadke', 'Na Sitine', 'Na skale',
        'Na Slanci', 'Na Slavíne', 'Na spojke', 'Na stráni', 'Na Štyridsiatku',
        'Na úvrati', 'Na varte', 'Na Vlkovkách', 'Na vrátkach', 'Na vŕšku',
        'Na vyhliadke', 'Na výslní', 'Na Zlatej nohe', 'Nábělkova',
        'Nábrežie arm. gen. L', 'Nábrežná', 'Nad Dunajom', 'Nad Gronárom',
        'Nad jazierkom', 'Nad kúriou', 'Nad lomom', 'Nad lúčkami',
        'Nad lúčkami', 'Nad ostrovom', 'Nad Sihoťou', 'Nákovná', 'Nákupná',
        'Námestie 1. mája', 'Námestie 6. apríla', 'Námestie Alexandra D',
        'Námestie Andreja Hli', 'Námestie Biely kríž', 'Námestie Hraničiarov',
        'Námestie Jána Kostru', 'Námestie Jána Pavla', 'Námestie Ľudovíta Št',
        'Námestie Martina Ben', 'Námestie Rodiny', 'Námestie slobody',
        'Námestie slobody', 'Námestie SNP', 'Námestie SNP',
        'Námestie sv. Františ', 'Námestie sv. Petra a', 'Narcisová',
        'Nedbalova', 'Nechtíková', 'Nejedlého', 'Nekrasovova', 'Nemčíkova',
        'Nerudova', 'Nevädzová', 'Nevská', 'Nezábudková', 'Nezvalova',
        'Niťová', 'Nitrianska', 'Nížinná', 'Nobelova', 'Nobelovo námestie',
        'Nová', 'Nová Bellova', 'Nová hora', 'Novackého', 'Nové pálenisko',
        'Nové záhrady I', 'Nové záhrady II', 'Nové záhrady III',
        'Nové záhrady IV', 'Nové záhrady V', 'Nové záhrady VI',
        'Nové záhrady VII', 'Novinárska', 'Novobanská', 'Novodvorská',
        'Novohorská', 'Novohradská', 'Novosadná', 'Novosvetská', 'Novosvetská',
        'Novosvetská', 'Novoveská', 'Nový záhon', 'Obežná', 'Obchodná',
        'Oblačná', 'Oblúková', 'Očovská', 'Odbojárov', 'Odborárska',
        'Odborárske námestie', 'Odborárske námestie', 'Odeská', 'Ohnicová',
        'Okánikova', 'Okružná', 'Olbrachtova', 'Oleandrová', 'Olejkárska',
        'Olivová', 'Olšová', 'Ondavská', 'Ondrejovova', 'Ondrejská', 'Opavská',
        'Opletalova', 'Oráčska', 'Oravská', 'Orechová', 'Orechová cesta',
        'Orechový rad', 'Orenburská', 'Orgovánová', 'Orchideová', 'Oriešková',
        'Ormisova', 'Osadná', 'Osiková', 'Oskorušová', 'Osloboditeľská',
        'Ostravská', 'Ostredková', 'Ostružinová', 'Osuského', 'Osvetová',
        'Otonelská', 'Ovčiarska', 'Ovocná', 'Ovručská', 'Ovsená',
        'Ovsištské námestie', 'Ožvoldíkova', 'Ôsma', 'Pajštúnska', 'Palackého',
        'Palárikova', 'Palárikova', 'Palinová', 'Palisády', 'Palisády',
        'Palisády', 'Palkovičova', 'Palmová', 'Panenská', 'Pankúchova',
        'Panónska cesta', 'Panská', 'Papánkovo námestie', 'Papraďová',
        'Parcelná', 'Páričkova', 'Parková', 'Partizánska', 'Pasienková',
        'Pasienky', 'Pastierska', 'Paulínyho', 'Pave Vukoviča', 'Pavla Blaha',
        'Pavla Horova', 'Pavlovičova', 'Pavlovova', 'Pavlovská', 'Pažického',
        'Pažítková', 'Pečnianska', 'Pekná cesta', 'Pekná cesta', 'Pekná cesta',
        'Pekná vyhliadka', 'Pekníkova', 'Pernecká', 'Perličková',
        'Pestovateľská', 'Petara Pasicha', 'Peterská', 'Petöfiho',
        'Petržalská', 'Petúniová', 'Pezinská', 'Piata', 'Pieskovcová',
        'Piesočná', 'Piešťanská', 'Pifflova', 'Pilárikova', 'Pílová',
        'Píniová', 'Pionierska', 'Pionierska', 'Pivoňková', 'Plachého',
        'Plachého', 'Planckova', 'Planét', 'Plánky', 'Platanová', 'Plátenícka',
        'Plavecká', 'Plickova', 'Pluhová', 'Plynárenská', 'Plzenská',
        'Pobrežná', 'Pod agátmi', 'Pod Bôrikom', 'Pod brehmi', 'Pod gaštanmi',
        'Pod Kalváriou', 'Pod Klepáčom', 'Pod Kobylou', 'Pod Krásnou hôrkou',
        'Pod lesom', 'Pod lipami', 'Pod Lipovým', 'Pod násypom',
        'Pod Rovnicami', 'Pod skalou', 'Pod srdcom', 'Pod Strážami',
        'Pod Vachmajstrom', 'Pod Válkom', 'Pod vinicami', 'Pod záhradami',
        'Pod záhradami', 'Pod Zečákom', 'Podbeľová', 'Podbrezovská', 'Podháj',
        'Podhorská', 'Podhorského', 'Podjavorinskej', 'Podkarpatská',
        'Podkerepušky', 'Podkolibská', 'Podkorunská', 'Podlesná',
        'Podlučinského', 'Podniková', 'Podpriehradná', 'Podtatranského',
        'Podunajská', 'Podunajská', 'Podzáhradná', 'Pohánková', 'Pohraničníkov',
        'Pohronská', 'Polárna', 'Polianky', 'Poľná', 'Poľnohospodárska',
        'Poľný mlyn', 'Poloreckého', 'Poľská', 'Poludníková', 'Poniklecová',
        'Popolná', 'Popovova', 'Popradská', 'Porubského', 'Poštová', 'Potočná',
        'Považanova', 'Považská', 'Povoznícka', 'Povraznícka', 'Povraznícka',
        'Požiarnická', 'Pračanská', 'Prasličková', 'Pražská', 'Pražská',
        'Predstaničné námesti', 'Prepoštská', 'Prešernova', 'Prešovská',
        'Prešovská', 'Prešovská', 'Pri Bielom kríži', 'Pri dvore',
        'Pri Dynamitke', 'Pri Habánskom mlyne', 'Pri hradnej studni',
        'Pri hrádzi', 'Pri kolíske', 'Pri kríži', 'Pri mlyne', 'Pri Rochu',
        'Pri seči', 'Pri Starej Prachárni', 'Pri Starom háji',
        'Pri starom letisku', 'Pri Starom Mýte', 'Pri strelnici', 'Pri Struhe',
        'Pri Suchom mlyne', 'Pri Šajbách', 'Pri tehelni', 'Pri trati',
        'Pri vinohradoch', 'Pri zvonici', 'Priama cesta', 'Pribylinská',
        'Pribinova', 'Pribinova', 'Pribinova', 'Pribišova', 'Prídanky',
        'Prídavková', 'Priečna', 'Priehradná', 'Priekopnícka', 'Priekopy',
        'Priemyselná', 'Priemyselná', 'Prievozská', 'Prievozská', 'Prievozská',
        'Príjazdná', 'Príkopova', 'Primaciálne námestie', 'Prímoravská',
        'Prípojná', 'Prístav', 'Prístavná', 'Prokofievova', 'Prokopa Veľkého',
        'Prokopova', 'Prúdová', 'Prvá', 'Prvosienková', 'Pšeničná',
        'Púchovská', 'Púpavová', 'Pustá', 'Puškinova', 'Pútnická',
        'Pyrenejská', 'Rácova', 'Račianska', 'Račianska', 'Račianska',
        'Račianska', 'Račianska', 'Račianska', 'Račianske mýto', 'Radarová',
        'Rádiová', 'Radlinského', 'Radničná', 'Radničné námestie', 'Radvanská',
        'Rajčianska', 'Rajecká', 'Rajská', 'Rajtákova', 'Raketová', 'Rákosová',
        'Rascová', 'Rascová', 'Rastislavova', 'Rastlinná', 'Rašelinová',
        'Ráztočná', 'Rázusovo nábrežie', 'Ražná', 'Rebarborová', 'Regrútska',
        'Remeselnícka', 'Repašského', 'Repíková', 'Repná', 'Rešetkova',
        'Revolučná', 'Révová', 'Revúcka', 'Rezedová', 'Riazanská', 'Riazanská',
        'Ribayová', 'Ríbezľová', 'Riečna', 'Rigeleho', 'Rímska', 'Rízlingová',
        'Riznerova', 'Robotnícka', 'Roľnícka', 'Romanova', 'Röntgenova',
        'Rosná', 'Rostovská', 'Rošického', 'Rovná', 'Rovniankova', 'Rovníková',
        'Royova', 'Rozálska', 'Rozmarínová', 'Rozvodná', 'Rožňavská',
        'Rožňavská', 'Rožňavská', 'Rubínová', 'Rubinsteinova',
        'Rudnayovo námestie', 'Rudnícka', 'Rulandská', 'Rumančeková',
        'Rumunská', 'Rusovce', 'Rusovská cesta', 'Rustaveliho', 'Ružičková',
        'Ružinovská', 'Ružinovská', 'Ružinovská', 'Ružomberská',
        'Ružová dolina', 'Ružová dolina', 'Rybárska brána', 'Rybné námestie',
        'Rybničná', 'Rybničná', 'Rybničná', 'Rýdziková', 'Rytierska',
        'Sabinovská', 'Sabinovská', 'Sad Janka Kráľa', 'Sadmelijská', 'Sadová',
        'Samova', 'Saratovská', 'Sartorisova', 'Sasanková', 'Sasinkova',
        'Savignonská', 'Seberíniho', 'Sečovská', 'Sedlárska', 'Sedmokrásková',
        'Segnáre', 'Segnerova', 'Sekulská', 'Sekurisova', 'Sekýľska',
        'Semenárska', 'Semianova', 'Semilonská', 'Senická', 'Senná',
        'Septimiova', 'Schengenská', 'Schillerova', 'Schneidera -Trnavské',
        'Schody pri starej vo', 'Sibírska', 'Siedma', 'Sienkiewiczova',
        'Silvánska', 'Sinokvetná', 'Skalická cesta', 'Skalná', 'Skerličova',
        'Sklabinská', 'Sklenárova', 'Sklenárska', 'Skoroceľová', 'Skuteckého',
        'Skýcovská', 'Sládkovičova', 'Sladová', 'Slatinská', 'Slávičie údolie',
        'Slavín', 'Slepá', 'Sliačska', 'Sliezska', 'Slivková', 'Sĺňavská',
        'Slnečná', 'Slnečnicová', 'Slovanské nábrežie', 'Slovienska',
        'Slovinec', 'Slovinská', 'Slovnaftská', 'Slovnaftská', 'Slowackého',
        'Smetanova', 'Smikova', 'Smolenická', 'Smolnícka', 'Smrečianska',
        'Smrečianska', 'Snežienková', 'Soferove schody', 'Socháňova',
        'Sochorova', 'Sokolíkova', 'Sokolská', 'Solivarská', 'Sološnická',
        'Somolického', 'Somolického', 'Sosnová', 'Sovia', 'Spádová',
        'Spätná cesta', 'Spišská', 'Spojná', 'Spoločenská', 'Sputniková',
        'Sreznevského', 'Srnčia', 'Stachanovská', 'Stálicová', 'Stanekova',
        'Staničná', 'Stará Černicová', 'Stará Ivánska cesta', 'Stará Klenová',
        'Stará Prievozská', 'Stará Stupavská', 'Stará Vajnorská',
        'Stará vinárska', 'Staré Grunty', 'Staré ihrisko', 'Staré záhrady',
        'Starhradská', 'Starohájska', 'Staromestská', 'Staromlynská',
        'Starorímska', 'Staroturský chodník', 'Stavbárska', 'Staviteľská',
        'Stepná cesta', 'Stodolova', 'Stoklasová', 'Stolárska', 'Strakova',
        'Stratená', 'Strážna', 'Strážnická', 'Strážny dom', 'Strečnianska',
        'Stredná', 'Strelecká', 'Strelkova', 'Strmá cesta', 'Strmé sady',
        'Strmý bok', 'Strmý vŕšok', 'Strojnícka', 'Stromová', 'Stropkovská',
        'Struková', 'Studená', 'Studenohorská', 'Stuhová', 'Stupavská',
        'Súbežná', 'Sudová', 'Súhvezdná', 'Suchá', 'Suché mýto', 'Suchohradská',
        'Súkennícka', 'Súľovská', 'Sumbalova', 'Súmračná', 'Súťažná',
        'Svätého Vincenta', 'Svätoplukova', 'Svätoplukova', 'Svätovojtešská',
        'Svébska', 'Svetlá', 'Svíbová', 'Svidnícka', 'Svoradova', 'Svrčia',
        'Syslia', 'Šafárikovo námestie', 'Šafárikovo námestie', 'Šafránová',
        'Šagátova', 'Šachorová', 'Šalátová', 'Šaldova', 'Šalviová',
        'Šamorínska', 'Šancová', 'Šancová', 'Šancová', 'Šancová', 'Šándorova',
        'Šarišská', 'Šášovská', 'Šaštínska', 'Ševčenkova', 'Šiesta', 'Šikmá',
        'Šinkovské', 'Šintavská', 'Šípková', 'Šípová', 'Šíravská', 'Široká',
        'Škarniclova', 'Školská', 'Škovránčia', 'Škultétyho', 'Šoltésovej',
        'Šošovicová', 'Špieszova', 'Špitálska', 'Športová',
        'Šrobárovo námestie', 'Šťastná', 'Štedrá', 'Štefana Králika',
        'Štefana Králika', 'Štefana Majera', 'Štefánikova', 'Štefánikova',
        'Štefánikova', 'Štefanovičova', 'Štefunkova', 'Štepná', 'Štetinova',
        'Štiavnická', 'Štítová', 'Štrbská', 'Štúrova', 'Štvrtá', 'Štyndlova',
        'Šulekova', 'Šulekova', 'Šulekova', 'Šumavská', 'Šuňavcova', 'Šúrska',
        'Šustekova', 'Šuty', 'Švabinského', 'Švantnerova', 'Tabaková',
        'Tablicova', 'Táborská', 'Tajovského', 'Talichova', 'Tallerova',
        'Tatranská', 'Tavaríkova osada', 'Tbiliská', 'Tehelná', 'Tehelňa',
        'Tehliarska', 'Technická', 'Tekovská', 'Tekvicová', 'Telocvičná',
        'Tematínska', 'Teplická', 'Terchovská', 'Teslova', 'Tešedíkova',
        'Tetmayerova', 'Thurzova', 'Tibenského', 'Tibériová', 'Tichá',
        'Tilgnerova', 'Timravina', 'Tobrucká', 'Tokajícka', 'Tolstého',
        'Tománkova', 'Tomanova', 'Tomášikova', 'Tomášikova', 'Tomášikova',
        'Tomášikova', 'Tomášikova', 'Toplianska', 'Topoľčianska', 'Topoľová',
        'Toryská', 'Továrenská', 'Trajánova', 'Tramínová', 'Tranovského',
        'Trávna', 'Trebišovská', 'Trebišovská', 'Trebišovská', 'Trenčianska',
        'Treskoňova', 'Tretia', 'Trhová', 'Trinásta', 'Trnavská cesta',
        'Trnavská cesta', 'Trnavská cesta', 'Trnavská cesta', 'Trnavská cesta',
        'Trnavské mýto', 'Trnková', 'Tŕňová', 'Trojdomy', 'Trojičné námestie',
        'Trstínska', 'Tučkova', 'Tuhovská', 'Tulipánová', 'Tupého',
        'Tupolevova', 'Turbínova', 'Turčianska', 'Turistická', 'Turnianska',
        'Tvarožkova', 'Tylova', 'Tymiánová', 'Tyršovo nábrežie', 'Učiteľská',
        'Údernícka', 'Údolná', 'Uhliská', 'Uhorková', 'Uhrova', 'Uhrovecká',
        'Ukrajinská', 'Ulica 1. mája', 'Ulica 29. augusta',
        'Ulica 29. augusta', 'Ulica 29. augusta', 'Ulica 29. augusta',
        'Ulica 8. mája', 'Ulica Alviano', 'Ulica Imricha Karvaš',
        'Ulica J. Valašťana D', 'Ulica Janka Alexyho', 'Ulica Jozefa Krónera',
        'Ulica Juraja Hronca', 'Ulica Karola Adlera', 'Ulica kpt. Rašu',
        'Ulica Leopoldov maje', 'Ulica Ľuda Zúbka', 'Ulica Nad Válkom',
        'Ulica padlých hrdino', 'Ulica Pri gaštanovej', 'Ulica Pri pastierni',
        'Ulica Pri Vápeníckom', 'Ulica Pri vodnej nád', 'Ulica svornosti',
        'Ulica Viktora Tegelh', 'Úprkova', 'Úradnícka', 'Uránová', 'Urbánkova',
        'Urbárska', 'Ursínyho', 'Uršulínska', 'Ušiakova', 'Úvozná', 'Uzbecká',
        'Úzka', 'Úžiny', 'V záhradách', 'Vajanského nábrežie', 'Vajnorská',
        'Vajnorská', 'Vajnorská', 'Vajnorská', 'Vajnorská', 'Vajnorská',
        'Vajnorská', 'Vajnorská', 'Vajnorská', 'Valachovej', 'Valašská',
        'Valchárska', 'Vančurova', 'Vansovej', 'Vápencová', 'Vápenka',
        'Vápenná', 'Varínska', 'Varšavská', 'Varšavská', 'Vavilovova',
        'Vavrinecká', 'Vavrínova', 'Vazovova', 'Vážska', 'Včelárska',
        'Velehradská', 'Veľké Štepnice', 'Veltlínska', 'Vendelínska',
        'Ventúrska', 'Veterná', 'Veternicová', 'Vetvárska', 'Vetvová',
        'Vidlicová', 'Viedenská cesta', 'Viedenská cesta', 'Viedenská cesta',
        'Vietnamská', 'Vígľašská', 'Vihorlatská', 'Viktorínova', 'Vilová',
        'Viničná', 'Vínna', 'Vinohradnícka', 'Višňová', 'Víťazná', 'Vlárska',
        'Vlastenecké námestie', 'Vlčie hrdlo', 'Vlčkova', 'Vlčkova', 'Vlčkova',
        'Vodné elektrárne', 'Vodný vrch', 'Vosková', 'Votrubova', 'Vrábeľská',
        'Vrakunská', 'Vrakunská cesta', 'Vrakunská cesta', 'Vrančovičova',
        'Vranovská', 'Vrbánska', 'Vrbenského', 'Vŕbová', 'Vresová',
        'Vretenová', 'Vrchná', 'Vrútocká', 'Vtáčikova', 'Vtáčnik', 'Vyhliadka',
        'Vyhnianska cesta', 'Výhonská', 'Východná', 'Vysoká', 'Vysokohorská',
        'Vyšehradská', 'Vyšná', 'Výtvarná', 'Vývojová', 'Wattova', 'Wilsonova',
        'Wolkrova', 'Za bránou', 'Za farou', 'Za Kasárňou', 'Za mlynom',
        'Za sokolovňou', 'Za Stanicou', 'Za tehelňou', 'Záborského',
        'Zadunajská cesta', 'Záhorácka', 'Záhorská', 'Záhradkárska', 'Záhradná',
        'Záhradnícka', 'Záhradnícka', 'Záhradnícka', 'Záhradnícka', 'Záhrady',
        'Záhrebská', 'Záhrebská', 'Záhumenná', 'Záhumenská', 'Zákutie',
        'Zálužická', 'Zámocká', 'Zámocké schody', 'Zámočnícka', 'Západná',
        'Západný rad', 'Záporožská', 'Záruby', 'Zátišie', 'Zátureckého',
        'Zavadilová', 'Závadská', 'Záveterná', 'Závodná', 'Závodníkova',
        'Zbrody', 'Zdravotnícka', 'Zelená', 'Zeleninová', 'Zelenohorská',
        'Zelinárska', 'Zhorínska', 'Zidiny', 'Zimná', 'Zlatá', 'Zlaté piesky',
        'Zlaté schody', 'Zlatohorská', 'Znievska', 'Zohorská', 'Zochova',
        'Zrinského', 'Zvolenská', 'Zvončeková', 'Žabí majer', 'Žabotova',
        'Žarnovická', 'Žatevná', 'Žehrianska', 'Železná', 'Železničiarska',
        'Železničná', 'Želiarska', 'Žellova', 'Žiacka', 'Žiarska', 'Židovská',
        'Žihľavová', 'Žilinská', 'Žilinská', 'Žitavská', 'Žitná', 'Živnostenská',
        'Žižkova', 'Žulová', 'Župné námestie', 'Borágova', 'Parenicová',
        'Loparová', 'Jegnešská', 'Jonatanová', 'Monardová', 'Perličková',
    )

    states = (
        'Bratislavský kraj', 'Trnavský kraj', 'Trenčiansky kraj',
        'Nitriansky kraj', 'Žilinský kraj', 'Banskobystrický kraj',
        'Prešovský kraj', 'Košický kraj',
    )

    countries = (
        'Afganistan', 'Afghanistanská islamská republika', 'Ålandy',
        'Albánsko', 'Albánska republika', 'Alžírsko',
        'Alžírska demokratická ľudová republika', 'Americká Samoa', 'Andorra',
        'Andorrské kniežatstvo', 'Angola', 'Angolská republika', 'Anguilla',
        'Antarktída', 'Antigua a Barbuda', 'Argentína',
        'Argentínska republika', 'Arménsko', 'Arménska republika', 'Aruba',
        'Austrália', 'Rakúsko', 'Rakúska republika', 'Azerbajdžan',
        'Azerbajdžanská republika', 'Bahamy', 'Bahamské spoločenstvo',
        'Bahrajn', 'Bahrajnské kráľovstvo', 'Bangladéš',
        'Bangladéšska ľudová republika', 'Barbados', 'Bielorusko',
        'Bieloruská republika', 'Belgicko', 'Belgické kráľovstvo', 'Belize',
        'Benin', 'Beninská republika', 'Bermudy', 'Bhután',
        'Bhutánske kráľovstvo', 'Bolívijská republika', 'Bolívijská republika',
        'Bolívia', 'Bosna a Hercegovina', 'Republika Bosny a Hercegoviny',
        'Botswana', 'Botswanská republika', 'Bouvetov ostrov', 'Brazília',
        'Brazílska federatívna republika', 'Britské indickooceánske územie',
        'Brunejsko-darussalamský štát', 'Bulharsko', 'Bulharská republika',
        'Burkina Faso', 'Burundi', 'Burundská republika', 'Kambodža',
        'Kambodžské kráľovstvo', 'Kamerun', 'Kamerunská republika', 'Kanada',
        'Kapverdy', 'Kapverdská republika', 'Kajmanie ostrovy',
        'Stredoafrická republika', 'Čad', 'Čadská republika', 'Čile',
        'Čilská republika', 'Čína', 'Čínska ľudová republika',
        'Vianočný ostrov', 'Kokosové ostrovy', 'Kolumbia',
        'Kolumbijská republika', 'Komory', 'Komorský zväz', 'Kongo',
        'Konžská republika', 'Konžská demokratická republika',
        'Cookove ostrovy', 'Kostarika', 'Kostarická republika',
        'Pobrežie Slonoviny', 'Republika Pobrežia Slonoviny', 'Chorvátsko',
        'Chorvátska republika', 'Kuba', 'Kubánska republika', 'Cyprus',
        'Cyperská republika', 'Česká republika', 'Dánsko', 'Dánske kráľovstvo',
        'Džibutsko', 'Džibutská republika', 'Dominika',
        'Dominické spoločenstvo', 'Dominikánska republika', 'Ekvádor',
        'Ekvádorská republika', 'Egypt', 'Egyptská arabská republika',
        'Salvádor', 'Salvádorská republika', 'Rovníková Guinea',
        'Republika Rovníkovej Guiney', 'Eritrea', 'Estónsko',
        'Estónska republika', 'Etiópia',
        'Etiópska federatívna demokratická republika', 'Falklandy (Malvíny)',
        'Faerské ostrovy', 'Fidži', 'Fínsko', 'Fínska republika', 'Francúzsko',
        'Francúzska republika', 'Francúzska Guyana', 'Francúzska Polynézia',
        'Francúzske južné a antarktické územia', 'Gabon', 'Gabonská republika',
        'Gambia', 'Gambijská republika', 'Gruzínsko', 'Nemecko',
        'Nemecká spolková republika', 'Ghana', 'Ghanská republika',
        'Gibraltár', 'Grécko', 'Grécka republika', 'Grónsko', 'Grenada',
        'Guadeloupe', 'Guam', 'Guatemala', 'Guatemalská republika', 'Guernsey',
        'Guinea', 'Guinejská republika', 'Guinea-Bissau',
        'Guinejsko-bissauská republika', 'Guyana',
        'Guyanská kooperatívna republika', 'Haiti', 'Haitská republika',
        'Heardov ostrov', 'Svätá stolica (Vatikánsky mestský štát)',
        'Honduras', 'Honduraská republika', 'Hongkong',
        'Osobitná administratívna oblasť Číny Hongkong', 'Maďarsko',
        'Maďarská republika', 'Island', 'Islandská republika', 'India',
        'Indická republika', 'Indonézia', 'Indonézska republika',
        'Iránska islamská republika', 'Iránska islamská republika', 'Irak',
        'Iracká republika', 'Írsko', 'Man', 'Izrael', 'Izraelský štát',
        'Taliansko', 'Talianska republika', 'Jamajka', 'Japonsko', 'Jersey',
        'Jordánsko', 'Jordánske hášimovské kráľovstvo', 'Kazachstan',
        'Kazašská republika', 'Keňa', 'Kenská republika', 'Kiribati',
        'Kiribatská republika', 'Kórejská ľudovodemokratická republika',
        'Kórejská ľudovodemokratická republika', 'Kórejská republika',
        'Kuvajt', 'Kuvajtský štát', 'Kirgizsko', 'Kirgizská republika',
        'Laoská ľudovodemokratická republika', 'Lotyšsko',
        'Lotyšská republika', 'Libanon', 'Libanonská republika', 'Lesotho',
        'Lesothské kráľovstvo', 'Libéria', 'Libérijská republika', 'Líbya',
        'Lichtenštajnsko', 'Lichtenštajnské kniežatstvo', 'Litva',
        'Litovská republika', 'Luxembursko', 'Luxemburské veľkovojvodstvo',
        'Macao', 'Osobitná administratívna oblasť Číny Macao',
        'Macedónska republika', 'Bývalá juhoslovanská republika Macedónsko',
        'Madagaskar', 'Madagaskarská republika', 'Malawi',
        'Malawijská republika', 'Malajzia', 'Maldivy', 'Maldivská republika',
        'Mali', 'Malijská republika', 'Malta', 'Maltská republika',
        'Marshallove ostrovy', 'Republika Marshallových ostrovov', 'Martinik',
        'Mauritánia', 'Mauritánska islamská republika', 'Maurícius',
        'Maurícijská republika', 'Mayotte', 'Mexiko', 'Spojené štáty mexické',
        'Mikronézske federatívne štáty', 'Mikronézske federatívne štáty',
        'Moldavská republika', 'Moldavská republika', 'Moldavsko', 'Monako',
        'Monacké kniežatstvo', 'Mongolsko', 'Čierna Hora', 'Montserrat',
        'Maroko', 'Marocké kráľovstvo', 'Mozambik', 'Mozambická republika',
        'Mjanmarsko', 'Namíbia', 'Namíbijská republika', 'Nauru',
        'Nauruská republika', 'Nepál',
        'Nepálska federatívna demokratická republika', 'Holandsko',
        'Holandské kráľovstvo', 'Nová Kaledónia', 'Nový Zéland', 'Nikaragua',
        'Nikaragujská republika', 'Niger', 'Nigerská republika', 'Nigéria',
        'Nigérijská federatívna republika', 'Niue', 'Norfolk',
        'Severné Mariány', 'Spoločenstvo Severných Marián', 'Nórsko',
        'Nórske kráľovstvo', 'Omán', 'Ománsky sultanát', 'Pakistan',
        'Pakistanská islamská republika', 'Palau', 'Palauská republika',
        'palestínske územie, Okupované', 'Okupované palestínske územie',
        'Panama', 'Panamská republika', 'Papua - Nová Guinea', 'Paraguaj',
        'Paraguajská republika', 'Peru', 'Peruánska republika', 'Filipíny',
        'Filipínska republika', 'Pitcairnove ostrovy', 'Poľsko',
        'Poľská republika', 'Portugalsko', 'Portugalská republika',
        'Portoriko', 'Katar', 'Katarský štát', 'Réunion', 'Rumunsko',
        'Ruská federácia', 'Rwanda', 'Rwandská republika', 'Svätý Bartolomej',
        'Svätá Helena, Ascension a Tristan da Cunha', 'Svätý Krištof a Nevis',
        'Svätá Lucia', 'Saint Martin', 'Saint Pierre a Miquelon',
        'Svätý Vincent a Grenadíny', 'Samoa', 'Samojský nezávislý štát',
        'San Maríno', 'Sanmarínska republika', 'Svätý Tomáš a Princov ostrov',
        'Demokratická republika Svätého Tomáša a Princovho ostrova',
        'Saudská Arábia', 'Saudskoarabské kráľovstvo', 'Senegal',
        'Senegalská republika', 'Srbsko', 'Srbská republika', 'Seychely',
        'Seychelská republika', 'Sierra Leone', 'Sierraleonská republika',
        'Singapur', 'Singapurská republika', 'Slovensko',
        'Slovenská republika', 'Slovinsko', 'Slovinská republika',
        'Šalamúnove ostrovy', 'Somálsko', 'Somálska republika', 'Južná Afrika',
        'Juhoafrická republika', 'Južná Georgia a Južné Sandwichove ostrovy',
        'Španielsko', 'Španielske kráľovstvo', 'Srí Lanka',
        'Srílanská demokratická socialistická republika', 'Sudán',
        'Sudánska republika', 'Surinam', 'Surinamská republika',
        'Svalbard a Jan Mayen', 'Svazijsko', 'Svazijské kráľovstvo', 'Švédsko',
        'Švédske kráľovstvo', 'Švajčiarsko', 'Švajčiarska konfederácia',
        'Sýrska arabská republika', 'Taiwan, provincia Číny', 'Taiwan',
        'Tadžikistan', 'Tadžická republika', 'Tanzánijská zjednotená republika',
        'Tanzánijská zjednotená republika', 'Thajsko', 'Thajské kráľovstvo',
        'Východný Timor', 'Východotimorská demokratická republika', 'Togo',
        'Togská republika', 'Tokelau', 'Tonga', 'Tongské kráľovstvo',
        'Trinidad a Tobago', 'Republika Trinidadu a Tobaga', 'Tunisko',
        'Tuniská republika', 'Turecko', 'Turecká republika', 'Turkménsko',
        'Ostrovy Turks a Caicos', 'Tuvalu', 'Uganda', 'Ugandská republika',
        'Ukrajina', 'Spojené arabské emiráty', 'Spojené kráľovstvo',
        'Spojené kráľovstvo Veľkej Británie a Severného Írska',
        'Spojené štáty', 'Spojené štáty americké',
        'Menšie odľahlé ostrovy Spojených štátov', 'Uruguaj',
        'Uruguajská východná republika', 'Uzbekistan', 'Uzbecká republika',
        'Vanuatu', 'Vanuatská republika', 'Venezuelská bolívarovská republika',
        'Venezuela', 'Vietnam', 'Vietnamská socialistická republika',
        'Panenské ostrovy, Britské', 'Britské Panenské ostrovy',
        'Panenské ostrovy, Americké', 'Panenské ostrovy Spojených štátov',
        'Wallis a Futuna', 'Západná Sahara', 'Jemen', 'Jemenská republika',
        'Zambia', 'Zambijská republika', 'Zimbabwe', 'Zimbabwianska republika',
        'Britské antarktické územie', 'Socialistická republika Barmský zväz',
        'Bieloruská sovietska socialistická republika',
        'ostrovy Canton a Enderbury',
        'Československo, Československá socialistická republika', 'Dahome',
        'Zem kráľovnej Maud', 'Východný Timor', 'Metropolitné Francúzsko',
        'Francúzske pobrežie Afarov a Isasov',
        'Francúzske južné a antarktické územia',
        'Nemecká demokratická republika', 'Nemecká spolková republika',
        'Gilbertove a lagúnové ostrovy', 'Johnston', 'Midwajské ostrovy',
        'Holandské Antily', 'neutrálne pôdy', 'Nové Hebridy',
        'Poručnícke územie tichomorských ostrovov', 'Panamská republika',
        'Panamské prieplavové pásmo', 'Rumunská socialistická republika',
        'Svätý Krištof', 'Srbsko a Čierna Hora', 'Sikkim', 'Rodézia',
        'Španielska Sahara', 'Tichomorské ostrovy pod správou USA',
        'ZSSR, Zväz sovietskych socialistických republík',
        'Republika Horná Volta', 'Vatikánsky mestský štát (Svätá stolica)',
        'Vietnamská demokratická republika', 'Wake',
        'Jemenská ľudovodemokratická republika', 'Jemenská arabská republika',
        'Socialistická federatívna republika Juhoslávia', 'Zairská republika',
    )

    def street_suffix_short(self):
        return self.random_element(self.street_suffixes_short)

    def street_suffix_long(self):
        return self.random_element(self.street_suffixes_long)

    def city_name(self):
        return self.random_element(self.cities)

    def street_name(self):
        return self.random_element(self.streets)

    def state(self):
        return self.random_element(self.states)

    def city_with_postcode(self):
        return self.postcode() + " " + self.random_element(self.cities)
