from django.db import models
from django.utils.translation import gettext_lazy as _


class Site(models.Model):
    domain = models.CharField(max_length=100)

    def __str__(self):
        return self.domain


class Article(models.Model):
    """
    A simple Article model for testing
    """
    site = models.ForeignKey(Site, models.CASCADE, related_name="admin_articles")
    title = models.CharField(max_length=100)
    hist = models.CharField(max_length=100, verbose_name=_("History"))
    created = models.DateTimeField(null=True)

    def __str__(self):
        return self.title

    def test_from_model(self):
        return "nothing"

    def test_from_model_with_override(self):
        return "nothing"
    test_from_model_with_override.short_description = "not What you Expect"


class ArticleProxy(Article):
    class Meta:
        proxy = True


class Count(models.Model):
    num = models.PositiveSmallIntegerField()
    parent = models.ForeignKey('self', models.CASCADE, null=True)

    def __str__(self):
        return str(self.num)


class Event(models.Model):
    date = models.DateTimeField(auto_now_add=True)


class Location(models.Model):
    event = models.OneToOneField(Event, models.CASCADE, verbose_name='awesome event')


class Guest(models.Model):
    event = models.OneToOneField(Event, models.CASCADE)
    name = models.CharField(max_length=255)

    class Meta:
        verbose_name = "awesome guest"


class EventGuide(models.Model):
    event = models.ForeignKey(Event, models.DO_NOTHING)


class Vehicle(models.Model):
    pass


class VehicleMixin(Vehicle):
    vehicle = models.OneToOneField(
        Vehicle,
        models.CASCADE,
        parent_link=True,
        related_name='vehicle_%(app_label)s_%(class)s',
    )

    class Meta:
        abstract = True


class Car(VehicleMixin):
    pass
