# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceSkuLocationInfo(Model):
    """ResourceSkuLocationInfo.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location: Location of the SKU
    :vartype location: str
    :ivar zones: List of availability zones where the SKU is supported.
    :vartype zones: list[str]
    :ivar zone_details: Details of capabilities available to a SKU in specific
     zones.
    :vartype zone_details:
     list[~azure.mgmt.compute.v2019_04_01.models.ResourceSkuZoneDetails]
    """

    _validation = {
        'location': {'readonly': True},
        'zones': {'readonly': True},
        'zone_details': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'zone_details': {'key': 'zoneDetails', 'type': '[ResourceSkuZoneDetails]'},
    }

    def __init__(self, **kwargs):
        super(ResourceSkuLocationInfo, self).__init__(**kwargs)
        self.location = None
        self.zones = None
        self.zone_details = None
