# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AutomaticOSUpgradePolicy(Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :param enable_automatic_os_upgrade: Indicates whether OS upgrades should
     automatically be applied to scale set instances in a rolling fashion when
     a newer version of the OS image becomes available. Default value is false.
     If this is set to true for Windows based scale sets, recommendation is to
     set
     [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet)
     to false.
    :type enable_automatic_os_upgrade: bool
    :param disable_automatic_rollback: Whether OS image rollback feature
     should be disabled. Default value is false.
    :type disable_automatic_rollback: bool
    """

    _attribute_map = {
        'enable_automatic_os_upgrade': {'key': 'enableAutomaticOSUpgrade', 'type': 'bool'},
        'disable_automatic_rollback': {'key': 'disableAutomaticRollback', 'type': 'bool'},
    }

    def __init__(self, *, enable_automatic_os_upgrade: bool=None, disable_automatic_rollback: bool=None, **kwargs) -> None:
        super(AutomaticOSUpgradePolicy, self).__init__(**kwargs)
        self.enable_automatic_os_upgrade = enable_automatic_os_upgrade
        self.disable_automatic_rollback = disable_automatic_rollback
