# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackupStorageDescription(Model):
    """Describes the parameters for the backup storage.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBlobBackupStorageDescription,
    FileShareBackupStorageDescription

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name for this backup storage.
    :type friendly_name: str
    :param storage_kind: Required. Constant filled by server.
    :type storage_kind: str
    """

    _validation = {
        'storage_kind': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'FriendlyName', 'type': 'str'},
        'storage_kind': {'key': 'StorageKind', 'type': 'str'},
    }

    _subtype_map = {
        'storage_kind': {'AzureBlobStore': 'AzureBlobBackupStorageDescription', 'FileShare': 'FileShareBackupStorageDescription'}
    }

    def __init__(self, **kwargs):
        super(BackupStorageDescription, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.storage_kind = None
