# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WebChatChannelProperties(Model):
    """The parameters to provide for the Web Chat channel.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar web_chat_embed_code: Web chat control embed code
    :vartype web_chat_embed_code: str
    :param sites: The list of Web Chat sites
    :type sites: list[~azure.mgmt.botservice.models.WebChatSite]
    """

    _validation = {
        'web_chat_embed_code': {'readonly': True},
    }

    _attribute_map = {
        'web_chat_embed_code': {'key': 'webChatEmbedCode', 'type': 'str'},
        'sites': {'key': 'sites', 'type': '[WebChatSite]'},
    }

    def __init__(self, sites=None):
        self.web_chat_embed_code = None
        self.sites = sites
