# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Channel(Model):
    """Channel definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FacebookChannel, EmailChannel, MsTeamsChannel,
    SkypeChannel, KikChannel, WebChatChannel, DirectLineChannel,
    TelegramChannel, SmsChannel, SlackChannel

    :param channel_name: Constant filled by server.
    :type channel_name: str
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
    }

    _subtype_map = {
        'channel_name': {'FacebookChannel': 'FacebookChannel', 'EmailChannel': 'EmailChannel', 'MsTeamsChannel': 'MsTeamsChannel', 'SkypeChannel': 'SkypeChannel', 'KikChannel': 'KikChannel', 'WebChatChannel': 'WebChatChannel', 'DirectLineChannel': 'DirectLineChannel', 'TelegramChannel': 'TelegramChannel', 'SmsChannel': 'SmsChannel', 'SlackChannel': 'SlackChannel'}
    }

    def __init__(self):
        self.channel_name = None
