# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceAccess(Model):
    """Specifies an OAuth 2.0 permission scope or an app role that an application
    requires. The resourceAccess property of the RequiredResourceAccess type is
    a collection of ResourceAccess.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param id: The unique identifier for one of the OAuth2Permission or
     AppRole instances that the resource application exposes.
    :type id: str
    :param type: Specifies whether the id property references an
     OAuth2Permission or an AppRole. Possible values are "scope" or "role".
    :type type: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, id, additional_properties=None, type=None):
        super(ResourceAccess, self).__init__()
        self.additional_properties = additional_properties
        self.id = id
        self.type = type
