# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FindSimilarRequest(Model):
    """Request body for find similar operation.

    :param face_id: FaceId of the query face. User needs to call Face - Detect
     first to get a valid faceId. Note that this faceId is not persisted and
     will expire 24 hours after the detection call
    :type face_id: str
    :param face_list_id: An existing user-specified unique candidate face
     list, created in Face List - Create a Face List. Face list contains a set
     of persistedFaceIds which are persisted and will never expire. Parameter
     faceListId and faceIds should not be provided at the same time
    :type face_list_id: str
    :param face_ids: An array of candidate faceIds. All of them are created by
     Face - Detect and the faceIds will expire 24 hours after the detection
     call.
    :type face_ids: list[str]
    :param max_num_of_candidates_returned: The number of top similar faces
     returned. The valid range is [1, 1000]. Default value: 20 .
    :type max_num_of_candidates_returned: int
    :param mode: Similar face searching mode. It can be "matchPerson" or
     "matchFace". Possible values include: 'matchPerson', 'matchFace'. Default
     value: "matchPerson" .
    :type mode: str or
     ~azure.cognitiveservices.vision.face.models.FindSimilarMatchMode
    """

    _validation = {
        'face_id': {'required': True},
        'face_list_id': {'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'face_ids': {'max_items': 1000},
        'max_num_of_candidates_returned': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'face_id': {'key': 'faceId', 'type': 'str'},
        'face_list_id': {'key': 'faceListId', 'type': 'str'},
        'face_ids': {'key': 'faceIds', 'type': '[str]'},
        'max_num_of_candidates_returned': {'key': 'maxNumOfCandidatesReturned', 'type': 'int'},
        'mode': {'key': 'mode', 'type': 'FindSimilarMatchMode'},
    }

    def __init__(self, face_id, face_list_id=None, face_ids=None, max_num_of_candidates_returned=20, mode="matchPerson"):
        super(FindSimilarRequest, self).__init__()
        self.face_id = face_id
        self.face_list_id = face_list_id
        self.face_ids = face_ids
        self.max_num_of_candidates_returned = max_num_of_candidates_returned
        self.mode = mode
