# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TrainingStatus(Model):
    """Training status object.

    :param status: Training status: notstarted, running, succeeded, failed. If
     the training process is waiting to perform, the status is notstarted. If
     the training is ongoing, the status is running. Status succeed means this
     person group is ready for Face - Identify. Status failed is often caused
     by no person or no persisted face exist in the person group. Possible
     values include: 'nonstarted', 'running', 'succeeded', 'failed'
    :type status: str or
     ~azure.cognitiveservices.vision.face.models.TrainingStatusType
    :param created: A combined UTC date and time string that describes person
     group created time.
    :type created: datetime
    :param last_action: Person group last modify time in the UTC, could be
     null value when the person group is not successfully trained.
    :type last_action: datetime
    :param message: Show failure message when training failed (omitted when
     training succeed).
    :type message: str
    """

    _validation = {
        'status': {'required': True},
        'created': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'TrainingStatusType'},
        'created': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_action': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, status, created, last_action=None, message=None):
        super(TrainingStatus, self).__init__()
        self.status = status
        self.created = created
        self.last_action = last_action
        self.message = message
