#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

TUNED_DIR="/etc/tune-profiles/"
if [[ -d "$TUNED_DIR" ]]; then
    POSTUPGRADE_TUNED_DIR="$VALUE_TMP_PREUPGRADE/postupgrade.d/tuned"
    if [[ ! -d "$POSTUPGRADE_TUNED_DIR" ]]; then
        mkdir -p "$POSTUPGRADE_TUNED_DIR"
    fi

    sed -i s/POSTUPGRADE_DIR/\$POSTUPGRADE_TUNED_DIR/g solution.txt
    cp -Rv $TUNED_DIR/* $POSTUPGRADE_TUNED_DIR
    log_medium_risk "We detected tuned profiles under $TUNED_DIR directory. See tuned-adm and tuned-profiles for more information."
    exit $RESULT_FAILED
fi

exit $RESULT_NOT_APPLICABLE



