#!/bin/bash
#
# Author: Honza Horak <hhorak@redhat.com>
# 
# Description:
# This script just does a back-up of /etc/ypserv.conf and
# /etc/sysconfig/yppasswdd


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Honza Horak <hhorak@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "ypserv"
COMPONENT="ypserv"
#END GENERATED SECTION

. ../common.sh

BACKUP_DONE=1
backup_config "/etc/ypserv.conf" && BACKUP_DONE=0
backup_config "/etc/sysconfig/yppasswdd" && BACKUP_DONE=0

# no config file was backed up, then return RESULT_NOT_APPLICABLE
[ $BACKUP_DONE -eq 1 ] && exit $RESULT_NOT_APPLICABLE

exit $RESULT_PASS

