#!/bin/bash
#
# Author: Honza Horak <hhorak@redhat.com>
#
# Description:
# This script just does a back-up of /var/yp/Makefile


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Honza Horak <hhorak@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "ypserv"
COMPONENT="ypserv"
#END GENERATED SECTION

. ../common.sh

CONFIG_FILE="/var/yp/Makefile"

backup_config "${CONFIG_FILE}" || exit $RESULT_NOT_APPLICABLE

# patch Makefile to apply changes we did in RHEL 7
TEST_DIR=$(pwd)
pushd "${VALUE_TMP_PREUPGRADE}/$(dirname $CONFIG_FILE)"
patch --no-backup-if-mismatch <"${TEST_DIR}/ypMakefile-rhel-7.patch"
if [ $? -ne 0 ] ; then
    read -r -d '' PROBLEM_DESC <<EOF
Patching file ${CONFIG_FILE} failed, you may have wrong MINUID/MINGID
definitions in that file and YPPUSH_ARGS may be missing there.
EOF
    log_high_risk "${PROBLEM_DESC}"
    exit $RESULT_FAILED
else
    log_debug "Patching file ${CONFIG_FILE} succeeded."
    echo "
File ${CONFIG_FILE} was patched successfully in ${VALUE_TMP_PREUPGRADE}/${CONFIG_FILE}
After upgrade you should copy it back manually.

" > solution.txt
fi
popd

exit $RESULT_FIXED

