#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>, Alois Mahdal <amahdal@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

bad_record_num() {
    #
    # Count "offending" records
    #
    grep -ace 'image[\t ]*=.*kdump' /etc/zipl.conf
}

prepare_fix() {
    #
    # Prepare kernel-kdump.sh and back up current zipl.conf
    #
    local fix_sh="$POSTUPGRADE_DIR/kernel-kdump.sh"
    cp "kernel-kdump.sh" "$fix_sh"
    chmod +x "$fix_sh"
}

info_msg() {
    #
    # Compose the "fixed" message"
    #
    echo -n "One or more invalid kernel-kdump records found in zipl.conf"
    echo -n " and will be removed during upgrade."
}

test "$(arch)" = s390x || exit_not_applicable
test -f /etc/zipl.conf || exit_not_applicable

case $(bad_record_num) in
    0)  exit_pass ;;
    *)  prepare_fix
        log_info "$(info_msg)"
        exit_fixed ;;
esac
