#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "grub"
COMPONENT="grub"
#END GENERATED SECTION
COMPONENT="grub"
FILE_NAME="splash.xpm.gz"

if [[ -f "/boot/grub/$FILE_NAME" ]]; then
    POSTUPGRADE_DIR="$VALUE_TMP_PREUPGRADE/postupgrade.d/grub"
    if [[ ! -d "$POSTUPGRADE_DIR" ]]; then
        mkdir -p "$POSTUPGRADE_DIR"
    fi
    SCRIPT_NAME="postupgrade-grub.sh"
    POST_SCRIPT="postupgrade.d/$SCRIPT_NAME"
    cp -f $POST_SCRIPT $POSTUPGRADE_DIR/$SCRIPT_NAME
    cp -f /boot/grub/$FILE_NAME $POSTUPGRADE_DIR/$FILE_NAME

    {
        echo
        echo -n "File /boot/grub/splash.xpm.gz will be preserved as well"
        echo -n " in order to work around behavior of legacy GRUB.  You"
        echo -n " may safely delete this file once your GRUB2 setup is"
        echo -n " working."
    } >> grub.txt

fi

log_medium_risk "After upgrade, manual migration of GRUB to GRUB2 will be necessary."
exit_fail
