#!/bin/bash

COMPONENT="distribution"
#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

FOUND=0
if [ ! -f "$VALUE_RPM_QA" ]; then
    log_error "File $VALUE_RPM_QA with all rpm packages is required."
    exit_error
fi

PKGS=`grep "devtoolset-" $VALUE_RPM_QA | awk '{print $1}'`
if [ x"$PKGS" != "x" ]; then
    log_high_risk "List of installed Red Hat Developer Toolset packages:"
    for pkg in $PKGS
    do
        log_info "$pkg"
    done
    exit_fail
fi

exit_pass
