#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>, Petr Stodulka <pstodulk@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

[ ! -f "$VALUE_RPM_RHSIGNED" ] || [ ! -r "$COMMON_DIR" ] && {
  log_error "Generic common content part is missing!"
  exit $RESULT_ERROR
}

KeptLibs=$(mktemp .KeptLibsXXX --tmpdir=/tmp)
MovedReplacedLibs=$(mktemp .MovedReplacedLibsXXX --tmpdir=/tmp)
cat "$COMMON_DIR"/default*_soversioned-kept "$COMMON_DIR"/default*_so-kept >$KeptLibs
cat "$COMMON_DIR"/default*_so*-moved_* "$COMMON_DIR"/default*_so*obsoleted >$MovedReplacedLibs

[ ! -r "$KeptLibs" ] || [ ! -r "$MovedReplacedLibs" ] && {
  log_error "Generic part of content is missing!"
  rm -f "$KeptLibs" "$MovedReplacedLibs"
  exit $RESULT_ERROR
}


found=0
results="$VALUE_TMP_PREUPGRADE/kickstart/NoSonameBumpLibs"
rm -f "$results" >/dev/null
echo -n \
"#This is autogenerated file by preupgrade-assistant. DO NOT CHANGE!
#
#This file contains the list of libraries installed on the system where
#the soname is available even on RHEL 7 system. Therefore RHEL 6 applications
#depending only on these libraries might be used on RHEL 7 without rebuild.
#
#But some of these libraries are available inside different packages on new
#RHEL 7 system or packages are available inside different repository
#(informations about moving of packages between repositories are part
#of another contents for RPMs). Affected libraries are delimited from the first
#group by another comment-line.
" >"$results"

#Check for kept sonames and report them for RH packages installed on the system
while read line; do

  for pkg in $(echo "$line" | cut -d':' -f2 | sed -e 's/,/ /g')
  do
    #skip non-rh and unavailable packages
    grep -q "^$pkg[[:space:]]" $VALUE_RPM_QA && is_dist_native "$pkg" || continue
    echo "$(echo "$line" | cut -d':' -f1) from $pkg kept." >>"$results"
    found=1
  done

done < "$KeptLibs"

# and kept packages which are inside different package on new system
# or package moved to another repository between OSs
echo "#libs below have changed package or repository" >> "$results"
while read line; do
  pkgs_msg=""
  npkgs="$(echo "$line" | cut -d ":" -f2 | cut -sd "|" -f2)"
  for pkg in $(echo "$line" | cut -d ":" -f2 | cut -d "|" -f1 | sed "s/,/ /g")
  do
    grep -q "^$pkg[[:space:]]" $VALUE_RPM_QA && is_dist_native "$pkg" || continue
    [ -n "$npkgs" ] && [[ "$pkg" !=  "$npkgs" ]] \
      && pkgs_msg=" (on RHEL 7 available in: $npkgs)"
    echo "$(echo "$line" | cut -d':' -f1) from $pkg kept$pkgs_msg " >>"$results"
  done
done < "$MovedReplacedLibs"

rm -rf "$KeptLibs" "$MovedReplacedLibs"

echo -n "
 * NoSonameBumpLibs - this informational file tells you all sonames of libraries, where the soname is same on RHEL 6 and RHEL 7. If your non-RH binaries depend just on these libraries, they might work without rebuild after upgrade.
" >>"$KICKSTART_README" && exit $RESULT_INFORMATIONAL

exit $RESULT_PASS
