#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Lautrbach <plautrba@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "openssh-server"
COMPONENT="openssh-server"
#END GENERATED SECTION

# This check can be used if you need root privilegues
check_root

SYSCONFIG_FILE=/etc/sysconfig/sshd

mkdir -p $VALUE_TMP_PREUPGRADE/cleanconf/$(dirname $SYSCONFIG_FILE)
cp $SYSCONFIG_FILE $VALUE_TMP_PREUPGRADE/cleanconf/$SYSCONFIG_FILE

if grep "^export " $SYSCONFIG_FILE; then
    solution_file \
"$SYSCONFIG_FILE will not be a shell script in RHEL 7 anymore so all 'export VARIABLE=VALUE' has to be changed to 'VARIABLE=VALUE'.
    
# sed -i 's/^export //' $SYSCONFIG_FILE

There is the $VALUE_TMP_PREUPGRADE/cleanconf/$SYSCONFIG_FILE with the fixed configuration.
"
    
    log_slight_risk "export shell commands will be deleted from $SYSCONFIG_FILE"

    sed -i 's/^export //' $VALUE_TMP_PREUPGRADE/cleanconf/$SYSCONFIG_FILE && exit $RESULT_FIXED

    exit $RESULT_FAIL
else
    exit $RESULT_PASS
fi
