#!/usr/bin/python2

import subprocess
import re
from preup.script_api import *


"""Preupgrade Assistant performs system upgradability assessment
and gathers information required for successful operating system upgrade.
Copyright (C) 2013 Red Hat Inc.
Martin Kosek <mkosek@redhat.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>."""
check_applies_to (check_applies="ipa-server")
check_rpm_to (check_rpm="",check_bin="python")
set_component("ipa-server")
#END GENERATED SECTION

try:
    from ipaserver.install import installutils
    from ipalib import api
    ipaserver_installed = True
except ImportError:
    ipaserver_installed = False

COMPONENT = 'ipa-server'

def main():
    if not ipaserver_installed:
        log_info("ipa-server package not installed")
        exit_not_applicable()

    if not installutils.is_ipa_configured():
        log_info("Identity Managament Server not configured")
        exit_not_applicable()

    log_extreme_risk("Identity Management Server cannot be upgraded in-place")
    exit_fail()

if __name__ == "__main__":
    set_component(COMPONENT)
    main()
    exit_pass()

