#!/bin/bash
#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Stodulka <pstodulk@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

rm -f solution.txt
touch solution.txt

# we need really all static lists in this content, so get right path
# - we can't use 'arch' because of cross arch migration (eg i386-x86_64)
REPO_STATS="$(dirname "$(readlink -f "$(ls "$COMMON_DIR/default_kept-pkgs")")")"
REGEX_PKG='s/^([^[:space:]|]+).*$/\1/'

# all without debug repositories (debuginfo not importnant without packages)
variant_all_pkgs_list() {
  cat $(ls -d -1 "${REPO_STATS}"/* | grep -iE "/${1}[^/]+$" |\
        grep -ve "_so" -e "grouplist" -e "debug";
        echo "${COMMON_DIR}/default_kept-pkgs";
        echo "${COMMON_DIR}/default_kept-pkgs-optional") |\
    sed -r "$REGEX_PKG" | sort -u
}

#e.g. Server + optional channel + common pkgs
#TODO: when addon will be solved by PA, may it could be removed first grep
# and deem relevant subcription as owned
variant_basic_pkgs_list() {
  _my_tmp=$(ls -d -1 "$COMMON_DIR"/default* | grep -iE "/default(\-optional)?_[^/]+$" |\
        grep -ve "_so" -e "grouplist" -e "debug" -e "utilities")
  # check if we found wanted files
  [ -n "$_my_tmp" ] && cat $_my_tmp | sed -r "$REGEX_PKG" | sort -u
}

##########################################################

result=$RESULT_PASS
VARIANT=$(sed -r "s/Red Hat Enterprise Linux ([^[:space:]]+).*/\1/" /etc/redhat-release)

ALL_VAR_PKGS=$(variant_all_pkgs_list "$VARIANT")
BASIC_VAR_PKGS=$(variant_basic_pkgs_list "$VARIANT")
rpm_signed=$(get_dist_native_list | grep -iv debuginfo | sort -u)

OTHER_VARIANT_PKGS=$(comm -2 -3 <(echo "$rpm_signed") <(echo "$ALL_VAR_PKGS"))
THIS_VARIANT_PKGS=$(comm -1 -2 <(echo "$rpm_signed") <(echo "$ALL_VAR_PKGS"))
ADDON_PKGS=$(comm -2 -3 <(echo "$THIS_VARIANT_PKGS") <(echo "$BASIC_VAR_PKGS"))

[ -n "$OTHER_VARIANT_PKGS" ] && {
  result=$RESULT_FAIL
  log_high_risk "You have installed Red Hat signed packages for different variant of RHEL system!"
  echo "Some Red Hat signed packages are appointed for different variant RHEL systems.
In this case we don't support inplace upgrade to new RHEL-7 systems with these packages.
These packages will be probably removed:
$OTHER_VARIANT_PKGS" >> solution.txt
}

[ -n "$ADDON_PKGS" ] && {
  result=$RESULT_FAIL
  log_high_risk "You have installed Red Hat signed packages which need special subscriptions."
  echo "Some Red Hat siggned packages are available only in special systems which required
some other subscriptions. Be sure you have all needed subscriptions for these packages:
$ADDON_PKGS" >> solution.txt
}

exit $result

