#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Pavel Reichl <preichl@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "sssd"
COMPONENT="sssd"
#END GENERATED SECTION

check_root

function solution() {
    printf '%s\n\n' "$@" >> "$SOLUTION_FILE" || exit_error
}

function check_problematic_option() {
    MATCH=$(grep -o -i -z "${2}" "${1}")
    if [ "$MATCH" != "" ]; then
        solution "Configuration file \"${1}\" contains problematic \
option \"$MATCH\"."
        return 0
    else
        return 1
    fi
}

PROBLEMATIC_OPT_FOUND=0
CONF_FILE='/etc/sssd/sssd.conf'


if [ ! -e "$CONF_FILE" ]; then
    solution "Configuration file \"$CONF_FILE\" is missing on the old system."
    exit_not_applicable
fi

# backup config file
mkdir -p $VALUE_TMP_PREUPGRADE/$(dirname $CONF_FILE)
cp $CONF_FILE $VALUE_TMP_PREUPGRADE$CONF_FILE

check_problematic_option "${CONF_FILE}" "\bkrb5_ccachedir\b" && PROBLEMATIC_OPT_FOUND=1
check_problematic_option "${CONF_FILE}" "\bkrb5_ccname_template[[:space:]]*=[[:space:]]*DIR:" && PROBLEMATIC_OPT_FOUND=1

if [ "$PROBLEMATIC_OPT_FOUND" == "1" ]; then
    solution 'The Kerberos provider is no longer able to create public directories when evaluating the krb5_ccachedir option. This is a backwards-incompatible change. Creating public directories is something the system administrator should perform in order for the directories to have the correct permissions and allow the authentication daemon to create user directories as private only.'
    exit_informational
fi

exit_pass