#!/usr/bin/env bash
COMPONENT="libcgroup"
#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ivana Hutarova Varekova <varekova@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "libcgroup"
COMPONENT="libcgroup"
#END GENERATED SECTION

CGROUPS_CONFIG_CGCONFIG='/etc/cgconfig.conf'
CGROUPS_CONFIG_CGRED='/etc/cgrules.conf'
CGROUPS_CONFIG_DIR='/etc/cgconfig.d'

# if there are any changes in the default confiuration,
# these changes have to be configured using system.d

# configuration files are changed
# CGROUPS_CONFIG_CGCONFIG='/etc/cgconfig.conf'
# CGROUPS_CONFIG_CGRED='/etc/cgrules.conf'
ETC_DIFF=`rpm -V  --nomtime --nodeps libcgroup | sed "s|[^ ]*  [^ ]* ||"`

if [ "x$ETC_DIFF" != "x" ]
then
	log_high_risk "libcgroup configuration files were customized ($ETC_DIFF file(s))"
	exit $RESULT_FAIL
fi

# there is a nonempty confiuration file in custom config files directory
# CGROUPS_CONFIG_DIR
if [ -s $CGROUPS_CONFIG_DIR ]
then
	log_high_risk "additional libcgroup configuration files were created ($CGROUPS_CONFIG_DIR)"
	exit $RESULT_FAIL
fi

exit $RESULT_PASS
