#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Matthew Harmsen <mharmsen@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "pki-ca"
check_rpm_to "" ""
COMPONENT="pki-ca"
#END GENERATED SECTION

pki_ca_registry="/etc/sysconfig/pki/ca"

if [ -d ${pki_ca_registry} ] ; then
    instances=`ls -1A ${pki_ca_registry} | wc -l`
    if [ ${instances} -gt 0 ] ; then
        # There is an IPA CA installed;
        # return an error since in-place upgrade of an
        # IPA CA from RHEL 6 to RHEL 7 is unsupported!
        log_extreme_risk "Identity Management Server CA cannot be upgraded in-place"
        exit_fail
    fi
fi

exit_pass
