#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Pavel Raiskup <praiskup@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to ""
check_rpm_to "perl" ""
COMPONENT=""
#END GENERATED SECTION

# NOTES:
# - see the bug #1138615 for reasons
#
# - this script requires yum-plugin-downloadonly package installed, so
#   so preupgrade-assistant-contents must require it
#
# - this script creates "rhelup" pre-upgrade hook;  that script modifies
#   rhelup's intermediate files so it is meant as believed _sooo ugly_
#   work-around before rhelup itself gets fixed somehow

perl_wrapper="$(dirname ${BASH_SOURCE})"/parse


packages=$(cat /root/preupgrade/RHEL6_7/common/default*_downgraded | \
    cut -d'|' -f1 | sort | uniq | $perl_wrapper $VALUE_RPM_RHSIGNED)

rv=$?

rhelup_preupgrade_hookdir=$VALUE_TMP_PREUPGRADE/preupgrade-scripts
fixfile=$rhelup_preupgrade_hookdir/fixpkgdowngrades.sh

generate_postupgrade_script()
{
    mkdir -p $rhelup_preupgrade_hookdir &>/dev/null

    cat <<EOF >$fixfile
#!/bin/bash

arch=\$(rpm --eval %_arch)

if [ "\$(id -u)" != 0 ]; then
    echo >&2 "please, run this under 'root' user"
    exit 1
fi

workdir=$VALUE_TMP_PREUPGRADE/pkgdowngrades
downloaddir=\$workdir/rpms
downloadlist=\$workdir/list
appendlist=\$workdir/append

mkdir -p \$workdir
mkdir -p \$downloaddir

rheluplist=/var/lib/system-upgrade/package.list
rhelupdir=/var/lib/system-upgrade

# "yumdownloader --archlist=x86_64" downloads multilib packages, so rather
# explicitly ask what is really installed

for pkg in $*; do
    really_installed=\$(rpm -q \$pkg --qf "%{NAME}.%{ARCH} ")

    yumdownloader \$really_installed --destdir=\$downloaddir

    # The multilib-ness did not change between RHEL major versions
    test \$? -eq 0 && continue

    # Is this ever going to be used?
    if test [[ "\$really_installed" == *.noarch ]]; then
        yumdownloader \$pkg.\$arch --destdir=\$downloaddir
    else
        yumdownloader \$pkg.noarch --destdir=\$downloaddir
    fi
done

find \$downloaddir -name '*.rpm' -printf "%f\\n" >\$downloadlist

cat \$downloadlist | grep -vFf \$rheluplist > \$appendlist

for i in \$(cat \$appendlist); do
    cp \$downloaddir/\$i \$rhelupdir
done
cat \$appendlist >> \$rheluplist

exit 0
EOF
    chmod +x $fixfile
}

case "$rv" in
    0)
        exit_pass
        ;;
    1)
        packages=`echo $packages`
        log_error "packages $packages are downgraded in RHEL7"
        log_medium_risk "having one of [$packages] package installed breaks upgrade"

        generate_postupgrade_script "$packages"

        exit_fixed
        ;;
    *)
        log_error "unknown error"
        exit_error
        ;;
esac
