#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "initscripts"
COMPONENT="initscripts"
#END GENERATED SECTION


INITSCRIPTS="not_handled.txt"
if [ -f "INITSCRIPTS" ]; then
    rm -f $INITSCRIPTS
fi
LEVEL=`runlevel | awk {'print $2'}`
COMPONENT="initscripts"
DISABLED_SERVICES="disabled.log"
ENABLED_SERVICES="enabled.log"
POSTUPGRADE_SCRIPT="services.py"
PRESET_FILE="90-default.preset"
if [ ! -f "$PRESET_FILE" ]; then
    log_error "File $PRESET_FILE is required for the content."
    exit_error 
fi
if [ -f $DISABLED_SERVICES ]; then
    rm -f $DISABLED_SERVICES
fi
if [ -f $ENABLED_SERVICES ]; then
    rm -f $ENABLED_SERVICES
fi

RESULT=0
for i in `cat $VALUE_CHKCONFIG | grep "$LEVEL:on" | awk '{print $1}'`
do
    RPM=`rpm -qf /etc/init.d/$i`
    if [ $? -ne 0 ]; then
	    log_medium_risk "The service $i is not handled by any package and will not be automatically enabled after in-place upgrade."
        RESULT=1
        continue
    fi
    RPM_NAME=`rpm -q --qf "%{NAME}" $RPM`
    grep "$RPM_NAME[[:space:]]" $VALUE_RPM_RHSIGNED > /dev/null
    if [ $? -ne 0 ]; then
	    log_medium_risk "The service $i is not installed by RedHat signed packages and will not be automatically enabled after in-place upgrade."
        continue
    fi
    grep "/etc/init.d/$i" $VALUE_CONFIGCHANGED > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        log_slight_risk "The service $i was modified."
    fi
    grep "enable $i." $PRESET_FILE > /dev/null 2>/dev/null
    if [ $? -ne 0 ]; then
        log_high_risk "The service $i on RHEL 7 is disabled by default. Enable them via commands: systemctl enable $i && systemctl start $i.service ."
    fi
	echo "$i" >> $ENABLED_SERVICES
done

for i in `cat $VALUE_CHKCONFIG | grep "$LEVEL:off" | awk '{print $1}'`
do
    RPM=`rpm -qf /etc/init.d/$i`
    if [ $? -ne 0 ]; then
	    log_medium_risk "The service $i is disabled and not handled by any package. It will be disabled after an in-place upgrade."
        RESULT=1
        continue
    fi
    RPM_NAME=`rpm -q --qf "%{NAME}" $RPM`
    grep "$RPM_NAME[[:space:]]" $VALUE_RPM_RHSIGNED > /dev/null
    if [ $? -ne 0 ]; then
	    log_medium_risk "The service $i is disabled and not installed by RedHat signed packages. It will be disabled after an in-place upgrade."
        RESULT=1
        continue
    fi
    grep "/etc/init.d/$i" $VALUE_CONFIGCHANGED > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        log_slight_risk "The service $i is disabled and was modified."
        RESULT=1
    fi
	echo "$i" >> $DISABLED_SERVICES
done

mkdir -p $POSTUPGRADE_DIR/initscripts
cp -a $ENABLED_SERVICES $POSTUPGRADE_DIR/initscripts/$ENABLED_SERVICES
cp -a $DISABLED_SERVICES $POSTUPGRADE_DIR/initscripts/$DISABLED_SERVICES
cp -a postupgrade.d/$POSTUPGRADE_SCRIPT $POSTUPGRADE_DIR/initscripts/$POSTUPGRADE_SCRIPT
chmod a+x $POSTUPGRADE_DIR/initscripts/$POSTUPGRADE_SCRIPT

if [ $RESULT -eq 1 ]; then
    exit_fail
fi

exit_informational
