#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

[ ! -f "$VALUE_RPM_RHSIGNED" ] && \
  log_error generic Common content part is missing! &&
  exit $RESULT_ERROR

[ ! -r SonameRemovalInfo ] && \
  log_error generic Part of the content is missing! && \
  exit $RESULT_ERROR

found=0
statuscode=$RESULT_INFORMATIONAL
rm -f solution.txt >/dev/null
echo \
"Application developed in C may use dynamic libraries (.so files) to reuse the
common functions/symbols in the binary. If the library is missing, application
will not run. Some of the libraries were removed between RHEL 6 and RHEL 7.
From your Red Hat Enterprise Linux 6 packages, following libraries disappeared:
" >solution.txt

#Check for soname removals and report them for RH packages installed
#on the system
for i in `cat SonameRemovalInfo`
do
  for j in `echo $i | cut -d':' -f2 | sed -e 's/|/ /g'`
  do
    #skip non-rh and unavailable packages
    grep -e "^$j[[:space:]]" "$VALUE_RPM_RHSIGNED" >/dev/null || continue
    m=" (required by NonRH signed package(s):"
    for l in `rpm -q --whatrequires $j | grep -v "no package requires" | \
     rev | cut -d'-' -f3- | rev`
    do
      grep -e "^$l[[:space:]]" "$VALUE_RPM_RHSIGNED" >/dev/null || m="$m$l "
    done
    m="$m)"
    [ "$m" == " (required by NonRH signed package(s):)" ] && m=""
    [ -n "$m" ] && log_high_risk "Library $j$m removed between RHEL 6 and RHEL 7" && \
      statuscode=$RESULT_FAIL 
    echo "`echo $i | cut -d':' -f1` from $j$m" >>solution.txt
    found=1
  done
done

grep required solution.txt >>"$VALUE_TMP_PREUPGRADE/kickstart/RemovedLibs-required"
grep -v required solution.txt | grep -v " " | grep -v "^$" >> "$VALUE_TMP_PREUPGRADE/kickstart/RemovedLibs-optional"
grep required "$VALUE_TMP_PREUPGRADE/kickstart/RemovedLibs-required" || rm "$VALUE_TMP_PREUPGRADE/kickstart/RemovedLibs-required"
grep [a-zA-Z] "$VALUE_TMP_PREUPGRADE/kickstart/RemovedLibs-optional" || rm "$VALUE_TMP_PREUPGRADE/kickstart/RemovedLibs-optional"
[ -f "$VALUE_TMP_PREUPGRADE/kickstart/RemovedLibs-required" ] && \
  echo " * RemovedLibs-required - This file contains all RHEL 6 libraries, which were in RHEL 7 removed. As some of your packages depends on it, you will need to check for the alternative solutions." >>"$VALUE_TMP_PREUPGRADE/kickstart/README"
[ -f "$VALUE_TMP_PREUPGRADE/kickstart/RemovedLibs-optional" ] && \
  echo " * RemovedLibs-optional - Similar to RemovedLibs-required, but in this case no non-rh package requires this. It is more informational thing for you - so you can deal with the unavailability of these libraries." >>"$VALUE_TMP_PREUPGRADE/kickstart/README"

echo \
"
We checked the requirements in Non-RH signed packages, but for the non
rpm-packaged binaries, you should check the compatibility list yourself
by using e.g. ldd <binary> command.
If some of your application uses the library on the list above, you may need
to get the .so library from different place or search for an alternative.
" >>solution.txt

[ $found -eq 1 ] && log_medium_risk "\
 We detected some .so libraries installed on the system were removed between RHEL 6 and RHEL 7. This may break the functionality of some of your 3rd party applications." && exit $statuscode

rm -f solution.txt && touch solution.txt

exit $RESULT_PASS
