#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

[ ! -f "$VALUE_RPM_RHSIGNED" ] && \
  log_error generic Common content part is missing! &&
  exit $RESULT_ERROR

[ ! -r SonameKeptInfo ] && \
  log_error generic Part of the content is missing! && \
  exit $RESULT_ERROR

found=0
results="$VALUE_TMP_PREUPGRADE/kickstart/NoSonameBumpLibs"
rm -f "$results" >/dev/null
echo \
"#This is autogenerated file by preupgrade-assistant. DO NOT CHANGE!
#
#This file contains the list of libraries installed on the system where
#the soname is available even on RHEL 7 system. Therefore RHEL 6 applications
#depending only on these libraries might be used on RHEL 7 without rebuild." \
>"$results"

#Check for kept sonames and report them for RH packages installed on the system
for i in `cat SonameKeptInfo`
do

  for j in `echo $i | cut -d':' -f2 | sed -e 's/|/ /g'`
  do
    #skip non-rh and unavailable packages
    grep -e "^$j[[:space:]]" "$VALUE_RPM_RHSIGNED" >/dev/null || continue
    echo "`echo $i | cut -d':' -f1` from $j kept." >>"$results"
    found=1
  done

done

[ $found -eq 1 ] && \
 echo " * NoSonameBumpLibs - this informational file tells you all sonames of libraries, where the soname is same on RHEL 6 and RHEL 7. If your non-RH binaries depend just on these libraries, they might work without rebuild after upgrade." >>"$VALUE_TMP_PREUPGRADE/kickstart/README" \
 && exit $RESULT_INFORMATIONAL

exit $RESULT_PASS
